# Various Notes and reminders

Copyright 2024 Bruno Herbelin

## Publishing new a release

-   Update `share/metainfo/io.github.brunoherbelin.Vimix.metainfo.xml`Add a `<release>`, with date and version number
    
-   Update `snap/snapcraft.yaml`Change version string
    
-   commit to Beta
    
-   Test the flatpack for Beta[https://github.com/brunoherbelin/vimix/tree/master/flatpak](https://github.com/brunoherbelin/vimix/tree/master/flatpak)
    
-   Test the snap for Beta
    
    ```bash
    $ snap remove vimix$ snapcraft pack (from vimix base dir)$ snap install ./vimix_0.X.Y_amd64.snap --devmode$ snap connections vimix
    ```
    
-   Merge Beta into origin/master
    
-   push origin/master
    
-   Create Release & Tag in [https://github.com/brunoherbelin/vimix](https://github.com/brunoherbelin/vimix)Document new features and major bugfixes
    
-   Edit the Json on [https://github.com/flathub/io.github.brunoherbelin.Vimix](https://github.com/flathub/io.github.brunoherbelin.Vimix)Set vimix git Tag and Commit #Merge pull-request after successful flathubbot compilation(delete branch)
    
-   Follow-up status of flathub package build on [https://buildbot.flathub.org](https://buildbot.flathub.org)(link is sent by email)
    

## Mac OSX specificities

-   Settings are saved in `/Users/[username]/Library/Application Support/vimix`Instructions to reset in finder, do "Go to folder" (shift+command+G),enter `/Users/[username]/Library/Application Support/vimix` and delete the folder 'vimix'
    
-   Generate and sign package
    
    -   `cd build`
        
        `cpack`
        
        `cd ..`
        
        `cmake --build build --target notarize`
        
-   POST INSTALL DMG SIGNING AND NOTARIZATION (done by --target notarize)
    

1.  SIGN DMG
    
    ```bash
    codesign --force --sign "Developer ID Application: <identityIdentifier>" <pathToDMG>
    ```
    
    verify with:
    
    ```bash
    codesign --verify --verbose=2 <pathToDMG>
    ```
    
2.  SUBMIT TO NOTARIZATION
    
    ```bash
    xcrun notarytool submit <pathToDMG> --keychain-profile "vimix" --wait
    ```
    
    verify with:
    
    ```bash
    xcrun notarytool log xxxx-xxxx-xxx  --keychain-profile "vimix"
    ```
    
    NB: "vimix" is the name of the app-specific password in keychain generated online: [https://support.apple.com/en-us/102654](https://support.apple.com/en-us/102654)
    
3.  STAPLE THE TICKET TO THE DISK IMAGE
    
    ```bash
    xcrun stapler staple <pathToDMG>
    ```
    
4.  VERIFY NOTARIZATION
    
    ```bash
    spctl -a -vv -t install <pathToDMG>
    ```
    
    NB: more info at [https://wiki.lazarus.freepascal.org/Notarization_for_macOS_10.14.5%2B](https://wiki.lazarus.freepascal.org/Notarization_for_macOS_10.14.5%2B)
    

## flatpack Development

The flatpak manifest for flathub is at [https://github.com/flathub/io.github.brunoherbelin.Vimix](https://github.com/flathub/io.github.brunoherbelin.Vimix)

To build the vimix flatpak with code from local folder (debugging), change the following:

```json
{    "name": "vimix",    "buildsystem": "cmake",    "config-opts": [        "-DCMAKE_BUILD_TYPE=Release"    ],    "sources": [        {        "type":"dir",        "path": "[your_development_dir]/vimix",        }    ]}
```

Run this to use the custom local desc

```
flatpak-builder --user --install --force-clean build [your_development_dir]/flatpak/io.github.brunoherbelin.Vimix.json
```

## Testing performance

Linux perf command

-   Allow perf on your system
    
    ```bash
    sudo sysctl -w kernel.perf_event_paranoid=-1
    ```
    
-   Launch command to record
    
    ```bash
    perf record ./vimixperf record --pid=XXXXX
    ```
    
    e.g.;
    
    ```bash
    __NV_PRIME_RENDER_OFFLOAD=1 __GLX_VENDOR_LIBRARY_NAME=nvidia   perf record --call-graph dwarf ./build/src/vimix
    ```
    
-   Analyse using [https://github.com/KDAB/hotspot](https://github.com/KDAB/hotspot)
    

## Memcheck

To generate memory usage plots in [massif format](https://valgrind.org/docs/manual/ms-manual.html):

```bash
G_SLICE=always-malloc valgrind --tool=massif ./vimix
```

To check for memory leaks:

```bash
G_SLICE=always-malloc valgrind --leak-check=full --log-file=vimix_mem.txt ./vimix
```