---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, équations, 
              structures, indices, exposant au-dessus des symboles, 
              texte sur un symbole, écrire sur les flèches, 
              texte au-dessus d'une flèche
---

# Comment écrire au-dessus d'un symbole ou d'une flèche ?

## Avec les commandes de base

La commande `\stackrel` permet de placer des éléments au-dessus d'une flèche
ou d'une relation :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\[  x \stackrel{f}{\mapsto} f(x)  \]
\end{document}
```


## Avec l'extension <ctanpkg:mathtools>

L'extension <ctanpkg:mathtools> (ou <ctanpkg:amsmath>) dispose de la commande 
`\overset` permettant de placer des "exposants centrés".

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
\[  \overset{a}{X} = \sum_{k=0}^{a} X^k  \]
\end{document}
```

Cette commande suit la logique de la commande `\underset` décrite à la question
"[](/4_domaines_specialises/mathematiques/structures/indices/obtenir_un_indice_dessous)".
Son principe se généralise avec la commande `\overunderset` qui permet 
de placer un exposant au-dessus du symbole et un indice au-dessous le symbole.

L'extension fournit également avec des commandes dédiées un moyen de placer 
des éléments au-dessus d'une flèche extensible. Ce sujet est évoqué 
à la question 
"[](/4_domaines_specialises/mathematiques/symboles/fleches/ajuster_la_longueur_d_une_fleche_par_rapport_a_un_texte)".


:::{sources}
- [Indices et exposants en folie](https://www.elzevir.fr/imj/latex/tips.html#indices), 
  par Manuel Pégourié-Gonnard
:::