---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, pages, en-têtes, pieds de page, titres
---

# Comment gérer un titre trop long dans un en-tête de page ?

Par défaut, les commandes de sectionnement de LaTeX permettent d'utiliser 
les titres de chapitre ou de section dans les en-têtes de page et autres. 
Mais les en-têtes de page sont positionnés dans une zone assez contrainte 
et les titres s'avèrent souvent trop longs y pour tenir.

Voici un exemple sur quatre pages reprenant le début du livre 
*[Le Tour du monde en quatre-vingts jours](https://fr.wikisource.org/wiki/Le_Tour_du_monde_en_quatre-vingts_jours)*.
Jules Verne, comme d'autre auteurs, donnait souvent à ses chapitres 
un titre souvent long résumant leur contenu. Un exemple parfait pour illustrer 
ce qu'il est possible de faire pour corriger les en-têtes.

```
\documentclass[french]{book}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)

\begin{document}
\tableofcontents
\chapter{Dans lequel Phileas Fogg et Passepartout s’acceptent réciproquement, 
l’un comme maître, l’autre comme domestique.}

\newpage
En l’année 1872, la maison portant le numéro 7 de Saville-row, Burlington 
Gardens, --- maison dans laquelle Shéridan mourut en 1814, --- était habitée 
par Phileas Fogg, esq., l’un des membres les plus singuliers et les plus 
remarqués du Reform-Club de Londres, bien qu’il semblât prendre à tâche 
de ne rien faire qui pût attirer l’attention.
\end{document}
```


## Avec les commandes de base

Les commandes de sectionnement autorisent un argument optionnel :

```{noedit}
\section[titre court]{titre long}
```

Si le *titre court* est présent, il sert à la fois pour la table des matières 
et pour l'en-tête de page.

```
\documentclass[french]{book}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)

\begin{document}
\tableofcontents
\chapter[Philéas Fogg et Passepartout]{Dans lequel Phileas Fogg et 
Passepartout s’acceptent réciproquement, l’un comme maître, l’autre 
comme domestique.}

\newpage
En l’année 1872, la maison portant le numéro 7 de Saville-row, Burlington 
Gardens, --- maison dans laquelle Shéridan mourut en 1814, --- était habitée 
par Phileas Fogg, esq., l’un des membres les plus singuliers et les plus 
remarqués du Reform-Club de Londres, bien qu’il semblât prendre à tâche 
de ne rien faire qui pût attirer l’attention.
\end{document}
```

Efficace, cette technique est devenue la réponse usuelle aux gens qui se plaignent 
de titres trop longs. Cependant, recourir au même texte pour la table des matières 
et pour les en-têtes peut également être peu satisfaisant : si les titres 
de vos chapitres sont vraiment très longs, une alternative intéressante 
consiste à avoir une entrée de table des matières courte et une entrée plus laconique 
encore dans l'en-tête.

Ici, les commandes de sectionnement utilisent des commandes de "marque" 
pour transmettre des informations aux en-têtes de page. Par exemple, `\chapter` utilise 
`\chaptermark`, `\section` utilise `\sectionmark`, et ainsi de suite. 
Partant de cette idée, voici un exemple de structure à trois couches pour les chapitres :

```{noedit}
\chapter[titre court]{titre long}
\chaptermark{titre très court}
```

En voici une application à notre exemple.

```
\documentclass[french]{book}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)

\begin{document}
\tableofcontents
\chapter[Dans lequel Phileas Fogg et Passepartout s’acceptent]{%
Dans lequel Phileas Fogg et Passepartout s’acceptent réciproquement, 
l’un comme maître, l’autre comme domestique.}
\chaptermark{Phileas Fogg et Passepartout}


\newpage
En l’année 1872, la maison portant le numéro 7 de Saville-row, Burlington 
Gardens, --- maison dans laquelle Shéridan mourut en 1814, --- était habitée 
par Phileas Fogg, esq., l’un des membres les plus singuliers et les plus 
remarqués du Reform-Club de Londres, bien qu’il semblât prendre à tâche 
de ne rien faire qui pût attirer l’attention.
\end{document}
```

Les chapitres, cependant, ont la tâche facile : 
rares sont les livres où un en-tête de page est placé sur la page de début de chapitre 
(si c'est le cas, il faudra utiliser une méthode similaire à ce qui suit). 
Dans le cas des sections, il faut typiquement tenir compte de la nature des commandes 
de "marque". L'élément qui va dans l'en-tête est la première marque sur la page 
(ou, à défaut de toute marque, la toute dernière marque des pages précédentes). 
En conséquence, la technique pour les sections est plus fastidieuse :

```{noedit}
\section[titre court]{titre long\sectionmark{titre très court}}
\sectionmark{titre très court}
```

Ici, le premier `\sectionmark` traite l'en-tête de la page 
sur laquelle la commande `\section` se positionne. Le second traite l'en-tête 
des pages suivantes. Notez qu'ici, vous avez besoin de l'argument optionnel 
pour `\section`, même si le *titre court* est le même texte que le *titre long*.


## Avec la classe <ctanpkg:memoir>

La classe <ctanpkg:memoir> met en place un argument optionnel supplémentaire 
pour les commandes de chapitre et de sectionnement, par exemple :

```{noedit}
\section[titre court][titre très court]{titre long}
```

En conséquence, il est toujours possible pour les utilisateurs de <ctanpkg:memoir> 
d'adapter le texte de l'en-tête au mieux, avec très peu de problèmes.

```
\documentclass[french]{memoir}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)

\begin{document}
\tableofcontents
\chapter[Phileas Fogg et Passepartout s'acceptent][%
Phileas Fogg et Passepartout]{%
Dans lequel Phileas Fogg et Passepartout s’acceptent réciproquement, 
l’un comme maître, l’autre comme domestique.}
\newpage
En l’année 1872, la maison portant le numéro 7 de Saville-row, Burlington 
Gardens, --- maison dans laquelle Shéridan mourut en 1814, --- était habitée 
par Phileas Fogg, esq., l’un des membres les plus singuliers et les plus 
remarqués du Reform-Club de Londres, bien qu’il semblât prendre à tâche 
de ne rien faire qui pût attirer l’attention.
\end{document}
```


## Avec l'extension <ctanpkg:fancyhdr>

L'extension <ctanpkg:fancyhdr> permet, 
[entre autres fonctionnalités](raccourcir_les_rappels_de_titres_en_haut_de_page.md), 
d'étendre la manipulation des titres avec la classe `book` 
aux autres classes existantes. Voici un exemple avec la classe `article` :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{fancyhdr}
  
  \pagestyle{fancy}

\begin{document}
\tableofcontents
\section[Phileas Fogg et Passepartout]{%
Dans lequel Phileas Fogg et Passepartout s’acceptent réciproquement, 
l’un comme maître, l’autre comme domestique.}

En l’année 1872, la maison portant le numéro 7 de Saville-row, Burlington 
Gardens, --- maison dans laquelle Shéridan mourut en 1814, --- était habitée 
par Phileas Fogg, esq., l’un des membres les plus singuliers et les plus 
remarqués du Reform-Club de Londres, bien qu’il semblât prendre à tâche 
de ne rien faire qui pût attirer l’attention.
\end{document}
```

L'extension <ctanpkg:fancyhdr> peut aussi résoudre une autre difficulté : 
les problèmes de taille peuvent parfois venir du fait que LaTeX met 
les titres d'en-têtes entièrement en majuscules, moins économes en place.
Il est ici possible de passer à un texte composé normalement en se servant 
de l'extension <ctanpkg:fancyhdr>. Elle fournit une commande `\nouppercase` 
à utiliser dans les lignes d'en-tête (et de pied de page) 
pour supprimer le comportement par défaut de LaTeX. 

L'exemple ci-dessous illustre une correction possible utilisant cette extension. 

```
\documentclass[french]{book}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{fancyhdr}
  
  \fancypagestyle{fancy}{% Description de notre nouveau style de page
    \fancyhead[L]{\nouppercase{\rightmark}}
    \fancyhead[R]{\nouppercase{\leftmark}}
    \renewcommand{\headrulewidth}{0.4pt}%
  }

\begin{document}
\tableofcontents
\chapter[Phileas Fogg et Passepartout]{%
Dans lequel Phileas Fogg et Passepartout s’acceptent réciproquement, 
l’un comme maître, l’autre comme domestique.}
\pagestyle{fancy} % Passage à notre style de page
\newpage
En l’année 1872, la maison portant le numéro 7 de Saville-row, Burlington 
Gardens, --- maison dans laquelle Shéridan mourut en 1814, --- était habitée 
par Phileas Fogg, esq., l’un des membres les plus singuliers et les plus 
remarqués du Reform-Club de Londres, bien qu’il semblât prendre à tâche 
de ne rien faire qui pût attirer l’attention.
\end{document}
```


## Avec les classes <ctanpkg:KOMA-script> 

Les classes <ctanpkg:KOMA-script> proposent par défaut des en-têtes composées 
sans ces majuscules systématiques. Elles modifient par ailleurs 
beaucoup d'autres éléments de présentation, ce qui demande de bien les connaître 
pour arriver à obtenir la présentation souhaitée par ailleurs.

```
\documentclass[french]{scrbook}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)

\begin{document}
\tableofcontents
\newpage
\chapter[Phileas Fogg et Passepartout s'acceptent]{%
Dans lequel Phileas Fogg et Passepartout s’acceptent réciproquement, 
l’un comme maître, l’autre comme domestique.}
\newpage
En l’année 1872, la maison portant le numéro 7 de Saville-row, Burlington 
Gardens, --- maison dans laquelle Shéridan mourut en 1814, --- était habitée 
par Phileas Fogg, esq., l’un des membres les plus singuliers et les plus 
remarqués du Reform-Club de Londres, bien qu’il semblât prendre à tâche 
de ne rien faire qui pût attirer l’attention.
\end{document}
```

## Avec l'extension <ctanpkg:titlesec>

L'extension <ctanpkg:titlesec> gère les titres de sectionnement d'une manière 
complètement différente. Par exemple, vous pouvez utiliser l'argument facultatif 
des commandes de sectionnement pour les seuls en-têtes de page, 
ceci en chargeant l'extension avec l'option `toctitles` :

```{noedit}
\usepackage[toctitles]{titlesec}
```

Toutefois, cette technique ne fonctionne pas sur les titres de chapitre, 
raison pour laquelle nous l'illustrons ici différemment avec des titres de section, 
en utilisant l'extension <ctanpkg:fancyhdr> pour générer des titres 
sur la classe `article`.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage[toctitles]{titlesec}
  \usepackage{fancyhdr}
  \fancypagestyle{fancy}{% Description de notre nouveau style de page
    \fancyhead[L]{\nouppercase{\rightmark}}
    \fancyhead[R]{\nouppercase{\leftmark}}
    \renewcommand{\headrulewidth}{0.4pt}%
  } 

\begin{document}
\tableofcontents
\newpage
\pagestyle{fancy}
\section[Phileas Fogg et Passepartout]{Dans lequel Phileas Fogg et Passepartout 
s’acceptent réciproquement, l’un comme maître, l’autre comme domestique.}

En l’année 1872, la maison portant le numéro 7 de Saville-row, Burlington 
Gardens, --- maison dans laquelle Shéridan mourut en 1814, --- était habitée 
par Phileas Fogg, esq., l’un des membres les plus singuliers et les plus 
remarqués du Reform-Club de Londres, bien qu’il semblât prendre à tâche 
de ne rien faire qui pût attirer l’attention.
\end{document}
```

La [documentation de l'extension](texdoc:titlesec) propose d'autres techniques utiles 
dans ce domaine.

:::{sources}
[My section title is too wide for the page header](faquk:FAQ-runheadtoobig)
:::
