use axum::Extension;
use miette::IntoDiagnostic;
use tower_livereload::LiveReloadLayer;

mod webmention;

use webmention::{SharedState, WebmentionState};

#[tokio::main]
#[tracing::instrument]
async fn main() -> miette::Result<()> {
    tracing_forest::init();
    let livereload_layer = LiveReloadLayer::new();

    // Create shared state for domain approval
    let shared_state = SharedState::new();

    // Create state for webmention record storage
    let webmention_state = WebmentionState::new();

    // Set up the router with webmention routes and state
    let app = webmention::router()
        .layer(Extension(shared_state))
        .layer(Extension(webmention_state))
        .layer(livereload_layer);

    let listener = tokio::net::TcpListener::bind("127.0.0.1:8080")
        .await
        .into_diagnostic()?;

    tracing::trace!("Listening at http://127.0.0.1:8080 with a sample Webmention server with Vouch support");
    axum::serve(listener, app).await.into_diagnostic()?;

    Ok(())
}