% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cli.R
\name{cli_li}
\alias{cli_li}
\title{CLI list item(s)}
\usage{
cli_li(
  items = NULL,
  labels = names(items),
  id = NULL,
  class = NULL,
  .auto_close = TRUE,
  .envir = parent.frame()
)
}
\arguments{
\item{items}{Character vector of items, or \code{NULL}.}

\item{labels}{For definition lists the item labels.}

\item{id}{Id of the new container. Can be used for closing it with
\code{\link[=cli_end]{cli_end()}} or in themes. If \code{NULL}, then an id is generated and
returned invisibly.}

\item{class}{Class of the item container. Can be used in themes.}

\item{.auto_close}{Whether to close the container, when the calling
function finishes (or \code{.envir} is removed, if specified).}

\item{.envir}{Environment to evaluate the glue expressions in. It is
also used to auto-close the container if \code{.auto_close} is \code{TRUE}.}
}
\value{
The id of the new container element, invisibly.
}
\description{
A list item is a container, see \link{containers}.
}
\details{
\subsection{Nested lists}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{fun <- function() \{
  ul <- cli_ul()
  cli_li("one:")
  cli_ol(letters[1:3])
  cli_li("two:")
  cli_li("three")
  cli_end(ul)
\}
fun()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> • one:                                                                          
#>   1. a                                                                          
#>   2. b                                                                          
#>   3. c                                                                          
#> • two:                                                                          
#> • three                                                                         
</pre></div>
}}

}
}
\seealso{
This function supports \link[=inline-markup]{inline markup}.

Other functions supporting inline markup: 
\code{\link{cli_abort}()},
\code{\link{cli_alert}()},
\code{\link{cli_blockquote}()},
\code{\link{cli_bullets}()},
\code{\link{cli_bullets_raw}()},
\code{\link{cli_dl}()},
\code{\link{cli_h1}()},
\code{\link{cli_ol}()},
\code{\link{cli_process_start}()},
\code{\link{cli_progress_along}()},
\code{\link{cli_progress_bar}()},
\code{\link{cli_progress_message}()},
\code{\link{cli_progress_output}()},
\code{\link{cli_progress_step}()},
\code{\link{cli_rule}},
\code{\link{cli_status}()},
\code{\link{cli_status_update}()},
\code{\link{cli_text}()},
\code{\link{cli_ul}()},
\code{\link{format_error}()},
\code{\link{format_inline}()}
}
\concept{functions supporting inline markup}
