# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, List, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models


class ManagementLockListResult(_serialization.Model):
    """The list of locks.

    :ivar value: The list of locks.
    :vartype value: list[~azure.mgmt.resource.locks.models.ManagementLockObject]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagementLockObject]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ManagementLockObject"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of locks.
        :paramtype value: list[~azure.mgmt.resource.locks.models.ManagementLockObject]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ManagementLockObject(_serialization.Model):
    """The lock information.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The resource ID of the lock.
    :vartype id: str
    :ivar type: The resource type of the lock - Microsoft.Authorization/locks.
    :vartype type: str
    :ivar name: The name of the lock.
    :vartype name: str
    :ivar level: The level of the lock. Possible values are: NotSpecified, CanNotDelete, ReadOnly.
     CanNotDelete means authorized users are able to read and modify the resources, but not delete.
     ReadOnly means authorized users can only read from a resource, but they can't modify or delete
     it. Required. Known values are: "NotSpecified", "CanNotDelete", and "ReadOnly".
    :vartype level: str or ~azure.mgmt.resource.locks.models.LockLevel
    :ivar notes: Notes about the lock. Maximum of 512 characters.
    :vartype notes: str
    :ivar owners: The owners of the lock.
    :vartype owners: list[~azure.mgmt.resource.locks.models.ManagementLockOwner]
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
        "name": {"readonly": True},
        "level": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "level": {"key": "properties.level", "type": "str"},
        "notes": {"key": "properties.notes", "type": "str"},
        "owners": {"key": "properties.owners", "type": "[ManagementLockOwner]"},
    }

    def __init__(
        self,
        *,
        level: Union[str, "_models.LockLevel"],
        notes: Optional[str] = None,
        owners: Optional[List["_models.ManagementLockOwner"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword level: The level of the lock. Possible values are: NotSpecified, CanNotDelete,
         ReadOnly. CanNotDelete means authorized users are able to read and modify the resources, but
         not delete. ReadOnly means authorized users can only read from a resource, but they can't
         modify or delete it. Required. Known values are: "NotSpecified", "CanNotDelete", and
         "ReadOnly".
        :paramtype level: str or ~azure.mgmt.resource.locks.models.LockLevel
        :keyword notes: Notes about the lock. Maximum of 512 characters.
        :paramtype notes: str
        :keyword owners: The owners of the lock.
        :paramtype owners: list[~azure.mgmt.resource.locks.models.ManagementLockOwner]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.type: Optional[str] = None
        self.name: Optional[str] = None
        self.level = level
        self.notes = notes
        self.owners = owners


class ManagementLockOwner(_serialization.Model):
    """Lock owner properties.

    :ivar application_id: The application ID of the lock owner.
    :vartype application_id: str
    """

    _attribute_map = {
        "application_id": {"key": "applicationId", "type": "str"},
    }

    def __init__(self, *, application_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword application_id: The application ID of the lock owner.
        :paramtype application_id: str
        """
        super().__init__(**kwargs)
        self.application_id = application_id


class Operation(_serialization.Model):
    """Microsoft.Authorization operation.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The object that represents the operation.
    :vartype display: ~azure.mgmt.resource.locks.models.OperationDisplay
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
    }

    def __init__(
        self, *, name: Optional[str] = None, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: The object that represents the operation.
        :paramtype display: ~azure.mgmt.resource.locks.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display


class OperationDisplay(_serialization.Model):
    """The object that represents the operation.

    :ivar provider: Service provider: Microsoft.Authorization.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: Profile, endpoint, etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Service provider: Microsoft.Authorization.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed: Profile, endpoint, etc.
        :paramtype resource: str
        :keyword operation: Operation type: Read, write, delete, etc.
        :paramtype operation: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation


class OperationListResult(_serialization.Model):
    """Result of the request to list Microsoft.Authorization operations. It contains a list of
    operations and a URL link to get the next set of results.

    :ivar value: List of Microsoft.Authorization operations.
    :vartype value: list[~azure.mgmt.resource.locks.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Operation"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Microsoft.Authorization operations.
        :paramtype value: list[~azure.mgmt.resource.locks.models.Operation]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link
