# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

from typing import Any, List, Mapping, Optional, TYPE_CHECKING, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class DecompileOperationRequest(_Model):
    """The body of the request for the decompileBicep operation.

    :ivar template: The ARM json template to be decompiled into a Bicep file. Required.
    :vartype template: str
    """

    template: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ARM json template to be decompiled into a Bicep file. Required."""

    @overload
    def __init__(
        self,
        *,
        template: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DecompileOperationSuccessResponse(_Model):
    """The response of the decompileBicep operation.

    :ivar files: An array of key-value pairs containing the entryPoint string as the key for the
     Bicep file decompiled from the ARM json template. Required.
    :vartype files: list[~azure.mgmt.resource.bicep.models.FileDefinition]
    :ivar entry_point: The file path to the main Bicep file generated from the decompiled ARM json
     template. Required.
    :vartype entry_point: str
    """

    files: List["_models.FileDefinition"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An array of key-value pairs containing the entryPoint string as the key for the Bicep file
     decompiled from the ARM json template. Required."""
    entry_point: str = rest_field(name="entryPoint", visibility=["read", "create", "update", "delete", "query"])
    """The file path to the main Bicep file generated from the decompiled ARM json template. Required."""

    @overload
    def __init__(
        self,
        *,
        files: List["_models.FileDefinition"],
        entry_point: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.resource.bicep.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.resource.bicep.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.resource.bicep.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FileDefinition(_Model):
    """The definition of a file along with its contents.

    :ivar path: The file path of the Bicep file.
    :vartype path: str
    :ivar contents: The contents of the Bicep file.
    :vartype contents: str
    """

    path: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The file path of the Bicep file."""
    contents: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The contents of the Bicep file."""

    @overload
    def __init__(
        self,
        *,
        path: Optional[str] = None,
        contents: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
