# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class CompositionMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of CompositionMode."""

    SEPARATE_COMPONENTS = "separateComponents"
    """Every component's match or prediction is returned as a separate instance of the entity."""
    COMBINE_COMPONENTS = "combineComponents"
    """When two or more components are found in the text and overlap, the components' spans are merged
    together into one span combining all of them."""


class EvaluationKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of EvaluationKind."""

    PERCENTAGE = "percentage"
    """Split the data into training and test sets according to user-defined percentages."""
    MANUAL = "manual"
    """Split the data according to the chosen dataset for every example in the data."""


class OperationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of OperationStatus."""

    NOT_STARTED = "notStarted"
    RUNNING = "running"
    SUCCEEDED = "succeeded"
    FAILED = "failed"
    CANCELLED = "cancelled"
    CANCELLING = "cancelling"
    PARTIALLY_COMPLETED = "partiallyCompleted"


class ProjectKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of ProjectKind."""

    CUSTOM_SINGLE_LABEL_CLASSIFICATION = "CustomSingleLabelClassification"
    """For building a classification model to classify text using your own data. Each file will have
    only one label. For example, file 1 is classified as A and file 2 is classified as B."""
    CUSTOM_MULTI_LABEL_CLASSIFICATION = "CustomMultiLabelClassification"
    """For building a classification model to classify text using your own data. Each file can have
    one or many labels. For example, file 1 is classified as A, B, and C and file 2 is classified
    as B and C."""
    CUSTOM_ENTITY_RECOGNITION = "CustomEntityRecognition"
    """For building an extraction model to identify your domain categories using your own data."""
    CUSTOM_ABSTRACTIVE_SUMMARIZATION = "CustomAbstractiveSummarization"
    """For building an abstractive summarization models which are able to summarize long documents."""
    CUSTOM_HEALTHCARE = "CustomHealthcare"
    """For building an text analytics for health model to identify your health domain data."""
    CUSTOM_TEXT_SENTIMENT = "CustomTextSentiment"
    """For building a sentiment models which are able to extract sentiment for long documents."""


class Sentiment(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of Sentiment."""

    POSITIVE = "positive"
    NEGATIVE = "negative"
    NEUTRAL = "neutral"


class StringIndexType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of StringIndexType."""

    UTF16_CODE_UNIT = "Utf16CodeUnit"
    """The offset and length values will correspond to UTF-16 code units. Use this option if your
    application is written in a language that support Unicode, for example Java, JavaScript."""
