# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.authorization.aio import AuthorizationManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAuthorizationManagementAccessReviewInstanceOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AuthorizationManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_access_review_instance_stop(self, resource_group):
        response = await self.client.access_review_instance.stop(
            schedule_definition_id="str",
            id="str",
            api_version="2021-12-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_access_review_instance_reset_decisions(self, resource_group):
        response = await self.client.access_review_instance.reset_decisions(
            schedule_definition_id="str",
            id="str",
            api_version="2021-12-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_access_review_instance_apply_decisions(self, resource_group):
        response = await self.client.access_review_instance.apply_decisions(
            schedule_definition_id="str",
            id="str",
            api_version="2021-12-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_access_review_instance_send_reminders(self, resource_group):
        response = await self.client.access_review_instance.send_reminders(
            schedule_definition_id="str",
            id="str",
            api_version="2021-12-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_access_review_instance_accept_recommendations(self, resource_group):
        response = await self.client.access_review_instance.accept_recommendations(
            schedule_definition_id="str",
            id="str",
            api_version="2021-12-01-preview",
        )

        # please add some check logic here by yourself
        # ...
