
// tiltdrivepro_in_table generated by DK/circ_table_gen.py -- do not modify manually

 // variables used
 // --sig_max  1.500000
 // --table_div  1.700617
 // --table_op  1.000000

struct tabletiltdrivepro_in { // 1-dimensional function table
    float low;
    float high;
    float istep;
    int size;
    float data[];
};

template <int tab_size>
struct tabletiltdrivepro_in_imp {
    float low;
    float high;
    float istep;
    int size;
    float data[tab_size];
    operator tabletiltdrivepro_in&() const { return *(tabletiltdrivepro_in*)this; }
};

 static tabletiltdrivepro_in_imp<2048> tiltdrivepro_in_table __rt_data = {
	0,-0.833333,1364.67,2048, {
	0.000000000000,-0.001434182008,-0.002882956218,-0.004344346759,-0.005816497532,
	-0.007297666177,-0.008786218339,-0.010280622178,-0.011779443156,-0.013281339047,
	-0.014785055197,-0.016289419994,-0.017793340555,-0.019295798619,-0.020795846626,
	-0.022292603990,-0.023785253541,-0.025273038144,-0.026755257472,-0.028231264936,
	-0.029700464765,-0.031162309221,-0.032616295953,-0.034061965477,-0.035498898779,
	-0.036926715031,-0.038345069427,-0.039753651116,-0.041152181244,-0.042540411084,
	-0.043918120269,-0.045285115107,-0.046641226978,-0.047986310820,-0.049320243677,
	-0.050642923339,-0.051954267033,-0.053254210193,-0.054542705289,-0.055819720709,
	-0.057085239725,-0.058339259467,-0.059581789998,-0.060812853406,-0.062032482961,
	-0.063240722307,-0.064437624704,-0.065623252302,-0.066797675466,-0.067960972128,
	-0.069113227180,-0.070254531895,-0.071384983388,-0.072504684101,-0.073613741319,
	-0.074712266711,-0.075800375906,-0.076878188081,-0.077945825581,-0.079003413563,
	-0.080051079654,-0.081088953633,-0.082117167136,-0.083135853375,-0.084145146871,
	-0.085145183214,-0.086136098828,-0.087118030757,-0.088091116462,-0.089055493636,
	-0.090011300022,-0.090958673258,-0.091897750717,-0.092828669368,-0.093751565647,
	-0.094666575333,-0.095573833434,-0.096473474088,-0.097365630462,-0.098250434667,
	-0.099128017675,-0.099998509249,-0.100862037870,-0.101718730683,-0.102568713433,
	-0.103412110422,-0.104249044463,-0.105079636834,-0.105904007251,-0.106722273833,
	-0.107534553071,-0.108340959813,-0.109141607236,-0.109936606834,-0.110726068404,
	-0.111510100036,-0.112288808102,-0.113062297255,-0.113830670422,-0.114594028809,
	-0.115352471897,-0.116106097448,-0.116855001509,-0.117599278421,-0.118339020825,
	-0.119074319674,-0.119805264241,-0.120531942135,-0.121254439312,-0.121972840090,
	-0.122687227165,-0.123397681627,-0.124104282976,-0.124807109141,-0.125506236498,
	-0.126201739889,-0.126893692640,-0.127582166585,-0.128267232080,-0.128948958029,
	-0.129627411903,-0.130302659759,-0.130974766266,-0.131643794722,-0.132309807078,
	-0.132972863960,-0.133633024689,-0.134290347304,-0.134944888585,-0.135596704073,
	-0.136245848091,-0.136892373768,-0.137536333060,-0.138177776772,-0.138816754577,
	-0.139453315039,-0.140087505635,-0.140719372773,-0.141348961816,-0.141976317102,
	-0.142601481960,-0.143224498737,-0.143845408812,-0.144464252620,-0.145081069668,
	-0.145695898555,-0.146308776994,-0.146919741825,-0.147528829040,-0.148136073793,
	-0.148741510427,-0.149345172484,-0.149947092727,-0.150547303155,-0.151145835019,
	-0.151742718841,-0.152337984428,-0.152931660890,-0.153523776651,-0.154114359471,
	-0.154703436456,-0.155291034076,-0.155877178176,-0.156461893995,-0.157045206175,
	-0.157627138778,-0.158207715299,-0.158786958677,-0.159364891312,-0.159941535074,
	-0.160516911317,-0.161091040890,-0.161663944153,-0.162235640980,-0.162806150782,
	-0.163375492508,-0.163943684662,-0.164510745311,-0.165076692096,-0.165641542244,
	-0.166205312576,-0.166768019516,-0.167329679103,-0.167890307001,-0.168449918504,
	-0.169008528550,-0.169566151725,-0.170122802275,-0.170678494114,-0.171233240830,
	-0.171787055697,-0.172339951677,-0.172891941433,-0.173443037334,-0.173993251464,
	-0.174542595625,-0.175091081349,-0.175638719902,-0.176185522291,-0.176731499270,
	-0.177276661349,-0.177821018795,-0.178364581644,-0.178907359703,-0.179449362557,
	-0.179990599572,-0.180531079907,-0.181070812510,-0.181609806133,-0.182148069330,
	-0.182685610464,-0.183222437712,-0.183758559072,-0.184293982362,-0.184828715230,
	-0.185362765156,-0.185896139456,-0.186428845286,-0.186960889648,-0.187492279390,
	-0.188023021216,-0.188553121683,-0.189082587209,-0.189611424075,-0.190139638428,
	-0.190667236288,-0.191194223545,-0.191720605968,-0.192246389203,-0.192771578781,
	-0.193296180120,-0.193820198523,-0.194343639186,-0.194866507201,-0.195388807555,
	-0.195910545134,-0.196431724728,-0.196952351029,-0.197472428638,-0.197991962065,
	-0.198510955729,-0.199029413966,-0.199547341027,-0.200064741079,-0.200581618212,
	-0.201097976436,-0.201613819685,-0.202129151821,-0.202643976632,-0.203158297835,
	-0.203672119080,-0.204185443949,-0.204698275958,-0.205210618562,-0.205722475151,
	-0.206233849055,-0.206744743546,-0.207255161838,-0.207765107089,-0.208274582400,
	-0.208783590821,-0.209292135350,-0.209800218932,-0.210307844463,-0.210815014792,
	-0.211321732718,-0.211828000998,-0.212333822339,-0.212839199408,-0.213344134827,
	-0.213848631177,-0.214352690997,-0.214856316787,-0.215359511010,-0.215862276086,
	-0.216364614403,-0.216866528310,-0.217368020120,-0.217869092114,-0.218369746538,
	-0.218869985604,-0.219369811493,-0.219869226354,-0.220368232306,-0.220866831437,
	-0.221365025806,-0.221862817443,-0.222360208351,-0.222857200505,-0.223353795853,
	-0.223849996318,-0.224345803794,-0.224841220155,-0.225336247246,-0.225830886892,
	-0.226325140890,-0.226819011020,-0.227312499034,-0.227805606665,-0.228298335624,
	-0.228790687602,-0.229282664267,-0.229774267270,-0.230265498241,-0.230756358789,
	-0.231246850507,-0.231736974967,-0.232226733726,-0.232716128321,-0.233205160272,
	-0.233693831082,-0.234182142239,-0.234670095212,-0.235157691455,-0.235644932409,
	-0.236131819495,-0.236618354123,-0.237104537686,-0.237590371563,-0.238075857120,
	-0.238560995707,-0.239045788662,-0.239530237310,-0.240014342961,-0.240498106913,
	-0.240981530452,-0.241464614851,-0.241947361371,-0.242429771260,-0.242911845757,
	-0.243393586087,-0.243874993464,-0.244356069091,-0.244836814161,-0.245317229855,
	-0.245797317344,-0.246277077790,-0.246756512342,-0.247235622141,-0.247714408318,
	-0.248192871992,-0.248671014277,-0.249148836274,-0.249626339075,-0.250103523764,
	-0.250580391417,-0.251056943098,-0.251533179866,-0.252009102769,-0.252484712847,
	-0.252960011134,-0.253434998652,-0.253909676418,-0.254384045440,-0.254858106718,
	-0.255331861246,-0.255805310007,-0.256278453981,-0.256751294137,-0.257223831439,
	-0.257696066842,-0.258168001296,-0.258639635742,-0.259110971117,-0.259582008347,
	-0.260052748356,-0.260523192059,-0.260993340364,-0.261463194174,-0.261932754384,
	-0.262402021885,-0.262870997560,-0.263339682288,-0.263808076939,-0.264276182379,
	-0.264743999468,-0.265211529061,-0.265678772004,-0.266145729143,-0.266612401312,
	-0.267078789344,-0.267544894066,-0.268010716297,-0.268476256853,-0.268941516545,
	-0.269406496177,-0.269871196549,-0.270335618456,-0.270799762688,-0.271263630029,
	-0.271727221258,-0.272190537152,-0.272653578479,-0.273116346005,-0.273578840491,
	-0.274041062692,-0.274503013360,-0.274964693242,-0.275426103078,-0.275887243608,
	-0.276348115563,-0.276808719673,-0.277269056663,-0.277729127251,-0.278188932154,
	-0.278648472083,-0.279107747746,-0.279566759846,-0.280025509081,-0.280483996147,
	-0.280942221734,-0.281400186529,-0.281857891215,-0.282315336471,-0.282772522971,
	-0.283229451388,-0.283686122387,-0.284142536633,-0.284598694785,-0.285054597499,
	-0.285510245426,-0.285965639217,-0.286420779515,-0.286875666961,-0.287330302193,
	-0.287784685846,-0.288238818548,-0.288692700929,-0.289146333610,-0.289599717212,
	-0.290052852352,-0.290505739642,-0.290958379693,-0.291410773111,-0.291862920498,
	-0.292314822455,-0.292766479579,-0.293217892462,-0.293669061694,-0.294119987863,
	-0.294570671552,-0.295021113341,-0.295471313808,-0.295921273528,-0.296370993070,
	-0.296820473003,-0.297269713893,-0.297718716301,-0.298167480786,-0.298616007905,
	-0.299064298210,-0.299512352251,-0.299960170575,-0.300407753728,-0.300855102250,
	-0.301302216679,-0.301749097552,-0.302195745401,-0.302642160756,-0.303088344145,
	-0.303534296092,-0.303980017119,-0.304425507744,-0.304870768485,-0.305315799854,
	-0.305760602363,-0.306205176520,-0.306649522830,-0.307093641797,-0.307537533921,
	-0.307981199699,-0.308424639627,-0.308867854198,-0.309310843901,-0.309753609224,
	-0.310196150653,-0.310638468669,-0.311080563753,-0.311522436383,-0.311964087034,
	-0.312405516177,-0.312846724285,-0.313287711824,-0.313728479260,-0.314169027057,
	-0.314609355675,-0.315049465572,-0.315489357205,-0.315929031027,-0.316368487490,
	-0.316807727043,-0.317246750133,-0.317685557204,-0.318124148700,-0.318562525060,
	-0.319000686722,-0.319438634122,-0.319876367694,-0.320313887868,-0.320751195074,
	-0.321188289739,-0.321625172288,-0.322061843144,-0.322498302727,-0.322934551456,
	-0.323370589748,-0.323806418016,-0.324242036672,-0.324677446129,-0.325112646792,
	-0.325547639069,-0.325982423364,-0.326417000078,-0.326851369612,-0.327285532365,
	-0.327719488731,-0.328153239106,-0.328586783882,-0.329020123449,-0.329453258194,
	-0.329886188506,-0.330318914768,-0.330751437364,-0.331183756672,-0.331615873074,
	-0.332047786945,-0.332479498661,-0.332911008596,-0.333342317120,-0.333773424603,
	-0.334204331414,-0.334635037918,-0.335065544479,-0.335495851461,-0.335925959223,
	-0.336355868125,-0.336785578524,-0.337215090776,-0.337644405233,-0.338073522249,
	-0.338502442173,-0.338931165355,-0.339359692140,-0.339788022874,-0.340216157901,
	-0.340644097563,-0.341071842199,-0.341499392149,-0.341926747749,-0.342353909335,
	-0.342780877240,-0.343207651797,-0.343634233336,-0.344060622185,-0.344486818673,
	-0.344912823124,-0.345338635864,-0.345764257214,-0.346189687496,-0.346614927029,
	-0.347039976131,-0.347464835120,-0.347889504309,-0.348313984012,-0.348738274541,
	-0.349162376207,-0.349586289318,-0.350010014183,-0.350433551107,-0.350856900395,
	-0.351280062349,-0.351703037273,-0.352125825465,-0.352548427225,-0.352970842850,
	-0.353393072637,-0.353815116879,-0.354236975871,-0.354658649904,-0.355080139268,
	-0.355501444253,-0.355922565147,-0.356343502235,-0.356764255803,-0.357184826134,
	-0.357605213512,-0.358025418216,-0.358445440527,-0.358865280723,-0.359284939081,
	-0.359704415878,-0.360123711387,-0.360542825882,-0.360961759634,-0.361380512915,
	-0.361799085995,-0.362217479140,-0.362635692618,-0.363053726696,-0.363471581636,
	-0.363889257703,-0.364306755159,-0.364724074264,-0.365141215278,-0.365558178459,
	-0.365974964065,-0.366391572352,-0.366808003574,-0.367224257985,-0.367640335838,
	-0.368056237384,-0.368471962873,-0.368887512554,-0.369302886676,-0.369718085484,
	-0.370133109225,-0.370547958142,-0.370962632481,-0.371377132481,-0.371791458386,
	-0.372205610435,-0.372619588866,-0.373033393919,-0.373447025829,-0.373860484832,
	-0.374273771163,-0.374686885056,-0.375099826743,-0.375512596456,-0.375925194425,
	-0.376337620879,-0.376749876048,-0.377161960157,-0.377573873434,-0.377985616104,
	-0.378397188391,-0.378808590518,-0.379219822709,-0.379630885183,-0.380041778161,
	-0.380452501863,-0.380863056507,-0.381273442310,-0.381683659488,-0.382093708258,
	-0.382503588833,-0.382913301427,-0.383322846253,-0.383732223522,-0.384141433445,
	-0.384550476231,-0.384959352090,-0.385368061229,-0.385776603855,-0.386184980175,
	-0.386593190393,-0.387001234714,-0.387409113341,-0.387816826476,-0.388224374322,
	-0.388631757078,-0.389038974945,-0.389446028122,-0.389852916806,-0.390259641195,
	-0.390666201485,-0.391072597872,-0.391478830549,-0.391884899712,-0.392290805553,
	-0.392696548264,-0.393102128037,-0.393507545061,-0.393912799527,-0.394317891623,
	-0.394722821537,-0.395127589457,-0.395532195568,-0.395936640057,-0.396340923108,
	-0.396745044905,-0.397149005632,-0.397552805470,-0.397956444602,-0.398359923208,
	-0.398763241468,-0.399166399562,-0.399569397668,-0.399972235965,-0.400374914628,
	-0.400777433835,-0.401179793761,-0.401581994580,-0.401984036468,-0.402385919596,
	-0.402787644138,-0.403189210266,-0.403590618151,-0.403991867962,-0.404392959871,
	-0.404793894046,-0.405194670655,-0.405595289866,-0.405995751845,-0.406396056760,
	-0.406796204775,-0.407196196055,-0.407596030765,-0.407995709067,-0.408395231125,
	-0.408794597101,-0.409193807157,-0.409592861452,-0.409991760147,-0.410390503402,
	-0.410789091376,-0.411187524225,-0.411585802109,-0.411983925184,-0.412381893605,
	-0.412779707530,-0.413177367111,-0.413574872505,-0.413972223864,-0.414369421342,
	-0.414766465091,-0.415163355263,-0.415560092009,-0.415956675479,-0.416353105824,
	-0.416749383194,-0.417145507735,-0.417541479598,-0.417937298930,-0.418332965877,
	-0.418728480586,-0.419123843202,-0.419519053872,-0.419914112740,-0.420309019949,
	-0.420703775643,-0.421098379966,-0.421492833059,-0.421887135065,-0.422281286124,
	-0.422675286378,-0.423069135966,-0.423462835028,-0.423856383704,-0.424249782131,
	-0.424643030448,-0.425036128791,-0.425429077299,-0.425821876107,-0.426214525351,
	-0.426607025166,-0.426999375687,-0.427391577049,-0.427783629384,-0.428175532827,
	-0.428567287510,-0.428958893565,-0.429350351123,-0.429741660317,-0.430132821276,
	-0.430523834131,-0.430914699012,-0.431305416047,-0.431695985365,-0.432086407095,
	-0.432476681364,-0.432866808299,-0.433256788027,-0.433646620675,-0.434036306368,
	-0.434425845231,-0.434815237390,-0.435204482968,-0.435593582090,-0.435982534878,
	-0.436371341457,-0.436760001948,-0.437148516473,-0.437536885155,-0.437925108114,
	-0.438313185470,-0.438701117345,-0.439088903858,-0.439476545128,-0.439864041275,
	-0.440251392416,-0.440638598670,-0.441025660155,-0.441412576987,-0.441799349283,
	-0.442185977161,-0.442572460735,-0.442958800121,-0.443344995434,-0.443731046789,
	-0.444116954300,-0.444502718081,-0.444888338246,-0.445273814907,-0.445659148177,
	-0.446044338168,-0.446429384992,-0.446814288760,-0.447199049584,-0.447583667573,
	-0.447968142839,-0.448352475491,-0.448736665638,-0.449120713390,-0.449504618855,
	-0.449888382142,-0.450272003357,-0.450655482610,-0.451038820007,-0.451422015654,
	-0.451805069659,-0.452187982127,-0.452570753163,-0.452953382874,-0.453335871364,
	-0.453718218738,-0.454100425099,-0.454482490553,-0.454864415201,-0.455246199148,
	-0.455627842496,-0.456009345347,-0.456390707804,-0.456771929969,-0.457153011942,
	-0.457533953825,-0.457914755719,-0.458295417723,-0.458675939938,-0.459056322464,
	-0.459436565400,-0.459816668844,-0.460196632897,-0.460576457655,-0.460956143217,
	-0.461335689681,-0.461715097144,-0.462094365704,-0.462473495456,-0.462852486497,
	-0.463231338924,-0.463610052832,-0.463988628317,-0.464367065473,-0.464745364397,
	-0.465123525181,-0.465501547921,-0.465879432710,-0.466257179642,-0.466634788810,
	-0.467012260308,-0.467389594228,-0.467766790662,-0.468143849702,-0.468520771441,
	-0.468897555970,-0.469274203380,-0.469650713762,-0.470027087207,-0.470403323806,
	-0.470779423647,-0.471155386821,-0.471531213418,-0.471906903527,-0.472282457236,
	-0.472657874635,-0.473033155812,-0.473408300855,-0.473783309851,-0.474158182889,
	-0.474532920056,-0.474907521438,-0.475281987123,-0.475656317198,-0.476030511747,
	-0.476404570858,-0.476778494616,-0.477152283106,-0.477525936414,-0.477899454625,
	-0.478272837823,-0.478646086092,-0.479019199518,-0.479392178183,-0.479765022172,
	-0.480137731568,-0.480510306454,-0.480882746912,-0.481255053027,-0.481627224879,
	-0.481999262552,-0.482371166128,-0.482742935687,-0.483114571311,-0.483486073082,
	-0.483857441081,-0.484228675388,-0.484599776084,-0.484970743249,-0.485341576963,
	-0.485712277306,-0.486082844358,-0.486453278198,-0.486823578905,-0.487193746558,
	-0.487563781235,-0.487933683016,-0.488303451978,-0.488673088199,-0.489042591758,
	-0.489411962731,-0.489781201196,-0.490150307230,-0.490519280911,-0.490888122314,
	-0.491256831517,-0.491625408595,-0.491993853625,-0.492362166682,-0.492730347842,
	-0.493098397181,-0.493466314774,-0.493834100695,-0.494201755020,-0.494569277823,
	-0.494936669179,-0.495303929162,-0.495671057845,-0.496038055303,-0.496404921609,
	-0.496771656837,-0.497138261060,-0.497504734350,-0.497871076782,-0.498237288426,
	-0.498603369356,-0.498969319645,-0.499335139363,-0.499700828583,-0.500066387377,
	-0.500431815815,-0.500797113970,-0.501162281912,-0.501527319713,-0.501892227443,
	-0.502257005172,-0.502621652972,-0.502986170911,-0.503350559061,-0.503714817491,
	-0.504078946271,-0.504442945469,-0.504806815156,-0.505170555401,-0.505534166273,
	-0.505897647839,-0.506261000170,-0.506624223333,-0.506987317396,-0.507350282428,
	-0.507713118497,-0.508075825670,-0.508438404016,-0.508800853600,-0.509163174491,
	-0.509525366756,-0.509887430461,-0.510249365674,-0.510611172461,-0.510972850888,
	-0.511334401021,-0.511695822928,-0.512057116673,-0.512418282322,-0.512779319942,
	-0.513140229597,-0.513501011354,-0.513861665276,-0.514222191429,-0.514582589879,
	-0.514942860689,-0.515303003924,-0.515663019649,-0.516022907927,-0.516382668824,
	-0.516742302402,-0.517101808726,-0.517461187860,-0.517820439866,-0.518179564808,
	-0.518538562750,-0.518897433755,-0.519256177884,-0.519614795202,-0.519973285771,
	-0.520331649653,-0.520689886910,-0.521047997605,-0.521405981801,-0.521763839558,
	-0.522121570939,-0.522479176005,-0.522836654818,-0.523194007439,-0.523551233930,
	-0.523908334351,-0.524265308764,-0.524622157230,-0.524978879808,-0.525335476560,
	-0.525691947546,-0.526048292827,-0.526404512462,-0.526760606512,-0.527116575037,
	-0.527472418096,-0.527828135750,-0.528183728057,-0.528539195077,-0.528894536869,
	-0.529249753493,-0.529604845007,-0.529959811471,-0.530314652944,-0.530669369483,
	-0.531023961148,-0.531378427996,-0.531732770087,-0.532086987479,-0.532441080229,
	-0.532795048395,-0.533148892036,-0.533502611208,-0.533856205971,-0.534209676380,
	-0.534563022494,-0.534916244369,-0.535269342064,-0.535622315634,-0.535975165136,
	-0.536327890629,-0.536680492167,-0.537032969809,-0.537385323609,-0.537737553625,
	-0.538089659913,-0.538441642529,-0.538793501529,-0.539145236968,-0.539496848903,
	-0.539848337390,-0.540199702483,-0.540550944239,-0.540902062712,-0.541253057958,
	-0.541603930033,-0.541954678990,-0.542305304886,-0.542655807775,-0.543006187711,
	-0.543356444750,-0.543706578945,-0.544056590352,-0.544406479025,-0.544756245017,
	-0.545105888383,-0.545455409177,-0.545804807453,-0.546154083265,-0.546503236667,
	-0.546852267711,-0.547201176452,-0.547549962944,-0.547898627238,-0.548247169390,
	-0.548595589451,-0.548943887475,-0.549292063515,-0.549640117623,-0.549988049853,
	-0.550335860257,-0.550683548888,-0.551031115798,-0.551378561040,-0.551725884666,
	-0.552073086728,-0.552420167278,-0.552767126368,-0.553113964051,-0.553460680378,
	-0.553807275401,-0.554153749171,-0.554500101741,-0.554846333161,-0.555192443483,
	-0.555538432759,-0.555884301039,-0.556230048375,-0.556575674818,-0.556921180419,
	-0.557266565229,-0.557611829298,-0.557956972678,-0.558301995419,-0.558646897571,
	-0.558991679185,-0.559336340312,-0.559680881001,-0.560025301304,-0.560369601269,
	-0.560713780948,-0.561057840390,-0.561401779645,-0.561745598763,-0.562089297794,
	-0.562432876787,-0.562776335792,-0.563119674859,-0.563462894036,-0.563805993374,
	-0.564148972922,-0.564491832728,-0.564834572842,-0.565177193313,-0.565519694190,
	-0.565862075522,-0.566204337358,-0.566546479746,-0.566888502736,-0.567230406375,
	-0.567572190712,-0.567913855796,-0.568255401675,-0.568596828398,-0.568938136012,
	-0.569279324566,-0.569620394108,-0.569961344686,-0.570302176348,-0.570642889142,
	-0.570983483115,-0.571323958316,-0.571664314792,-0.572004552590,-0.572344671758,
	-0.572684672344,-0.573024554396,-0.573364317959,-0.573703963082,-0.574043489812,
	-0.574382898196,-0.574722188281,-0.575061360113,-0.575400413741,-0.575739349211,
	-0.576078166569,-0.576416865862,-0.576755447137,-0.577093910441,-0.577432255820,
	-0.577770483320,-0.578108592988,-0.578446584871,-0.578784459014,-0.579122215464,
	-0.579459854267,-0.579797375469,-0.580134779116,-0.580472065254,-0.580809233929,
	-0.581146285186,-0.581483219072,-0.581820035633,-0.582156734913,-0.582493316959,
	-0.582829781816,-0.583166129529,-0.583502360144,-0.583838473707,-0.584174470262,
	-0.584510349855,-0.584846112531,-0.585181758335,-0.585517287312,-0.585852699508,
	-0.586187994966,-0.586523173733,-0.586858235852,-0.587193181369,-0.587528010329,
	-0.587862722775,-0.588197318754,-0.588531798308,-0.588866161483,-0.589200408323,
	-0.589534538873,-0.589868553177,-0.590202451278,-0.590536233222,-0.590869899053,
	-0.591203448814,-0.591536882550,-0.591870200304,-0.592203402121,-0.592536488045,
	-0.592869458119,-0.593202312387,-0.593535050894,-0.593867673681,-0.594200180794,
	-0.594532572276,-0.594864848170,-0.595197008521,-0.595529053370,-0.595860982762,
	-0.596192796740,-0.596524495347,-0.596856078627,-0.597187546623,-0.597518899377,
	-0.597850136933,-0.598181259334,-0.598512266623,-0.598843158843,-0.599173936037,
	-0.599504598247,-0.599835145516,-0.600165577888,-0.600495895404,-0.600826098108,
	-0.601156186042,-0.601486159248,-0.601816017769,-0.602145761648,-0.602475390927,
	-0.602804905648,-0.603134305853,-0.603463591586,-0.603792762887,-0.604121819800,
	-0.604450762366,-0.604779590628,-0.605108304627,-0.605436904406,-0.605765390006,
	-0.606093761469,-0.606422018837,-0.606750162153,-0.607078191457,-0.607406106792,
	-0.607733908199,-0.608061595720,-0.608389169397,-0.608716629270,-0.609043975382,
	-0.609371207773,-0.609698326486,-0.610025331562,-0.610352223042,-0.610679000968,
	-0.611005665380,-0.611332216319,-0.611658653828,-0.611984977947,-0.612311188717,
	-0.612637286180,-0.612963270376,-0.613289141346,-0.613614899131,-0.613940543772,
	-0.614266075310,-0.614591493786,-0.614916799240,-0.615241991713,-0.615567071246,
	-0.615892037880,-0.616216891655,-0.616541632611,-0.616866260790,-0.617190776231,
	-0.617515178975,-0.617839469063,-0.618163646534,-0.618487711430,-0.618811663790,
	-0.619135503655,-0.619459231065,-0.619782846060,-0.620106348680,-0.620429738966,
	-0.620753016957,-0.621076182693,-0.621399236215,-0.621722177562,-0.622045006774,
	-0.622367723892,-0.622690328954,-0.623012822002,-0.623335203073,-0.623657472209,
	-0.623979629450,-0.624301674833,-0.624623608400,-0.624945430190,-0.625267140242,
	-0.625588738596,-0.625910225291,-0.626231600367,-0.626552863864,-0.626874015820,
	-0.627195056274,-0.627515985267,-0.627836802838,-0.628157509025,-0.628478103869,
	-0.628798587407,-0.629118959680,-0.629439220725,-0.629759370584,-0.630079409293,
	-0.630399336893,-0.630719153423,-0.631038858921,-0.631358453426,-0.631677936977,
	-0.631997309613,-0.632316571372,-0.632635722294,-0.632954762417,-0.633273691780,
	-0.633592510422,-0.633911218381,-0.634229815695,-0.634548302404,-0.634866678546,
	-0.635184944159,-0.635503099282,-0.635821143954,-0.636139078212,-0.636456902095,
	-0.636774615641,-0.637092218890,-0.637409711878,-0.637727094645,-0.638044367228,
	-0.638361529665,-0.638678581996,-0.638995524258,-0.639312356489,-0.639629078726,
	-0.639945691010,-0.640262193376,-0.640578585863,-0.640894868510,-0.641211041354,
	-0.641527104432,-0.641843057784,-0.642158901446,-0.642474635456,-0.642790259853,
	-0.643105774673,-0.643421179955,-0.643736475737,-0.644051662055,-0.644366738949,
	-0.644681706454,-0.644996564609,-0.645311313451,-0.645625953019,-0.645940483348,
	-0.646254904477,-0.646569216444,-0.646883419285,-0.647197513038,-0.647511497740,
	-0.647825373429,-0.648139140141,-0.648452797915,-0.648766346787,-0.649079786795,
	-0.649393117976,-0.649706340366,-0.650019454003,-0.650332458925,-0.650645355167,
	-0.650958142768,-0.651270821764,-0.651583392192,-0.651895854089,-0.652208207493,
	-0.652520452439,-0.652832588965,-0.653144617108,-0.653456536904,-0.653768348391,
	-0.654080051605,-0.654391646583,-0.654703133361,-0.655014511976,-0.655325782466,
	-0.655636944865,-0.655947999212,-0.656258945543,-0.656569783894,-0.656880514302,
	-0.657191136804,-0.657501651435,-0.657812058233,-0.658122357233,-0.658432548473,
	-0.658742631988,-0.659052607815,-0.659362475990,-0.659672236550,-0.659981889530,
	-0.660291434968,-0.660600872899,-0.660910203360,-0.661219426386,-0.661528542014,
	-0.661837550281,-0.662146451221,-0.662455244872,-0.662763931269,-0.663072510449,
	-0.663380982447,-0.663689347299,-0.663997605042,-0.664305755711,-0.664613799342,
	-0.664921735971,-0.665229565635,-0.665537288368,-0.665844904206,-0.666152413187,
	-0.666459815344,-0.666767110715,-0.667074299334,-0.667381381238,-0.667688356462,
	-0.667995225042,-0.668301987013,-0.668608642411,-0.668915191272,-0.669221633632,
	-0.669527969525,-0.669834198987,-0.670140322055,-0.670446338762,-0.670752249146,
	-0.671058053240,-0.671363751081,-0.671669342705,-0.671974828145,-0.672280207439,
	-0.672585480620,-0.672890647725,-0.673195708789,-0.673500663846,-0.673805512933,
	-0.674110256084,-0.674414893335,-0.674719424720,-0.675023850276,-0.675328170036,
	-0.675632384037,-0.675936492312,-0.676240494898,-0.676544391830,-0.676848183142,
	-0.677151868869,-0.677455449046,-0.677758923709,-0.678062292892,-0.678365556630,
	-0.678668714959,-0.678971767912,-0.679274715525,-0.679577557833,-0.679880294870,
	-0.680182926671,-0.680485453271,-0.680787874705,-0.681090191008,-0.681392402213,
	-0.681694508357,-0.681996509473,-0.682298405596,-0.682600196761,-0.682901883003,
	-0.683203464355,-0.683504940853,-0.683806312532,-0.684107579424,-0.684408741566,
	-0.684709798992,-0.685010751736,-0.685311599832,-0.685612343315,-0.685912982220,
	-0.686213516580,-0.686513946430,-0.686814271805,-0.687114492739,-0.687414609266,
	-0.687714621420,-0.688014529236,-0.688314332748,-0.688614031990,-0.688913626996,
	-0.689213117801,-0.689512504438,-0.689811786943,-0.690110965348,-0.690410039688,
	-0.690709009998,-0.691007876311,-0.691306638661,-0.691605297083,-0.691903851610,
	-0.692202302276,-0.692500649115,-0.692798892162,-0.693097031451,-0.693395067014,
	-0.693692998887,-0.693990827102,-0.694288551694,-0.694586172697,-0.694883690145,
	-0.695181104071,-0.695478414509,-0.695775621492,-0.696072725056,-0.696369725233,
	-0.696666622057,-0.696963415561,-0.697260105781,-0.697556692748,-0.697853176497,
	-0.698149557062,-0.698445834475,-0.698742008771,-0.699038079984,-0.699334048146,
	-0.699629913291,-0.699925675454,-0.700221334666,-0.700516890962,-0.700812344376,
	-0.701107694940,-0.701402942689,-0.701698087655,-0.701993129871,-0.702288069373,
	-0.702582906191,-0.702877640361,-0.703172271916,-0.703466800887,-0.703761227310,
	-0.704055551217,-0.704349772641,-0.704643891617,-0.704937908176,-0.705231822352,
	-0.705525634178,-0.705819343688,-0.706112950915,-0.706406455891,-0.706699858650,
	-0.706993159225,-0.707286357649,-0.707579453955,-0.707872448177,-0.708165340346,
	-0.708458130497,-0.708750818662,-0.709043404874,-0.709335889166,-0.709628271571,
	-0.709920552123,-0.710212730853,-0.710504807795,-0.710796782982,-0.711088656446,
	-0.711380428221,-0.711672098339,-0.711963666832,-0.712255133735,-0.712546499080,
	-0.712837762898,-0.713128925224,-0.713419986090,-0.713710945528,-0.714001803571,
	-0.714292560253,-0.714583215605,-0.714873769660,-0.715164222451,-0.715454574011,
	-0.715744824372,-0.716034973566,-0.716325021627,-0.716614968586,-0.716904814477,
	-0.717194559331,-0.717484203182,-0.717773746061,-0.718063188002,-0.718352529037,
	-0.718641769198,-0.718930908517,-0.719219947028,-0.719508884761,-0.719797721751,
	-0.720086458029,-0.720375093627,-0.720663628578,-0.720952062914,-0.721240396667,
	-0.721528629870,-0.721816762555,-0.722104794754,-0.722392726500,-0.722680557824,
	-0.722968288759,-0.723255919337,-0.723543449590,-0.723830879550,-0.724118209250,
	-0.724405438722,-0.724692567997,-0.724979597108,-0.725266526087,-0.725553354965,
	-0.725840083776,-0.726126712551,-0.726413241321,-0.726699670120,-0.726985998978,
	-0.727272227929,-0.727558357003,-0.727844386234,-0.728130315652,-0.728416145290,
	-0.728701875179,-0.728987505352,-0.729273035840,-0.729558466675,-0.729843797889,
	-0.730129029514,-0.730414161581,-0.730699194123,-0.730984127171,-0.731268960757,
	-0.731553694913,-0.731838329670,-0.732122865060,-0.732407301115,-0.732691637866,
	-0.732975875346,-0.733260013585,-0.733544052616,-0.733827992470,-0.734111833178,
	-0.734395574773,-0.734679217285,-0.734962760747,-0.735246205190,-0.735529550645,
	-0.735812797144,-0.736095944719,-0.736378993400,-0.736661943221,-0.736944794211,
	-0.737227546402,-0.737510199826,-0.737792754515,-0.738075210499,-0.738357567810,
	-0.738639826479,-0.738921986538,-0.739204048019,-0.739486010951,-0.739767875368,
	-0.740049641299,-0.740331308777,-0.740612877832,-0.740894348496,-0.741175720801,
	-0.741456994776,-0.741738170455,-0.742019247866,-0.742300227043,-0.742581108016,
	-0.742861890816,-0.743142575475,-0.743423162023,-0.743703650492,-0.743984040912,
	-0.744264333316,-0.744544527733,-0.744824624195,-0.745104622734,-0.745384523379,
	-0.745664326162,-0.745944031115,-0.746223638268,-0.746503147651,-0.746782559297,
	-0.747061873235,-0.747341089498,-0.747620208115,-0.747899229118,-0.748178152537,
	-0.748456978405,-0.748735706750,-0.749014337604,-0.749292870999,-0.749571306965,
	-0.749849645532,-0.750127886731,-0.750406030594,-0.750684077151,-0.750962026432,
	-0.751239878470,-0.751517633293,-0.751795290933,-0.752072851421,-0.752350314787,
	-0.752627681062,-0.752904950277,-0.753182122462,-0.753459197648,-0.753736175866,
	-0.754013057146,-0.754289841518,-0.754566529014,-0.754843119664,-0.755119613498,
	-0.755396010547,-0.755672310842,-0.755948514412,-0.756224621289,-0.756500631503,
	-0.756776545085,-0.757052362064,-0.757328082472,-0.757603706339,-0.757879233694,
	-0.758154664569,-0.758429998995,-0.758705237000,-0.758980378616,-0.759255423874,
	-0.759530372802,-0.759805225433,-0.760079981795,-0.760354641920,-0.760629205837,
	-0.760903673578,-0.761178045171,-0.761452320647,-0.761726500038,-0.762000583372,
	-0.762274570680,-0.762548461992,-0.762822257339,-0.763095956750,-0.763369560256,
	-0.763643067886,-0.763916479672,-0.764189795642,-0.764463015828,-0.764736140259,
	-0.765009168965,-0.765282101977,-0.765554939324,-0.765827681037,-0.766100327145,
	-0.766372877678,-0.766645332667,-0.766917692141,-0.767189956131,-0.767462124666,
	-0.767734197776,-0.768006175492,-0.768278057842,-0.768549844858,-0.768821536569,
	-0.769093133004,-0.769364634194,-0.769636040169,-0.769907350958,-0.770178566591,
	-0.770449687098,-0.770720712509,-0.770991642853,-0.771262478161,-0.771533218462,
	-0.771803863785,-0.772074414162,-0.772344869620,-0.772615230191,-0.772885495903,
	-0.773155666787,-0.773425742872,-0.773695724187,-0.773965610763,-0.774235402629,
	-0.774505099815,-0.774774702349,-0.775044210263,-0.775313623585,-0.775582942345,
	-0.775852166572,-0.776121296297,-0.776390331548,-0.776659272355,-0.776928118748,
	-0.777196870756,-0.777465528409,-0.777734091736,-0.778002560766,-0.778270935529,
	-0.778539216054,-0.778807402372,-0.779075494510,-0.779343492500,-0.779611396369,
	-0.779879206148,-0.780146921865,-0.780414543550,-0.780682071233,-0.780949504942,
	-0.781216844708,-0.781484090559,-0.781751242524,-0.782018300633,-0.782285264916,
	-0.782552135400,-0.782818912117,-0.783085595094,-0.783352184361,-0.783618679947,
	-0.783885081882,-0.784151390194,-0.784417604913,-0.784683726068,-0.784949753687,
	-0.785215687801,-0.785481528438,-0.785747275628,-0.786012929398,-0.786278489780,
	-0.786543956800,-0.786809330490,-0.787074610877,-0.787339797990,-0.787604891859,
	-0.787869892513,-0.788134799980,-0.788399614290,-0.788664335472,-0.788928963554,
	-0.789193498565,-0.789457940535,-0.789722289491,-0.789986545465,-0.790250708483,
	-0.790514778575,-0.790778755769,-0.791042640096,-0.791306431583,-0.791570130259,
	-0.791833736153,-0.792097249294,-0.792360669711,-0.792623997432,-0.792887232487,
	-0.793150374903,-0.793413424710,-0.793676381937,-0.793939246612,-0.794202018763,
	-0.794464698421,-0.794727285612,-0.794989780367,-0.795252182713,-0.795514492679,
	-0.795776710294,-0.796038835586,-0.796300868585,-0.796562809318,-0.796824657814,
	-0.797086414102,-0.797348078211,-0.797609650169,-0.797871130004,-0.798132517745,
	-0.798393813420,-0.798655017059,-0.798916128689,-0.799177148339,-0.799438076037,
	-0.799698911812,-0.799959655693,-0.800220307707,-0.800480867884,-0.800741336251,
	-0.801001712837,-0.801261997670,-0.801522190779,-0.801782292192,-0.802042301938,
	-0.802302220044,-0.802562046539,-0.802821781452,-0.803081424810,-0.803340976643,
	-0.803600436977,-0.803859805842,-0.804119083266,-0.804378269277,-0.804637363903,
	-0.804896367172,-0.805155279113,-0.805414099754,-0.805672829123,-0.805931467248,
	-0.806190014157,-0.806448469879,-0.806706834441,-0.806965107873,-0.807223290200,
	-0.807481381453,-0.807739381659,-0.807997290846,-0.808255109042,-0.808512836275,
	-0.808770472574,-0.809028017965,-0.809285472478,-0.809542836141,-0.809800108980,
	-0.810057291025,-0.810314382303,-0.810571382842,-0.810828292670,-0.811085111815,
	-0.811341840306,-0.811598478169,-0.811855025433,-0.812111482125,-0.812367848274,
	-0.812624123908,-0.812880309053,-0.813136403739,-0.813392407993,-0.813648321842,
	-0.813904145315,-0.814159878440,-0.814415521243,-0.814671073753,-0.814926535998,
	-0.815181908005,-0.815437189803,-0.815692381418,-0.815947482879,-0.816202494213,
	-0.816457415448,-0.816712246611,-0.816966987731,-0.817221638835,-0.817476199951,
	-0.817730671105,-0.817985052327,-0.818239343642,-0.818493545080,-0.818747656668,
	-0.819001678433,-0.819255610402,-0.819509452604,-0.819763205065,-0.820016867814,
	-0.820270440878,-0.820523924284,-0.820777318061,-0.821030622234,-0.821283836832,
	-0.821536961883,-0.821789997413,-0.822042943451,-0.822295800023,-0.822548567157,
	-0.822801244881,-0.823053833221,-0.823306332206,-0.823558741862,-0.823811062217,
	-0.824063293298,-0.824315435133,-0.824567487748,-0.824819451172,-0.825071325432,
	-0.825323110554,-0.825574806566,-0.825826413495,-0.826077931370,-0.826329360216,
	-0.826580700061,-0.826831950932,-0.827083112857,-0.827334185862,-0.827585169975,
	-0.827836065224,-0.828086871634,-0.828337589234,-0.828588218050,-0.828838758110,
	-0.829089209441,-0.829339572069,-0.829589846023,-0.829840031328,-0.830090128013,
	-0.830340136103,-0.830590055627,-0.830839886611,-0.831089629082,-0.831339283068,
	-0.831588848595,-0.831838325690,-0.832087714380,-0.832337014692,-0.832586226654,
	-0.832835350291,-0.833084385632,-0.833333332703
	}
};

double always_inline tiltdrivepro_inclip(double x) {
    double f = fabs(x);
    f = f * tiltdrivepro_in_table.istep;
    int i = static_cast<int>(f);
    if (i < 0) {
        f = tiltdrivepro_in_table.data[0];
    } else if (i >= tiltdrivepro_in_table.size-1) {
        f = tiltdrivepro_in_table.data[tiltdrivepro_in_table.size-1];
    } else {
    f -= i;
    f = tiltdrivepro_in_table.data[i]*(1-f) + tiltdrivepro_in_table.data[i+1]*f;
    }
    return copysign(f, x);
}

