// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{Expression, Filter, StringFilterMatchMode, ffi};
use glib::{
    prelude::*,
    signal::{SignalHandlerId, connect_raw},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GtkStringFilter")]
    pub struct StringFilter(Object<ffi::GtkStringFilter, ffi::GtkStringFilterClass>) @extends Filter;

    match fn {
        type_ => || ffi::gtk_string_filter_get_type(),
    }
}

impl StringFilter {
    #[doc(alias = "gtk_string_filter_new")]
    pub fn new(expression: Option<impl AsRef<Expression>>) -> StringFilter {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::gtk_string_filter_new(
                expression
                    .map(|p| p.as_ref().clone().upcast())
                    .into_glib_ptr(),
            ))
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`StringFilter`] objects.
    ///
    /// This method returns an instance of [`StringFilterBuilder`](crate::builders::StringFilterBuilder) which can be used to create [`StringFilter`] objects.
    pub fn builder() -> StringFilterBuilder {
        StringFilterBuilder::new()
    }

    #[doc(alias = "gtk_string_filter_get_expression")]
    #[doc(alias = "get_expression")]
    pub fn expression(&self) -> Option<Expression> {
        unsafe { from_glib_none(ffi::gtk_string_filter_get_expression(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_string_filter_get_ignore_case")]
    #[doc(alias = "get_ignore_case")]
    #[doc(alias = "ignore-case")]
    pub fn ignores_case(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_string_filter_get_ignore_case(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_string_filter_get_match_mode")]
    #[doc(alias = "get_match_mode")]
    #[doc(alias = "match-mode")]
    pub fn match_mode(&self) -> StringFilterMatchMode {
        unsafe { from_glib(ffi::gtk_string_filter_get_match_mode(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_string_filter_get_search")]
    #[doc(alias = "get_search")]
    pub fn search(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::gtk_string_filter_get_search(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_string_filter_set_expression")]
    #[doc(alias = "expression")]
    pub fn set_expression(&self, expression: Option<impl AsRef<Expression>>) {
        unsafe {
            ffi::gtk_string_filter_set_expression(
                self.to_glib_none().0,
                expression.as_ref().map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_string_filter_set_ignore_case")]
    #[doc(alias = "ignore-case")]
    pub fn set_ignore_case(&self, ignore_case: bool) {
        unsafe {
            ffi::gtk_string_filter_set_ignore_case(self.to_glib_none().0, ignore_case.into_glib());
        }
    }

    #[doc(alias = "gtk_string_filter_set_match_mode")]
    #[doc(alias = "match-mode")]
    pub fn set_match_mode(&self, mode: StringFilterMatchMode) {
        unsafe {
            ffi::gtk_string_filter_set_match_mode(self.to_glib_none().0, mode.into_glib());
        }
    }

    #[doc(alias = "gtk_string_filter_set_search")]
    #[doc(alias = "search")]
    pub fn set_search(&self, search: Option<&str>) {
        unsafe {
            ffi::gtk_string_filter_set_search(self.to_glib_none().0, search.to_glib_none().0);
        }
    }

    #[doc(alias = "expression")]
    pub fn connect_expression_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_expression_trampoline<F: Fn(&StringFilter) + 'static>(
            this: *mut ffi::GtkStringFilter,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::expression".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_expression_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "ignore-case")]
    pub fn connect_ignore_case_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_ignore_case_trampoline<F: Fn(&StringFilter) + 'static>(
            this: *mut ffi::GtkStringFilter,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::ignore-case".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_ignore_case_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "match-mode")]
    pub fn connect_match_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_match_mode_trampoline<F: Fn(&StringFilter) + 'static>(
            this: *mut ffi::GtkStringFilter,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::match-mode".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_match_mode_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "search")]
    pub fn connect_search_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_search_trampoline<F: Fn(&StringFilter) + 'static>(
            this: *mut ffi::GtkStringFilter,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::search".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_search_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for StringFilter {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`StringFilter`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct StringFilterBuilder {
    builder: glib::object::ObjectBuilder<'static, StringFilter>,
}

impl StringFilterBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn expression(self, expression: impl AsRef<Expression>) -> Self {
        Self {
            builder: self
                .builder
                .property("expression", expression.as_ref().clone()),
        }
    }

    pub fn ignore_case(self, ignore_case: bool) -> Self {
        Self {
            builder: self.builder.property("ignore-case", ignore_case),
        }
    }

    pub fn match_mode(self, match_mode: StringFilterMatchMode) -> Self {
        Self {
            builder: self.builder.property("match-mode", match_mode),
        }
    }

    pub fn search(self, search: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("search", search.into()),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`StringFilter`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> StringFilter {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}
