% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs_layer.R
\name{layer_positions}
\alias{layer_positions}
\title{Layer position adjustments}
\description{
In ggplot2, a plot is constructed by adding layers to it. In addition to
\link[=layer_geoms]{geoms} and \link[=layer_stats]{stats}, position adjustments are the
third required part of a layer. The 'position' part of a layer is responsible
for dodging, jittering and nudging groups of data to minimise their overlap,
or otherwise tweaking their positions.

For example if you add \code{position = position_nudge(x = 1)} to a layer, you
can offset every x-position by 1. For many layers, the default position
adjustment is \code{\link[=position_identity]{position_identity()}}, which performs no adjustment.
}
\section{Specifying positions}{
There are 4 ways in which the 'position' part of a layer can be specified.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{1. A layer can have default position adjustments
geom_jitter() # has `position = "jitter"`

2. It can be given to a layer as a string
geom_point(position = "jitter")

3. The position function can be used to pass extra arguments
geom_point(position = position_jitter(width = 1))

4. It can be given to `layer()` directly
layer(
  geom = "point",
  stat = "identity",
  position = "jitter"
)
}\if{html}{\out{</div>}}

These ways are not always equivalent. Some layers may not understand what
to do with a position adjustment, and require additional parameters passed
through the \verb{position_*()} function, or may not work correctly. For
example \code{\link[=position_dodge]{position_dodge()}} requires non-overlapping x intervals, whereas
\code{\link[=geom_point]{geom_point()}} doesn't have dimensions to calculate intervals for. To give
positions as a string, take the function name, and remove the \code{position_}
prefix, such that \code{position_fill} becomes \code{"fill"}.
}

\section{Pairing geoms with positions}{
Some geoms work better with some positions than others. Below follows a brief
overview of geoms and position adjustments that work well together.
\subsection{Identity}{

\code{\link[=position_identity]{position_identity()}} can work with virtually any geom.
}

\subsection{Dodging}{

\code{\link[=position_dodge]{position_dodge()}} pushes overlapping objects away from one another and
requires a \code{group} variable. \code{\link[=position_dodge2]{position_dodge2()}} can work without group
variables and can handle variable widths. As a rule of thumb, layers where
groups occupy a range on the x-axis pair well with dodging. If layers have
no width, you may be required to specify it manually with
\code{position_dodge(width = ...)}. Some geoms that pair well with dodging are
\code{\link[=geom_bar]{geom_bar()}}, \code{\link[=geom_boxplot]{geom_boxplot()}}, \code{\link[=geom_linerange]{geom_linerange()}},
\code{\link[=geom_errorbar]{geom_errorbar()}} and \code{\link[=geom_text]{geom_text()}}.
}

\subsection{Jittering}{

\code{\link[=position_jitter]{position_jitter()}} adds a some random noise to every point,
which can help with overplotting. \code{\link[=position_jitterdodge]{position_jitterdodge()}} does the same,
but also dodges the points. As a rule of thumb, jittering works best
when points have discrete x-positions. Jittering is most useful for
\code{\link[=geom_point]{geom_point()}}, but can also be used in \code{\link[=geom_path]{geom_path()}} for example.
}

\subsection{Nudging}{

\code{\link[=position_nudge]{position_nudge()}} can add offsets to x- and y-positions. This can be
useful for discrete positions where you don't want to put an object
exactly in the middle. While most useful for \code{\link[=geom_text]{geom_text()}}, it can be
used with virtually all geoms.
}

\subsection{Stacking}{

\code{\link[=position_stack]{position_stack()}} is useful for displaying data on top of one another. It
can be used for geoms that are usually anchored to the x-axis, for example
\code{\link[=geom_bar]{geom_bar()}}, \code{\link[=geom_area]{geom_area()}} or \code{\link[=geom_histogram]{geom_histogram()}}.
}

\subsection{Filling}{

\code{\link[=position_fill]{position_fill()}} can be used to give proportions at every x-position. Like
stacking, filling is most useful for geoms that are anchored to the x-axis,
like \code{\link[=geom_bar]{geom_bar()}}, \code{\link[=geom_area]{geom_area()}} or \code{\link[=geom_histogram]{geom_histogram()}}.
}
}

\section{Under the hood}{
Internally, positions are represented as \code{\link[=ggproto]{ggproto}} classes that
occupy a slot in a layer. All these classes inherit from the parental
\code{\link{Position}} ggproto object that orchestrates how positions work. Briefly,
positions are given the opportunity to adjust the data of each facet panel.
For more information about extending positions, see the \strong{New positions}
section of the
\href{https://ggplot2-book.org/extensions.html#new-positions}{online book}.
}

\seealso{
For an overview of all position adjustments, see the
\href{https://ggplot2.tidyverse.org/reference/index.html#position-adjustment}{online reference}.

Other layer documentation: 
\code{\link{layer}()},
\code{\link{layer_geoms}},
\code{\link{layer_stats}}
}
\concept{layer documentation}
