% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterFunctions.R
\name{makeClusterFunctions}
\alias{makeClusterFunctions}
\alias{ClusterFunctions}
\title{ClusterFunctions Constructor}
\usage{
makeClusterFunctions(
  name,
  submitJob,
  killJob = NULL,
  listJobsQueued = NULL,
  listJobsRunning = NULL,
  array.var = NA_character_,
  store.job.collection = FALSE,
  store.job.files = FALSE,
  scheduler.latency = 0,
  fs.latency = 0,
  hooks = list()
)
}
\arguments{
\item{name}{[\code{character(1)}]\cr
Name of cluster functions.}

\item{submitJob}{[\code{function(reg, jc, ...)}]\cr
Function to submit new jobs. Must return a \code{\link{SubmitJobResult}} object.
The arguments are \code{reg} (\code{\link{Registry}}) and \code{jobs} (\code{\link{JobCollection}}).}

\item{killJob}{[\code{function(reg, batch.id)}]\cr
Function to kill a job on the batch system. Make sure that you definitely kill the job! Return
value is currently ignored. Must have the arguments \code{reg} (\code{\link{Registry}}) and
\code{batch.id} (\code{character(1)} as returned by \code{submitJob}).
Note that there is a helper function \code{\link{cfKillJob}} to repeatedly try to kill jobs.
Set \code{killJob} to \code{NULL} if killing jobs cannot be supported.}

\item{listJobsQueued}{[\code{function(reg)}]\cr
List all queued jobs on the batch system for the current user.
Must return an character vector of batch ids, same format as they
are returned by \code{submitJob}.
Set \code{listJobsQueued} to \code{NULL} if listing of queued jobs is not supported.}

\item{listJobsRunning}{[\code{function(reg)}]\cr
List all running jobs on the batch system for the current user.
Must return an character vector of batch ids, same format as they
are returned by \code{submitJob}. It does not matter if you return a few job ids too many (e.g.
all for the current user instead of all for the current registry), but you have to include all
relevant ones. Must have the argument are \code{reg} (\code{\link{Registry}}).
Set \code{listJobsRunning} to \code{NULL} if listing of running jobs is not supported.}

\item{array.var}{[\code{character(1)}]\cr
Name of the environment variable set by the scheduler to identify IDs of job arrays.
Default is \code{NA} for no array support.}

\item{store.job.collection}{[\code{logical(1)}]\cr
Flag to indicate that the cluster function implementation of \code{submitJob} can not directly handle \code{\link{JobCollection}} objects.
If set to \code{FALSE}, the \code{\link{JobCollection}} is serialized to the file system before submitting the job.}

\item{store.job.files}{[\code{logical(1)}]\cr
Flag to indicate that job files need to be stored in the file directory.
If set to \code{FALSE} (default), the job file is created in a temporary directory, otherwise (or if the debug mode is enabled) in
the subdirectory \code{jobs} of the \code{file.dir}.}

\item{scheduler.latency}{[\code{numeric(1)}]\cr
Time to sleep after important interactions with the scheduler to ensure a sane state.
Currently only triggered after calling \code{\link{submitJobs}}.}

\item{fs.latency}{[\code{numeric(1)}]\cr
Expected maximum latency of the file system, in seconds.
Set to a positive number for network file systems like NFS which enables more robust (but also more expensive) mechanisms to
access files and directories.
Usually safe to set to \code{0} to disable the heuristic, e.g. if you are working on a local file system.}

\item{hooks}{[\code{list}]\cr
Named list of functions which will we called on certain events like \dQuote{pre.submit} or \dQuote{post.sync}.
See \link{Hooks}.}
}
\description{
This is the constructor used to create \emph{custom} cluster functions.
Note that some standard implementations for TORQUE, Slurm, LSF, SGE, etc. ship
with the package.
}
\seealso{
Other ClusterFunctions: 
\code{\link{makeClusterFunctionsDocker}()},
\code{\link{makeClusterFunctionsInteractive}()},
\code{\link{makeClusterFunctionsLSF}()},
\code{\link{makeClusterFunctionsMulticore}()},
\code{\link{makeClusterFunctionsOpenLava}()},
\code{\link{makeClusterFunctionsSGE}()},
\code{\link{makeClusterFunctionsSSH}()},
\code{\link{makeClusterFunctionsSlurm}()},
\code{\link{makeClusterFunctionsSocket}()},
\code{\link{makeClusterFunctionsTORQUE}()}

Other ClusterFunctionsHelper: 
\code{\link{cfBrewTemplate}()},
\code{\link{cfHandleUnknownSubmitError}()},
\code{\link{cfKillJob}()},
\code{\link{cfReadBrewTemplate}()},
\code{\link{makeSubmitJobResult}()},
\code{\link{runOSCommand}()}
}
\concept{ClusterFunctions}
\concept{ClusterFunctionsHelper}
