##
##  OSSP uuid - Universally Unique Identifier
##  Copyright (c) 2004-2007 Ralf S. Engelschall <rse@engelschall.com>
##  Copyright (c) 2004-2007 The OSSP Project <http://www.ossp.org/>
##
##  This file is part of OSSP uuid, a library for the generation
##  of UUIDs which can found at http://www.ossp.org/pkg/lib/uuid/
##
##  Permission to use, copy, modify, and distribute this software for
##  any purpose with or without fee is hereby granted, provided that
##  the above copyright notice and this permission notice appear in all
##  copies.
##
##  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
##  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
##  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
##  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
##  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
##  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
##  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
##  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
##  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
##  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
##  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
##  SUCH DAMAGE.
##
##  Makefile.PL: Perl MakeMaker build source procedure
##

require 5.008;

use Config;
use ExtUtils::MakeMaker;

my $blddir  = $ENV{BLD};
my $libname = $ENV{LIBNAME};
my $compat  = $ENV{COMPAT};
my $version = $ENV{UUID_VERSION_RAW};


for my $f (qw(uuid.pm uuid_compat.pm)) {
	open(my $ifh, '<', "$f.in") or die;
	open(my $ofh, '>', "$f")   or die;
	while(<$ifh>) {
		chomp;
		s/%VERSION%/$version/;
		print $ofh "$_\n";
	}
	close($ifh);
	close($ofh);
}


WriteMakefile(
    NAME              => 'OSSP::uuid',
    VERSION_FROM      => 'uuid.pm',
    ABSTRACT          => 'OSSP uuid Perl Binding',
    PREREQ_PM         => {},
    LIBS              => [ "-L$blddir/.libs -L.. -l$libname" ],
    DEFINE            => '',
    INC               => "-I.. -I$blddir",
    PM                => { 'uuid.pm'   => '$(INST_LIBDIR)/uuid.pm',
                           ($compat ? ('uuid_compat.pm'  => '$(INST_LIBDIR)/../Data/UUID.pm')  : ()), },
    MAN3PODS          => { },
    TYPEMAPS          => [ 'uuid.tm' ],
    test              => { TESTS => 'uuid.ts' . ($compat ? ' uuid_compat.ts' : '') },
    NO_META           => 1,
    #    cruel hack to workaround the conflict between OSSP uuid's
    #    uuid_create() function and one from FreeBSD's libc
    ((   "$Config{'osname'}$Config{'osvers'}" =~ m/^freebsd[56]\./
      and $Config{'ld'} =~ m/cc$/ and -f "/usr/include/uuid.h") ?
      ( LDDLFLAGS => $Config{'lddlflags'} . ' -Wl,-Bsymbolic') : ())
);


system 'sed "s/PERL_DL_NONLAZY=1//g" < Makefile > Makefile.old';
open(my $Makefile, '>>', 'Makefile.old') or die;
print $Makefile (<< "EOF");
all:: manuals_custom
manuals_custom: blibdirs
	sed -e "s/\@UUID_VERSION_MDOC_DATE\@/$ENV{UUID_VERSION_MDOC_DATE}/" -e "s/\@UUID_VERSION_RAW\@/$version/" < Data::UUID.3perl.in > \$(INST_MAN3DIR)/Data::UUID.3perl
	sed -e "s/\@UUID_VERSION_MDOC_DATE\@/$ENV{UUID_VERSION_MDOC_DATE}/" -e "s/\@UUID_VERSION_RAW\@/$version/" < OSSP::uuid.3perl.in > \$(INST_MAN3DIR)/OSSP::uuid.3perl

clean:: custom_clean
custom_clean:
	rm -f uuid.pm uuid_compat.pm Makefile.old
EOF
close($Makefile);
rename('Makefile.old', 'Makefile');
