/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules;

import java.util.Vector;
import org.apache.turbine.modules.GenericLoader;
import org.apache.turbine.modules.ScheduledJob;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.assemblerbroker.AssemblerBrokerService;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.services.schedule.JobEntry;
import org.apache.turbine.util.ObjectUtils;
import org.apache.turbine.util.RunData;

public class ScheduledJobLoader
extends GenericLoader {
    private static ScheduledJobLoader instance = new ScheduledJobLoader(TurbineResources.getInt("scheduledjob.cache.size", 10));

    private void addInstance(String name, ScheduledJob job) {
        if (this.cache()) {
            this.put(name, job);
        }
    }

    public void exec(JobEntry job, String name) throws Exception {
        this.getInstance(name).run(job);
    }

    public void exec(RunData data, String name) throws Exception {
        throw new Exception("RunData objects not accepted for Scheduled jobs");
    }

    public ScheduledJob getInstance(String name) throws Exception {
        ScheduledJob job = null;
        if (this.cache() && this.containsKey(name)) {
            job = (ScheduledJob)this.get(name);
        } else {
            AssemblerBrokerService ab = (AssemblerBrokerService)TurbineServices.getInstance().getService("AssemblerBrokerService");
            try {
                job = (ScheduledJob)ab.getAssembler("scheduledjob", name);
            }
            catch (ClassCastException cce) {
                job = null;
            }
            if (job == null) {
                Vector packages = TurbineResources.getVector("module.packages");
                ObjectUtils.addOnce(packages, GenericLoader.getBasePackage());
                throw new ClassNotFoundException("\n\n\tRequested ScheduledJob not found: " + name + "\n" + "\tTurbine looked in the following modules.packages " + "path: \n\t" + packages.toString() + "\n");
            }
            if (this.cache()) {
                this.addInstance(name, job);
            }
        }
        return job;
    }

    public static ScheduledJobLoader getInstance() {
        return instance;
    }

    private ScheduledJobLoader() {
    }

    private ScheduledJobLoader(int i) {
        super(i);
    }
}

