
// copicat1_table generated by DK/circ_table_gen.py -- do not modify manually

 // variables used
 // --sig_max  1.500000
 // --table_div  24.120176
 // --table_op  0.050000

struct tablecopicat1 { // 1-dimensional function table
    float low;
    float high;
    float istep;
    int size;
    float data[];
};

template <int tab_size>
struct tablecopicat1_imp {
    float low;
    float high;
    float istep;
    int size;
    float data[tab_size];
    operator tablecopicat1&() const { return *(tablecopicat1*)this; }
};

 static tablecopicat1_imp<2048> copicat1_table __rt_data = {
	0,-0.833333,68.2333,2048, {
	0.000000000000,-0.000724265940,-0.001448099739,-0.002171501586,-0.002894471673,
	-0.003617010189,-0.004339117326,-0.005060793273,-0.005782038223,-0.006502852365,
	-0.007223235890,-0.007943188990,-0.008662711855,-0.009381804678,-0.010100467648,
	-0.010818700958,-0.011536504799,-0.012253879362,-0.012970824840,-0.013687341423,
	-0.014403429304,-0.015119088675,-0.015834319728,-0.016549122654,-0.017263497646,
	-0.017977444896,-0.018690964597,-0.019404056940,-0.020116722119,-0.020828960326,
	-0.021540771754,-0.022252156594,-0.022963115041,-0.023673647287,-0.024383753525,
	-0.025093433948,-0.025802688750,-0.026511518123,-0.027219922260,-0.027927901355,
	-0.028635455602,-0.029342585194,-0.030049290325,-0.030755571188,-0.031461427977,
	-0.032166860885,-0.032871870108,-0.033576455838,-0.034280618269,-0.034984357597,
	-0.035687674014,-0.036390567715,-0.037093038895,-0.037795087748,-0.038496714468,
	-0.039197919250,-0.039898702289,-0.040599063778,-0.041299003913,-0.041998522889,
	-0.042697620900,-0.043396298141,-0.044094554808,-0.044792391094,-0.045489807197,
	-0.046186803310,-0.046883379628,-0.047579536348,-0.048275273664,-0.048970591772,
	-0.049665490868,-0.050359971146,-0.051054032803,-0.051747676034,-0.052440901034,
	-0.053133708001,-0.053826097129,-0.054518068614,-0.055209622652,-0.055900759440,
	-0.056591479173,-0.057281782048,-0.057971668260,-0.058661138006,-0.059350191482,
	-0.060038828885,-0.060727050410,-0.061414856255,-0.062102246616,-0.062789221689,
	-0.063475781671,-0.064161926758,-0.064847657148,-0.065532973037,-0.066217874621,
	-0.066902362099,-0.067586435665,-0.068270095519,-0.068953341856,-0.069636174873,
	-0.070318594768,-0.071000601737,-0.071682195979,-0.072363377690,-0.073044147067,
	-0.073724504308,-0.074404449610,-0.075083983170,-0.075763105187,-0.076441815856,
	-0.077120115377,-0.077798003947,-0.078475481762,-0.079152549021,-0.079829205922,
	-0.080505452662,-0.081181289439,-0.081856716451,-0.082531733896,-0.083206341971,
	-0.083880540875,-0.084554330805,-0.085227711960,-0.085900684537,-0.086573248735,
	-0.087245404751,-0.087917152785,-0.088588493034,-0.089259425696,-0.089929950970,
	-0.090600069053,-0.091269780145,-0.091939084444,-0.092607982147,-0.093276473454,
	-0.093944558563,-0.094612237672,-0.095279510980,-0.095946378685,-0.096612840987,
	-0.097278898083,-0.097944550173,-0.098609797454,-0.099274640126,-0.099939078388,
	-0.100603112438,-0.101266742475,-0.101929968697,-0.102592791305,-0.103255210495,
	-0.103917226468,-0.104578839423,-0.105240049558,-0.105900857072,-0.106561262164,
	-0.107221265034,-0.107880865880,-0.108540064901,-0.109198862297,-0.109857258266,
	-0.110515253008,-0.111172846722,-0.111830039607,-0.112486831863,-0.113143223688,
	-0.113799215282,-0.114454806843,-0.115109998573,-0.115764790668,-0.116419183330,
	-0.117073176757,-0.117726771149,-0.118379966704,-0.119032763623,-0.119685162105,
	-0.120337162350,-0.120988764556,-0.121639968923,-0.122290775651,-0.122941184939,
	-0.123591196986,-0.124240811993,-0.124890030159,-0.125538851683,-0.126187276764,
	-0.126835305604,-0.127482938400,-0.128130175353,-0.128777016662,-0.129423462527,
	-0.130069513148,-0.130715168724,-0.131360429454,-0.132005295540,-0.132649767179,
	-0.133293844572,-0.133937527919,-0.134580817420,-0.135223713273,-0.135866215679,
	-0.136508324838,-0.137150040948,-0.137791364211,-0.138432294826,-0.139072832992,
	-0.139712978910,-0.140352732778,-0.140992094798,-0.141631065168,-0.142269644089,
	-0.142907831760,-0.143545628381,-0.144183034152,-0.144820049272,-0.145456673943,
	-0.146092908362,-0.146728752731,-0.147364207248,-0.147999272115,-0.148633947530,
	-0.149268233694,-0.149902130805,-0.150535639065,-0.151168758673,-0.151801489829,
	-0.152433832733,-0.153065787584,-0.153697354582,-0.154328533927,-0.154959325820,
	-0.155589730459,-0.156219748044,-0.156849378777,-0.157478622855,-0.158107480480,
	-0.158735951850,-0.159364037166,-0.159991736628,-0.160619050435,-0.161245978787,
	-0.161872521884,-0.162498679925,-0.163124453112,-0.163749841642,-0.164374845716,
	-0.164999465535,-0.165623701297,-0.166247553202,-0.166871021450,-0.167494106241,
	-0.168116807774,-0.168739126250,-0.169361061867,-0.169982614827,-0.170603785327,
	-0.171224573569,-0.171844979752,-0.172465004074,-0.173084646737,-0.173703907940,
	-0.174322787881,-0.174941286762,-0.175559404781,-0.176177142139,-0.176794499034,
	-0.177411475667,-0.178028072236,-0.178644288942,-0.179260125984,-0.179875583561,
	-0.180490661873,-0.181105361120,-0.181719681501,-0.182333623215,-0.182947186462,
	-0.183560371442,-0.184173178353,-0.184785607396,-0.185397658769,-0.186009332672,
	-0.186620629304,-0.187231548865,-0.187842091554,-0.188452257570,-0.189062047113,
	-0.189671460382,-0.190280497576,-0.190889158894,-0.191497444536,-0.192105354701,
	-0.192712889588,-0.193320049395,-0.193926834323,-0.194533244571,-0.195139280337,
	-0.195744941820,-0.196350229220,-0.196955142736,-0.197559682567,-0.198163848911,
	-0.198767641968,-0.199371061937,-0.199974109016,-0.200576783404,-0.201179085301,
	-0.201781014906,-0.202382572416,-0.202983758031,-0.203584571950,-0.204185014372,
	-0.204785085494,-0.205384785517,-0.205984114638,-0.206583073056,-0.207181660970,
	-0.207779878579,-0.208377726081,-0.208975203675,-0.209572311559,-0.210169049932,
	-0.210765418992,-0.211361418938,-0.211957049968,-0.212552312281,-0.213147206074,
	-0.213741731547,-0.214335888898,-0.214929678324,-0.215523100025,-0.216116154198,
	-0.216708841042,-0.217301160755,-0.217893113534,-0.218484699579,-0.219075919087,
	-0.219666772256,-0.220257259285,-0.220847380371,-0.221437135712,-0.222026525506,
	-0.222615549951,-0.223204209245,-0.223792503586,-0.224380433172,-0.224967998200,
	-0.225555198868,-0.226142035374,-0.226728507916,-0.227314616691,-0.227900361896,
	-0.228485743730,-0.229070762390,-0.229655418073,-0.230239710978,-0.230823641300,
	-0.231407209238,-0.231990414990,-0.232573258751,-0.233155740721,-0.233737861096,
	-0.234319620072,-0.234901017849,-0.235482054621,-0.236062730588,-0.236643045945,
	-0.237223000890,-0.237802595620,-0.238381830332,-0.238960705222,-0.239539220488,
	-0.240117376327,-0.240695172935,-0.241272610509,-0.241849689246,-0.242426409342,
	-0.243002770995,-0.243578774400,-0.244154419755,-0.244729707255,-0.245304637099,
	-0.245879209481,-0.246453424598,-0.247027282647,-0.247600783824,-0.248173928326,
	-0.248746716348,-0.249319148087,-0.249891223739,-0.250462943500,-0.251034307566,
	-0.251605316134,-0.252175969399,-0.252746267557,-0.253316210804,-0.253885799336,
	-0.254455033350,-0.255023913040,-0.255592438602,-0.256160610233,-0.256728428127,
	-0.257295892481,-0.257863003489,-0.258429761349,-0.258996166254,-0.259562218400,
	-0.260127917984,-0.260693265200,-0.261258260243,-0.261822903309,-0.262387194592,
	-0.262951134289,-0.263514722594,-0.264077959703,-0.264640845810,-0.265203381110,
	-0.265765565798,-0.266327400069,-0.266888884118,-0.267450018140,-0.268010802330,
	-0.268571236881,-0.269131321990,-0.269691057850,-0.270250444655,-0.270809482602,
	-0.271368171883,-0.271926512693,-0.272484505227,-0.273042149679,-0.273599446243,
	-0.274156395114,-0.274712996485,-0.275269250550,-0.275825157505,-0.276380717542,
	-0.276935930856,-0.277490797640,-0.278045318089,-0.278599492396,-0.279153320754,
	-0.279706803359,-0.280259940403,-0.280812732079,-0.281365178582,-0.281917280105,
	-0.282469036841,-0.283020448984,-0.283571516727,-0.284122240263,-0.284672619785,
	-0.285222655488,-0.285772347563,-0.286321696204,-0.286870701604,-0.287419363956,
	-0.287967683452,-0.288515660286,-0.289063294650,-0.289610586738,-0.290157536741,
	-0.290704144853,-0.291250411265,-0.291796336171,-0.292341919763,-0.292887162234,
	-0.293432063775,-0.293976624579,-0.294520844838,-0.295064724745,-0.295608264491,
	-0.296151464269,-0.296694324270,-0.297236844687,-0.297779025712,-0.298320867536,
	-0.298862370351,-0.299403534348,-0.299944359721,-0.300484846659,-0.301024995355,
	-0.301564806000,-0.302104278785,-0.302643413903,-0.303182211544,-0.303720671899,
	-0.304258795160,-0.304796581518,-0.305334031164,-0.305871144289,-0.306407921084,
	-0.306944361740,-0.307480466447,-0.308016235397,-0.308551668780,-0.309086766787,
	-0.309621529609,-0.310155957435,-0.310690050457,-0.311223808865,-0.311757232849,
	-0.312290322599,-0.312823078307,-0.313355500161,-0.313887588353,-0.314419343072,
	-0.314950764508,-0.315481852851,-0.316012608291,-0.316543031017,-0.317073121221,
	-0.317602879090,-0.318132304815,-0.318661398586,-0.319190160591,-0.319718591021,
	-0.320246690064,-0.320774457911,-0.321301894749,-0.321829000769,-0.322355776159,
	-0.322882221109,-0.323408335808,-0.323934120443,-0.324459575206,-0.324984700283,
	-0.325509495864,-0.326033962137,-0.326558099292,-0.327081907516,-0.327605386998,
	-0.328128537927,-0.328651360490,-0.329173854877,-0.329696021275,-0.330217859872,
	-0.330739370857,-0.331260554417,-0.331781410741,-0.332301940016,-0.332822142430,
	-0.333342018171,-0.333861567427,-0.334380790384,-0.334899687232,-0.335418258157,
	-0.335936503346,-0.336454422987,-0.336972017267,-0.337489286374,-0.338006230494,
	-0.338522849815,-0.339039144524,-0.339555114807,-0.340070760852,-0.340586082844,
	-0.341101080972,-0.341615755421,-0.342130106379,-0.342644134031,-0.343157838564,
	-0.343671220165,-0.344184279020,-0.344697015315,-0.345209429237,-0.345721520970,
	-0.346233290702,-0.346744738619,-0.347255864906,-0.347766669749,-0.348277153334,
	-0.348787315847,-0.349297157473,-0.349806678397,-0.350315878806,-0.350824758884,
	-0.351333318818,-0.351841558792,-0.352349478991,-0.352857079601,-0.353364360806,
	-0.353871322792,-0.354377965744,-0.354884289846,-0.355390295283,-0.355895982240,
	-0.356401350901,-0.356906401451,-0.357411134075,-0.357915548957,-0.358419646280,
	-0.358923426231,-0.359426888992,-0.359930034748,-0.360432863682,-0.360935375980,
	-0.361437571824,-0.361939451398,-0.362441014887,-0.362942262474,-0.363443194342,
	-0.363943810676,-0.364444111658,-0.364944097472,-0.365443768301,-0.365943124329,
	-0.366442165738,-0.366940892712,-0.367439305434,-0.367937404086,-0.368435188852,
	-0.368932659915,-0.369429817456,-0.369926661659,-0.370423192707,-0.370919410781,
	-0.371415316064,-0.371910908739,-0.372406188987,-0.372901156992,-0.373395812934,
	-0.373890156997,-0.374384189362,-0.374877910210,-0.375371319725,-0.375864418087,
	-0.376357205478,-0.376849682080,-0.377341848074,-0.377833703642,-0.378325248965,
	-0.378816484225,-0.379307409602,-0.379798025277,-0.380288331432,-0.380778328248,
	-0.381268015906,-0.381757394586,-0.382246464469,-0.382735225736,-0.383223678567,
	-0.383711823143,-0.384199659644,-0.384687188252,-0.385174409145,-0.385661322504,
	-0.386147928509,-0.386634227341,-0.387120219179,-0.387605904203,-0.388091282593,
	-0.388576354529,-0.389061120190,-0.389545579756,-0.390029733407,-0.390513581321,
	-0.390997123679,-0.391480360658,-0.391963292440,-0.392445919202,-0.392928241124,
	-0.393410258384,-0.393891971162,-0.394373379636,-0.394854483985,-0.395335284388,
	-0.395815781023,-0.396295974069,-0.396775863703,-0.397255450105,-0.397734733452,
	-0.398213713923,-0.398692391696,-0.399170766948,-0.399648839858,-0.400126610603,
	-0.400604079362,-0.401081246311,-0.401558111629,-0.402034675492,-0.402510938079,
	-0.402986899567,-0.403462560132,-0.403937919953,-0.404412979205,-0.404887738067,
	-0.405362196715,-0.405836355326,-0.406310214076,-0.406783773143,-0.407257032703,
	-0.407729992933,-0.408202654008,-0.408675016106,-0.409147079402,-0.409618844073,
	-0.410090310295,-0.410561478244,-0.411032348096,-0.411502920027,-0.411973194212,
	-0.412443170827,-0.412912850049,-0.413382232051,-0.413851317011,-0.414320105102,
	-0.414788596501,-0.415256791383,-0.415724689923,-0.416192292295,-0.416659598675,
	-0.417126609238,-0.417593324158,-0.418059743611,-0.418525867770,-0.418991696811,
	-0.419457230907,-0.419922470234,-0.420387414964,-0.420852065274,-0.421316421336,
	-0.421780483325,-0.422244251415,-0.422707725779,-0.423170906592,-0.423633794026,
	-0.424096388257,-0.424558689456,-0.425020697798,-0.425482413456,-0.425943836604,
	-0.426404967414,-0.426865806059,-0.427326352713,-0.427786607549,-0.428246570739,
	-0.428706242456,-0.429165622872,-0.429624712162,-0.430083510496,-0.430542018047,
	-0.431000234988,-0.431458161491,-0.431915797729,-0.432373143872,-0.432830200093,
	-0.433286966565,-0.433743443458,-0.434199630945,-0.434655529198,-0.435111138387,
	-0.435566458685,-0.436021490262,-0.436476233290,-0.436930687941,-0.437384854382,
	-0.437838732791,-0.438292323335,-0.438745626185,-0.439198641512,-0.439651369487,
	-0.440103810280,-0.440555964062,-0.441007831004,-0.441459411275,-0.441910705046,
	-0.442361712487,-0.442812433769,-0.443262869061,-0.443713018533,-0.444162882355,
	-0.444612460697,-0.445061753728,-0.445510761618,-0.445959484537,-0.446407922654,
	-0.446856076137,-0.447303945158,-0.447751529883,-0.448198830483,-0.448645847127,
	-0.449092579983,-0.449539029220,-0.449985195008,-0.450431077513,-0.450876676906,
	-0.451321993354,-0.451767027026,-0.452211778089,-0.452656246713,-0.453100433065,
	-0.453544337314,-0.453987959626,-0.454431300171,-0.454874359115,-0.455317136626,
	-0.455759632872,-0.456201848021,-0.456643782239,-0.457085435694,-0.457526808553,
	-0.457967900984,-0.458408713152,-0.458849245226,-0.459289497372,-0.459729469756,
	-0.460169162546,-0.460608575907,-0.461047710007,-0.461486565012,-0.461925141088,
	-0.462363438401,-0.462801457118,-0.463239197404,-0.463676659425,-0.464113843348,
	-0.464550749337,-0.464987377559,-0.465423728180,-0.465859801364,-0.466295597277,
	-0.466731116084,-0.467166357951,-0.467601323043,-0.468036011524,-0.468470423560,
	-0.468904559316,-0.469338418956,-0.469772002645,-0.470205310548,-0.470638342829,
	-0.471071099652,-0.471503581182,-0.471935787582,-0.472367719018,-0.472799375654,
	-0.473230757652,-0.473661865177,-0.474092698393,-0.474523257463,-0.474953542552,
	-0.475383553822,-0.475813291436,-0.476242755559,-0.476671946354,-0.477100863982,
	-0.477529508609,-0.477957880396,-0.478385979506,-0.478813806102,-0.479241360348,
	-0.479668642404,-0.480095652435,-0.480522390601,-0.480948857067,-0.481375051993,
	-0.481800975542,-0.482226627876,-0.482652009156,-0.483077119546,-0.483501959206,
	-0.483926528298,-0.484350826983,-0.484774855424,-0.485198613781,-0.485622102216,
	-0.486045320891,-0.486468269965,-0.486890949600,-0.487313359958,-0.487735501198,
	-0.488157373482,-0.488578976971,-0.489000311824,-0.489421378202,-0.489842176266,
	-0.490262706176,-0.490682968092,-0.491102962175,-0.491522688583,-0.491942147478,
	-0.492361339018,-0.492780263364,-0.493198920675,-0.493617311111,-0.494035434832,
	-0.494453291995,-0.494870882762,-0.495288207290,-0.495705265740,-0.496122058269,
	-0.496538585038,-0.496954846204,-0.497370841926,-0.497786572363,-0.498202037674,
	-0.498617238016,-0.499032173549,-0.499446844430,-0.499861250818,-0.500275392870,
	-0.500689270744,-0.501102884599,-0.501516234592,-0.501929320881,-0.502342143623,
	-0.502754702976,-0.503166999097,-0.503579032143,-0.503990802272,-0.504402309641,
	-0.504813554406,-0.505224536725,-0.505635256754,-0.506045714651,-0.506455910571,
	-0.506865844672,-0.507275517110,-0.507684928040,-0.508094077620,-0.508502966005,
	-0.508911593352,-0.509319959816,-0.509728065554,-0.510135910721,-0.510543495472,
	-0.510950819965,-0.511357884352,-0.511764688792,-0.512171233437,-0.512577518445,
	-0.512983543969,-0.513389310166,-0.513794817189,-0.514200065193,-0.514605054335,
	-0.515009784767,-0.515414256644,-0.515818470122,-0.516222425354,-0.516626122495,
	-0.517029561698,-0.517432743118,-0.517835666909,-0.518238333224,-0.518640742218,
	-0.519042894044,-0.519444788856,-0.519846426807,-0.520247808050,-0.520648932739,
	-0.521049801028,-0.521450413068,-0.521850769014,-0.522250869017,-0.522650713232,
	-0.523050301810,-0.523449634905,-0.523848712668,-0.524247535252,-0.524646102810,
	-0.525044415494,-0.525442473456,-0.525840276848,-0.526237825822,-0.526635120529,
	-0.527032161122,-0.527428947752,-0.527825480572,-0.528221759731,-0.528617785382,
	-0.529013557676,-0.529409076764,-0.529804342794,-0.530199355877,-0.530594116107,
	-0.530988623597,-0.531382878468,-0.531776880848,-0.532170630864,-0.532564128649,
	-0.532957374335,-0.533350368055,-0.533743109945,-0.534135600139,-0.534527838775,
	-0.534919825987,-0.535311561915,-0.535703046695,-0.536094280465,-0.536485263363,
	-0.536875995527,-0.537266477098,-0.537656708213,-0.538046689011,-0.538436419632,
	-0.538825900216,-0.539215130902,-0.539604111829,-0.539992843138,-0.540381324969,
	-0.540769557461,-0.541157540755,-0.541545274991,-0.541932760309,-0.542319996850,
	-0.542706984754,-0.543093724161,-0.543480215212,-0.543866458047,-0.544252452807,
	-0.544638199633,-0.545023698664,-0.545408950042,-0.545793953906,-0.546178710399,
	-0.546563219659,-0.546947481828,-0.547331497046,-0.547715265454,-0.548098787192,
	-0.548482062402,-0.548865091222,-0.549247873795,-0.549630410260,-0.550012700757,
	-0.550394745428,-0.550776544413,-0.551158097851,-0.551539405884,-0.551920468651,
	-0.552301286294,-0.552681858951,-0.553062186764,-0.553442269872,-0.553822108415,
	-0.554201702535,-0.554581052370,-0.554960158061,-0.555339019747,-0.555717637569,
	-0.556096011666,-0.556474142179,-0.556852029246,-0.557229673008,-0.557607073604,
	-0.557984231174,-0.558361145858,-0.558737817794,-0.559114247123,-0.559490433983,
	-0.559866378515,-0.560242080857,-0.560617541148,-0.560992759528,-0.561367736136,
	-0.561742471110,-0.562116964591,-0.562491216715,-0.562865227624,-0.563238997454,
	-0.563612526346,-0.563985814437,-0.564358861867,-0.564731668773,-0.565104235294,
	-0.565476561569,-0.565848647736,-0.566220493933,-0.566592100299,-0.566963466971,
	-0.567334594087,-0.567705481786,-0.568076130205,-0.568446539483,-0.568816709757,
	-0.569186641164,-0.569556333843,-0.569925787931,-0.570295003565,-0.570663980883,
	-0.571032720023,-0.571401221120,-0.571769484314,-0.572137509740,-0.572505297536,
	-0.572872847839,-0.573240160785,-0.573607236512,-0.573974075157,-0.574340676855,
	-0.574707041744,-0.575073169959,-0.575439061639,-0.575804716918,-0.576170135933,
	-0.576535318821,-0.576900265717,-0.577264976758,-0.577629452079,-0.577993691817,
	-0.578357696107,-0.578721465085,-0.579084998887,-0.579448297648,-0.579811361504,
	-0.580174190589,-0.580536785041,-0.580899144993,-0.581261270581,-0.581623161940,
	-0.581984819205,-0.582346242511,-0.582707431993,-0.583068387786,-0.583429110024,
	-0.583789598842,-0.584149854374,-0.584509876755,-0.584869666120,-0.585229222602,
	-0.585588546336,-0.585947637455,-0.586306496095,-0.586665122388,-0.587023516469,
	-0.587381678471,-0.587739608529,-0.588097306775,-0.588454773344,-0.588812008368,
	-0.589169011981,-0.589525784317,-0.589882325508,-0.590238635688,-0.590594714989,
	-0.590950563545,-0.591306181488,-0.591661568951,-0.592016726068,-0.592371652969,
	-0.592726349788,-0.593080816658,-0.593435053710,-0.593789061077,-0.594142838891,
	-0.594496387284,-0.594849706388,-0.595202796335,-0.595555657257,-0.595908289285,
	-0.596260692551,-0.596612867186,-0.596964813323,-0.597316531091,-0.597668020624,
	-0.598019282051,-0.598370315504,-0.598721121114,-0.599071699011,-0.599422049328,
	-0.599772172193,-0.600122067739,-0.600471736095,-0.600821177392,-0.601170391760,
	-0.601519379330,-0.601868140232,-0.602216674596,-0.602564982552,-0.602913064229,
	-0.603260919758,-0.603608549269,-0.603955952891,-0.604303130754,-0.604650082986,
	-0.604996809719,-0.605343311080,-0.605689587199,-0.606035638205,-0.606381464227,
	-0.606727065394,-0.607072441836,-0.607417593679,-0.607762521054,-0.608107224089,
	-0.608451702913,-0.608795957652,-0.609139988437,-0.609483795395,-0.609827378654,
	-0.610170738343,-0.610513874588,-0.610856787519,-0.611199477262,-0.611541943945,
	-0.611884187697,-0.612226208643,-0.612568006912,-0.612909582632,-0.613250935928,
	-0.613592066928,-0.613932975760,-0.614273662549,-0.614614127424,-0.614954370510,
	-0.615294391934,-0.615634191822,-0.615973770302,-0.616313127499,-0.616652263540,
	-0.616991178550,-0.617329872656,-0.617668345984,-0.618006598659,-0.618344630808,
	-0.618682442556,-0.619020034028,-0.619357405350,-0.619694556648,-0.620031488046,
	-0.620368199670,-0.620704691646,-0.621040964097,-0.621377017149,-0.621712850926,
	-0.622048465554,-0.622383861158,-0.622719037860,-0.623053995787,-0.623388735061,
	-0.623723255809,-0.624057558153,-0.624391642217,-0.624725508126,-0.625059156004,
	-0.625392585974,-0.625725798160,-0.626058792685,-0.626391569673,-0.626724129247,
	-0.627056471531,-0.627388596648,-0.627720504720,-0.628052195871,-0.628383670224,
	-0.628714927901,-0.629045969025,-0.629376793719,-0.629707402105,-0.630037794306,
	-0.630367970444,-0.630697930641,-0.631027675019,-0.631357203700,-0.631686516806,
	-0.632015614459,-0.632344496781,-0.632673163893,-0.633001615917,-0.633329852974,
	-0.633657875186,-0.633985682673,-0.634313275558,-0.634640653960,-0.634967818001,
	-0.635294767801,-0.635621503482,-0.635948025164,-0.636274332968,-0.636600427014,
	-0.636926307421,-0.637251974312,-0.637577427805,-0.637902668021,-0.638227695080,
	-0.638552509101,-0.638877110204,-0.639201498510,-0.639525674137,-0.639849637205,
	-0.640173387833,-0.640496926140,-0.640820252247,-0.641143366271,-0.641466268331,
	-0.641788958547,-0.642111437038,-0.642433703921,-0.642755759316,-0.643077603341,
	-0.643399236114,-0.643720657753,-0.644041868377,-0.644362868104,-0.644683657052,
	-0.645004235338,-0.645324603080,-0.645644760396,-0.645964707404,-0.646284444221,
	-0.646603970964,-0.646923287750,-0.647242394697,-0.647561291921,-0.647879979541,
	-0.648198457671,-0.648516726431,-0.648834785934,-0.649152636300,-0.649470277643,
	-0.649787710080,-0.650104933727,-0.650421948702,-0.650738755118,-0.651055353094,
	-0.651371742743,-0.651687924183,-0.652003897528,-0.652319662894,-0.652635220397,
	-0.652950570152,-0.653265712275,-0.653580646879,-0.653895374081,-0.654209893995,
	-0.654524206736,-0.654838312418,-0.655152211158,-0.655465903068,-0.655779388262,
	-0.656092666857,-0.656405738965,-0.656718604702,-0.657031264180,-0.657343717514,
	-0.657655964816,-0.657968006203,-0.658279841786,-0.658591471679,-0.658902895996,
	-0.659214114850,-0.659525128354,-0.659835936621,-0.660146539764,-0.660456937895,
	-0.660767131129,-0.661077119577,-0.661386903351,-0.661696482565,-0.662005857331,
	-0.662315027760,-0.662623993965,-0.662932756059,-0.663241314152,-0.663549668357,
	-0.663857818786,-0.664165765550,-0.664473508760,-0.664781048528,-0.665088384966,
	-0.665395518184,-0.665702448294,-0.666009175406,-0.666315699632,-0.666622021082,
	-0.666928139867,-0.667234056097,-0.667539769883,-0.667845281336,-0.668150590565,
	-0.668455697681,-0.668760602793,-0.669065306012,-0.669369807448,-0.669674107210,
	-0.669978205408,-0.670282102151,-0.670585797549,-0.670889291711,-0.671192584746,
	-0.671495676764,-0.671798567873,-0.672101258182,-0.672403747800,-0.672706036836,
	-0.673008125398,-0.673310013595,-0.673611701535,-0.673913189326,-0.674214477077,
	-0.674515564895,-0.674816452889,-0.675117141166,-0.675417629834,-0.675717919000,
	-0.676018008773,-0.676317899259,-0.676617590566,-0.676917082801,-0.677216376071,
	-0.677515470482,-0.677814366143,-0.678113063159,-0.678411561638,-0.678709861685,
	-0.679007963408,-0.679305866912,-0.679603572304,-0.679901079690,-0.680198389176,
	-0.680495500867,-0.680792414870,-0.681089131291,-0.681385650234,-0.681681971806,
	-0.681978096111,-0.682274023256,-0.682569753344,-0.682865286481,-0.683160622773,
	-0.683455762323,-0.683750705237,-0.684045451620,-0.684340001575,-0.684634355207,
	-0.684928512620,-0.685222473919,-0.685516239207,-0.685809808589,-0.686103182169,
	-0.686396360049,-0.686689342334,-0.686982129128,-0.687274720533,-0.687567116653,
	-0.687859317591,-0.688151323451,-0.688443134335,-0.688734750346,-0.689026171586,
	-0.689317398160,-0.689608430168,-0.689899267714,-0.690189910899,-0.690480359827,
	-0.690770614598,-0.691060675316,-0.691350542081,-0.691640214997,-0.691929694163,
	-0.692218979683,-0.692508071657,-0.692796970186,-0.693085675373,-0.693374187317,
	-0.693662506121,-0.693950631884,-0.694238564708,-0.694526304694,-0.694813851941,
	-0.695101206550,-0.695388368623,-0.695675338258,-0.695962115556,-0.696248700617,
	-0.696535093541,-0.696821294428,-0.697107303377,-0.697393120488,-0.697678745860,
	-0.697964179593,-0.698249421786,-0.698534472538,-0.698819331948,-0.699104000115,
	-0.699388477137,-0.699672763114,-0.699956858144,-0.700240762325,-0.700524475755,
	-0.700807998534,-0.701091330758,-0.701374472527,-0.701657423937,-0.701940185087,
	-0.702222756074,-0.702505136996,-0.702787327950,-0.703069329034,-0.703351140344,
	-0.703632761979,-0.703914194034,-0.704195436607,-0.704476489794,-0.704757353692,
	-0.705038028398,-0.705318514008,-0.705598810618,-0.705878918325,-0.706158837224,
	-0.706438567412,-0.706718108984,-0.706997462037,-0.707276626665,-0.707555602964,
	-0.707834391030,-0.708112990958,-0.708391402843,-0.708669626780,-0.708947662864,
	-0.709225511190,-0.709503171852,-0.709780644946,-0.710057930565,-0.710335028804,
	-0.710611939758,-0.710888663520,-0.711165200184,-0.711441549845,-0.711717712595,
	-0.711993688530,-0.712269477741,-0.712545080324,-0.712820496370,-0.713095725974,
	-0.713370769229,-0.713645626226,-0.713920297060,-0.714194781823,-0.714469080607,
	-0.714743193506,-0.715017120611,-0.715290862015,-0.715564417810,-0.715837788089,
	-0.716110972942,-0.716383972462,-0.716656786740,-0.716929415869,-0.717201859939,
	-0.717474119042,-0.717746193269,-0.718018082712,-0.718289787461,-0.718561307607,
	-0.718832643241,-0.719103794454,-0.719374761336,-0.719645543977,-0.719916142469,
	-0.720186556900,-0.720456787362,-0.720726833944,-0.720996696736,-0.721266375827,
	-0.721535871308,-0.721805183267,-0.722074311795,-0.722343256979,-0.722612018911,
	-0.722880597677,-0.723148993369,-0.723417206073,-0.723685235879,-0.723953082875,
	-0.724220747150,-0.724488228793,-0.724755527890,-0.725022644531,-0.725289578803,
	-0.725556330794,-0.725822900591,-0.726089288283,-0.726355493957,-0.726621517700,
	-0.726887359599,-0.727153019742,-0.727418498215,-0.727683795106,-0.727948910501,
	-0.728213844486,-0.728478597148,-0.728743168575,-0.729007558851,-0.729271768062,
	-0.729535796296,-0.729799643638,-0.730063310174,-0.730326795989,-0.730590101169,
	-0.730853225799,-0.731116169965,-0.731378933752,-0.731641517245,-0.731903920528,
	-0.732166143688,-0.732428186807,-0.732690049972,-0.732951733265,-0.733213236773,
	-0.733474560578,-0.733735704766,-0.733996669419,-0.734257454623,-0.734518060459,
	-0.734778487013,-0.735038734368,-0.735298802606,-0.735558691812,-0.735818402068,
	-0.736077933458,-0.736337286063,-0.736596459968,-0.736855455254,-0.737114272004,
	-0.737372910300,-0.737631370226,-0.737889651862,-0.738147755290,-0.738405680594,
	-0.738663427854,-0.738920997152,-0.739178388569,-0.739435602188,-0.739692638089,
	-0.739949496353,-0.740206177061,-0.740462680295,-0.740719006135,-0.740975154661,
	-0.741231125955,-0.741486920096,-0.741742537166,-0.741997977243,-0.742253240408,
	-0.742508326741,-0.742763236322,-0.743017969230,-0.743272525545,-0.743526905346,
	-0.743781108713,-0.744035135725,-0.744288986460,-0.744542660997,-0.744796159416,
	-0.745049481795,-0.745302628212,-0.745555598747,-0.745808393476,-0.746061012479,
	-0.746313455832,-0.746565723615,-0.746817815905,-0.747069732780,-0.747321474316,
	-0.747573040592,-0.747824431684,-0.748075647670,-0.748326688627,-0.748577554632,
	-0.748828245761,-0.749078762091,-0.749329103698,-0.749579270659,-0.749829263050,
	-0.750079080947,-0.750328724426,-0.750578193563,-0.750827488434,-0.751076609114,
	-0.751325555679,-0.751574328203,-0.751822926763,-0.752071351433,-0.752319602289,
	-0.752567679404,-0.752815582854,-0.753063312713,-0.753310869056,-0.753558251957,
	-0.753805461490,-0.754052497729,-0.754299360748,-0.754546050621,-0.754792567422,
	-0.755038911223,-0.755285082099,-0.755531080123,-0.755776905367,-0.756022557905,
	-0.756268037810,-0.756513345154,-0.756758480010,-0.757003442450,-0.757248232547,
	-0.757492850373,-0.757737296000,-0.757981569500,-0.758225670945,-0.758469600406,
	-0.758713357955,-0.758956943663,-0.759200357603,-0.759443599844,-0.759686670458,
	-0.759929569516,-0.760172297088,-0.760414853245,-0.760657238058,-0.760899451597,
	-0.761141493932,-0.761383365134,-0.761625065271,-0.761866594415,-0.762107952634,
	-0.762349139999,-0.762590156578,-0.762831002442,-0.763071677658,-0.763312182297,
	-0.763552516427,-0.763792680117,-0.764032673435,-0.764272496450,-0.764512149230,
	-0.764751631843,-0.764990944359,-0.765230086843,-0.765469059365,-0.765707861992,
	-0.765946494792,-0.766184957831,-0.766423251177,-0.766661374898,-0.766899329060,
	-0.767137113730,-0.767374728975,-0.767612174862,-0.767849451456,-0.768086558825,
	-0.768323497033,-0.768560266149,-0.768796866235,-0.769033297361,-0.769269559590,
	-0.769505652989,-0.769741577622,-0.769977333554,-0.770212920852,-0.770448339579,
	-0.770683589801,-0.770918671583,-0.771153584987,-0.771388330081,-0.771622906926,
	-0.771857315588,-0.772091556130,-0.772325628617,-0.772559533111,-0.772793269678,
	-0.773026838379,-0.773260239278,-0.773493472439,-0.773726537924,-0.773959435796,
	-0.774192166118,-0.774424728953,-0.774657124362,-0.774889352409,-0.775121413155,
	-0.775353306662,-0.775585032993,-0.775816592209,-0.776047984371,-0.776279209541,
	-0.776510267781,-0.776741159151,-0.776971883713,-0.777202441527,-0.777432832654,
	-0.777663057155,-0.777893115090,-0.778123006520,-0.778352731504,-0.778582290103,
	-0.778811682377,-0.779040908385,-0.779269968187,-0.779498861842,-0.779727589410,
	-0.779956150950,-0.780184546521,-0.780412776182,-0.780640839991,-0.780868738008,
	-0.781096470290,-0.781324036896,-0.781551437884,-0.781778673312,-0.782005743238,
	-0.782232647720,-0.782459386815,-0.782685960581,-0.782912369075,-0.783138612354,
	-0.783364690475,-0.783590603495,-0.783816351471,-0.784041934460,-0.784267352517,
	-0.784492605699,-0.784717694062,-0.784942617663,-0.785167376556,-0.785391970798,
	-0.785616400444,-0.785840665550,-0.786064766171,-0.786288702361,-0.786512474177,
	-0.786736081672,-0.786959524901,-0.787182803920,-0.787405918781,-0.787628869540,
	-0.787851656251,-0.788074278967,-0.788296737742,-0.788519032630,-0.788741163684,
	-0.788963130957,-0.789184934504,-0.789406574376,-0.789628050627,-0.789849363309,
	-0.790070512475,-0.790291498178,-0.790512320469,-0.790732979401,-0.790953475026,
	-0.791173807395,-0.791393976560,-0.791613982573,-0.791833825485,-0.792053505348,
	-0.792273022212,-0.792492376128,-0.792711567147,-0.792930595320,-0.793149460696,
	-0.793368163328,-0.793586703264,-0.793805080554,-0.794023295249,-0.794241347397,
	-0.794459237050,-0.794676964255,-0.794894529063,-0.795111931522,-0.795329171681,
	-0.795546249589,-0.795763165295,-0.795979918847,-0.796196510293,-0.796412939682,
	-0.796629207062,-0.796845312479,-0.797061255983,-0.797277037621,-0.797492657439,
	-0.797708115486,-0.797923411808,-0.798138546452,-0.798353519465,-0.798568330894,
	-0.798782980784,-0.798997469183,-0.799211796136,-0.799425961690,-0.799639965890,
	-0.799853808781,-0.800067490410,-0.800281010822,-0.800494370061,-0.800707568174,
	-0.800920605204,-0.801133481196,-0.801346196196,-0.801558750247,-0.801771143393,
	-0.801983375680,-0.802195447150,-0.802407357847,-0.802619107816,-0.802830697098,
	-0.803042125739,-0.803253393780,-0.803464501265,-0.803675448237,-0.803886234738,
	-0.804096860810,-0.804307326497,-0.804517631840,-0.804727776881,-0.804937761661,
	-0.805147586224,-0.805357250610,-0.805566754860,-0.805776099016,-0.805985283118,
	-0.806194307209,-0.806403171327,-0.806611875514,-0.806820419811,-0.807028804256,
	-0.807237028892,-0.807445093756,-0.807652998890,-0.807860744332,-0.808068330122,
	-0.808275756299,-0.808483022903,-0.808690129972,-0.808897077544,-0.809103865659,
	-0.809310494355,-0.809516963670,-0.809723273643,-0.809929424310,-0.810135415710,
	-0.810341247880,-0.810546920858,-0.810752434682,-0.810957789387,-0.811162985011,
	-0.811368021591,-0.811572899163,-0.811777617764,-0.811982177430,-0.812186578197,
	-0.812390820101,-0.812594903178,-0.812798827463,-0.813002592991,-0.813206199799,
	-0.813409647920,-0.813612937390,-0.813816068243,-0.814019040515,-0.814221854239,
	-0.814424509450,-0.814627006181,-0.814829344467,-0.815031524341,-0.815233545837,
	-0.815435408988,-0.815637113828,-0.815838660389,-0.816040048704,-0.816241278806,
	-0.816442350728,-0.816643264501,-0.816844020158,-0.817044617731,-0.817245057251,
	-0.817445338751,-0.817645462262,-0.817845427815,-0.818045235441,-0.818244885171,
	-0.818444377036,-0.818643711067,-0.818842887293,-0.819041905746,-0.819240766455,
	-0.819439469450,-0.819638014762,-0.819836402418,-0.820034632450,-0.820232704885,
	-0.820430619754,-0.820628377084,-0.820825976906,-0.821023419246,-0.821220704134,
	-0.821417831597,-0.821614801664,-0.821811614362,-0.822008269719,-0.822204767762,
	-0.822401108519,-0.822597292017,-0.822793318282,-0.822989187342,-0.823184899223,
	-0.823380453950,-0.823575851552,-0.823771092052,-0.823966175478,-0.824161101855,
	-0.824355871208,-0.824550483563,-0.824744938945,-0.824939237379,-0.825133378889,
	-0.825327363500,-0.825521191236,-0.825714862122,-0.825908376182,-0.826101733439,
	-0.826294933917,-0.826487977640,-0.826680864631,-0.826873594913,-0.827066168509,
	-0.827258585441,-0.827450845733,-0.827642949407,-0.827834896484,-0.828026686987,
	-0.828218320938,-0.828409798359,-0.828601119270,-0.828792283693,-0.828983291650,
	-0.829174143160,-0.829364838246,-0.829555376926,-0.829745759223,-0.829935985155,
	-0.830126054743,-0.830315968007,-0.830505724966,-0.830695325640,-0.830884770047,
	-0.831074058208,-0.831263190140,-0.831452165863,-0.831640985395,-0.831829648754,
	-0.832018155958,-0.832206507026,-0.832394701974,-0.832582740822,-0.832770623585,
	-0.832958350281,-0.833145920927,-0.833333335540
	}
};

double always_inline copicat1clip(double x) {
    double f = fabs(x);
    f = f * copicat1_table.istep;
    int i = static_cast<int>(f);
    if (i < 0) {
        f = copicat1_table.data[0];
    } else if (i >= copicat1_table.size-1) {
        f = copicat1_table.data[copicat1_table.size-1];
    } else {
    f -= i;
    f = copicat1_table.data[i]*(1-f) + copicat1_table.data[i+1]*f;
    }
    return copysign(f, x);
}

