---
id: Number input
section: components
cssPrefix: pf-v6-c-number-input
propComponents: ['NumberInput']
---

import { Fragment, useReducer, useState } from 'react';

## Examples

### Default

```ts file="./NumberInputDefault.tsx"
```

### With unit

```ts file="./NumberInputUnit.tsx"
```

### With unit and thresholds

To enable a user entered value to snap to the nearest threshold if the entered input is out of bounds, define the blur event handler.

```ts file="./NumberInputUnitThreshold.tsx"
```

### Disabled

```ts file="./NumberInputDisabled.tsx"
```

### With status

```ts file="./NumberInputWithStatus.tsx"
```

### Varying sizes

```ts file="./NumberInputVaryingSizes.tsx"
```

### Custom increment/decrement

```ts file="./NumberInputCustomStep.tsx"
```

### Custom increment/decrement and thresholds

```ts file="./NumberInputCustomStepAndThreshold.tsx"
```
