/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2025 Univ. Grenoble Alpes, CNRS, Grenoble INP - UGA, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifdef PYTHON_BINDING

#ifndef __PYTHON_HOTPLUG_ACTION__
#define __PYTHON_HOTPLUG_ACTION__

#include "HotPlugAction.h"

#include <QDir>

namespace camitk {

class PythonHotPlugActionExtension;

/**
 * @brief An Action that can be created on the fly and execute python
 * script in a specific virtual env.
 */
class CAMITK_API PythonHotPlugAction : public HotPlugAction {
    Q_OBJECT

public:
    /// Default Constructor
    /// calls user-defined init()
    PythonHotPlugAction(PythonHotPlugActionExtension* actionExtension, const VariantDataModel& data);

    /// Default Destructor
    virtual ~PythonHotPlugAction() = default;

    /// calls user-defined init() if found
    /// @return true if the script was found and no error was raised from python
    virtual bool init() override;

    /// Calls user-defined targetDefined() and getUI()
    virtual QWidget* getWidget() override;

    /// return the "pythonesque" name of the action
    QString getPythonName();

public slots:
    /** this method is automatically called when the action is triggered.
      * Call getTargets() method to get the list of components to use.
      * \note getTargets() is automatically filtered so that it only contains compatible components,
      * i.e., instances of "$componentClass$" (or a subclass).
      */
    virtual Action::ApplyStatus apply() override;

protected:
    /// Call the C++ symbol parameterChanged
    virtual void parameterChangedEvent(QString parameterName) override;

private:
    /// the "pythonesque" name of the action (used to find the python script filename)
    /// lower snake case of the "Action Name" → "action_name"
    QString pythonName;

    /// the python extension managing this action
    PythonHotPlugActionExtension* pythonExtension;

    /// if the action is marked as having no gui, getWidget should call targetChanged
    /// and return nullptr (false by default)
    bool noGui;
};

} // namespace camitk

#endif // __PYTHON_HOTPLUG_ACTION__
#endif // PYTHON_BINDING

