#if defined(Hiro_TabFrame)
struct mTabFrame : mWidget {
  Declare(TabFrame)
  using mObject::remove;
  friend struct mTabFrameItem;

  auto append(sTabFrameItem item) -> type&;
  auto doChange() const -> void;
  auto doClose(sTabFrameItem item) const -> void;
  auto doMove(sTabFrameItem from, sTabFrameItem to) const -> void;
  auto item(uint position) const -> TabFrameItem;
  auto itemCount() const -> uint;
  auto items() const -> std::vector<TabFrameItem>;
  auto navigation() const -> Navigation;
  auto onChange(const std::function<void ()>& callback = {}) -> type&;
  auto onClose(const std::function<void (TabFrameItem)>& callback = {}) -> type&;
  auto onMove(const std::function<void (TabFrameItem, TabFrameItem)>& callback = {}) -> type&;
  auto remove(sTabFrameItem item) -> type&;
  auto reset() -> type& override;
  auto selected() const -> TabFrameItem;
  auto setEnabled(bool enabled = true) -> type& override;
  auto setFont(const Font& font = {}) -> type& override;
  auto setNavigation(Navigation navigation = Navigation::Top) -> type&;
  auto setParent(mObject* object = nullptr, s32 offset = -1) -> type& override;
  auto setVisible(bool visible = true) -> type& override;

//private:
  struct State {
    std::vector<sTabFrameItem> items;
    Navigation navigation = Navigation::Top;
    std::function<void ()> onChange;
    std::function<void (TabFrameItem)> onClose;
    std::function<void (TabFrameItem, TabFrameItem)> onMove;
  } state;

  auto destruct() -> void override;
};
#endif
