/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import java.util.regex.Pattern;
import org.odftoolkit.odfdom.type.OdfDataType;

public class RelativeLength
implements OdfDataType {
    private String mLength;
    private static final Pattern relativeLengthPattern = Pattern.compile("^[0-9]+\\*$");

    public RelativeLength(String length) throws NumberFormatException {
        if (!RelativeLength.isValid(length)) {
            throw new NumberFormatException("parameter is invalid for datatype RelativeLength");
        }
        this.mLength = length;
    }

    public String toString() {
        return this.mLength;
    }

    public static RelativeLength valueOf(String stringValue) throws NumberFormatException {
        return new RelativeLength(stringValue);
    }

    public static boolean isValid(String stringValue) {
        return stringValue != null && relativeLengthPattern.matcher(stringValue).matches();
    }
}

