/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * DW100 Hardware dewarper
 *
 * Copyright 2022 NXP
 * Author: Xavier Roumegue (xavier.roumegue@oss.nxp.com)
 */

#ifndef _DW100_REGS_H_
#define _DW100_REGS_H_

/* AHB register offset */
#define DW100_DEWARP_ID			0x00
#define DW100_DEWARP_CTRL		0x04
#define DW100_DEWARP_CTRL_ENABLE			BIT(0)
#define DW100_DEWARP_CTRL_START				BIT(1)
#define DW100_DEWARP_CTRL_SOFT_RESET			BIT(2)
#define DW100_DEWARP_CTRL_FORMAT_YUV422_SP		0UL
#define DW100_DEWARP_CTRL_FORMAT_YUV422_PACKED		1UL
#define DW100_DEWARP_CTRL_FORMAT_YUV420_SP		2UL
#define DW100_DEWARP_CTRL_INPUT_FORMAT_MASK		GENMASK(5, 4)
#define DW100_DEWARP_CTRL_INPUT_FORMAT(x)		((x) << 4)
#define DW100_DEWARP_CTRL_OUTPUT_FORMAT(x)		((x) << 6)
#define DW100_DEWARP_CTRL_OUTPUT_FORMAT_MASK		GENMASK(7, 6)
#define DW100_DEWARP_CTRL_SRC_AUTO_SHADOW		BIT(8)
#define DW100_DEWARP_CTRL_HW_HANDSHAKE			BIT(9)
#define DW100_DEWARP_CTRL_DST_AUTO_SHADOW		BIT(10)
#define DW100_DEWARP_CTRL_SPLIT_LINE			BIT(11)
#define DW100_DEWARP_CTRL_PREFETCH_MODE_MASK		GENMASK(17, 16)
#define DW100_DEWARP_CTRL_PREFETCH_MODE_TRAVERSAL	(0UL << 16)
#define DW100_DEWARP_CTRL_PREFETCH_MODE_CALCULATION	(1UL << 16)
#define DW100_DEWARP_CTRL_PREFETCH_MODE_AUTO		(2UL << 16)
#define DW100_DEWARP_CTRL_PREFETCH_THRESHOLD_MASK	GENMASK(24, 18)
#define DW100_DEWARP_CTRL_PREFETCH_THRESHOLD(x)		((x) << 18)

#define DW100_MAP_LUT_ADDR		0x08
#define DW100_MAP_LUT_ADDR_ADDR(addr)	(((addr) >> 4) & GENMASK(29, 0))
#define DW100_MAP_LUT_SIZE		0x0c
#define DW100_MAP_LUT_SIZE_WIDTH(w)	(((w) & GENMASK(10, 0)) << 0)
#define DW100_MAP_LUT_SIZE_HEIGHT(h)	(((h) & GENMASK(10, 0)) << 16)
#define DW100_SRC_IMG_Y_BASE		0x10
#define DW100_IMG_Y_BASE(base)		(((base) >> 4) & GENMASK(29, 0))
#define DW100_SRC_IMG_UV_BASE		0x14
#define DW100_IMG_UV_BASE(base)		(((base) >> 4) & GENMASK(29, 0))
#define DW100_SRC_IMG_SIZE		0x18
#define DW100_IMG_SIZE_WIDTH(w)		(((w) & GENMASK(12, 0)) << 0)
#define DW100_IMG_SIZE_HEIGHT(h)	(((h) & GENMASK(12, 0)) << 16)

#define DW100_SRC_IMG_STRIDE		0x1c
#define DW100_MAP_LUT_ADDR2		0x20
#define DW100_MAP_LUT_SIZE2		0x24
#define DW100_SRC_IMG_Y_BASE2		0x28
#define DW100_SRC_IMG_UV_BASE2		0x2c
#define DW100_SRC_IMG_SIZE2		0x30
#define DW100_SRC_IMG_STRIDE2		0x34
#define DW100_DST_IMG_Y_BASE		0x38
#define DW100_DST_IMG_UV_BASE		0x3c
#define DW100_DST_IMG_SIZE		0x40
#define DW100_DST_IMG_STRIDE		0x44
#define DW100_DST_IMG_Y_BASE2		0x48
#define DW100_DST_IMG_UV_BASE2		0x4c
#define DW100_DST_IMG_SIZE2		0x50
#define DW100_DST_IMG_STRIDE2		0x54
#define DW100_SWAP_CONTROL		0x58
#define DW100_SWAP_CONTROL_BYTE		BIT(0)
#define DW100_SWAP_CONTROL_SHORT	BIT(1)
#define DW100_SWAP_CONTROL_WORD		BIT(2)
#define DW100_SWAP_CONTROL_LONG		BIT(3)
#define DW100_SWAP_CONTROL_Y(x)		(((x) & GENMASK(3, 0)) << 0)
#define DW100_SWAP_CONTROL_UV(x)	(((x) & GENMASK(3, 0)) << 4)
#define DW100_SWAP_CONTROL_SRC(x)	(((x) & GENMASK(7, 0)) << 0)
#define DW100_SWAP_CONTROL_DST(x)	(((x) & GENMASK(7, 0)) << 8)
#define DW100_SWAP_CONTROL_SRC2(x)	(((x) & GENMASK(7, 0)) << 16)
#define DW100_SWAP_CONTROL_DST2(x)	(((x) & GENMASK(7, 0)) << 24)
#define DW100_SWAP_CONTROL_SRC_MASK	GENMASK(7, 0)
#define DW100_SWAP_CONTROL_DST_MASK	GENMASK(15, 8)
#define DW100_SWAP_CONTROL_SRC2_MASK	GENMASK(23, 16)
#define DW100_SWAP_CONTROL_DST2_MASK	GENMASK(31, 24)
#define DW100_VERTICAL_SPLIT_LINE	0x5c
#define DW100_HORIZON_SPLIT_LINE	0x60
#define DW100_SCALE_FACTOR		0x64
#define DW100_ROI_START			0x68
#define DW100_ROI_START_X(x)		(((x) & GENMASK(12, 0)) << 0)
#define DW100_ROI_START_Y(y)		(((y) & GENMASK(12, 0)) << 16)
#define DW100_BOUNDARY_PIXEL		0x6c
#define DW100_BOUNDARY_PIXEL_V(v)	(((v) & GENMASK(7, 0)) << 0)
#define DW100_BOUNDARY_PIXEL_U(u)	(((u) & GENMASK(7, 0)) << 8)
#define DW100_BOUNDARY_PIXEL_Y(y)	(((y) & GENMASK(7, 0)) << 16)

#define DW100_INTERRUPT_STATUS		0x70
#define DW100_INTERRUPT_STATUS_INT_FRAME_DONE		BIT(0)
#define DW100_INTERRUPT_STATUS_INT_ERR_TIME_OUT		BIT(1)
#define DW100_INTERRUPT_STATUS_INT_ERR_AXI_RESP		BIT(2)
#define DW100_INTERRUPT_STATUS_INT_ERR_X		BIT(3)
#define DW100_INTERRUPT_STATUS_INT_ERR_MB_FETCH		BIT(4)
#define DW100_INTERRUPT_STATUS_INT_ERR_FRAME2		BIT(5)
#define DW100_INTERRUPT_STATUS_INT_ERR_FRAME3		BIT(6)
#define DW100_INTERRUPT_STATUS_INT_ERR_FRAME_DONE	BIT(7)
#define DW100_INTERRUPT_STATUS_INT_ERR_STATUS(x)	(((x) >> 1) & 0x7f)
#define DW100_INTERRUPT_STATUS_INT_STATUS(x)		((x) & 0xff)

#define DW100_INTERRUPT_STATUS_INT_ENABLE_MASK		GENMASK(15, 8)
#define DW100_INTERRUPT_STATUS_INT_ENABLE(x)		(((x) & GENMASK(7, 0)) << 8)
#define DW100_INTERRUPT_STATUS_FRAME_BUSY		BIT(16)
#define DW100_INTERRUPT_STATUS_INT_CLEAR(x)		(((x) & GENMASK(7, 0)) << 24)
#define DW100_BUS_CTRL			0x74
#define DW100_BUS_CTRL_AXI_MASTER_ENABLE	BIT(31)
#define DW100_BUS_CTRL1			0x78
#define DW100_BUS_TIME_OUT_CYCLE	0x7c
#define DW100_DST_IMG_Y_SIZE1		0x80
#define DW100_DST_IMG_Y_SIZE(sz)	(((sz) >> 4) & GENMASK(29, 0))
#define DW100_DST_IMG_UV_SIZE(sz)	(((sz) >> 4) & GENMASK(29, 0))
#define DW100_DST_IMG_UV_SIZE1		0x84
#define DW100_DST_IMG_Y_SIZE2		0x88
#define DW100_DST_IMG_UV_SIZE2		0x8c

#endif /* _DW100_REGS_H_ */
