import os
import re
from datetime import datetime

# Extract the version number from the grandparent folder name
current_file_path = os.path.realpath(__file__)
greatgrandparent_folder_path = os.path.dirname(os.path.dirname(os.path.dirname(os.path.dirname(current_file_path))))
greatgrandparent_folder_name = os.path.basename(greatgrandparent_folder_path)

version_folder_pattern = re.compile(r'kickshaw_(\d+\.\d+\.\d+)_GTK3_source_only')
match = version_folder_pattern.match(greatgrandparent_folder_name)

if not match:
    print("The script is not in the correct folder structure.")
    exit()

version_number = match.group(1)

# Path to the file that needs to be modified
file_path = '../declarations_definitions_and_enumerations.h'

# Read the contents of the file
with open(file_path, 'r') as file:
    lines = file.readlines()

# Replace the version number and year
for i, line in enumerate(lines):
    if line.startswith('#define KICKSHAW_VERSION'):
        lines[i] = f'#define KICKSHAW_VERSION "{version_number}"\n'
    elif line.startswith('#define RELEASED_IN'):
        current_year = datetime.now().year
        lines[i] = f'#define RELEASED_IN "{current_year}"\n'

# Write the changes back to the file
with open(file_path, 'w') as file:
    file.writelines(lines)

print("File updated successfully.")
