;; julia-tab.scm

;; Copyright 2018,2020,2021 Matthew R. Wette
;; 
;; This library is free software; you can redistribute it and/or
;; modify it under the terms of the GNU Lesser General Public
;; License as published by the Free Software Foundation; either
;; version 3 of the License, or (at your option) any later version.
;; See the file COPYING included with the this distribution.

(define julia-mtab
  '(($start . 68) ($string . 3) ($float . 4) ($fixed . 5) ($ident . 6) 
    (";" . 7) ("begin" . 8) ("]" . 9) ("[" . 10) ("*" . 11) ("+" . 12) 
    (">" . 13) ("&&" . 14) ("||" . 15) ("elseif" . 16) ("else" . 17) ("if" . 
    18) ("return" . 19) ("," . 20) ("=" . 21) ("end" . 22) (")" . 23) ("(" . 
    24) ("function" . 25) ($error . 2) ($end . 27)))

(define julia-ntab
  '((28 . float) (29 . integer) (30 . compound-expr) (31 . string) (32 . 
    number) (33 . primary-expr) (34 . sel-expr) (35 . ttag-expr) (36 . 
    exp-expr) (37 . unary-expr) (38 . shift-expr) (39 . frac-expr) (40 . 
    mul-expr) (41 . add-expr) (42 . colon-expr) (43 . pipe-expr) (44 . 
    ??1-expr) (45 . rel-expr) (46 . logand-expr) (47 . logor-expr) (48 . 
    cond-expr) (49 . keyval-expr) (50 . elseif-list-1) (51 . elseif-list) 
    (52 . assn-expr) (53 . lval-list) (54 . return-expr) (55 . if-expr) 
    (56 . stmt-list-1) (57 . expr-no-assn) (58 . expr-list-1) (59 . expr-list)
    (60 . arg-list-1) (61 . expr) (62 . stmt-list) (63 . term) (64 . arg-list)
    (65 . ident) (66 . stmt-expr) (67 . function-defn) (68 . translation-unit)
    ))

(define julia-len-v
  #(1 1 1 10 8 1 1 3 1 1 1 3 1 1 2 2 2 3 1 2 5 7 6 8 1 4 5 1 1 1 3 1 1 1 3 1 
    3 1 3 1 1 1 1 3 1 3 1 1 1 1 1 1 1 1 1 3 2 1 3 1 1 1 1 1 1 1))

(define julia-rto-v
  #(#f 68 68 67 67 64 60 60 53 59 58 58 62 56 56 66 66 66 66 54 55 55 55 55 
    51 50 50 61 57 52 52 49 48 47 47 46 46 45 45 44 43 42 41 41 40 40 39 38 37
    36 35 34 33 33 33 33 33 33 30 63 65 32 32 29 28 31))

(define julia-pat-v
  #(((4 . 1) (5 . 2) (3 . 3) (28 . 4) (29 . 5) (6 . 6) (8 . 7) (30 . 8) 
    (10 . 9) (24 . 10) (31 . 11) (32 . 12) (65 . 13) (33 . 14) (34 . 15) 
    (35 . 16) (36 . 17) (37 . 18) (38 . 19) (39 . 20) (40 . 21) (41 . 22) 
    (42 . 23) (43 . 24) (44 . 25) (45 . 26) (46 . 27) (47 . 28) (57 . 29) 
    (48 . 30) (58 . 31) (49 . 32) (18 . 33) (19 . 34) (59 . 35) (52 . 36) 
    (53 . 37) (54 . 38) (55 . 39) (25 . 40) (66 . 41) (67 . 42) (68 . 43)) 
    ((14 . -64) (21 . -64) (15 . -64) (13 . -64) (12 . -64) (11 . -64) 
    (20 . -64) (22 . -64) (24 . -64) (10 . -64) (8 . -64) (3 . -64) (4 . -64) 
    (5 . -64) (6 . -64) (19 . -64) (18 . -64) (23 . -64) (7 . -64) (16 . -64) 
    (17 . -64) (27 . -64)) ((14 . -63) (21 . -63) (15 . -63) (13 . -63) 
    (12 . -63) (11 . -63) (20 . -63) (22 . -63) (24 . -63) (10 . -63) (8 . -63
    ) (3 . -63) (4 . -63) (5 . -63) (6 . -63) (19 . -63) (18 . -63) (23 . -63)
    (7 . -63) (16 . -63) (17 . -63) (27 . -63)) ((15 . -65) (21 . -65) 
    (14 . -65) (11 . -65) (12 . -65) (13 . -65) (20 . -65) (22 . -65) (18 . 
    -65) (19 . -65) (6 . -65) (5 . -65) (4 . -65) (3 . -65) (8 . -65) (10 . 
    -65) (24 . -65) (23 . -65) (7 . -65) (16 . -65) (17 . -65) (27 . -65)) 
    ((15 . -62) (21 . -62) (14 . -62) (11 . -62) (12 . -62) (13 . -62) 
    (20 . -62) (22 . -62) (18 . -62) (19 . -62) (6 . -62) (5 . -62) (4 . -62) 
    (3 . -62) (8 . -62) (10 . -62) (24 . -62) (23 . -62) (7 . -62) (16 . -62) 
    (17 . -62) (27 . -62)) ((15 . -61) (21 . -61) (14 . -61) (11 . -61) 
    (12 . -61) (13 . -61) (20 . -61) (22 . -61) (18 . -61) (19 . -61) (6 . -61
    ) (5 . -61) (4 . -61) (3 . -61) (8 . -61) (10 . -61) (24 . -61) (23 . -61)
    (7 . -61) (16 . -61) (17 . -61) (27 . -61)) ((15 . -60) (21 . -60) 
    (14 . -60) (11 . -60) (12 . -60) (13 . -60) (20 . -60) (22 . -60) (18 . 
    -60) (19 . -60) (6 . -60) (5 . -60) (4 . -60) (3 . -60) (8 . -60) (10 . 
    -60) (24 . -60) (23 . -60) (7 . -60) (16 . -60) (17 . -60) (27 . -60)) 
    ((4 . 1) (5 . 2) (3 . 3) (28 . 4) (29 . 5) (6 . 6) (8 . 7) (30 . 8) 
    (10 . 9) (24 . 10) (31 . 11) (32 . 12) (65 . 13) (33 . 14) (34 . 15) 
    (35 . 16) (36 . 17) (37 . 18) (38 . 19) (39 . 20) (40 . 21) (41 . 22) 
    (42 . 23) (43 . 24) (44 . 25) (45 . 26) (46 . 27) (47 . 28) (57 . 29) 
    (48 . 30) (58 . 31) (49 . 32) (18 . 33) (19 . 34) (59 . 35) (52 . 36) 
    (53 . 37) (54 . 38) (55 . 39) (66 . 62) (56 . 63) (62 . 64)) ((14 . -57) 
    (21 . -57) (15 . -57) (13 . -57) (12 . -57) (11 . -57) (20 . -57) (22 . 
    -57) (24 . -57) (10 . -57) (8 . -57) (3 . -57) (4 . -57) (5 . -57) 
    (6 . -57) (19 . -57) (18 . -57) (23 . -57) (7 . -57) (16 . -57) (17 . -57)
    (27 . -57)) ((9 . 61)) ((4 . 1) (5 . 2) (3 . 3) (28 . 4) (29 . 5) (6 . 6) 
    (8 . 7) (30 . 8) (10 . 9) (24 . 10) (31 . 11) (32 . 12) (65 . 13) (33 . 14
    ) (34 . 15) (35 . 16) (36 . 17) (37 . 18) (38 . 19) (39 . 20) (40 . 21) 
    (41 . 22) (42 . 23) (43 . 24) (44 . 25) (45 . 26) (46 . 27) (47 . 28) 
    (48 . 30) (49 . 49) (52 . 50) (61 . 60)) ((14 . -54) (21 . -54) (15 . -54)
    (13 . -54) (12 . -54) (11 . -54) (20 . -54) (22 . -54) (24 . -54) (10 . 
    -54) (8 . -54) (3 . -54) (4 . -54) (5 . -54) (6 . -54) (19 . -54) (18 . 
    -54) (23 . -54) (7 . -54) (16 . -54) (17 . -54) (27 . -54)) ((14 . -53) 
    (21 . -53) (15 . -53) (13 . -53) (12 . -53) (11 . -53) (20 . -53) (22 . 
    -53) (24 . -53) (10 . -53) (8 . -53) (3 . -53) (4 . -53) (5 . -53) 
    (6 . -53) (19 . -53) (18 . -53) (23 . -53) (7 . -53) (16 . -53) (17 . -53)
    (27 . -53)) ((14 . -52) (21 . -52) (15 . -52) (13 . -52) (12 . -52) 
    (11 . -52) (20 . -52) (22 . -52) (24 . -52) (10 . -52) (8 . -52) (3 . -52)
    (4 . -52) (5 . -52) (6 . -52) (19 . -52) (18 . -52) (23 . -52) (7 . -52) 
    (16 . -52) (17 . -52) (27 . -52)) ((15 . -51) (21 . -51) (14 . -51) 
    (11 . -51) (12 . -51) (13 . -51) (20 . -51) (22 . -51) (18 . -51) (19 . 
    -51) (6 . -51) (5 . -51) (4 . -51) (3 . -51) (8 . -51) (10 . -51) (24 . 
    -51) (23 . -51) (7 . -51) (16 . -51) (17 . -51) (27 . -51)) ((14 . -50) 
    (21 . -50) (15 . -50) (13 . -50) (12 . -50) (11 . -50) (20 . -50) (22 . 
    -50) (24 . -50) (10 . -50) (8 . -50) (3 . -50) (4 . -50) (5 . -50) 
    (6 . -50) (19 . -50) (18 . -50) (23 . -50) (7 . -50) (16 . -50) (17 . -50)
    (27 . -50)) ((15 . -49) (21 . -49) (14 . -49) (11 . -49) (12 . -49) 
    (13 . -49) (20 . -49) (22 . -49) (18 . -49) (19 . -49) (6 . -49) (5 . -49)
    (4 . -49) (3 . -49) (8 . -49) (10 . -49) (24 . -49) (23 . -49) (7 . -49) 
    (16 . -49) (17 . -49) (27 . -49)) ((14 . -48) (21 . -48) (15 . -48) 
    (13 . -48) (12 . -48) (11 . -48) (20 . -48) (22 . -48) (24 . -48) (10 . 
    -48) (8 . -48) (3 . -48) (4 . -48) (5 . -48) (6 . -48) (19 . -48) (18 . 
    -48) (23 . -48) (7 . -48) (16 . -48) (17 . -48) (27 . -48)) ((15 . -47) 
    (21 . -47) (14 . -47) (11 . -47) (12 . -47) (13 . -47) (20 . -47) (22 . 
    -47) (18 . -47) (19 . -47) (6 . -47) (5 . -47) (4 . -47) (3 . -47) 
    (8 . -47) (10 . -47) (24 . -47) (23 . -47) (7 . -47) (16 . -47) (17 . -47)
    (27 . -47)) ((14 . -46) (21 . -46) (15 . -46) (13 . -46) (12 . -46) 
    (11 . -46) (20 . -46) (22 . -46) (24 . -46) (10 . -46) (8 . -46) (3 . -46)
    (4 . -46) (5 . -46) (6 . -46) (19 . -46) (18 . -46) (23 . -46) (7 . -46) 
    (16 . -46) (17 . -46) (27 . -46)) ((15 . -44) (21 . -44) (14 . -44) 
    (11 . -44) (12 . -44) (13 . -44) (20 . -44) (22 . -44) (18 . -44) (19 . 
    -44) (6 . -44) (5 . -44) (4 . -44) (3 . -44) (8 . -44) (10 . -44) (24 . 
    -44) (23 . -44) (7 . -44) (16 . -44) (17 . -44) (27 . -44)) ((11 . 59) 
    (14 . -42) (21 . -42) (15 . -42) (13 . -42) (12 . -42) (20 . -42) (22 . 
    -42) (24 . -42) (10 . -42) (8 . -42) (3 . -42) (4 . -42) (5 . -42) 
    (6 . -42) (19 . -42) (18 . -42) (23 . -42) (7 . -42) (16 . -42) (17 . -42)
    (27 . -42)) ((12 . 58) (15 . -41) (21 . -41) (14 . -41) (13 . -41) 
    (20 . -41) (22 . -41) (18 . -41) (19 . -41) (6 . -41) (5 . -41) (4 . -41) 
    (3 . -41) (8 . -41) (10 . -41) (24 . -41) (23 . -41) (7 . -41) (16 . -41) 
    (17 . -41) (27 . -41)) ((14 . -40) (21 . -40) (15 . -40) (13 . -40) 
    (20 . -40) (22 . -40) (24 . -40) (10 . -40) (8 . -40) (3 . -40) (4 . -40) 
    (5 . -40) (6 . -40) (19 . -40) (18 . -40) (23 . -40) (7 . -40) (16 . -40) 
    (17 . -40) (27 . -40)) ((15 . -39) (21 . -39) (14 . -39) (13 . -39) 
    (20 . -39) (22 . -39) (18 . -39) (19 . -39) (6 . -39) (5 . -39) (4 . -39) 
    (3 . -39) (8 . -39) (10 . -39) (24 . -39) (23 . -39) (7 . -39) (16 . -39) 
    (17 . -39) (27 . -39)) ((14 . -37) (21 . -37) (15 . -37) (13 . -37) 
    (20 . -37) (22 . -37) (24 . -37) (10 . -37) (8 . -37) (3 . -37) (4 . -37) 
    (5 . -37) (6 . -37) (19 . -37) (18 . -37) (23 . -37) (7 . -37) (16 . -37) 
    (17 . -37) (27 . -37)) ((14 . 56) (13 . 57) (15 . -35) (21 . -35) (20 . 
    -35) (22 . -35) (18 . -35) (19 . -35) (6 . -35) (5 . -35) (4 . -35) 
    (3 . -35) (8 . -35) (10 . -35) (24 . -35) (23 . -35) (7 . -35) (16 . -35) 
    (17 . -35) (27 . -35)) ((15 . 55) (21 . -33) (20 . -33) (22 . -33) 
    (24 . -33) (10 . -33) (8 . -33) (3 . -33) (4 . -33) (5 . -33) (6 . -33) 
    (19 . -33) (18 . -33) (23 . -33) (7 . -33) (16 . -33) (17 . -33) (27 . -33
    )) ((21 . -32) (20 . -32) (22 . -32) (18 . -32) (19 . -32) (6 . -32) 
    (5 . -32) (4 . -32) (3 . -32) (8 . -32) (10 . -32) (24 . -32) (23 . -32) 
    (7 . -32) (16 . -32) (17 . -32) (27 . -32)) ((21 . -10) (20 . -10)) 
    ((21 . -31) (20 . -31) (22 . -31) (24 . -31) (10 . -31) (8 . -31) (3 . -31
    ) (4 . -31) (5 . -31) (6 . -31) (19 . -31) (18 . -31) (23 . -31) (7 . -31)
    (16 . -31) (17 . -31) (27 . -31)) ((20 . 54) (21 . -9)) ((21 . 53) 
    (20 . -28) (22 . -29) (18 . -29) (19 . -29) (6 . -29) (5 . -29) (4 . -29) 
    (3 . -29) (8 . -29) (10 . -29) (24 . -29) (16 . -29) (17 . -29) (7 . -29) 
    (27 . -29)) ((4 . 1) (5 . 2) (3 . 3) (28 . 4) (29 . 5) (6 . 6) (8 . 7) 
    (30 . 8) (10 . 9) (24 . 10) (31 . 11) (32 . 12) (65 . 13) (33 . 14) 
    (34 . 15) (35 . 16) (36 . 17) (37 . 18) (38 . 19) (39 . 20) (40 . 21) 
    (41 . 22) (42 . 23) (43 . 24) (44 . 25) (45 . 26) (46 . 27) (47 . 28) 
    (48 . 30) (49 . 49) (52 . 50) (61 . 52)) ((4 . 1) (5 . 2) (3 . 3) (28 . 4)
    (29 . 5) (6 . 6) (8 . 7) (30 . 8) (10 . 9) (24 . 10) (31 . 11) (32 . 12) 
    (65 . 13) (33 . 14) (34 . 15) (35 . 16) (36 . 17) (37 . 18) (38 . 19) 
    (39 . 20) (40 . 21) (41 . 22) (42 . 23) (43 . 24) (44 . 25) (45 . 26) 
    (46 . 27) (47 . 28) (48 . 30) (49 . 49) (52 . 50) (61 . 51)) ((21 . -8)) 
    ((22 . -18) (24 . -18) (10 . -18) (8 . -18) (3 . -18) (4 . -18) (5 . -18) 
    (6 . -18) (19 . -18) (18 . -18) (16 . -18) (17 . -18) (7 . -18) (27 . -18)
    ) ((21 . 48)) ((7 . 45) (63 . 47)) ((7 . 45) (63 . 46)) ((6 . 6) (65 . 44)
    ) ((27 . -2)) ((27 . -1)) ((27 . 0)) ((24 . 78)) ((18 . -59) (19 . -59) 
    (6 . -59) (5 . -59) (4 . -59) (3 . -59) (8 . -59) (10 . -59) (24 . -59) 
    (22 . -59) (16 . -59) (17 . -59) (7 . -59) (27 . -59)) ((22 . -15) 
    (24 . -15) (10 . -15) (8 . -15) (3 . -15) (4 . -15) (5 . -15) (6 . -15) 
    (19 . -15) (18 . -15) (16 . -15) (17 . -15) (7 . -15) (27 . -15)) (
    (22 . -16) (24 . -16) (10 . -16) (8 . -16) (3 . -16) (4 . -16) (5 . -16) 
    (6 . -16) (19 . -16) (18 . -16) (16 . -16) (17 . -16) (7 . -16) (27 . -16)
    ) ((4 . 1) (5 . 2) (3 . 3) (28 . 4) (29 . 5) (6 . 6) (8 . 7) (30 . 8) 
    (10 . 9) (24 . 10) (31 . 11) (32 . 12) (65 . 13) (33 . 14) (34 . 15) 
    (35 . 16) (36 . 17) (37 . 18) (38 . 19) (39 . 20) (40 . 21) (41 . 22) 
    (42 . 23) (43 . 24) (44 . 25) (45 . 26) (46 . 27) (47 . 28) (48 . 30) 
    (49 . 73) (57 . 77)) ((21 . 53) (23 . -29) (7 . -29) (22 . -29) (18 . -29)
    (19 . -29) (6 . -29) (5 . -29) (4 . -29) (3 . -29) (8 . -29) (10 . -29) 
    (24 . -29) (16 . -29) (17 . -29) (27 . -29)) ((23 . -27) (7 . -27)) 
    ((7 . -19)) ((7 . 45) (63 . 76)) ((4 . 1) (5 . 2) (3 . 3) (28 . 4) 
    (29 . 5) (6 . 6) (8 . 7) (30 . 8) (10 . 9) (24 . 10) (31 . 11) (32 . 12) 
    (65 . 13) (33 . 14) (34 . 15) (35 . 16) (36 . 17) (37 . 18) (38 . 19) 
    (39 . 20) (40 . 21) (41 . 22) (42 . 23) (43 . 24) (44 . 25) (45 . 26) 
    (46 . 27) (47 . 28) (48 . 30) (49 . 49) (52 . 75)) ((4 . 1) (5 . 2) 
    (3 . 3) (28 . 4) (29 . 5) (6 . 6) (8 . 7) (30 . 8) (10 . 9) (24 . 10) 
    (31 . 11) (32 . 12) (65 . 13) (33 . 14) (34 . 15) (35 . 16) (36 . 17) 
    (37 . 18) (38 . 19) (39 . 20) (40 . 21) (41 . 22) (42 . 23) (43 . 24) 
    (44 . 25) (45 . 26) (46 . 27) (47 . 28) (48 . 30) (49 . 73) (57 . 74)) 
    ((4 . 1) (5 . 2) (3 . 3) (28 . 4) (29 . 5) (6 . 6) (8 . 7) (30 . 8) 
    (10 . 9) (24 . 10) (31 . 11) (32 . 12) (65 . 13) (33 . 14) (34 . 15) 
    (35 . 16) (36 . 17) (37 . 18) (38 . 19) (39 . 20) (40 . 21) (41 . 22) 
    (42 . 23) (43 . 24) (44 . 25) (45 . 26) (46 . 27) (47 . 72)) ((4 . 1) 
    (5 . 2) (3 . 3) (28 . 4) (29 . 5) (6 . 6) (8 . 7) (30 . 8) (10 . 9) 
    (24 . 10) (31 . 11) (32 . 12) (65 . 13) (33 . 14) (34 . 15) (35 . 16) 
    (36 . 17) (37 . 18) (38 . 19) (39 . 20) (40 . 21) (41 . 22) (42 . 23) 
    (43 . 24) (44 . 25) (45 . 26) (46 . 71)) ((4 . 1) (5 . 2) (3 . 3) (28 . 4)
    (29 . 5) (6 . 6) (8 . 7) (30 . 8) (10 . 9) (24 . 10) (31 . 11) (32 . 12) 
    (65 . 13) (33 . 14) (34 . 15) (35 . 16) (36 . 17) (37 . 18) (38 . 19) 
    (39 . 20) (40 . 21) (41 . 22) (42 . 23) (43 . 24) (44 . 25) (45 . 70)) 
    ((4 . 1) (5 . 2) (3 . 3) (28 . 4) (29 . 5) (6 . 6) (8 . 7) (30 . 8) 
    (10 . 9) (24 . 10) (31 . 11) (32 . 12) (65 . 13) (33 . 14) (34 . 15) 
    (35 . 16) (36 . 17) (37 . 18) (38 . 19) (39 . 20) (40 . 69)) ((4 . 1) 
    (5 . 2) (3 . 3) (28 . 4) (29 . 5) (6 . 6) (8 . 7) (30 . 8) (10 . 9) 
    (24 . 10) (31 . 11) (32 . 12) (65 . 13) (33 . 14) (34 . 15) (35 . 16) 
    (36 . 17) (37 . 18) (38 . 19) (39 . 68)) ((23 . 67)) ((14 . -56) (21 . -56
    ) (15 . -56) (13 . -56) (12 . -56) (11 . -56) (20 . -56) (22 . -56) 
    (24 . -56) (10 . -56) (8 . -56) (3 . -56) (4 . -56) (5 . -56) (6 . -56) 
    (19 . -56) (18 . -56) (23 . -56) (7 . -56) (16 . -56) (17 . -56) (27 . -56
    )) ((22 . -13) (18 . -13) (19 . -13) (6 . -13) (5 . -13) (4 . -13) 
    (3 . -13) (8 . -13) (10 . -13) (24 . -13) (16 . -13) (17 . -13) (7 . -13))
    ((4 . 1) (5 . 2) (3 . 3) (28 . 4) (29 . 5) (6 . 6) (8 . 7) (30 . 8) 
    (10 . 9) (24 . 10) (31 . 11) (32 . 12) (65 . 13) (33 . 14) (34 . 15) 
    (35 . 16) (36 . 17) (37 . 18) (38 . 19) (39 . 20) (40 . 21) (41 . 22) 
    (42 . 23) (43 . 24) (44 . 25) (45 . 26) (46 . 27) (47 . 28) (57 . 29) 
    (48 . 30) (58 . 31) (49 . 32) (18 . 33) (19 . 34) (59 . 35) (52 . 36) 
    (53 . 37) (54 . 38) (55 . 39) (66 . 66) (22 . -12) (16 . -12) (17 . -12) 
    (7 . -12)) ((22 . 65)) ((15 . -58) (21 . -58) (14 . -58) (11 . -58) 
    (12 . -58) (13 . -58) (20 . -58) (22 . -58) (18 . -58) (19 . -58) (6 . -58
    ) (5 . -58) (4 . -58) (3 . -58) (8 . -58) (10 . -58) (24 . -58) (23 . -58)
    (7 . -58) (16 . -58) (17 . -58) (27 . -58)) ((22 . -14) (18 . -14) 
    (19 . -14) (6 . -14) (5 . -14) (4 . -14) (3 . -14) (8 . -14) (10 . -14) 
    (24 . -14) (16 . -14) (17 . -14) (7 . -14)) ((14 . -55) (21 . -55) 
    (15 . -55) (13 . -55) (12 . -55) (11 . -55) (20 . -55) (22 . -55) (24 . 
    -55) (10 . -55) (8 . -55) (3 . -55) (4 . -55) (5 . -55) (6 . -55) (19 . 
    -55) (18 . -55) (23 . -55) (7 . -55) (16 . -55) (17 . -55) (27 . -55)) 
    ((15 . -45) (21 . -45) (14 . -45) (11 . -45) (12 . -45) (13 . -45) 
    (20 . -45) (22 . -45) (18 . -45) (19 . -45) (6 . -45) (5 . -45) (4 . -45) 
    (3 . -45) (8 . -45) (10 . -45) (24 . -45) (23 . -45) (7 . -45) (16 . -45) 
    (17 . -45) (27 . -45)) ((11 . 59) (14 . -43) (21 . -43) (15 . -43) 
    (13 . -43) (12 . -43) (20 . -43) (22 . -43) (24 . -43) (10 . -43) (8 . -43
    ) (3 . -43) (4 . -43) (5 . -43) (6 . -43) (19 . -43) (18 . -43) (23 . -43)
    (7 . -43) (16 . -43) (17 . -43) (27 . -43)) ((13 . 57) (14 . -38) (21 . 
    -38) (15 . -38) (20 . -38) (22 . -38) (24 . -38) (10 . -38) (8 . -38) 
    (3 . -38) (4 . -38) (5 . -38) (6 . -38) (19 . -38) (18 . -38) (23 . -38) 
    (7 . -38) (16 . -38) (17 . -38) (27 . -38)) ((15 . -36) (21 . -36) 
    (20 . -36) (22 . -36) (18 . -36) (19 . -36) (6 . -36) (5 . -36) (4 . -36) 
    (3 . -36) (8 . -36) (10 . -36) (24 . -36) (23 . -36) (7 . -36) (16 . -36) 
    (17 . -36) (27 . -36)) ((21 . -34) (20 . -34) (22 . -34) (24 . -34) 
    (10 . -34) (8 . -34) (3 . -34) (4 . -34) (5 . -34) (6 . -34) (19 . -34) 
    (18 . -34) (23 . -34) (7 . -34) (16 . -34) (17 . -34) (27 . -34)) (
    (22 . -28) (24 . -28) (10 . -28) (8 . -28) (3 . -28) (4 . -28) (5 . -28) 
    (6 . -28) (19 . -28) (18 . -28) (16 . -28) (17 . -28) (7 . -28) (27 . -28)
    (21 . -28) (20 . -28)) ((21 . -11) (20 . -11)) ((22 . -30) (18 . -30) 
    (19 . -30) (6 . -30) (5 . -30) (4 . -30) (3 . -30) (8 . -30) (10 . -30) 
    (24 . -30) (16 . -30) (17 . -30) (7 . -30) (27 . -30) (23 . -30)) (
    (4 . 1) (5 . 2) (3 . 3) (28 . 4) (29 . 5) (6 . 6) (8 . 7) (30 . 8) 
    (10 . 9) (24 . 10) (31 . 11) (32 . 12) (65 . 13) (33 . 14) (34 . 15) 
    (35 . 16) (36 . 17) (37 . 18) (38 . 19) (39 . 20) (40 . 21) (41 . 22) 
    (42 . 23) (43 . 24) (44 . 25) (45 . 26) (46 . 27) (47 . 28) (57 . 29) 
    (48 . 30) (58 . 31) (49 . 32) (18 . 33) (19 . 34) (59 . 35) (52 . 36) 
    (53 . 37) (54 . 38) (55 . 39) (66 . 62) (56 . 63) (62 . 82)) ((22 . -17) 
    (24 . -17) (10 . -17) (8 . -17) (3 . -17) (4 . -17) (5 . -17) (6 . -17) 
    (19 . -17) (18 . -17) (16 . -17) (17 . -17) (7 . -17) (27 . -17)) (
    (6 . 6) (65 . 79) (60 . 80) (64 . 81)) ((23 . -6) (20 . -6)) ((20 . 89) 
    (23 . -5)) ((23 . 88)) ((16 . 83) (50 . 84) (51 . 85) (17 . 86) (22 . 87))
    ((4 . 1) (5 . 2) (3 . 3) (28 . 4) (29 . 5) (6 . 6) (8 . 7) (30 . 8) 
    (10 . 9) (24 . 10) (31 . 11) (32 . 12) (65 . 13) (33 . 14) (34 . 15) 
    (35 . 16) (36 . 17) (37 . 18) (38 . 19) (39 . 20) (40 . 21) (41 . 22) 
    (42 . 23) (43 . 24) (44 . 25) (45 . 26) (46 . 27) (47 . 28) (48 . 30) 
    (49 . 49) (52 . 50) (61 . 97)) ((16 . 96) (22 . -24) (17 . -24)) ((22 . 94
    ) (17 . 95)) ((4 . 1) (5 . 2) (3 . 3) (28 . 4) (29 . 5) (6 . 6) (8 . 7) 
    (30 . 8) (10 . 9) (24 . 10) (31 . 11) (32 . 12) (65 . 13) (33 . 14) 
    (34 . 15) (35 . 16) (36 . 17) (37 . 18) (38 . 19) (39 . 20) (40 . 21) 
    (41 . 22) (42 . 23) (43 . 24) (44 . 25) (45 . 26) (46 . 27) (47 . 28) 
    (57 . 29) (48 . 30) (58 . 31) (49 . 32) (18 . 33) (19 . 34) (59 . 35) 
    (52 . 36) (53 . 37) (54 . 38) (55 . 39) (66 . 62) (56 . 63) (62 . 93)) 
    ((7 . -20)) ((7 . 45) (63 . 91) (21 . 92)) ((6 . 6) (65 . 90)) ((23 . -7) 
    (20 . -7)) ((4 . 1) (5 . 2) (3 . 3) (28 . 4) (29 . 5) (6 . 6) (8 . 7) 
    (30 . 8) (10 . 9) (24 . 10) (31 . 11) (32 . 12) (65 . 13) (33 . 14) 
    (34 . 15) (35 . 16) (36 . 17) (37 . 18) (38 . 19) (39 . 20) (40 . 21) 
    (41 . 22) (42 . 23) (43 . 24) (44 . 25) (45 . 26) (46 . 27) (47 . 28) 
    (57 . 29) (48 . 30) (58 . 31) (49 . 32) (18 . 33) (19 . 34) (59 . 35) 
    (52 . 36) (53 . 37) (54 . 38) (55 . 39) (66 . 62) (56 . 63) (62 . 103)) 
    ((4 . 1) (5 . 2) (3 . 3) (28 . 4) (29 . 5) (6 . 6) (8 . 7) (30 . 8) 
    (10 . 9) (24 . 10) (31 . 11) (32 . 12) (65 . 13) (33 . 14) (34 . 15) 
    (35 . 16) (36 . 17) (37 . 18) (38 . 19) (39 . 20) (40 . 21) (41 . 22) 
    (42 . 23) (43 . 24) (44 . 25) (45 . 26) (46 . 27) (47 . 28) (48 . 30) 
    (49 . 49) (52 . 50) (61 . 102)) ((22 . 101)) ((7 . -22)) ((4 . 1) (5 . 2) 
    (3 . 3) (28 . 4) (29 . 5) (6 . 6) (8 . 7) (30 . 8) (10 . 9) (24 . 10) 
    (31 . 11) (32 . 12) (65 . 13) (33 . 14) (34 . 15) (35 . 16) (36 . 17) 
    (37 . 18) (38 . 19) (39 . 20) (40 . 21) (41 . 22) (42 . 23) (43 . 24) 
    (44 . 25) (45 . 26) (46 . 27) (47 . 28) (57 . 29) (48 . 30) (58 . 31) 
    (49 . 32) (18 . 33) (19 . 34) (59 . 35) (52 . 36) (53 . 37) (54 . 38) 
    (55 . 39) (66 . 62) (56 . 63) (62 . 100)) ((4 . 1) (5 . 2) (3 . 3) 
    (28 . 4) (29 . 5) (6 . 6) (8 . 7) (30 . 8) (10 . 9) (24 . 10) (31 . 11) 
    (32 . 12) (65 . 13) (33 . 14) (34 . 15) (35 . 16) (36 . 17) (37 . 18) 
    (38 . 19) (39 . 20) (40 . 21) (41 . 22) (42 . 23) (43 . 24) (44 . 25) 
    (45 . 26) (46 . 27) (47 . 28) (48 . 30) (49 . 49) (52 . 50) (61 . 99)) 
    ((7 . 45) (63 . 98)) ((4 . 1) (5 . 2) (3 . 3) (28 . 4) (29 . 5) (6 . 6) 
    (8 . 7) (30 . 8) (10 . 9) (24 . 10) (31 . 11) (32 . 12) (65 . 13) (33 . 14
    ) (34 . 15) (35 . 16) (36 . 17) (37 . 18) (38 . 19) (39 . 20) (40 . 21) 
    (41 . 22) (42 . 23) (43 . 24) (44 . 25) (45 . 26) (46 . 27) (47 . 28) 
    (57 . 29) (48 . 30) (58 . 31) (49 . 32) (18 . 33) (19 . 34) (59 . 35) 
    (52 . 36) (53 . 37) (54 . 38) (55 . 39) (66 . 62) (56 . 63) (62 . 108)) 
    ((7 . 45) (63 . 107)) ((22 . 106)) ((7 . -21)) ((7 . 45) (63 . 105)) 
    ((7 . 45) (63 . 104)) ((22 . 110)) ((27 . -4)) ((7 . -23)) ((4 . 1) 
    (5 . 2) (3 . 3) (28 . 4) (29 . 5) (6 . 6) (8 . 7) (30 . 8) (10 . 9) 
    (24 . 10) (31 . 11) (32 . 12) (65 . 13) (33 . 14) (34 . 15) (35 . 16) 
    (36 . 17) (37 . 18) (38 . 19) (39 . 20) (40 . 21) (41 . 22) (42 . 23) 
    (43 . 24) (44 . 25) (45 . 26) (46 . 27) (47 . 28) (57 . 29) (48 . 30) 
    (58 . 31) (49 . 32) (18 . 33) (19 . 34) (59 . 35) (52 . 36) (53 . 37) 
    (54 . 38) (55 . 39) (66 . 62) (56 . 63) (62 . 109)) ((22 . -25) (16 . -25)
    (17 . -25)) ((22 . -26) (16 . -26) (17 . -26)) ((7 . 45) (63 . 111)) 
    ((27 . -3))))

(define julia-tables
  (list
   (cons 'mtab julia-mtab)
   (cons 'ntab julia-ntab)
   (cons 'len-v julia-len-v)
   (cons 'rto-v julia-rto-v)
   (cons 'pat-v julia-pat-v)
   ))

;;; end tables
