/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICS;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PAINTSTRUCT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCROLLINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;

public class ExpandBar
extends Composite {
    ExpandItem[] items;
    int itemCount;
    ExpandItem focusItem;
    int spacing = 4;
    int yCurrentScroll;
    long hFont;

    public ExpandBar(Composite parent, int style) {
        super(parent, ExpandBar.checkStyle(style));
    }

    public void addExpandListener(ExpandListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    @Override
    long callWindowProc(long hwnd, int msg, long wParam, long lParam) {
        if (this.handle == 0L) {
            return 0L;
        }
        return OS.DefWindowProc(hwnd, msg, wParam, lParam);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int style) {
        return (style &= 0xFFFFFEFF) | 0x40000;
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed2) {
        int height = 0;
        int width = 0;
        if ((wHint == -1 || hHint == -1) && this.itemCount > 0) {
            long hDC = OS.GetDC(this.handle);
            long hTheme = 0L;
            if (this.isAppThemed()) {
                hTheme = this.display.hExplorerBarTheme();
            }
            long hCurrentFont = 0L;
            long oldFont = 0L;
            if (hTheme == 0L) {
                if (this.hFont != 0L) {
                    hCurrentFont = this.hFont;
                } else {
                    NONCLIENTMETRICS info = new NONCLIENTMETRICS();
                    info.cbSize = NONCLIENTMETRICS.sizeof;
                    if (OS.SystemParametersInfo(41, 0, info, 0)) {
                        LOGFONT logFont = info.lfCaptionFont;
                        hCurrentFont = OS.CreateFontIndirect(logFont);
                    }
                }
                if (hCurrentFont != 0L) {
                    oldFont = OS.SelectObject(hDC, hCurrentFont);
                }
            }
            height += this.spacing;
            int i2 = 0;
            while (i2 < this.itemCount) {
                ExpandItem item2 = this.items[i2];
                height += item2.getHeaderHeightInPixels();
                if (item2.expanded) {
                    height += item2.height;
                }
                height += this.spacing;
                width = Math.max(width, item2.getPreferredWidth(hTheme, hDC));
                ++i2;
            }
            if (hCurrentFont != 0L) {
                OS.SelectObject(hDC, oldFont);
                if (hCurrentFont != this.hFont) {
                    OS.DeleteObject(hCurrentFont);
                }
            }
            OS.ReleaseDC(this.handle, hDC);
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        Rectangle trim = this.computeTrimInPixels(0, 0, width, height);
        return new Point(trim.width, trim.height);
    }

    @Override
    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFFFFD;
        this.state |= 0x2000;
    }

    void createItem(ExpandItem item2, int style, int index) {
        if (index < 0 || index > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            ExpandItem[] newItems = new ExpandItem[this.itemCount + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount - index);
        this.items[index] = item2;
        ++this.itemCount;
        if (this.focusItem == null) {
            this.focusItem = item2;
        }
        RECT rect = new RECT();
        OS.GetWindowRect(this.handle, rect);
        item2.width = Math.max(0, rect.right - rect.left - this.spacing * 2);
        this.layoutItems(index, true);
    }

    @Override
    void createWidget() {
        super.createWidget();
        this.items = new ExpandItem[4];
        if (!this.isAppThemed()) {
            this.backgroundMode = 1;
        }
    }

    @Override
    int defaultBackground() {
        if (!this.isAppThemed()) {
            return OS.GetSysColor(5);
        }
        return super.defaultBackground();
    }

    void destroyItem(ExpandItem item2) {
        int index = 0;
        while (index < this.itemCount) {
            if (this.items[index] == item2) break;
            ++index;
        }
        if (index == this.itemCount) {
            return;
        }
        if (item2 == this.focusItem) {
            int focusIndex;
            int n2 = focusIndex = index > 0 ? index - 1 : 1;
            if (focusIndex < this.itemCount) {
                this.focusItem = this.items[focusIndex];
                this.focusItem.redraw(true);
            } else {
                this.focusItem = null;
            }
        }
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
        item2.redraw(true);
        this.layoutItems(index, true);
    }

    @Override
    void drawThemeBackground(long hDC, long hwnd, RECT rect) {
        RECT rect2 = new RECT();
        OS.GetClientRect(this.handle, rect2);
        OS.MapWindowPoints(this.handle, hwnd, rect2, 2);
        OS.DrawThemeBackground(this.display.hExplorerBarTheme(), hDC, 5, 0, rect2, null);
    }

    void drawWidget(GC gc, RECT clipRect) {
        long hTheme = 0L;
        if (this.isAppThemed()) {
            hTheme = this.display.hExplorerBarTheme();
        }
        if (hTheme != 0L) {
            RECT rect = new RECT();
            OS.GetClientRect(this.handle, rect);
            OS.DrawThemeBackground(hTheme, gc.handle, 1, 0, rect, clipRect);
        } else {
            this.drawBackground(gc.handle);
        }
        boolean drawFocus = false;
        if (this.handle == OS.GetFocus()) {
            int uiState = (int)OS.SendMessage(this.handle, 297, 0L, 0L);
            drawFocus = (uiState & 1) == 0;
        }
        long hCurrentFont = 0L;
        long oldFont = 0L;
        if (hTheme == 0L) {
            if (this.hFont != 0L) {
                hCurrentFont = this.hFont;
            } else {
                NONCLIENTMETRICS info = new NONCLIENTMETRICS();
                info.cbSize = NONCLIENTMETRICS.sizeof;
                if (OS.SystemParametersInfo(41, 0, info, 0)) {
                    LOGFONT logFont = info.lfCaptionFont;
                    hCurrentFont = OS.CreateFontIndirect(logFont);
                }
            }
            if (hCurrentFont != 0L) {
                oldFont = OS.SelectObject(gc.handle, hCurrentFont);
            }
            if (this.foreground != -1) {
                OS.SetTextColor(gc.handle, this.foreground);
            }
        }
        int i2 = 0;
        while (i2 < this.itemCount) {
            ExpandItem item2;
            item2.drawItem(gc, hTheme, clipRect, (item2 = this.items[i2]) == this.focusItem && drawFocus);
            ++i2;
        }
        if (hCurrentFont != 0L) {
            OS.SelectObject(gc.handle, oldFont);
            if (hCurrentFont != this.hFont) {
                OS.DeleteObject(hCurrentFont);
            }
        }
    }

    @Override
    Control findBackgroundControl() {
        Control control = super.findBackgroundControl();
        if (!this.isAppThemed() && control == null) {
            control = this;
        }
        return control;
    }

    @Override
    Control findThemeControl() {
        return this.isAppThemed() ? this : super.findThemeControl();
    }

    int getBandHeight() {
        long hDC = OS.GetDC(this.handle);
        long oldHFont = OS.SelectObject(hDC, this.hFont == 0L ? this.defaultFont() : this.hFont);
        TEXTMETRIC lptm = new TEXTMETRIC();
        OS.GetTextMetrics(hDC, lptm);
        OS.SelectObject(hDC, oldHFont);
        OS.ReleaseDC(this.handle, hDC);
        return Math.max(24, lptm.tmHeight + 4);
    }

    public ExpandItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        return this.items[index];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public ExpandItem[] getItems() {
        this.checkWidget();
        ExpandItem[] result2 = new ExpandItem[this.itemCount];
        System.arraycopy(this.items, 0, result2, 0, this.itemCount);
        return result2;
    }

    public int getSpacing() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getSpacingInPixels());
    }

    int getSpacingInPixels() {
        return this.spacing;
    }

    public int indexOf(ExpandItem item2) {
        this.checkWidget();
        if (item2 == null) {
            this.error(4);
        }
        int i2 = 0;
        while (i2 < this.itemCount) {
            if (this.items[i2] == item2) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    boolean isAppThemed() {
        if (this.background != -1) {
            return false;
        }
        if (this.foreground != -1) {
            return false;
        }
        if (this.hFont != 0L) {
            return false;
        }
        return OS.IsAppThemed();
    }

    void layoutItems(int index, boolean setScrollbar) {
        if (index < this.itemCount) {
            ExpandItem item2;
            int y2 = this.spacing - this.yCurrentScroll;
            int i2 = 0;
            while (i2 < index) {
                item2 = this.items[i2];
                if (item2.expanded) {
                    y2 += item2.height;
                }
                y2 += item2.getHeaderHeightInPixels() + this.spacing;
                ++i2;
            }
            i2 = index;
            while (i2 < this.itemCount) {
                item2 = this.items[i2];
                item2.setBoundsInPixels(this.spacing, y2, 0, 0, true, false);
                if (item2.expanded) {
                    y2 += item2.height;
                }
                y2 += item2.getHeaderHeightInPixels() + this.spacing;
                ++i2;
            }
        }
        if (setScrollbar) {
            this.setScrollbar();
        }
    }

    @Override
    void releaseChildren(boolean destroy) {
        if (this.items != null) {
            int i2 = 0;
            while (i2 < this.items.length) {
                ExpandItem item2 = this.items[i2];
                if (item2 != null && !item2.isDisposed()) {
                    item2.release(false);
                }
                ++i2;
            }
            this.items = null;
        }
        this.focusItem = null;
        super.releaseChildren(destroy);
    }

    public void removeExpandListener(ExpandListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, listener2);
        this.eventTable.unhook(18, listener2);
    }

    @Override
    void reskinChildren(int flags) {
        if (this.items != null) {
            int i2 = 0;
            while (i2 < this.items.length) {
                ExpandItem item2 = this.items[i2];
                if (item2 != null) {
                    item2.reskin(flags);
                }
                ++i2;
            }
        }
        super.reskinChildren(flags);
    }

    @Override
    void setBackgroundPixel(int pixel) {
        super.setBackgroundPixel(pixel);
        int flags = 1157;
        OS.RedrawWindow(this.handle, null, 0L, flags);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.hFont = font != null ? font.handle : 0L;
        this.layoutItems(0, true);
    }

    @Override
    void setForegroundPixel(int pixel) {
        super.setForegroundPixel(pixel);
        int flags = 1157;
        OS.RedrawWindow(this.handle, null, 0L, flags);
    }

    void setScrollbar() {
        if (this.itemCount == 0) {
            return;
        }
        if ((this.style & 0x200) == 0) {
            return;
        }
        RECT rect = new RECT();
        OS.GetClientRect(this.handle, rect);
        int height = rect.bottom - rect.top;
        ExpandItem item2 = this.items[this.itemCount - 1];
        int maxHeight = item2.y + this.getBandHeight() + this.spacing;
        if (item2.expanded) {
            maxHeight += item2.height;
        }
        if (this.yCurrentScroll > 0 && height > maxHeight) {
            this.yCurrentScroll = Math.max(0, this.yCurrentScroll + maxHeight - height);
            this.layoutItems(0, false);
        }
        SCROLLINFO info = new SCROLLINFO();
        info.cbSize = SCROLLINFO.sizeof;
        info.fMask = 7;
        info.nMin = 0;
        info.nMax = maxHeight += this.yCurrentScroll;
        info.nPage = height;
        info.nPos = Math.min(this.yCurrentScroll, info.nMax);
        if (info.nPage != 0) {
            ++info.nPage;
        }
        OS.SetScrollInfo(this.handle, 1, info, true);
    }

    public void setSpacing(int spacing) {
        this.checkWidget();
        this.setSpacingInPixels(DPIUtil.autoScaleUp(spacing));
    }

    void setSpacingInPixels(int spacing) {
        if (spacing < 0) {
            return;
        }
        if (spacing == this.spacing) {
            return;
        }
        this.spacing = spacing;
        RECT rect = new RECT();
        OS.GetClientRect(this.handle, rect);
        int width = Math.max(0, rect.right - rect.left - spacing * 2);
        int i2 = 0;
        while (i2 < this.itemCount) {
            ExpandItem item2 = this.items[i2];
            if (item2.width != width) {
                item2.setBoundsInPixels(0, 0, width, item2.height, false, true);
            }
            ++i2;
        }
        this.layoutItems(0, true);
        OS.InvalidateRect(this.handle, null, true);
    }

    @Override
    boolean updateTextDirection(int textDirection) {
        if (super.updateTextDirection(textDirection)) {
            int i2 = 0;
            int n2 = this.items.length;
            while (i2 < n2) {
                if (this.items[i2] != null) {
                    this.items[i2].updateTextDirection(textDirection == 0x6000000 ? 0x6000000 : this.style & Integer.MIN_VALUE);
                }
                ++i2;
            }
            return true;
        }
        return false;
    }

    void showItem(ExpandItem item2) {
        Control control = item2.control;
        if (control != null && !control.isDisposed()) {
            control.setVisible(item2.expanded);
        }
        item2.redraw(true);
        int index = this.indexOf(item2);
        this.layoutItems(index + 1, true);
    }

    void showFocus(boolean up) {
        RECT rect = new RECT();
        OS.GetClientRect(this.handle, rect);
        int height = rect.bottom - rect.top;
        int updateY = 0;
        if (up) {
            if (this.focusItem.y < 0) {
                updateY = Math.min(this.yCurrentScroll, -this.focusItem.y);
            }
        } else {
            int itemHeight = this.focusItem.y + this.getBandHeight();
            if (this.focusItem.expanded && height >= this.getBandHeight() + this.focusItem.height) {
                itemHeight += this.focusItem.height;
            }
            if (itemHeight > height) {
                updateY = height - itemHeight;
            }
        }
        if (updateY != 0) {
            this.yCurrentScroll = Math.max(0, this.yCurrentScroll - updateY);
            if ((this.style & 0x200) != 0) {
                SCROLLINFO info = new SCROLLINFO();
                info.cbSize = SCROLLINFO.sizeof;
                info.fMask = 4;
                info.nPos = this.yCurrentScroll;
                OS.SetScrollInfo(this.handle, 1, info, true);
            }
            OS.ScrollWindowEx(this.handle, 0, updateY, null, null, 0L, null, 3);
            int i2 = 0;
            while (i2 < this.itemCount) {
                this.items[i2].y += updateY;
                ++i2;
            }
        }
    }

    @Override
    TCHAR windowClass() {
        return this.display.windowClass;
    }

    @Override
    long windowProc() {
        return this.display.windowProc;
    }

    @Override
    LRESULT WM_KEYDOWN(long wParam, long lParam) {
        LRESULT result2 = super.WM_KEYDOWN(wParam, lParam);
        if (result2 != null) {
            return result2;
        }
        if (this.focusItem == null) {
            return result2;
        }
        switch ((int)wParam) {
            case 13: 
            case 32: {
                Event event = new Event();
                event.item = this.focusItem;
                this.sendEvent(this.focusItem.expanded ? 18 : 17, event);
                this.focusItem.expanded = !this.focusItem.expanded;
                this.showItem(this.focusItem);
                return LRESULT.ZERO;
            }
            case 38: {
                int focusIndex = this.indexOf(this.focusItem);
                if (focusIndex <= 0) break;
                this.focusItem.redraw(true);
                this.focusItem = this.items[focusIndex - 1];
                this.focusItem.redraw(true);
                this.showFocus(true);
                return LRESULT.ZERO;
            }
            case 40: {
                int focusIndex = this.indexOf(this.focusItem);
                if (focusIndex >= this.itemCount - 1) break;
                this.focusItem.redraw(true);
                this.focusItem = this.items[focusIndex + 1];
                this.focusItem.redraw(true);
                this.showFocus(false);
                return LRESULT.ZERO;
            }
        }
        return result2;
    }

    @Override
    LRESULT WM_KILLFOCUS(long wParam, long lParam) {
        LRESULT result2 = super.WM_KILLFOCUS(wParam, lParam);
        if (this.focusItem != null) {
            this.focusItem.redraw(true);
        }
        return result2;
    }

    @Override
    LRESULT WM_LBUTTONDOWN(long wParam, long lParam) {
        LRESULT result2 = super.WM_LBUTTONDOWN(wParam, lParam);
        if (result2 == LRESULT.ZERO) {
            return result2;
        }
        int x2 = OS.GET_X_LPARAM(lParam);
        int y2 = OS.GET_Y_LPARAM(lParam);
        int i2 = 0;
        while (i2 < this.itemCount) {
            ExpandItem item2 = this.items[i2];
            boolean hover = item2.isHover(x2, y2);
            if (hover && this.focusItem != item2) {
                this.focusItem.redraw(true);
                this.focusItem = item2;
                this.focusItem.redraw(true);
                this.forceFocus();
                break;
            }
            ++i2;
        }
        return result2;
    }

    @Override
    LRESULT WM_LBUTTONUP(long wParam, long lParam) {
        int y2;
        LRESULT result2 = super.WM_LBUTTONUP(wParam, lParam);
        if (result2 == LRESULT.ZERO) {
            return result2;
        }
        if (this.focusItem == null) {
            return result2;
        }
        int x2 = OS.GET_X_LPARAM(lParam);
        boolean hover = this.focusItem.isHover(x2, y2 = OS.GET_Y_LPARAM(lParam));
        if (hover) {
            Event event = new Event();
            event.item = this.focusItem;
            this.sendEvent(this.focusItem.expanded ? 18 : 17, event);
            this.focusItem.expanded = !this.focusItem.expanded;
            this.showItem(this.focusItem);
        }
        return result2;
    }

    @Override
    LRESULT WM_MOUSELEAVE(long wParam, long lParam) {
        LRESULT result2 = super.WM_MOUSELEAVE(wParam, lParam);
        if (result2 != null) {
            return result2;
        }
        int i2 = 0;
        while (i2 < this.itemCount) {
            ExpandItem item2 = this.items[i2];
            if (item2.hover) {
                item2.hover = false;
                item2.redraw(false);
                break;
            }
            ++i2;
        }
        return result2;
    }

    @Override
    LRESULT WM_MOUSEMOVE(long wParam, long lParam) {
        LRESULT result2 = super.WM_MOUSEMOVE(wParam, lParam);
        if (result2 == LRESULT.ZERO) {
            return result2;
        }
        int x2 = OS.GET_X_LPARAM(lParam);
        int y2 = OS.GET_Y_LPARAM(lParam);
        int i2 = 0;
        while (i2 < this.itemCount) {
            ExpandItem item2 = this.items[i2];
            boolean hover = item2.isHover(x2, y2);
            if (item2.hover != hover) {
                item2.hover = hover;
                item2.redraw(false);
            }
            ++i2;
        }
        return result2;
    }

    @Override
    LRESULT WM_MOUSEWHEEL(long wParam, long lParam) {
        return this.wmScrollWheel(true, wParam, lParam);
    }

    @Override
    LRESULT WM_PAINT(long wParam, long lParam) {
        if ((this.state & 0x1000) != 0) {
            return LRESULT.ZERO;
        }
        PAINTSTRUCT ps = new PAINTSTRUCT();
        GCData data2 = new GCData();
        data2.ps = ps;
        data2.hwnd = this.handle;
        GC gc = this.new_GC(data2);
        if (gc != null) {
            int width = ps.right - ps.left;
            int height = ps.bottom - ps.top;
            if (width != 0 && height != 0) {
                RECT rect = new RECT();
                OS.SetRect(rect, ps.left, ps.top, ps.right, ps.bottom);
                this.drawWidget(gc, rect);
                if (this.hooks(9) || this.filters(9)) {
                    Event event = new Event();
                    event.gc = gc;
                    event.setBoundsInPixels(new Rectangle(rect.left, rect.top, width, height));
                    this.sendEvent(9, event);
                    event.gc = null;
                }
            }
            gc.dispose();
        }
        return LRESULT.ZERO;
    }

    @Override
    LRESULT WM_PRINTCLIENT(long wParam, long lParam) {
        LRESULT result2 = super.WM_PRINTCLIENT(wParam, lParam);
        RECT rect = new RECT();
        OS.GetClientRect(this.handle, rect);
        GCData data2 = new GCData();
        data2.device = this.display;
        data2.foreground = this.getForegroundPixel();
        GC gc = GC.win32_new(wParam, data2);
        this.drawWidget(gc, rect);
        gc.dispose();
        return result2;
    }

    @Override
    LRESULT WM_SETCURSOR(long wParam, long lParam) {
        LRESULT result2 = super.WM_SETCURSOR(wParam, lParam);
        if (result2 != null) {
            return result2;
        }
        short hitTest = (short)OS.LOWORD(lParam);
        if (hitTest == 1) {
            int i2 = 0;
            while (i2 < this.itemCount) {
                ExpandItem item2 = this.items[i2];
                if (item2.hover) {
                    long hCursor = OS.LoadCursor(0L, 32649L);
                    OS.SetCursor(hCursor);
                    return LRESULT.ONE;
                }
                ++i2;
            }
        }
        return result2;
    }

    @Override
    LRESULT WM_SETFOCUS(long wParam, long lParam) {
        LRESULT result2 = super.WM_SETFOCUS(wParam, lParam);
        if (this.focusItem != null) {
            this.focusItem.redraw(true);
        }
        return result2;
    }

    @Override
    LRESULT WM_SIZE(long wParam, long lParam) {
        LRESULT result2 = super.WM_SIZE(wParam, lParam);
        RECT rect = new RECT();
        OS.GetClientRect(this.handle, rect);
        int width = Math.max(0, rect.right - rect.left - this.spacing * 2);
        int i2 = 0;
        while (i2 < this.itemCount) {
            ExpandItem item2 = this.items[i2];
            if (item2.width != width) {
                item2.setBoundsInPixels(0, 0, width, item2.height, false, true);
            }
            ++i2;
        }
        this.setScrollbar();
        OS.InvalidateRect(this.handle, null, true);
        return result2;
    }

    @Override
    LRESULT wmScroll(ScrollBar bar, boolean update, long hwnd, int msg, long wParam, long lParam) {
        LRESULT result2 = super.wmScroll(bar, true, hwnd, msg, wParam, lParam);
        SCROLLINFO info = new SCROLLINFO();
        info.cbSize = SCROLLINFO.sizeof;
        info.fMask = 4;
        OS.GetScrollInfo(this.handle, 1, info);
        int updateY = this.yCurrentScroll - info.nPos;
        OS.ScrollWindowEx(this.handle, 0, updateY, null, null, 0L, null, 3);
        this.yCurrentScroll = info.nPos;
        if (updateY != 0) {
            int i2 = 0;
            while (i2 < this.itemCount) {
                this.items[i2].y += updateY;
                ++i2;
            }
        }
        return result2;
    }
}

