/*
 * Decompiled with CFR 0.152.
 */
package gde.device.skyrc;

import gde.GDE;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.menu.MenuToolBar;
import gde.utils.StringHelper;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.logging.Logger;

public class GplLogReader {
    static Logger log = Logger.getLogger(GplLogReader.class.getName());
    static String lineSep = GDE.LINE_SEPARATOR;
    static DecimalFormat df3 = new DecimalFormat("0.000");
    static StringBuffer sb;
    static final DataExplorer application;
    static final Channels channels;
    static final byte beginMarker = -18;
    static final byte endMarker = -35;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RecordSet read(String filePath, IDevice device, String recordNameExtend, Integer channelConfigNumber) {
        Channel activeChannel = null;
        int lineNumber = 0;
        String recordSetNameExtend = device.getRecordSetStemNameReplacement();
        RecordSet recordSet = null;
        FilterInputStream data_in = null;
        int[] points = new int[device.getNoneCalculationMeasurementNames(1, device.getMeasurementNames(1)).length];
        MenuToolBar menuToolBar = application.getMenuToolBar();
        GDE.getUiNotification().setProgress(0);
        try {
            activeChannel = channelConfigNumber == null ? channels.getActiveChannel() : (Channel)channels.get((Object)channelConfigNumber);
            channelConfigNumber = channels.getActiveChannelNumber();
            if (activeChannel != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, device.getChannelCount() + " - data for channel = " + channelConfigNumber);
                }
                String recordSetName = activeChannel.size() + 1 + recordSetNameExtend;
                recordSetName = recordNameExtend.length() > 2 ? recordSetName + " [" + recordNameExtend + "]" : recordSetName;
                long startTime = System.nanoTime() / 1000000L;
                File file = new File(filePath);
                FileInputStream file_input = new FileInputStream(file);
                data_in = new DataInputStream(file_input);
                byte[] buffer = new byte[16];
                boolean isLogData = false;
                long timeStep_ms = 0L;
                long timeStamp_ms = 0L;
                while (((DataInputStream)data_in).read(buffer) != -1) {
                    if (!isLogData && buffer[0] == -18 && buffer[1] == -18 && buffer[2] == -18) {
                        isLogData = true;
                        recordSetName = activeChannel.size() + 1 + recordSetNameExtend;
                        recordSetName = recordNameExtend.length() > 2 ? recordSetName + " [" + recordNameExtend + "]" : recordSetName;
                        recordSet = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)channelConfigNumber, (boolean)true, (boolean)true, (boolean)true);
                        activeChannel.put((Object)recordSetName, (Object)recordSet);
                        recordSet = (RecordSet)activeChannel.get((Object)recordSetName);
                        String speedUnit = buffer[4] == 0 ? "km/h" : (buffer[4] == 1 ? "mph" : "km/h");
                        recordSet.get(0).setUnit(speedUnit);
                        switch (speedUnit) {
                            default: {
                                recordSet.get(0).setFactor(0.001);
                                recordSet.get(1).setUnit("m");
                                recordSet.get(1).setFactor(0.1);
                                recordSet.get(4).setUnit("km");
                                recordSet.get(4).setFactor(1.0);
                                break;
                            }
                            case "mph": {
                                recordSet.get(0).setFactor(6.214E-4);
                                recordSet.get(1).setUnit("feet");
                                recordSet.get(1).setFactor(0.3281);
                                recordSet.get(4).setUnit("mi");
                                recordSet.get(4).setFactor(0.6214);
                            }
                        }
                        int utcOffset = (buffer[5] & 0xFF) - 12;
                        timeStep_ms = 100 * buffer[3];
                        log.log(Level.INFO, String.format("timeStep_ms = %d speedUnit = 0x%02X utcOffset = %d firmware = %d.%d", timeStep_ms, buffer[4], buffer[5] - 12, buffer[12], buffer[13]));
                        int year = 2000 + buffer[6];
                        byte month = buffer[7];
                        byte day = buffer[8];
                        int hour = buffer[9] + utcOffset + device.getUTCdelta();
                        byte minute = buffer[10];
                        byte seconds = buffer[11];
                        log.log(Level.INFO, String.format("startTimeStamp = %d-%02d-%02d %02d:%02d:%02d", year, (int)month, (int)day, hour, (int)minute, (int)seconds));
                        long startTimeStamp = new GregorianCalendar(year, month - 1, day, hour, minute, seconds).getTimeInMillis();
                        recordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(startTimeStamp) + String.format(Locale.ENGLISH, "\nFirmware: %d.%d", buffer[12], buffer[13]));
                        recordSet.setStartTimeStamp(startTimeStamp);
                        String dateTime = String.format("%d-%02d-%02d", year, (int)month, (int)day);
                        activeChannel.setFileDescription((String)(application.isObjectoriented() ? dateTime + " " + application.getObjectKey() : dateTime));
                        timeStamp_ms = 0L;
                        continue;
                    }
                    if (isLogData && buffer[0] == -35 && buffer[1] == -35 && buffer[2] == -35) {
                        isLogData = false;
                        recordSet.descriptionAppendFilename(filePath.substring(filePath.lastIndexOf(47) + 1));
                        if (GDE.isWithUi()) {
                            activeChannel.applyTemplate(recordSetName, false);
                        }
                        GDE.getUiNotification().setProgress(100);
                        if (GDE.isWithUi()) {
                            Channels.getInstance().switchChannel(activeChannel.getName());
                            activeChannel.switchRecordSet(recordSetName);
                            device.updateVisibilityStatus(recordSet, true);
                            menuToolBar.updateChannelSelector();
                            menuToolBar.updateRecordSetSelectCombo();
                            continue;
                        }
                    }
                    if (!isLogData || recordSet == null) continue;
                    recordSet.addNoneCalculationRecordsPoints(device.convertDataBytes(points, buffer), (double)timeStamp_ms);
                    timeStamp_ms += timeStep_ms;
                }
                if (isLogData) {
                    if (GDE.isWithUi()) {
                        activeChannel.applyTemplate(recordSetName, false);
                    }
                    GDE.getUiNotification().setProgress(100);
                    if (GDE.isWithUi()) {
                        Channels.getInstance().switchChannel(activeChannel.getName());
                        activeChannel.switchRecordSet(recordSetName);
                        device.updateVisibilityStatus(recordSet, true);
                        menuToolBar.updateChannelSelector();
                        menuToolBar.updateRecordSetSelectCombo();
                    }
                }
                data_in.close();
                data_in = null;
                GDE.getUiNotification().setProgress(100);
                if (GDE.isWithUi() && recordSet != null) {
                    Channels.getInstance().switchChannel(activeChannel.getName());
                    activeChannel.switchRecordSet(recordSetName);
                    device.updateVisibilityStatus(recordSet, true);
                    menuToolBar.updateChannelSelector();
                    menuToolBar.updateRecordSetSelectCombo();
                    if (isLogData && recordSet != null) {
                        recordSet.descriptionAppendFilename(filePath.substring(filePath.lastIndexOf(47) + 1));
                    }
                }
                log.log(Level.TIME, "read time = " + StringHelper.getFormatedTime((String)"mm:ss:SSS", (long)(System.nanoTime() / 1000000L - startTime)));
            }
        }
        catch (FileNotFoundException e) {
            log.log(Level.WARNING, e.getMessage(), e);
            application.openMessageDialog(e.getMessage());
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.getMessage(), e);
            application.openMessageDialog(e.getMessage());
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
            if (activeChannel != null && activeChannel.size() > 0) {
                String recordSetName = activeChannel.getFirstRecordSetName();
                activeChannel.setActiveRecordSet(recordSetName);
                device.updateVisibilityStatus((RecordSet)activeChannel.get((Object)recordSetName), true);
                ((RecordSet)activeChannel.get((Object)recordSetName)).checkAllDisplayable();
                if (GDE.isWithUi()) {
                    activeChannel.switchRecordSet(recordSetName);
                }
            }
            String msg = filePath + " - " + Messages.getString((String)"GDE_MSGE0045", (Object[])new Object[]{e.getMessage(), lineNumber});
            log.log(Level.WARNING, msg, e);
            application.openMessageDialog(msg);
        }
        finally {
            if (data_in != null) {
                try {
                    data_in.close();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, e.getMessage());
                }
                data_in = null;
            }
            GDE.getUiNotification().setStatusMessage("");
        }
        return recordSet;
    }

    static {
        application = DataExplorer.getInstance();
        channels = Channels.getInstance();
    }
}

