/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jaxb.runtime.v2.runtime.reflect.opt;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jaxb.core.v2.model.core.TypeInfo;
import org.glassfish.jaxb.runtime.v2.bytecode.ClassTailor;
import org.glassfish.jaxb.runtime.v2.model.runtime.RuntimeClassInfo;
import org.glassfish.jaxb.runtime.v2.model.runtime.RuntimePropertyInfo;
import org.glassfish.jaxb.runtime.v2.runtime.reflect.Accessor;
import org.glassfish.jaxb.runtime.v2.runtime.reflect.TransducedAccessor;
import org.glassfish.jaxb.runtime.v2.runtime.reflect.opt.AccessorInjector;
import org.glassfish.jaxb.runtime.v2.runtime.reflect.opt.Bean;
import org.glassfish.jaxb.runtime.v2.runtime.reflect.opt.OptimizedAccessorFactory;
import org.glassfish.jaxb.runtime.v2.runtime.reflect.opt.TransducedAccessor_field_Byte;
import org.glassfish.jaxb.runtime.v2.runtime.reflect.opt.TransducedAccessor_method_Byte;

public abstract class OptimizedTransducedAccessorFactory {
    private static final Logger logger = Logger.getLogger(OptimizedTransducedAccessorFactory.class.getName());
    private static final String fieldTemplateName;
    private static final String methodTemplateName;
    private static final Map<Class, String> suffixMap;

    private OptimizedTransducedAccessorFactory() {
    }

    public static final TransducedAccessor get(RuntimePropertyInfo prop) {
        if (OptimizedAccessorFactory.noOptimization) {
            return null;
        }
        Accessor acc = prop.getAccessor();
        Class<?> opt = null;
        TypeInfo parent = prop.parent();
        if (!(parent instanceof RuntimeClassInfo)) {
            return null;
        }
        Class dc = (Class)((RuntimeClassInfo)parent).getClazz();
        String newClassName = ClassTailor.toVMClassName(dc) + "_JaxbXducedAccessor_" + prop.getName();
        if (acc instanceof Accessor.FieldReflection) {
            Accessor.FieldReflection racc = (Accessor.FieldReflection)acc;
            Field field2 = racc.f;
            int mods = field2.getModifiers();
            if (Modifier.isPrivate(mods) || Modifier.isFinal(mods)) {
                return null;
            }
            Class<?> t2 = field2.getType();
            if (t2.isPrimitive()) {
                opt = AccessorInjector.prepare(dc, fieldTemplateName + suffixMap.get(t2), newClassName, ClassTailor.toVMClassName(Bean.class), ClassTailor.toVMClassName(dc), "f_" + t2.getName(), field2.getName());
            }
        }
        if (acc.getClass() == Accessor.GetterSetterReflection.class) {
            Accessor.GetterSetterReflection gacc = (Accessor.GetterSetterReflection)acc;
            if (gacc.getter == null || gacc.setter == null) {
                return null;
            }
            Class<?> t3 = gacc.getter.getReturnType();
            if (Modifier.isPrivate(gacc.getter.getModifiers()) || Modifier.isPrivate(gacc.setter.getModifiers())) {
                return null;
            }
            if (t3.isPrimitive()) {
                opt = AccessorInjector.prepare(dc, methodTemplateName + suffixMap.get(t3), newClassName, ClassTailor.toVMClassName(Bean.class), ClassTailor.toVMClassName(dc), "get_" + t3.getName(), gacc.getter.getName(), "set_" + t3.getName(), gacc.setter.getName());
            }
        }
        if (opt == null) {
            return null;
        }
        logger.log(Level.FINE, "Using optimized TransducedAccessor for " + prop.displayName());
        try {
            return (TransducedAccessor)opt.newInstance();
        }
        catch (InstantiationException e2) {
            logger.log(Level.INFO, "failed to load an optimized TransducedAccessor", e2);
        }
        catch (IllegalAccessException e3) {
            logger.log(Level.INFO, "failed to load an optimized TransducedAccessor", e3);
        }
        catch (SecurityException e4) {
            logger.log(Level.INFO, "failed to load an optimized TransducedAccessor", e4);
        }
        return null;
    }

    static {
        String s2 = TransducedAccessor_field_Byte.class.getName();
        fieldTemplateName = s2.substring(0, s2.length() - "Byte".length()).replace('.', '/');
        s2 = TransducedAccessor_method_Byte.class.getName();
        methodTemplateName = s2.substring(0, s2.length() - "Byte".length()).replace('.', '/');
        suffixMap = new HashMap<Class, String>();
        suffixMap.put(Byte.TYPE, "Byte");
        suffixMap.put(Short.TYPE, "Short");
        suffixMap.put(Integer.TYPE, "Integer");
        suffixMap.put(Long.TYPE, "Long");
        suffixMap.put(Boolean.TYPE, "Boolean");
        suffixMap.put(Float.TYPE, "Float");
        suffixMap.put(Double.TYPE, "Double");
    }
}

