/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import javax.json.Json;
import javax.json.JsonMergePatch;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public final class JsonMergePatchImpl
implements JsonMergePatch {
    private JsonValue patch;

    public JsonMergePatchImpl(JsonValue patch2) {
        this.patch = patch2;
    }

    @Override
    public JsonValue apply(JsonValue target) {
        return JsonMergePatchImpl.mergePatch(target, this.patch);
    }

    @Override
    public JsonValue toJsonValue() {
        return this.patch;
    }

    private static JsonValue mergePatch(JsonValue target, JsonValue patch2) {
        if (patch2.getValueType() != JsonValue.ValueType.OBJECT) {
            return patch2;
        }
        if (target.getValueType() != JsonValue.ValueType.OBJECT) {
            target = JsonValue.EMPTY_JSON_OBJECT;
        }
        JsonObject targetJsonObject = target.asJsonObject();
        JsonObjectBuilder builder = Json.createObjectBuilder(targetJsonObject);
        patch2.asJsonObject().forEach((key2, value) -> {
            if (value == JsonValue.NULL) {
                if (targetJsonObject.containsKey(key2)) {
                    builder.remove((String)key2);
                }
            } else if (targetJsonObject.containsKey(key2)) {
                builder.add((String)key2, JsonMergePatchImpl.mergePatch((JsonValue)targetJsonObject.get(key2), value));
            } else {
                builder.add((String)key2, JsonMergePatchImpl.mergePatch(JsonValue.EMPTY_JSON_OBJECT, value));
            }
        });
        return builder.build();
    }

    static JsonValue diff(JsonValue source, JsonValue target) {
        if (source.getValueType() != JsonValue.ValueType.OBJECT || target.getValueType() != JsonValue.ValueType.OBJECT) {
            return target;
        }
        JsonObject s2 = (JsonObject)source;
        JsonObject t2 = (JsonObject)target;
        JsonObjectBuilder builder = Json.createObjectBuilder();
        s2.forEach((key2, value) -> {
            if (t2.containsKey(key2)) {
                if (!value.equals(t2.get(key2))) {
                    builder.add((String)key2, JsonMergePatchImpl.diff(value, (JsonValue)t2.get(key2)));
                }
            } else {
                builder.addNull((String)key2);
            }
        });
        t2.forEach((key2, value) -> {
            if (!s2.containsKey(key2)) {
                builder.add((String)key2, (JsonValue)value);
            }
        });
        return builder.build();
    }
}

