/*
 * Decompiled with CFR 0.152.
 */
package gde.device.multiplex;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.DeviceDialog;
import gde.device.InputTypes;
import gde.device.multiplex.FlightRecorder;
import gde.device.multiplex.VisualizationControl;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.SWTResourceManager;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class FlightRecorderDialog
extends DeviceDialog {
    static final Logger log = Logger.getLogger(FlightRecorderDialog.class.getName());
    CTabFolder tabFolder;
    CTabFolder subTabFolder1;
    CTabFolder subTabFolder2;
    CTabItem visualizationTabItem;
    Composite visualizationMainComposite;
    Composite uniLogVisualization;
    Composite mLinkVisualization;
    Composite configurationMainComposite;
    Button saveVisualizationButton;
    Button inputFileButton;
    Button helpButton;
    Button closeButton;
    CTabItem gpsLoggerTabItem;
    CTabItem telemetryTabItem;
    final FlightRecorder device;
    final Settings settings;
    RecordSet lastActiveRecordSet = null;
    boolean isVisibilityChanged = false;
    int measurementsCount = 0;
    final List<CTabItem> configurations = new ArrayList<CTabItem>();

    public FlightRecorderDialog(Shell parent, FlightRecorder useDevice) {
        super(parent);
        this.device = useDevice;
        this.settings = Settings.getInstance();
        this.measurementsCount = (Math.abs(this.device.getDataBlockSize(InputTypes.FILE_IO)) + 1) / 2;
    }

    public void open() {
        try {
            this.shellAlpha = Settings.getInstance().getDialogAlphaValue();
            this.isAlphaEnabled = Settings.getInstance().isDeviceDialogAlphaEnabled();
            log.log(java.util.logging.Level.FINE, "dialogShell.isDisposed() " + String.valueOf(this.dialogShell == null ? "null" : Boolean.valueOf(this.dialogShell.isDisposed())));
            if (this.dialogShell == null || this.dialogShell.isDisposed()) {
                this.dialogShell = this.settings.isDeviceDialogsModal() ? new Shell(this.application.getShell(), 34912) : (this.settings.isDeviceDialogsOnTop() ? new Shell(this.application.getDisplay(), 18528) : new Shell(this.application.getDisplay(), 2144));
                SWTResourceManager.registerResourceUser((Widget)this.dialogShell);
                FormLayout dialogShellLayout = new FormLayout();
                this.dialogShell.setLayout((Layout)dialogShellLayout);
                this.dialogShell.layout();
                this.dialogShell.pack();
                this.dialogShell.setSize(GDE.IS_LINUX ? 740 : 675, 80 + this.measurementsCount * 26 + 50 + 42);
                this.dialogShell.setText(this.device.getName() + Messages.getString((String)"GDE_MSGT0273"));
                this.dialogShell.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.dialogShell.setImage(SWTResourceManager.getImage((String)"gde/resource/ToolBoxHot.gif"));
                this.dialogShell.addListener(31, new Listener(){

                    public void handleEvent(Event event) {
                        switch (event.detail) {
                            case 2: {
                                FlightRecorderDialog.this.dialogShell.close();
                                event.detail = 0;
                                event.doit = false;
                            }
                        }
                    }
                });
                this.dialogShell.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent evt) {
                        log.log(java.util.logging.Level.FINEST, "dialogShell.widgetDisposed, event=" + String.valueOf(evt));
                        if (FlightRecorderDialog.this.device.isChangePropery()) {
                            String msg = Messages.getString((String)"GDE_MSGI0041", (Object[])new String[]{FlightRecorderDialog.this.device.getPropertiesFileName()});
                            if (FlightRecorderDialog.this.application.openYesNoMessageDialog(FlightRecorderDialog.this.getDialogShell(), msg) == 64) {
                                log.log(java.util.logging.Level.FINE, "SWT.YES");
                                FlightRecorderDialog.this.device.storeDeviceProperties();
                                FlightRecorderDialog.this.setClosePossible(true);
                            }
                        }
                        FlightRecorderDialog.this.dispose();
                    }
                });
                this.dialogShell.addHelpListener(new HelpListener(){

                    public void helpRequested(HelpEvent evt) {
                        log.log(java.util.logging.Level.FINER, "dialogShell.helpRequested, event=" + String.valueOf(evt));
                        FlightRecorderDialog.this.application.openHelpDialog(FlightRecorderDialog.this.device.getName(), "HelpInfo.html");
                    }
                });
                this.dialogShell.addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent paintevent) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "dialogShell.paintControl, event=" + String.valueOf(paintevent));
                        }
                        RecordSet activeRecordSet = FlightRecorderDialog.this.application.getActiveRecordSet();
                        if (FlightRecorderDialog.this.lastActiveRecordSet == null && activeRecordSet != null || activeRecordSet != null && !FlightRecorderDialog.this.lastActiveRecordSet.getName().equals(activeRecordSet.getName())) {
                            FlightRecorderDialog.this.tabFolder.setSelection(Channels.getInstance().getActiveChannelNumber() - 1);
                        }
                        FlightRecorderDialog.this.lastActiveRecordSet = FlightRecorderDialog.this.application.getActiveRecordSet();
                    }
                });
                this.tabFolder = new CTabFolder((Composite)this.dialogShell, 0);
                this.tabFolder.setSimple(false);
                for (int i = 1; i <= this.device.getChannelCount(); ++i) {
                    this.createVisualizationTabItem(i, 24);
                }
                FormData tabFolderLData = new FormData();
                tabFolderLData.top = new FormAttachment(0, 1000, 0);
                tabFolderLData.left = new FormAttachment(0, 1000, 0);
                tabFolderLData.right = new FormAttachment(1000, 1000, 0);
                tabFolderLData.bottom = new FormAttachment(1000, 1000, -50);
                this.tabFolder.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.tabFolder.setLayoutData((Object)tabFolderLData);
                this.tabFolder.setSelection(0);
                this.saveVisualizationButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData saveButtonLData = new FormData();
                saveButtonLData.width = 130;
                saveButtonLData.height = GDE.IS_MAC ? 33 : 30;
                saveButtonLData.left = new FormAttachment(0, 1000, 15);
                saveButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.saveVisualizationButton.setLayoutData((Object)saveButtonLData);
                this.saveVisualizationButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.saveVisualizationButton.setText(Messages.getString((String)"GDE_MSGT2710"));
                this.saveVisualizationButton.setToolTipText(Messages.getString((String)"GDE_MSGT2711"));
                this.saveVisualizationButton.setEnabled(false);
                this.saveVisualizationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(java.util.logging.Level.FINEST, "saveButton.widgetSelected, event=" + String.valueOf(evt));
                        FlightRecorderDialog.this.device.storeDeviceProperties();
                        FlightRecorderDialog.this.saveVisualizationButton.setEnabled(false);
                    }
                });
                this.inputFileButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData inputFileButtonLData = new FormData();
                inputFileButtonLData.width = 130;
                inputFileButtonLData.height = GDE.IS_MAC ? 33 : 30;
                inputFileButtonLData.left = new FormAttachment(0, 1000, 155);
                inputFileButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.inputFileButton.setLayoutData((Object)inputFileButtonLData);
                this.inputFileButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.inputFileButton.setText(Messages.getString((String)"GDE_MSGT2712"));
                this.inputFileButton.setToolTipText(Messages.getString((String)"GDE_MSGT2713"));
                this.inputFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(java.util.logging.Level.FINEST, "inputFileButton.widgetSelected, event=" + String.valueOf(evt));
                        if (FlightRecorderDialog.this.isVisibilityChanged) {
                            String msg = Messages.getString((String)"GDE_MSGI0041", (Object[])new String[]{FlightRecorderDialog.this.device.getPropertiesFileName()});
                            if (FlightRecorderDialog.this.application.openYesNoMessageDialog(FlightRecorderDialog.this.dialogShell, msg) == 64) {
                                log.log(java.util.logging.Level.FINE, "SWT.YES");
                                FlightRecorderDialog.this.device.storeDeviceProperties();
                            }
                        }
                        FlightRecorderDialog.this.device.open_closeCommPort();
                    }
                });
                this.helpButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData helpButtonLData = new FormData();
                helpButtonLData.width = GDE.IS_MAC ? 50 : 40;
                helpButtonLData.height = GDE.IS_MAC ? 33 : 30;
                helpButtonLData.left = new FormAttachment(0, 1000, 302);
                helpButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.helpButton.setLayoutData((Object)helpButtonLData);
                this.helpButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.helpButton.setImage(SWTResourceManager.getImage((String)"gde/resource/QuestionHot.gif"));
                this.helpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(java.util.logging.Level.FINEST, "helpButton.widgetSelected, event=" + String.valueOf(evt));
                        FlightRecorderDialog.this.application.openHelpDialog(FlightRecorderDialog.this.device.getName(), "HelpInfo.html");
                    }
                });
                this.closeButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData closeButtonLData = new FormData();
                closeButtonLData.width = 130;
                closeButtonLData.height = GDE.IS_MAC ? 33 : 30;
                closeButtonLData.right = new FormAttachment(1000, 1000, -10);
                closeButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.closeButton.setLayoutData((Object)closeButtonLData);
                this.closeButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.closeButton.setText(Messages.getString((String)"GDE_MSGT0485"));
                this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(java.util.logging.Level.FINEST, "closeButton.widgetSelected, event=" + String.valueOf(evt));
                        FlightRecorderDialog.this.dispose();
                    }
                });
                try {
                    this.tabFolder.setSelection(Channels.getInstance().getActiveChannelNumber() - 1);
                }
                catch (RuntimeException e) {
                    this.tabFolder.setSelection(0);
                }
                this.dialogShell.setLocation(this.getParent().toDisplay(this.getParent().getSize().x / 2 - 375, 10));
                this.dialogShell.open();
            } else {
                this.dialogShell.setVisible(true);
                this.dialogShell.setActive();
            }
            Display display = this.dialogShell.getDisplay();
            while (!this.dialogShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Exception e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
        }
    }

    private void createVisualizationTabItem(int channelNumber, int numMeasurements) {
        this.visualizationTabItem = new CTabItem(this.tabFolder, 0);
        this.visualizationTabItem.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.visualizationTabItem.setText(Messages.getString((String)"GDE_MSGT2709") + " - " + this.device.getChannelNameReplacement(channelNumber));
        this.visualizationMainComposite = new Composite((Composite)this.tabFolder, 0);
        FormLayout visualizationMainCompositeLayout = new FormLayout();
        this.visualizationMainComposite.setLayout((Layout)visualizationMainCompositeLayout);
        this.visualizationTabItem.setControl((Control)this.visualizationMainComposite);
        FormData layoutData = new FormData();
        layoutData.top = new FormAttachment(0, 1000, 0);
        layoutData.left = new FormAttachment(0, 1000, 0);
        layoutData.right = new FormAttachment(1000, 1000, 0);
        layoutData.bottom = new FormAttachment(1000, 1000, 0);
        new VisualizationControl(this.visualizationMainComposite, layoutData, this, channelNumber, this.device, Messages.getString((String)"GDE_MSGT2709"), 0, numMeasurements);
    }

    public void enableSaveButton(boolean enable) {
        this.saveVisualizationButton.setEnabled(enable);
        this.application.updateAllTabs(true);
    }

    public Integer getTabFolderSelectionIndex() {
        return this.tabFolder.getSelectionIndex();
    }
}

