/*
 * Decompiled with CFR 0.152.
 */
package gde.device.robbe;

import gde.GDE;
import gde.config.Settings;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DesktopPropertyType;
import gde.device.DesktopPropertyTypes;
import gde.device.DeviceConfiguration;
import gde.device.InputTypes;
import gde.device.robbe.PowerPeak;
import gde.exception.DataInconsitsentException;
import gde.log.Level;
import gde.messages.Messages;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.eclipse.swt.custom.CTabItem;

public class PowerPeakIV
extends PowerPeak {
    static final Logger logger = Logger.getLogger(PowerPeakIV.class.getName());

    public PowerPeakIV(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        Messages.setDeviceResourceBundle((String)"gde.device.graupner.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.USAGE_MODE = new String[]{Messages.getString((String)"GDE_MSGT2200"), Messages.getString((String)"GDE_MSGT2201"), Messages.getString((String)"GDE_MSGT2202"), Messages.getString((String)"GDE_MSGT2203"), Messages.getString((String)"GDE_MSGT2200"), Messages.getString((String)"GDE_MSGT2205"), Messages.getString((String)"GDE_MSGT2206"), Messages.getString((String)"GDE_MSGT2207"), Messages.getString((String)"GDE_MSGT2222"), Messages.getString((String)"GDE_MSGT2209")};
        this.CHARGE_MODE = new String[]{Messages.getString((String)"GDE_MSGT2210"), Messages.getString((String)"GDE_MSGT2212"), Messages.getString((String)"GDE_MSGT2213"), Messages.getString((String)"GDE_MSGT2216"), Messages.getString((String)"GDE_MSGT2218"), Messages.getString((String)"GDE_MSGT2215"), Messages.getString((String)"GDE_MSGT2216"), Messages.getString((String)"GDE_MSGT2217"), Messages.getString((String)"GDE_MSGT2218"), Messages.getString((String)"GDE_MSGT2219"), Messages.getString((String)"GDE_MSGT2220"), Messages.getString((String)"GDE_MSGT2221"), Messages.getString((String)"GDE_MSGT2222")};
        this.DISCHARGE_MODE = new String[]{Messages.getString((String)"GDE_MSGT2210"), Messages.getString((String)"GDE_MSGT2212"), Messages.getString((String)"GDE_MSGT2213"), Messages.getString((String)"GDE_MSGT2216"), Messages.getString((String)"GDE_MSGT2218"), Messages.getString((String)"GDE_MSGT2224"), Messages.getString((String)"GDE_MSGT2220"), Messages.getString((String)"GDE_MSGT2222")};
        this.DELAY_MODE = new String[]{"", "", "", ""};
        this.CURRENT_MODE = new String[]{Messages.getString((String)"GDE_MSGT2229"), Messages.getString((String)"GDE_MSGT2230"), Messages.getString((String)"GDE_MSGT2231"), Messages.getString((String)"GDE_MSGT2232"), Messages.getString((String)"GDE_MSGT2233"), Messages.getString((String)"GDE_MSGT2234"), Messages.getString((String)"GDE_MSGT2235"), Messages.getString((String)"GDE_MSGT2236"), Messages.getString((String)"GDE_MSGT2237")};
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(1, "", "");
        }
    }

    public PowerPeakIV(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.graupner.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.USAGE_MODE = new String[]{Messages.getString((String)"GDE_MSGT2200"), Messages.getString((String)"GDE_MSGT2201"), Messages.getString((String)"GDE_MSGT2202"), Messages.getString((String)"GDE_MSGT2203"), Messages.getString((String)"GDE_MSGT2200"), Messages.getString((String)"GDE_MSGT2205"), Messages.getString((String)"GDE_MSGT2206"), Messages.getString((String)"GDE_MSGT2207"), Messages.getString((String)"GDE_MSGT2222"), Messages.getString((String)"GDE_MSGT2209")};
        this.CHARGE_MODE = new String[]{Messages.getString((String)"GDE_MSGT2210"), Messages.getString((String)"GDE_MSGT2212"), Messages.getString((String)"GDE_MSGT2213"), Messages.getString((String)"GDE_MSGT2216"), Messages.getString((String)"GDE_MSGT2218"), Messages.getString((String)"GDE_MSGT2215"), Messages.getString((String)"GDE_MSGT2216"), Messages.getString((String)"GDE_MSGT2217"), Messages.getString((String)"GDE_MSGT2218"), Messages.getString((String)"GDE_MSGT2219"), Messages.getString((String)"GDE_MSGT2220"), Messages.getString((String)"GDE_MSGT2221"), Messages.getString((String)"GDE_MSGT2222")};
        this.DISCHARGE_MODE = new String[]{Messages.getString((String)"GDE_MSGT2210"), Messages.getString((String)"GDE_MSGT2212"), Messages.getString((String)"GDE_MSGT2213"), Messages.getString((String)"GDE_MSGT2216"), Messages.getString((String)"GDE_MSGT2218"), Messages.getString((String)"GDE_MSGT2224"), Messages.getString((String)"GDE_MSGT2220"), Messages.getString((String)"GDE_MSGT2222")};
        this.DELAY_MODE = new String[]{"", "", "", ""};
        this.CURRENT_MODE = new String[]{Messages.getString((String)"GDE_MSGT2229"), Messages.getString((String)"GDE_MSGT2230"), Messages.getString((String)"GDE_MSGT2231"), Messages.getString((String)"GDE_MSGT2232"), Messages.getString((String)"GDE_MSGT2233"), Messages.getString((String)"GDE_MSGT2234"), Messages.getString((String)"GDE_MSGT2235"), Messages.getString((String)"GDE_MSGT2236"), Messages.getString((String)"GDE_MSGT2237")};
        this.configureSerialPortMenu(1, "", "");
    }

    @Override
    public int getLovDataByteSize() {
        return 128;
    }

    public byte[] getPreparedBufferChannel2(byte[] dataBuffer) {
        byte[] buffer = new byte[Math.abs(this.getDataBlockSize(InputTypes.SERIAL_IO))];
        Arrays.fill(buffer, (byte)48);
        System.arraycopy(dataBuffer, 0, buffer, 0, 7);
        System.arraycopy(dataBuffer, 33, buffer, 7, 4);
        System.arraycopy(dataBuffer, 37, buffer, 13, 12);
        System.arraycopy(dataBuffer, 97, buffer, 49, 12);
        return buffer;
    }

    @Override
    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int deviceDataBufferSize = Math.abs(this.getDataBlockSize(InputTypes.SERIAL_IO));
        int[] points = new int[this.getNumberOfMeasurements(recordSet.getChannelConfigNumber())];
        int offset = 6;
        int progressCycle = 0;
        int lovDataSize = this.getLovDataByteSize();
        int outputChannel = recordSet.getChannelConfigNumber();
        if (dataBuffer[offset] == 12) {
            byte[] convertBuffer = new byte[deviceDataBufferSize];
            if (doUpdateProgressBar) {
                this.application.setProgress(progressCycle, sThreadId);
            }
            for (int i = 0; i < recordDataSize; ++i) {
                System.arraycopy(dataBuffer, offset + i * lovDataSize, convertBuffer, 0, deviceDataBufferSize);
                if (outputChannel == 1) {
                    recordSet.addPoints(this.convertDataBytes(points, convertBuffer));
                } else if (outputChannel == 2) {
                    recordSet.addPoints(this.convertDataBytes(points, this.getPreparedBufferChannel2(convertBuffer)));
                }
                if (!doUpdateProgressBar || i % 50 != 0) continue;
                this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
            }
            recordSet.setTimeStep_ms(this.getAverageTimeStep_ms() != null ? this.getAverageTimeStep_ms() : 1000.0);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        this.updateVisibilityStatus(recordSet, true);
        recordSet.syncScaleOfSyncableRecords();
    }

    @Override
    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        int maxVotage = Integer.MIN_VALUE;
        int minVotage = Integer.MAX_VALUE;
        try {
            points[0] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[13]), Character.valueOf((char)dataBuffer[14]), Character.valueOf((char)dataBuffer[15]), Character.valueOf((char)dataBuffer[16])), 16);
            points[1] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[17]), Character.valueOf((char)dataBuffer[18]), Character.valueOf((char)dataBuffer[19]), Character.valueOf((char)dataBuffer[20])), 16);
            points[2] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[21]), Character.valueOf((char)dataBuffer[22]), Character.valueOf((char)dataBuffer[23]), Character.valueOf((char)dataBuffer[24])), 16);
            points[3] = Double.valueOf((double)(points[0] * points[1]) / 1000.0).intValue();
            points[4] = Double.valueOf((double)(points[0] * points[2]) / 1000.0).intValue();
            points[5] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[25]), Character.valueOf((char)dataBuffer[26]), Character.valueOf((char)dataBuffer[27]), Character.valueOf((char)dataBuffer[28])), 16);
            points[6] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[3]), Character.valueOf((char)dataBuffer[4]), Character.valueOf((char)dataBuffer[5]), Character.valueOf((char)dataBuffer[6])), 16);
            points[7] = 0;
            int i = 0;
            int j = 0;
            while (i < points.length - 8) {
                try {
                    points[i + 8] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[49 + j]), Character.valueOf((char)dataBuffer[50 + j]), Character.valueOf((char)dataBuffer[51 + j]), Character.valueOf((char)dataBuffer[52 + j])), 16);
                }
                catch (NumberFormatException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                }
                if (points[i + 8] > 0) {
                    maxVotage = points[i + 8] > maxVotage ? points[i + 8] : maxVotage;
                    minVotage = points[i + 8] < minVotage ? points[i + 8] : minVotage;
                }
                ++i;
                j += 4;
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
        points[7] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
        return points;
    }

    @Override
    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int progressCycle = 0;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        for (int i = 0; i < recordDataSize; ++i) {
            int maxVotage = Integer.MIN_VALUE;
            int minVotage = Integer.MAX_VALUE;
            logger.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize);
            System.arraycopy(dataBuffer, i * dataBufferSize, convertBuffer, 0, dataBufferSize);
            points[0] = ((convertBuffer[0] & 0xFF) << 24) + ((convertBuffer[1] & 0xFF) << 16) + ((convertBuffer[2] & 0xFF) << 8) + ((convertBuffer[3] & 0xFF) << 0);
            points[1] = ((convertBuffer[4] & 0xFF) << 24) + ((convertBuffer[5] & 0xFF) << 16) + ((convertBuffer[6] & 0xFF) << 8) + ((convertBuffer[7] & 0xFF) << 0);
            points[2] = ((convertBuffer[8] & 0xFF) << 24) + ((convertBuffer[9] & 0xFF) << 16) + ((convertBuffer[10] & 0xFF) << 8) + ((convertBuffer[11] & 0xFF) << 0);
            points[3] = Double.valueOf((double)points[0] / 1000.0 * (double)points[1]).intValue();
            points[4] = Double.valueOf((double)points[0] / 1000.0 * (double)points[2]).intValue();
            points[5] = ((convertBuffer[12] & 0xFF) << 24) + ((convertBuffer[13] & 0xFF) << 16) + ((convertBuffer[14] & 0xFF) << 8) + ((convertBuffer[15] & 0xFF) << 0);
            points[6] = ((convertBuffer[16] & 0xFF) << 24) + ((convertBuffer[17] & 0xFF) << 16) + ((convertBuffer[18] & 0xFF) << 8) + ((convertBuffer[19] & 0xFF) << 0);
            points[7] = 0;
            int j = 0;
            int k = 0;
            while (j < points.length - 8) {
                points[j + 8] = ((convertBuffer[k + 20] & 0xFF) << 24) + ((convertBuffer[k + 21] & 0xFF) << 16) + ((convertBuffer[k + 22] & 0xFF) << 8) + ((convertBuffer[k + 23] & 0xFF) << 0);
                if (points[j + 8] > 0) {
                    maxVotage = points[j + 8] > maxVotage ? points[j + 8] : maxVotage;
                    minVotage = points[j + 8] < minVotage ? points[j + 8] : minVotage;
                }
                ++j;
                k += 4;
            }
            points[7] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
            recordSet.addPoints(points);
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    @Override
    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        Record record;
        int i;
        recordSet.setAllDisplayable();
        int numCells = recordSet.getChannelConfigNumber() == 1 ? 12 : 3;
        for (i = recordSet.size() - numCells - 3; i < recordSet.size(); ++i) {
            record = recordSet.get(i);
            record.setDisplayable(record.hasReasonableData());
            log.log(Level.FINER, record.getName() + " setDisplayable=" + (record.getOrdinal() <= 5 || record.hasReasonableData()));
        }
        if (logger.isLoggable(Level.FINE)) {
            for (i = 0; i < recordSet.size(); ++i) {
                record = recordSet.get(i);
                logger.log(Level.FINE, record.getName() + " isActive=" + record.isActive() + " isVisible=" + record.isVisible() + " isDisplayable=" + record.isDisplayable());
            }
        }
    }

    @Override
    public PowerPeak.RobbeDeviceType getDeviceTypeIdentifier() {
        return PowerPeak.RobbeDeviceType.PowerPeakIV;
    }

    @Override
    public int getDesktopTargetReferenceOrdinal(DesktopPropertyTypes desktopPropertyType) {
        DesktopPropertyType property = this.getDesktopProperty(desktopPropertyType);
        return property != null ? property.getTargetReferenceOrdinal() : -1;
    }

    @Override
    public int[] getCellVoltageOrdinals() {
        return new int[]{0, 2};
    }

    @Override
    public boolean isProcessing(int outletNum, byte[] dataBuffer) {
        if (outletNum == 1) {
            String processingModeOut1 = String.format("%c%c", Character.valueOf((char)dataBuffer[7]), Character.valueOf((char)dataBuffer[8]));
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "processingModeOut1 = " + (processingModeOut1 != null && processingModeOut1.length() > 0 ? this.USAGE_MODE[Integer.parseInt(processingModeOut1, 16)] : processingModeOut1));
            }
            if (this.settings.isReduceChargeDischarge()) {
                return processingModeOut1 != null && processingModeOut1.length() == 2 && (processingModeOut1.equals("01") || processingModeOut1.equals("02") || this.settings.isContinuousRecordSet() && processingModeOut1.equals("03"));
            }
            return processingModeOut1 != null && processingModeOut1.length() == 2 && !processingModeOut1.equals("00") && !processingModeOut1.equals("06");
        }
        if (outletNum == 2) {
            String processingModeOut2 = String.format("%c%c", Character.valueOf((char)dataBuffer[33]), Character.valueOf((char)dataBuffer[34]));
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "processingModeOut2 = " + (processingModeOut2 != null && processingModeOut2.length() > 0 ? this.USAGE_MODE[Integer.parseInt(processingModeOut2, 16)] : processingModeOut2));
            }
            if (this.settings.isReduceChargeDischarge()) {
                return processingModeOut2 != null && processingModeOut2.length() == 2 && (processingModeOut2.equals("01") || processingModeOut2.equals("02") || this.settings.isContinuousRecordSet() && processingModeOut2.equals("03"));
            }
            return processingModeOut2 != null && processingModeOut2.length() == 2 && !processingModeOut2.equals("00") && !processingModeOut2.equals("06");
        }
        return false;
    }

    @Override
    public int getProcessingMode(byte[] dataBuffer) {
        String processingMode = String.format("%c%c", Character.valueOf((char)dataBuffer[7]), Character.valueOf((char)dataBuffer[8]));
        return processingMode != null && processingMode.length() > 0 ? Integer.parseInt(processingMode, 16) : 0;
    }

    @Override
    public String getProcessingType(byte[] dataBuffer) {
        String type = "";
        String processingMode = String.format("%c%c", Character.valueOf((char)dataBuffer[7]), Character.valueOf((char)dataBuffer[8]));
        int opMode = processingMode != null && processingMode.length() > 0 ? Integer.parseInt(processingMode, 16) : 0;
        String processingType = String.format("%c%c", Character.valueOf((char)dataBuffer[9]), Character.valueOf((char)dataBuffer[10]));
        switch (opMode) {
            case 1: {
                type = processingType != null && processingType.length() > 0 ? this.CHARGE_MODE[Integer.parseInt(processingType, 16)] : "";
                break;
            }
            case 2: {
                type = processingType != null && processingType.length() > 0 ? this.DISCHARGE_MODE[Integer.parseInt(processingType, 16)] : "";
                break;
            }
            case 3: {
                type = processingType != null && processingType.length() > 0 ? this.DELAY_MODE[Integer.parseInt(processingType, 16)] : "";
                break;
            }
            case 5: {
                type = processingType != null && processingType.length() > 0 ? this.CURRENT_MODE[Integer.parseInt(processingType, 16)] : "";
                break;
            }
            case 6: {
                GDE.getUiNotification().setStatusMessage(Messages.getString((String)"GDE_MSGE2218") + String.format("%02d", Integer.parseInt(processingType, 16)), 3);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "processingMode=" + processingMode + " processingType=" + processingType);
        }
        return type;
    }

    @Override
    public boolean isLinkedMode(byte[] dataBuffer) {
        return false;
    }

    @Override
    public String getFirmwareVersion(byte[] dataBuffer) {
        return this.firmware;
    }

    @Override
    public int getCycleNumber(int outletNum, byte[] dataBuffer) {
        return 0;
    }

    @Override
    public void setTemperatureUnit(int channelNumber, RecordSet recordSet, byte[] dataBuffer) {
    }

    public CTabItem getUtilityDeviceTabItem() {
        return this.application.getUtilGraphicsWindow(Messages.getString((String)"GDE_MSGT2340"));
    }
}

