/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.solvers;

import org.apache.commons.math3.analysis.solvers.AbstractUnivariateSolver;
import org.apache.commons.math3.exception.NoBracketingException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;

public class BrentSolver
extends AbstractUnivariateSolver {
    private static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;

    public BrentSolver() {
        this(1.0E-6);
    }

    public BrentSolver(double absoluteAccuracy) {
        super(absoluteAccuracy);
    }

    public BrentSolver(double relativeAccuracy, double absoluteAccuracy) {
        super(relativeAccuracy, absoluteAccuracy);
    }

    public BrentSolver(double relativeAccuracy, double absoluteAccuracy, double functionValueAccuracy) {
        super(relativeAccuracy, absoluteAccuracy, functionValueAccuracy);
    }

    protected double doSolve() throws NoBracketingException, TooManyEvaluationsException, NumberIsTooLargeException {
        double min = this.getMin();
        double max = this.getMax();
        double initial = this.getStartValue();
        double functionValueAccuracy = this.getFunctionValueAccuracy();
        this.verifySequence(min, initial, max);
        double yInitial = this.computeObjectiveValue(initial);
        if (FastMath.abs(yInitial) <= functionValueAccuracy) {
            return initial;
        }
        double yMin = this.computeObjectiveValue(min);
        if (FastMath.abs(yMin) <= functionValueAccuracy) {
            return min;
        }
        if (yInitial * yMin < 0.0) {
            return this.brent(min, initial, yMin, yInitial);
        }
        double yMax = this.computeObjectiveValue(max);
        if (FastMath.abs(yMax) <= functionValueAccuracy) {
            return max;
        }
        if (yInitial * yMax < 0.0) {
            return this.brent(initial, max, yInitial, yMax);
        }
        throw new NoBracketingException(min, max, yMin, yMax);
    }

    private double brent(double lo, double hi, double fLo, double fHi) {
        double d2;
        double a2 = lo;
        double fa = fLo;
        double b2 = hi;
        double fb = fHi;
        double c2 = a2;
        double fc = fa;
        double e2 = d2 = b2 - a2;
        double t2 = this.getAbsoluteAccuracy();
        double eps = this.getRelativeAccuracy();
        while (true) {
            if (FastMath.abs(fc) < FastMath.abs(fb)) {
                a2 = b2;
                b2 = c2;
                c2 = a2;
                fa = fb;
                fb = fc;
                fc = fa;
            }
            double tol = 2.0 * eps * FastMath.abs(b2) + t2;
            double m2 = 0.5 * (c2 - b2);
            if (FastMath.abs(m2) <= tol || Precision.equals(fb, 0.0)) {
                return b2;
            }
            if (FastMath.abs(e2) < tol || FastMath.abs(fa) <= FastMath.abs(fb)) {
                e2 = d2 = m2;
            } else {
                double q2;
                double p2;
                double s2 = fb / fa;
                if (a2 == c2) {
                    p2 = 2.0 * m2 * s2;
                    q2 = 1.0 - s2;
                } else {
                    q2 = fa / fc;
                    double r2 = fb / fc;
                    p2 = s2 * (2.0 * m2 * q2 * (q2 - r2) - (b2 - a2) * (r2 - 1.0));
                    q2 = (q2 - 1.0) * (r2 - 1.0) * (s2 - 1.0);
                }
                if (p2 > 0.0) {
                    q2 = -q2;
                } else {
                    p2 = -p2;
                }
                s2 = e2;
                e2 = d2;
                if (p2 >= 1.5 * m2 * q2 - FastMath.abs(tol * q2) || p2 >= FastMath.abs(0.5 * s2 * q2)) {
                    e2 = d2 = m2;
                } else {
                    d2 = p2 / q2;
                }
            }
            a2 = b2;
            fa = fb;
            b2 = FastMath.abs(d2) > tol ? (b2 += d2) : (m2 > 0.0 ? (b2 += tol) : (b2 -= tol));
            fb = this.computeObjectiveValue(b2);
            if (!(fb > 0.0 && fc > 0.0) && (!(fb <= 0.0) || !(fc <= 0.0))) continue;
            c2 = a2;
            fc = fa;
            e2 = d2 = b2 - a2;
        }
    }
}

