/*
 * Decompiled with CFR 0.152.
 */
package gde.utils;

import gde.GDE;
import gde.device.DataTypes;
import gde.io.DataParser;
import gde.log.Level;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Point;

public class StringHelper {
    static final Logger log = Logger.getLogger(StringHelper.class.getName());

    public static HashMap<String, String> splitString(String line, String delimiter, String[] hashKeys) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (line != null && line.length() > 5) {
            String value;
            String tmpStr = line;
            int endindex = 0;
            while ((endindex = tmpStr.indexOf(delimiter)) != -1) {
                for (String key : hashKeys) {
                    if (!tmpStr.startsWith(key)) continue;
                    value = tmpStr.substring(key.length(), endindex).trim();
                    if (value.startsWith("=")) {
                        value = value.substring(1).trim();
                    }
                    resultMap.put(key, value);
                    break;
                }
                tmpStr = tmpStr.substring(endindex + delimiter.length(), tmpStr.length());
            }
            for (String key : hashKeys) {
                if (!tmpStr.startsWith(key)) continue;
                value = tmpStr.substring(key.length()).trim();
                if (value.startsWith("=")) {
                    value = value.substring(1).trim();
                }
                resultMap.put(key, value);
                break;
            }
            if (log.isLoggable(Level.FINER)) {
                for (String key : hashKeys) {
                    log.log(Level.FINER, key + " = " + resultMap.get(key));
                }
            }
        }
        return resultMap;
    }

    public static String[] splitString(String line, String delimiter, String stripString) {
        Vector<String> result = new Vector<String>();
        if (line != null && line.length() > 5) {
            String tmpStr = line.endsWith(delimiter) ? line.substring(0, line.lastIndexOf(delimiter)) : line;
            int endindex = 0;
            while ((endindex = tmpStr.indexOf(delimiter)) != -1) {
                String tmp = tmpStr.substring(0, endindex);
                if (tmp.startsWith(stripString)) {
                    tmp = tmp.substring(stripString.length());
                } else if (tmp.endsWith(stripString)) {
                    tmp = tmp.substring(0, tmp.indexOf(stripString));
                }
                result.add(tmp);
                tmpStr = tmpStr.substring(endindex + delimiter.length(), tmpStr.length());
            }
            if (tmpStr.length() > 0) {
                if (tmpStr.startsWith(stripString)) {
                    tmpStr = tmpStr.substring(stripString.length());
                } else if (tmpStr.endsWith(stripString)) {
                    tmpStr = tmpStr.substring(0, tmpStr.indexOf(stripString));
                }
                result.add(tmpStr);
            }
            if (log.isLoggable(Level.FINER)) {
                for (String string : result) {
                    log.log(Level.FINER, stripString + " = " + string);
                }
            }
        }
        return result.toArray(new String[0]);
    }

    public static String getDateAndTime() {
        return new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(new Date().getTime());
    }

    public static String getDateAndTime(String format) {
        return new SimpleDateFormat(format).format(new Date().getTime());
    }

    public static String getDate() {
        return new SimpleDateFormat("yyyy-MM-dd").format(new Date());
    }

    public static Date getDate(String dateString) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd").parse(dateString);
        }
        catch (ParseException e) {
            return new Date();
        }
    }

    public static String getFormatedTime(String format, long millisec) {
        return new SimpleDateFormat(format).format(millisec);
    }

    public static String getFormatedDuration(String format, long millisec) {
        if (millisec > 346896000000L) {
            throw new UnsupportedOperationException("use getFormatedTime instead");
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.getTimeZone().setRawOffset(0);
        return sdf.format(millisec);
    }

    @Deprecated
    public static String getFormatedLatLonWithMinutes(String format, int value) {
        return String.format(format, value / 1000000, (double)(value % 1000000) / 10000.0);
    }

    public static String getFormatedWithMinutes(String format, double translatedValue) {
        String sign = translatedValue < 0.0 && (int)translatedValue == 0 ? "-" : "";
        return String.format(sign + format, (int)translatedValue, Math.abs(translatedValue % 1.0 * 60.0));
    }

    public static String removeBlanks(String inputString) {
        String[] tmpDev = inputString.split(" ");
        StringBuilder sb = new StringBuilder();
        for (String tmp : tmpDev) {
            sb.append(tmp);
        }
        return sb.toString();
    }

    public static String intArrayToString(Integer[] values) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; values != null && i < values.length; ++i) {
            sb.append(values[i]);
            if (i == values.length - 1) continue;
            sb.append(';');
        }
        return sb.toString();
    }

    public static String intArrayToString(int[] values) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; values != null && i < values.length; ++i) {
            sb.append(values[i]);
            if (i == values.length - 1) continue;
            sb.append(';');
        }
        return sb.toString();
    }

    public static int[] stringToIntArray(String values) {
        String[] stringValues = values.split(";");
        int[] array = new int[stringValues.length];
        for (int i = 0; i < stringValues.length && stringValues.length > 1; ++i) {
            array[i] = Integer.valueOf(stringValues[i].trim());
        }
        return array;
    }

    public static byte[] byteString2ByteArray(String values) {
        byte[] array = new byte[(values.length() + 1) / 2];
        int i = 0;
        int j = 0;
        while (i < array.length) {
            String subStr;
            try {
                subStr = values.substring(j, j + 2);
            }
            catch (Exception e) {
                subStr = values.substring(j, j + 1);
            }
            array[i] = Byte.valueOf(subStr, 16);
            ++i;
            j += 2;
        }
        return array;
    }

    public static String pointArrayToString(Point[] points) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; points != null && i < points.length; ++i) {
            sb.append(points[i].x).append(':').append(points[i].y);
            if (i == points.length - 1) continue;
            sb.append(';');
        }
        return sb.toString();
    }

    public static Point[] stringToPointArray(String values) {
        String[] stringValues = values.split(";");
        Point[] points = new Point[stringValues.length];
        for (int i = 0; i < points.length && points.length > 1; ++i) {
            String[] xy = stringValues[i].split(":");
            points[i] = new Point(Integer.valueOf(xy[0].trim()).intValue(), Integer.valueOf(xy[1].trim()).intValue());
        }
        return points;
    }

    public static void printSWTKeyCode(KeyEvent evt) {
        Object keyCode = "" + evt.character;
        switch (evt.keyCode) {
            case 65536: {
                keyCode = "ALT";
                break;
            }
            case 131072: {
                keyCode = "SHIFT";
                break;
            }
            case 262144: {
                keyCode = "CONTROL";
                break;
            }
            case 0x400000: {
                keyCode = "COMMAND";
                break;
            }
            case 0x1000001: {
                keyCode = "ARROW_UP";
                break;
            }
            case 0x1000002: {
                keyCode = "ARROW_DOWN";
                break;
            }
            case 0x1000003: {
                keyCode = "ARROW_LEFT";
                break;
            }
            case 0x1000004: {
                keyCode = "ARROW_RIGHT";
                break;
            }
            case 0x1000005: {
                keyCode = "PAGE_UP";
                break;
            }
            case 0x1000006: {
                keyCode = "PAGE_DOWN";
                break;
            }
            case 0x1000007: {
                keyCode = "HOME";
                break;
            }
            case 0x1000008: {
                keyCode = "END";
                break;
            }
            case 0x1000009: {
                keyCode = "INSERT";
                break;
            }
            case 8: {
                keyCode = "BS";
                break;
            }
            case 13: {
                keyCode = "CR";
                break;
            }
            case 127: {
                keyCode = "DEL";
                break;
            }
            case 27: {
                keyCode = "ESC";
                break;
            }
            case 10: {
                keyCode = "LF";
                break;
            }
            case 9: {
                keyCode = "TAB";
                break;
            }
            case 0x100000A: {
                keyCode = "F1";
                break;
            }
            case 0x100000B: {
                keyCode = "F2";
                break;
            }
            case 0x100000C: {
                keyCode = "F3";
                break;
            }
            case 0x100000D: {
                keyCode = "F4";
                break;
            }
            case 0x100000E: {
                keyCode = "F5";
                break;
            }
            case 0x100000F: {
                keyCode = "F6";
                break;
            }
            case 0x1000010: {
                keyCode = "F7";
                break;
            }
            case 0x1000011: {
                keyCode = "F8";
                break;
            }
            case 0x1000012: {
                keyCode = "F9";
                break;
            }
            case 0x1000013: {
                keyCode = "F10";
                break;
            }
            case 0x1000014: {
                keyCode = "F11";
                break;
            }
            case 0x1000015: {
                keyCode = "F12";
                break;
            }
            case 0x1000016: {
                keyCode = "F13";
                break;
            }
            case 0x1000017: {
                keyCode = "F14";
                break;
            }
            case 0x1000018: {
                keyCode = "F15";
                break;
            }
            case 16777259: {
                keyCode = "KEYPAD_ADD";
                break;
            }
            case 16777261: {
                keyCode = "KEYPAD_SUBTRACT";
                break;
            }
            case 16777258: {
                keyCode = "KEYPAD_MULTIPLY";
                break;
            }
            case 16777263: {
                keyCode = "KEYPAD_DIVIDE";
                break;
            }
            case 16777262: {
                keyCode = "KEYPAD_DECIMAL";
                break;
            }
            case 0x1000050: {
                keyCode = "KEYPAD_CR";
                break;
            }
            case 0x1000030: {
                keyCode = "KEYPAD_0";
                break;
            }
            case 0x1000031: {
                keyCode = "KEYPAD_1";
                break;
            }
            case 16777266: {
                keyCode = "KEYPAD_2";
                break;
            }
            case 0x1000033: {
                keyCode = "KEYPAD_3";
                break;
            }
            case 16777268: {
                keyCode = "KEYPAD_4";
                break;
            }
            case 16777269: {
                keyCode = "KEYPAD_5";
                break;
            }
            case 16777270: {
                keyCode = "KEYPAD_6";
                break;
            }
            case 16777271: {
                keyCode = "KEYPAD_7";
                break;
            }
            case 16777272: {
                keyCode = "KEYPAD_8";
                break;
            }
            case 16777273: {
                keyCode = "KEYPAD_9";
                break;
            }
            case 16777277: {
                keyCode = "KEYPAD_EQUAL";
                break;
            }
            case 16777298: {
                keyCode = "CAPS_LOCK";
                break;
            }
            case 16777299: {
                keyCode = "NUM_LOCK";
                break;
            }
            case 16777300: {
                keyCode = "SCROLL_LOCK";
                break;
            }
            case 0x1000055: {
                keyCode = "PAUSE";
                break;
            }
            case 16777302: {
                keyCode = "BREAK";
                break;
            }
            case 16777303: {
                keyCode = "PRINT_SCREEN";
                break;
            }
            case 0x1000051: {
                keyCode = "HELP";
                break;
            }
        }
        log.log(Level.INFO, "keyCode = SWT." + (String)keyCode);
    }

    public static boolean verifyPortInput(String eventText) {
        char[] chars = new char[eventText.length()];
        eventText.getChars(0, chars.length, chars, 0);
        for (int i = 0; i < chars.length; ++i) {
            log.log(Level.FINER, "\"" + chars[i] + "\"");
            if (GDE.IS_WINDOWS) {
                if ('0' <= chars[i] && chars[i] <= '9' || 'c' == chars[i] || 'C' == chars[i] || 'o' == chars[i] || 'O' == chars[i] || 'm' == chars[i] || 'M' == chars[i] || ' ' == chars[i]) continue;
                return false;
            }
            if (GDE.IS_LINUX) {
                if ('0' <= chars[i] && chars[i] <= '9' || '/' == chars[i] || 'd' == chars[i] || 'e' == chars[i] || 'v' == chars[i] || 't' == chars[i] || 'y' == chars[i] || ' ' == chars[i] || 'U' == chars[i] || 'S' == chars[i] || 'B' == chars[i]) continue;
                return false;
            }
            if (!GDE.IS_MAC) continue;
        }
        return true;
    }

    public static boolean verifyTypedInput(DataTypes useType, String eventText) {
        boolean doIt = true;
        switch (useType) {
            case INTEGER: {
                try {
                    if (eventText.equals("-")) {
                        return doIt;
                    }
                    if (eventText.equals("")) {
                        eventText = "0";
                    }
                    Integer.parseInt(eventText.trim());
                }
                catch (Exception e) {
                    doIt = false;
                }
                break;
            }
            case DOUBLE: {
                try {
                    if (eventText.equals("-") || eventText.equals(",") || eventText.equals(".") || eventText.equals("")) {
                        doIt = true;
                        break;
                    }
                    Double.parseDouble(eventText.replace(",", ".").trim());
                }
                catch (Exception e) {
                    doIt = false;
                }
                break;
            }
            case BOOLEAN: {
                try {
                    Boolean.parseBoolean(eventText.trim());
                }
                catch (Exception e) {
                    doIt = false;
                }
                break;
            }
            case HEXADECIMAL: {
                try {
                    doIt = eventText.chars().allMatch(c -> "0123456789ABCDEFabcdef".indexOf(c) >= 0);
                }
                catch (Exception e) {
                    doIt = false;
                }
                break;
            }
            default: {
                doIt = true;
            }
        }
        return doIt;
    }

    public static String verifyTypedString(DataTypes useType, String eventText) {
        Object result = eventText;
        while (((String)result).startsWith("0")) {
            result = ((String)result).substring(1);
        }
        switch (useType) {
            case INTEGER: {
                try {
                    if (eventText.replace(',', '.').contains(".")) {
                        result = eventText.substring(0, eventText.indexOf(46));
                    }
                    Integer.parseInt((String)result);
                }
                catch (Exception e) {
                    result = "0";
                }
                break;
            }
            case DOUBLE: {
                try {
                    if (!eventText.replace(',', '.').contains(".")) {
                        result = eventText + ".0";
                    }
                    if (((String)result).startsWith(".")) {
                        result = "0" + (String)result;
                    }
                    Double.parseDouble((String)result);
                }
                catch (Exception e) {
                    result = "1.0";
                }
                break;
            }
            case BOOLEAN: {
                if (((String)result).equals("true") || ((String)result).equals("false")) break;
                result = "true";
                break;
            }
        }
        return result;
    }

    public static String printBinary(byte inByte, boolean newLine) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 8; ++i) {
            sb.append((0x80 & inByte) >> 7);
            inByte = (byte)(inByte << 1);
        }
        if (newLine) {
            sb.append(GDE.LINE_SEPARATOR);
        }
        return sb.toString();
    }

    public static boolean verifyHexAsString(String eventText) {
        char[] chars = new char[eventText.length()];
        eventText.getChars(0, chars.length, chars, 0);
        for (int i = 0; i < chars.length; ++i) {
            log.log(Level.FINER, "\"" + chars[i] + "\"");
            if ('0' <= chars[i] && chars[i] <= '9' || 'a' == chars[i] || 'A' == chars[i] || 'b' == chars[i] || 'B' == chars[i] || 'c' == chars[i] || 'C' == chars[i] || 'd' == chars[i] || 'D' == chars[i] || 'e' == chars[i] || 'E' == chars[i] || 'f' == chars[i] || 'F' == chars[i]) continue;
            return false;
        }
        return true;
    }

    public static String byte2CharString(byte[] bytes, int size) {
        StringBuffer sb = new StringBuffer().append("[").append(size).append("], ");
        for (int i = 0; i < size; ++i) {
            sb.append(String.format("%c", Character.valueOf((char)bytes[i])));
        }
        return sb.toString();
    }

    public static String byte2CharString(byte[] bytes, int start, int size) {
        int i;
        StringBuffer sb = new StringBuffer().append("[").append(start).append(";").append(size).append("], ");
        int n = i = start >= 0 ? start : 0;
        while (i < size) {
            sb.append(String.format("%c", Character.valueOf((char)bytes[i])));
            ++i;
        }
        return sb.toString();
    }

    public static int byte2hex2int(byte[] bytes, int start, int size) {
        StringBuffer sb = new StringBuffer();
        for (int i = start; i < size + start; ++i) {
            sb.append(String.format("%c", Character.valueOf((char)bytes[i])));
        }
        return Integer.parseInt(sb.toString(), 16);
    }

    public static String fourDigitsRunningNumber(int size) {
        StringBuffer sb = new StringBuffer().append("[").append(String.format("%04d", size)).append("], ");
        for (int i = 0; i < size; ++i) {
            sb.append(String.format("%4d", i));
        }
        return sb.toString();
    }

    public static String byte2Hex4CharString(byte[] bytes, int size) {
        StringBuffer sb = new StringBuffer().append("[").append(String.format("%04d", size)).append("], ");
        for (int i = 0; i < size; ++i) {
            sb.append(String.format("  %02X", bytes[i]));
        }
        return sb.toString();
    }

    public static String byte2Hex2CharString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (byte b : bytes) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }

    public static String byte2Hex2CharString(byte[] bytes, int size) {
        StringBuffer sb = new StringBuffer().append("[").append(String.format("%3d", size)).append("], ");
        for (int i = 0; i < size; ++i) {
            sb.append(String.format(" %02X", bytes[i]));
        }
        return sb.toString();
    }

    public static String byte2Hex2CharString(byte[] bytes, int start, int size) {
        StringBuffer sb = new StringBuffer().append("[").append(String.format("%3d", size)).append("], ");
        for (int i = start; i < size + start; ++i) {
            sb.append(String.format(" %02X", bytes[i]));
        }
        return sb.toString();
    }

    public static String bcdEncodeInverted(byte[] bytes, int start, int size) {
        StringBuffer sb = new StringBuffer();
        for (int i = start + size - 1; i >= start; --i) {
            sb.append(String.format("%02X", bytes[i]));
        }
        if (Pattern.compile(".*[ABCDEF]").matcher(sb.toString()).find()) {
            log.log(Level.WARNING, "invalid input " + String.valueOf(sb));
            return "0";
        }
        return sb.toString();
    }

    public static String byte2FourDigitsIntegerString(byte[] bytes) {
        StringBuffer sb = new StringBuffer().append("[").append(String.format("%3d", bytes.length)).append("], ");
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(String.format("%4d", bytes[i] & 0xFF));
        }
        return sb.toString();
    }

    public static String byte2FourDigitsIntegerString(byte[] bytes, byte subtract, int offset, int length) {
        StringBuffer sb = new StringBuffer().append("[").append(String.format("%3d", bytes.length)).append("], ");
        for (int i = offset; i < length; ++i) {
            sb.append(String.format("%4d", (bytes[i] & 0xFF) + subtract));
        }
        return sb.toString();
    }

    public static String integer2Hex4ByteString(int[] values) {
        StringBuilder sb = new StringBuilder();
        for (int value : values) {
            sb.append(String.format("%04X", value));
        }
        if (log.isLoggable(java.util.logging.Level.FINE)) {
            log.log(java.util.logging.Level.FINE, sb.toString());
        }
        return sb.toString();
    }

    public static byte[] convert2ByteArray(String twoCharsPerByte) {
        int length = ((String)twoCharsPerByte).length() / 2;
        byte[] buffer = new byte[length];
        twoCharsPerByte = (String)twoCharsPerByte + "0";
        int i = 0;
        int j = 0;
        while (i < length) {
            buffer[i] = (byte)Integer.parseInt(((String)twoCharsPerByte).substring(j, j + 2), 16);
            ++i;
            j += 2;
        }
        return buffer;
    }

    public static String convert2CharString(byte[] buffer) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < buffer.length; ++i) {
            if (buffer[i] == 12) {
                sb.append("<FF>");
                continue;
            }
            if (buffer[i] == 13) {
                sb.append("<CR>");
                continue;
            }
            if (buffer[i] == 6) {
                sb.append("<ACK>");
                continue;
            }
            if (buffer[i] == 21) {
                sb.append("<NAK>");
                continue;
            }
            if (buffer[i] == -1) {
                sb.append('|');
                continue;
            }
            if (i == buffer.length - 5) {
                sb.append("|").append((char)buffer[i]);
                continue;
            }
            sb.append((char)buffer[i]);
        }
        return sb.toString();
    }

    public static String[] enumValues2StringArray(Object[] enumValues) {
        Vector<String> tmpVec = new Vector<String>();
        for (Object element : enumValues) {
            tmpVec.add(element.toString());
        }
        return tmpVec.toArray(new String[0]);
    }

    public static String listToString(List<String> list, char separator) {
        Iterator<String> iter = list.iterator();
        StringBuffer measurements = new StringBuffer(iter.next());
        while (iter.hasNext()) {
            measurements.append(separator).append(iter.next());
        }
        return measurements.toString();
    }

    public static List<String> stringToList(String string, char separator) {
        return Arrays.asList(string.split("" + separator));
    }

    public static String[] int2Array(int items) {
        String[] itemNames = new String[items];
        for (int i = 0; i < items; ++i) {
            itemNames[i] = Integer.valueOf(i + 1).toString();
        }
        return itemNames;
    }

    public static String byte2bin_8(byte value) {
        StringBuilder sb = new StringBuilder().append("binary : ");
        int i = 0;
        int j = 128;
        while (i < 8) {
            if ((value & j) > 0) {
                sb.append("1");
            } else {
                sb.append("0");
            }
            ++i;
            j /= 2;
        }
        return sb.toString();
    }

    public static String int2bin_16(int value) {
        StringBuilder sb = new StringBuilder().append("binary : ");
        int i = 0;
        int j = 32768;
        while (i < 16) {
            if ((value & j) > 0) {
                sb.append("1");
            } else {
                sb.append("0");
            }
            ++i;
            j /= 2;
        }
        return sb.toString();
    }

    public static String int2bin_32(long value) {
        StringBuilder sb = new StringBuilder().append("binary : ");
        int i = 0;
        int j = Integer.MIN_VALUE;
        while (i < 32) {
            if ((value & (long)j) > 0L) {
                sb.append("1");
            } else {
                sb.append("0");
            }
            ++i;
            j /= 2;
        }
        return sb.toString();
    }

    public static void printMemInt(String name, byte[] buffer, int startIndex, int _byte, int width, int count) {
        System.out.println(String.format("%s 0x%04X", name, startIndex));
        for (int i = 0; i < count; ++i) {
            switch (_byte) {
                case 1: {
                    int j;
                    for (j = 0; j < width; ++j) {
                        System.out.print(String.format("%02d", buffer[startIndex]));
                        ++startIndex;
                    }
                    break;
                }
                case 2: {
                    int j;
                    for (j = 0; j < width; ++j) {
                        System.out.print(DataParser.parse2Short(buffer, startIndex));
                        startIndex += 2;
                    }
                    break;
                }
            }
            System.out.print("; ");
        }
        System.out.println();
    }

    public static void printMemHex(String name, byte[] buffer, int startIndex, int _byte, int width, int count) {
        System.out.println(String.format("%s 0x%04X", name, startIndex));
        for (int i = 0; i < count; ++i) {
            switch (_byte) {
                case 1: {
                    int j;
                    for (j = 0; j < width; ++j) {
                        System.out.print(String.format("%02x", buffer[startIndex]));
                        ++startIndex;
                    }
                    break;
                }
                case 2: {
                    int j;
                    for (j = 0; j < width; ++j) {
                        System.out.print(String.format("%02x%02x", buffer[startIndex], buffer[startIndex + 1]));
                        startIndex += 2;
                    }
                    break;
                }
            }
            System.out.print("; ");
        }
        System.out.println();
    }

    public static void printMemChar(String name, byte[] buffer, int startIndex, int _byte, int width, int count) {
        System.out.println(String.format("%s 0x%04X", name, startIndex));
        for (int i = 0; i < count; ++i) {
            switch (_byte) {
                case 1: {
                    int j;
                    for (j = 0; j < width; ++j) {
                        System.out.print(String.format("%c", buffer[startIndex]));
                        ++startIndex;
                    }
                    break;
                }
                case 2: {
                    int j;
                    for (j = 0; j < width; ++j) {
                        System.out.print(String.format("%c%c", buffer[startIndex], buffer[startIndex + 1]));
                        startIndex += 2;
                    }
                    break;
                }
            }
            System.out.print("; ");
        }
        System.out.println();
    }

    public static String transfer(String array) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length(); ++i) {
            sb.append(array.charAt(i));
        }
        return sb.toString();
    }

    public static String center(String s, int size) {
        return StringHelper.center(s, size, ' ');
    }

    public static String center(String s, int size, char pad) {
        if (s == null || size <= s.length()) {
            return s;
        }
        StringBuilder sb = new StringBuilder(size);
        for (int i = 0; i < (size - s.length()) / 2; ++i) {
            sb.append(pad);
        }
        sb.append(s);
        while (sb.length() < size) {
            sb.append(pad);
        }
        return sb.toString();
    }

    public static String arrayToString(Object[] inputArray) {
        StringBuffer sb = new StringBuffer();
        for (Object object : inputArray) {
            sb.append(object).append(", ");
        }
        if (inputArray.length > 2) {
            sb.deleteCharAt(sb.length() - 2);
        }
        return sb.toString();
    }

    public static String arrayToString(int[] inputArray) {
        StringBuffer sb = new StringBuffer();
        int[] nArray = inputArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer object = nArray[i];
            sb.append(object).append(", ");
        }
        return sb.toString();
    }

    public static String arrayToString1000(int[] inputArray) {
        StringBuffer sb = new StringBuffer();
        int[] nArray = inputArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer object = nArray[i];
            sb.append(object / 1000).append(", ");
        }
        return sb.toString();
    }

    public static Object arrayToString(byte[] inputArray) {
        StringBuffer sb = new StringBuffer();
        byte[] byArray = inputArray;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            Byte object = byArray[i];
            sb.append(object).append(", ");
        }
        return sb.toString();
    }
}

