/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.CANDIDATEFORM;
import org.eclipse.swt.internal.win32.COMPOSITIONFORM;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.IME;
import org.eclipse.swt.widgets.Widget;

public class Caret
extends Widget {
    Canvas parent;
    int x;
    int y;
    int width;
    int height;
    boolean moved;
    boolean resized;
    boolean isVisible;
    Image image;
    Font font;
    LOGFONT oldFont;

    public Caret(Canvas parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget();
    }

    void createWidget() {
        this.isVisible = true;
        if (this.parent.getCaret() == null) {
            this.parent.setCaret(this);
        }
    }

    long defaultFont() {
        long hwnd = this.parent.handle;
        long hwndIME = OS.ImmGetDefaultIMEWnd(hwnd);
        long hFont = 0L;
        if (hwndIME != 0L) {
            hFont = OS.SendMessage(hwndIME, 49, 0L, 0L);
        }
        if (hFont == 0L) {
            hFont = OS.SendMessage(hwnd, 49, 0L, 0L);
        }
        if (hFont == 0L) {
            return this.parent.defaultFont();
        }
        return hFont;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    Rectangle getBoundsInPixels() {
        int[] buffer;
        if (this.image != null) {
            Rectangle rect = this.image.getBoundsInPixels();
            return new Rectangle(this.x, this.y, rect.width, rect.height);
        }
        if (this.width == 0 && OS.SystemParametersInfo(8198, 0, buffer = new int[1], 0)) {
            return new Rectangle(this.x, this.y, buffer[0], this.height);
        }
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Font getFont() {
        this.checkWidget();
        if (this.font == null) {
            long hFont = this.defaultFont();
            return Font.win32_new(this.display, hFont);
        }
        return this.font;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Point getLocation() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getLocationInPixels());
    }

    Point getLocationInPixels() {
        return new Point(this.x, this.y);
    }

    public Canvas getParent() {
        this.checkWidget();
        return this.parent;
    }

    public Point getSize() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getSizeInPixels());
    }

    Point getSizeInPixels() {
        int[] buffer;
        if (this.image != null) {
            Rectangle rect = this.image.getBoundsInPixels();
            return new Point(rect.width, rect.height);
        }
        if (this.width == 0 && OS.SystemParametersInfo(8198, 0, buffer = new int[1], 0)) {
            return new Point(buffer[0], this.height);
        }
        return new Point(this.width, this.height);
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.isVisible;
    }

    boolean hasFocus() {
        return this.parent.handle == OS.GetFocus();
    }

    boolean isFocusCaret() {
        return this.parent.caret == this && this.hasFocus();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.isVisible && this.parent.isVisible() && this.hasFocus();
    }

    void killFocus() {
        OS.DestroyCaret();
        this.restoreIMEFont();
    }

    void move() {
        this.moved = false;
        if (!OS.SetCaretPos(this.x, this.y)) {
            return;
        }
        this.resizeIME();
    }

    void resizeIME() {
        if (!OS.IsDBLocale) {
            return;
        }
        POINT ptCurrentPos = new POINT();
        if (!OS.GetCaretPos(ptCurrentPos)) {
            return;
        }
        long hwnd = this.parent.handle;
        long hIMC = OS.ImmGetContext(hwnd);
        IME ime = this.parent.getIME();
        if (ime != null && ime.isInlineEnabled()) {
            Point size = this.getSizeInPixels();
            CANDIDATEFORM lpCandidate = new CANDIDATEFORM();
            lpCandidate.dwStyle = 128;
            lpCandidate.ptCurrentPos = ptCurrentPos;
            lpCandidate.rcArea = new RECT();
            OS.SetRect(lpCandidate.rcArea, ptCurrentPos.x, ptCurrentPos.y, ptCurrentPos.x + size.x, ptCurrentPos.y + size.y);
            OS.ImmSetCandidateWindow(hIMC, lpCandidate);
        } else {
            RECT rect = new RECT();
            OS.GetClientRect(hwnd, rect);
            COMPOSITIONFORM lpCompForm = new COMPOSITIONFORM();
            lpCompForm.dwStyle = 1;
            lpCompForm.x = ptCurrentPos.x;
            lpCompForm.y = ptCurrentPos.y;
            lpCompForm.left = rect.left;
            lpCompForm.right = rect.right;
            lpCompForm.top = rect.top;
            lpCompForm.bottom = rect.bottom;
            OS.ImmSetCompositionWindow(hIMC, lpCompForm);
        }
        OS.ImmReleaseContext(hwnd, hIMC);
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.parent != null && this == this.parent.caret) {
            if (!this.parent.isDisposed()) {
                this.parent.setCaret(null);
            } else {
                this.parent.caret = null;
            }
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.image = null;
        this.font = null;
        this.oldFont = null;
    }

    void resize() {
        int[] buffer;
        this.resized = false;
        long hwnd = this.parent.handle;
        OS.DestroyCaret();
        long hBitmap = this.image != null ? this.image.handle : 0L;
        int width = this.width;
        if (this.image == null && width == 0 && OS.SystemParametersInfo(8198, 0, buffer = new int[1], 0)) {
            width = buffer[0];
        }
        OS.CreateCaret(hwnd, hBitmap, width, this.height);
        OS.SetCaretPos(this.x, this.y);
        OS.ShowCaret(hwnd);
        this.move();
    }

    void restoreIMEFont() {
        if (!OS.IsDBLocale) {
            return;
        }
        if (this.oldFont == null) {
            return;
        }
        long hwnd = this.parent.handle;
        long hIMC = OS.ImmGetContext(hwnd);
        OS.ImmSetCompositionFont(hIMC, this.oldFont);
        OS.ImmReleaseContext(hwnd, hIMC);
        this.oldFont = null;
    }

    public void setBounds(int x2, int y2, int width, int height) {
        this.checkWidget();
        this.setBoundsInPixels(DPIUtil.autoScaleUp(x2), DPIUtil.autoScaleUp(y2), DPIUtil.autoScaleUp(width), DPIUtil.autoScaleUp(height));
    }

    void setBoundsInPixels(int x2, int y2, int width, int height) {
        boolean sameExtent;
        boolean samePosition = this.x == x2 && this.y == y2;
        boolean bl = sameExtent = this.width == width && this.height == height;
        if (samePosition && sameExtent) {
            return;
        }
        this.x = x2;
        this.y = y2;
        this.width = width;
        this.height = height;
        if (sameExtent) {
            this.moved = true;
            if (this.isVisible && this.hasFocus()) {
                this.move();
            }
        } else {
            this.resized = true;
            if (this.isVisible && this.hasFocus()) {
                this.resize();
            }
        }
    }

    public void setBounds(Rectangle rect) {
        if (rect == null) {
            this.error(4);
        }
        this.setBoundsInPixels(DPIUtil.autoScaleUp(rect));
    }

    void setBoundsInPixels(Rectangle rect) {
        this.setBoundsInPixels(rect.x, rect.y, rect.width, rect.height);
    }

    void setFocus() {
        int[] buffer;
        long hwnd = this.parent.handle;
        long hBitmap = 0L;
        if (this.image != null) {
            hBitmap = this.image.handle;
        }
        int width = this.width;
        if (this.image == null && width == 0 && OS.SystemParametersInfo(8198, 0, buffer = new int[1], 0)) {
            width = buffer[0];
        }
        OS.CreateCaret(hwnd, hBitmap, width, this.height);
        this.move();
        this.setIMEFont();
        if (this.isVisible) {
            OS.ShowCaret(hwnd);
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        this.font = font;
        if (this.hasFocus()) {
            this.setIMEFont();
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        if (this.isVisible && this.hasFocus()) {
            this.resize();
        }
    }

    void setIMEFont() {
        LOGFONT logFont;
        if (!OS.IsDBLocale) {
            return;
        }
        long hFont = 0L;
        if (this.font != null) {
            hFont = this.font.handle;
        }
        if (hFont == 0L) {
            hFont = this.defaultFont();
        }
        long hwnd = this.parent.handle;
        long hIMC = OS.ImmGetContext(hwnd);
        if (this.oldFont == null) {
            this.oldFont = new LOGFONT();
            if (!OS.ImmGetCompositionFont(hIMC, this.oldFont)) {
                this.oldFont = null;
            }
        }
        if (OS.GetObject(hFont, LOGFONT.sizeof, logFont = new LOGFONT()) != 0) {
            OS.ImmSetCompositionFont(hIMC, logFont);
        }
        OS.ImmReleaseContext(hwnd, hIMC);
    }

    public void setLocation(int x2, int y2) {
        this.checkWidget();
        this.setLocationInPixels(DPIUtil.autoScaleUp(x2), DPIUtil.autoScaleUp(y2));
    }

    void setLocationInPixels(int x2, int y2) {
        if (this.x == x2 && this.y == y2) {
            return;
        }
        this.x = x2;
        this.y = y2;
        this.moved = true;
        if (this.isVisible && this.hasFocus()) {
            this.move();
        }
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        location = DPIUtil.autoScaleUp(location);
        this.setLocationInPixels(location.x, location.y);
    }

    public void setSize(int width, int height) {
        this.checkWidget();
        this.setSizeInPixels(DPIUtil.autoScaleUp(width), DPIUtil.autoScaleUp(height));
    }

    void setSizeInPixels(int width, int height) {
        if (this.width == width && this.height == height) {
            return;
        }
        this.width = width;
        this.height = height;
        this.resized = true;
        if (this.isVisible && this.hasFocus()) {
            this.resize();
        }
    }

    public void setSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        size = DPIUtil.autoScaleUp(size);
        this.setSizeInPixels(size.x, size.y);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (visible == this.isVisible) {
            return;
        }
        this.isVisible = visible;
        long hwnd = this.parent.handle;
        if (OS.GetFocus() != hwnd) {
            return;
        }
        if (!this.isVisible) {
            OS.HideCaret(hwnd);
        } else {
            if (this.resized) {
                this.resize();
            } else if (this.moved) {
                this.move();
            }
            OS.ShowCaret(hwnd);
        }
    }
}

