/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WebKit;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IPropertyBag;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.ole.win32.VARIANT;
import org.eclipse.swt.internal.webkit.IWebDataSource;
import org.eclipse.swt.internal.webkit.IWebFrame;
import org.eclipse.swt.internal.webkit.IWebFramePrivate;
import org.eclipse.swt.internal.webkit.IWebOpenPanelResultListener;
import org.eclipse.swt.internal.webkit.IWebURLRequest;
import org.eclipse.swt.internal.webkit.IWebView;
import org.eclipse.swt.internal.webkit.WebKit_win32;
import org.eclipse.swt.internal.win32.DOCINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PRINTDLG;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

class WebUIDelegate {
    COMObject iWebUIDelegate;
    int refCount = 0;
    String lastHoveredLinkURL;
    Browser browser;
    Point size;
    Point location;
    boolean menuBar = true;
    boolean toolBar = true;
    boolean statusBar = true;
    boolean prompt = true;

    WebUIDelegate(Browser browser) {
        this.createCOMInterfaces();
        this.browser = browser;
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    int canTakeFocus(long sender, int forward, long result2) {
        OS.MoveMemory(result2, new int[]{1}, 4);
        return 0;
    }

    int contextMenuItemsForElement(long sender, long element, long defaultItemsHMenu, long resultHMenu) {
        Point pt = this.browser.getDisplay().getCursorLocation();
        Event event = new Event();
        event.x = pt.x;
        event.y = pt.y;
        this.browser.notifyListeners(35, event);
        if (event.doit) {
            Menu menu2 = this.browser.getMenu();
            if (menu2 != null && !menu2.isDisposed()) {
                if (event.x != pt.x || event.y != pt.y) {
                    menu2.setLocation(event.x, event.y);
                }
                menu2.setVisible(true);
            } else {
                OS.MoveMemory(resultHMenu, new long[]{defaultItemsHMenu}, C.PTR_SIZEOF);
                return 0;
            }
        }
        OS.MoveMemory(resultHMenu, new long[1], C.PTR_SIZEOF);
        return 0;
    }

    void createCOMInterfaces() {
        int[] nArray = new int[66];
        nArray[0] = 2;
        nArray[3] = 3;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 2;
        nArray[9] = 2;
        nArray[10] = 2;
        nArray[11] = 2;
        nArray[12] = 2;
        nArray[13] = 2;
        nArray[14] = 2;
        nArray[15] = 2;
        nArray[16] = 2;
        nArray[17] = 2;
        nArray[18] = 2;
        nArray[19] = 2;
        nArray[20] = 2;
        nArray[21] = 2;
        nArray[22] = 2;
        nArray[23] = 3;
        nArray[24] = 4;
        nArray[25] = 4;
        nArray[26] = 2;
        nArray[27] = 3;
        nArray[28] = 4;
        nArray[29] = 4;
        nArray[30] = 3;
        nArray[31] = 3;
        nArray[32] = 3;
        nArray[33] = 3;
        nArray[34] = 5;
        nArray[35] = 3;
        nArray[36] = 1;
        nArray[37] = 3;
        nArray[38] = 2;
        nArray[39] = 2;
        nArray[40] = 2;
        nArray[41] = 2;
        nArray[42] = 3;
        nArray[43] = 2;
        nArray[44] = 3;
        nArray[45] = 1;
        nArray[46] = 1;
        nArray[49] = 1;
        nArray[50] = 1;
        nArray[51] = 2;
        nArray[52] = 2;
        nArray[53] = 2;
        nArray[54] = 2;
        nArray[55] = 3;
        nArray[56] = 5;
        nArray[57] = 2;
        nArray[58] = 2;
        nArray[59] = 3;
        nArray[60] = 1;
        nArray[61] = 2;
        nArray[62] = 2;
        nArray[63] = 4;
        nArray[64] = 10;
        nArray[65] = 3;
        this.iWebUIDelegate = new COMObject(nArray){

            @Override
            public long method0(long[] args2) {
                return WebUIDelegate.this.QueryInterface(args2[0], args2[1]);
            }

            @Override
            public long method1(long[] args2) {
                return WebUIDelegate.this.AddRef();
            }

            @Override
            public long method2(long[] args2) {
                return WebUIDelegate.this.Release();
            }

            @Override
            public long method3(long[] args2) {
                return WebUIDelegate.this.createWebViewWithRequest(args2[0], args2[1], args2[2]);
            }

            @Override
            public long method4(long[] args2) {
                return WebUIDelegate.this.webViewShow(args2[0]);
            }

            @Override
            public long method5(long[] args2) {
                return WebUIDelegate.this.webViewClose(args2[0]);
            }

            @Override
            public long method6(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method7(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method8(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method9(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method10(long[] args2) {
                return WebUIDelegate.this.setStatusText(args2[0], args2[1]);
            }

            @Override
            public long method11(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method12(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method13(long[] args2) {
                return WebUIDelegate.this.setToolbarsVisible(args2[0], (int)args2[1]);
            }

            @Override
            public long method14(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method15(long[] args2) {
                return WebUIDelegate.this.setStatusBarVisible(args2[0], (int)args2[1]);
            }

            @Override
            public long method16(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method17(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method18(long[] args2) {
                return WebUIDelegate.this.setFrame(args2[0], args2[1]);
            }

            @Override
            public long method19(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method20(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method21(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method22(long[] args2) {
                return WebUIDelegate.this.runJavaScriptAlertPanelWithMessage(args2[0], args2[1]);
            }

            @Override
            public long method23(long[] args2) {
                return WebUIDelegate.this.runJavaScriptConfirmPanelWithMessage(args2[0], args2[1], args2[2]);
            }

            @Override
            public long method24(long[] args2) {
                return WebUIDelegate.this.runJavaScriptTextInputPanelWithPrompt(args2[0], args2[1], args2[2], args2[3]);
            }

            @Override
            public long method25(long[] args2) {
                return WebUIDelegate.this.runBeforeUnloadConfirmPanelWithMessage(args2[0], args2[1], args2[2], args2[3]);
            }

            @Override
            public long method26(long[] args2) {
                return WebUIDelegate.this.runOpenPanelForFileButtonWithResultListener(args2[0], args2[1]);
            }

            @Override
            public long method27(long[] args2) {
                return WebUIDelegate.this.mouseDidMoveOverElement(args2[0], args2[1], (int)args2[2]);
            }

            @Override
            public long method28(long[] args2) {
                return WebUIDelegate.this.contextMenuItemsForElement(args2[0], args2[1], args2[2], args2[3]);
            }

            @Override
            public long method29(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method30(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method31(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method32(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method33(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method34(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method35(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method36(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method37(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method38(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method39(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method40(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method41(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method42(long[] args2) {
                return WebUIDelegate.this.canTakeFocus(args2[0], (int)args2[1], args2[2]);
            }

            @Override
            public long method43(long[] args2) {
                return WebUIDelegate.this.takeFocus(args2[0], (int)args2[1]);
            }

            @Override
            public long method44(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method45(long[] args2) {
                return 0L;
            }

            @Override
            public long method46(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method47(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method48(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method49(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method50(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method51(long[] args2) {
                return WebUIDelegate.this.printFrame(args2[0], args2[1]);
            }

            @Override
            public long method52(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method53(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method54(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method55(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method56(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method57(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method58(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method59(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method60(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method61(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method62(long[] args2) {
                return WebUIDelegate.this.setMenuBarVisible(args2[0], (int)args2[1]);
            }

            @Override
            public long method63(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method64(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method65(long[] args2) {
                return -2147467263L;
            }
        };
    }

    int createWebViewWithRequest(long sender, long request, long webView) {
        WindowEvent newEvent = new WindowEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        newEvent.required = true;
        OpenWindowListener[] openWindowListeners = this.browser.webBrowser.openWindowListeners;
        int i2 = 0;
        while (i2 < openWindowListeners.length) {
            openWindowListeners[i2].open(newEvent);
            ++i2;
        }
        IWebView iwebview = null;
        Widget browser = null;
        if (newEvent.browser != null && newEvent.browser.webBrowser instanceof WebKit) {
            browser = newEvent.browser;
        }
        if (browser != null && !browser.isDisposed()) {
            iwebview = ((WebKit)((Browser)browser).webBrowser).webView;
            OS.MoveMemory(webView, new long[]{iwebview.getAddress()}, C.PTR_SIZEOF);
            if (request != 0L) {
                IWebURLRequest req = new IWebURLRequest(request);
                long[] result2 = new long[1];
                int hr = req.URL(result2);
                if (hr != 0 || result2[0] == 0L) {
                    return 0;
                }
                String sUrl = WebKit.extractBSTR(result2[0]);
                COM.SysFreeString(result2[0]);
                if (sUrl.length() != 0) {
                    result2[0] = 0L;
                    hr = iwebview.mainFrame(result2);
                    if (hr != 0 || result2[0] == 0L) {
                        return 0;
                    }
                    IWebFrame mainFrame = new IWebFrame(result2[0]);
                    mainFrame.loadRequest(req.getAddress());
                    mainFrame.Release();
                }
            }
            return 0;
        }
        return -2147467263;
    }

    protected void disposeCOMInterfaces() {
        if (this.iWebUIDelegate != null) {
            this.iWebUIDelegate.dispose();
            this.iWebUIDelegate = null;
        }
    }

    long getAddress() {
        return this.iWebUIDelegate.getAddress();
    }

    int mouseDidMoveOverElement(long sender, long elementInformation, int modifierFlags) {
        long hHeap;
        long resultPtr;
        if (elementInformation == 0L) {
            return 0;
        }
        IPropertyBag info = new IPropertyBag(elementInformation);
        long key2 = WebKit.createBSTR("WebElementLinkURLKey");
        int hr = info.Read(key2, resultPtr = OS.HeapAlloc(hHeap = OS.GetProcessHeap(), 8, VARIANT.sizeof), null);
        if (hr != 0 || resultPtr == 0L) {
            return 0;
        }
        String value = null;
        VARIANT v2 = new VARIANT();
        COM.MoveMemory(v2, resultPtr, VARIANT.sizeof);
        if (v2.vt == 8) {
            value = WebKit.extractBSTR(v2.lVal);
        }
        OS.HeapFree(hHeap, 0, resultPtr);
        StatusTextListener[] statusTextListeners = this.browser.webBrowser.statusTextListeners;
        if (value == null || value.length() == 0) {
            if (this.lastHoveredLinkURL == null) {
                return 0;
            }
            this.lastHoveredLinkURL = null;
            StatusTextEvent statusText = new StatusTextEvent(this.browser);
            statusText.display = this.browser.getDisplay();
            statusText.widget = this.browser;
            statusText.text = "";
            int i2 = 0;
            while (i2 < statusTextListeners.length) {
                statusTextListeners[i2].changed(statusText);
                ++i2;
            }
            return 0;
        }
        if (value.equals(this.lastHoveredLinkURL)) {
            return 0;
        }
        this.lastHoveredLinkURL = value;
        StatusTextEvent statusText = new StatusTextEvent(this.browser);
        statusText.display = this.browser.getDisplay();
        statusText.widget = this.browser;
        statusText.text = value;
        int i3 = 0;
        while (i3 < statusTextListeners.length) {
            statusTextListeners[i3].changed(statusText);
            ++i3;
        }
        return 0;
    }

    int printFrame(long webView, long frame) {
        IWebFrame iwebFrame = new IWebFrame(frame);
        PRINTDLG pd = new PRINTDLG();
        pd.lStructSize = PRINTDLG.sizeof;
        pd.Flags = 256;
        Display display = this.browser.getDisplay();
        display.sendPreExternalEventDispatchEvent();
        boolean success = OS.PrintDlg(pd);
        display.sendPostExternalEventDispatchEvent();
        if (!success) {
            return 0;
        }
        long printDC = pd.hDC;
        long[] result2 = new long[1];
        int hr = iwebFrame.QueryInterface(WebKit_win32.IID_IWebFramePrivate, result2);
        if (hr != 0 || result2[0] == 0L) {
            return 0;
        }
        IWebFramePrivate privateFrame = new IWebFramePrivate(result2[0]);
        privateFrame.setInPrintingMode(1, printDC);
        int[] count = new int[1];
        hr = privateFrame.getPrintedPageCount(printDC, count);
        if (hr != 0 || count[0] == 0) {
            privateFrame.Release();
            return 0;
        }
        int pageCount = count[0];
        String jobName = null;
        result2[0] = 0L;
        hr = iwebFrame.dataSource(result2);
        if (hr == 0 && result2[0] != 0L) {
            IWebDataSource dataSource = new IWebDataSource(result2[0]);
            result2[0] = 0L;
            hr = dataSource.pageTitle(result2);
            dataSource.Release();
            if (hr == 0 && result2[0] != 0L) {
                jobName = WebKit.extractBSTR(result2[0]);
                COM.SysFreeString(result2[0]);
            }
        }
        DOCINFO di2 = new DOCINFO();
        di2.cbSize = DOCINFO.sizeof;
        long hHeap = OS.GetProcessHeap();
        long lpszDocName = 0L;
        if (jobName != null && jobName.length() != 0) {
            TCHAR buffer = new TCHAR(0, jobName, true);
            int byteCount = buffer.length() * 2;
            lpszDocName = OS.HeapAlloc(hHeap, 8, byteCount);
            OS.MoveMemory(lpszDocName, buffer, byteCount);
            di2.lpszDocName = lpszDocName;
        }
        int rc = OS.StartDoc(printDC, di2);
        if (lpszDocName != 0L) {
            OS.HeapFree(hHeap, 0, lpszDocName);
        }
        if (rc >= 0) {
            int i2 = 0;
            while (i2 < pageCount) {
                OS.StartPage(printDC);
                privateFrame.spoolPages(printDC, i2, i2, null);
                OS.EndPage(printDC);
                ++i2;
            }
            privateFrame.setInPrintingMode(0, printDC);
            OS.EndDoc(printDC);
        }
        privateFrame.Release();
        return 0;
    }

    int QueryInterface(long riid, long ppvObject) {
        if (riid == 0L || ppvObject == 0L) {
            return -2147024809;
        }
        GUID guid = new GUID();
        COM.MoveMemory(guid, riid, GUID.sizeof);
        if (COM.IsEqualGUID(guid, COM.IIDIUnknown)) {
            OS.MoveMemory(ppvObject, new long[]{this.iWebUIDelegate.getAddress()}, C.PTR_SIZEOF);
            new IUnknown(this.iWebUIDelegate.getAddress()).AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(guid, WebKit_win32.IID_IWebUIDelegate)) {
            OS.MoveMemory(ppvObject, new long[]{this.iWebUIDelegate.getAddress()}, C.PTR_SIZEOF);
            new IUnknown(this.iWebUIDelegate.getAddress()).AddRef();
            return 0;
        }
        OS.MoveMemory(ppvObject, new long[1], C.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int runBeforeUnloadConfirmPanelWithMessage(long sender, long message2, long initiatedByFrame, long result2) {
        if (!this.prompt) {
            return 0;
        }
        Shell parent = this.browser.getShell();
        String string2 = WebKit.extractBSTR(message2);
        StringBuilder text2 = new StringBuilder(Compatibility.getMessage("SWT_OnBeforeUnload_Message1"));
        text2.append("\n\n");
        text2.append(string2);
        text2.append("\n\n");
        text2.append(Compatibility.getMessage("SWT_OnBeforeUnload_Message2"));
        MessageBox box = new MessageBox(parent, 292);
        box.setMessage(text2.toString());
        int[] response = new int[]{box.open() == 32 ? 1 : 0};
        OS.MoveMemory(result2, response, 4);
        return 0;
    }

    int runJavaScriptAlertPanelWithMessage(long sender, long message2) {
        String messageString = WebKit.extractBSTR(message2);
        this.showAlertMessage("Javascript", messageString);
        return 0;
    }

    int runJavaScriptConfirmPanelWithMessage(long sender, long message2, long result2) {
        String messageString = WebKit.extractBSTR(message2);
        int[] response = new int[]{this.showConfirmPanel("Javascript", messageString) == 32 ? 1 : 0};
        OS.MoveMemory(result2, response, 4);
        return 0;
    }

    int runJavaScriptTextInputPanelWithPrompt(long sender, long message2, long defaultText, long result2) {
        String messageString = WebKit.extractBSTR(message2);
        String defaultTextString = WebKit.extractBSTR(defaultText);
        String resultString = this.showTextPrompter("Javascript", messageString, defaultTextString);
        long[] response = new long[1];
        if (resultString != null) {
            response[0] = WebKit.createBSTR(resultString);
        }
        OS.MoveMemory(result2, response, C.PTR_SIZEOF);
        return 0;
    }

    int runOpenPanelForFileButtonWithResultListener(long sender, long resultListener) {
        Shell parent = this.browser.getShell();
        FileDialog dialog2 = new FileDialog(parent, 0);
        String result2 = dialog2.open();
        IWebOpenPanelResultListener listener2 = new IWebOpenPanelResultListener(resultListener);
        if (result2 == null) {
            listener2.cancel();
        } else {
            listener2.chooseFilename(WebKit.createBSTR(result2));
        }
        return 0;
    }

    int setFrame(long sender, long frame) {
        RECT rect = new RECT();
        COM.MoveMemory(rect, frame, RECT.sizeof);
        this.location = DPIUtil.autoScaleUp(this.browser.getDisplay().map((Control)this.browser, null, DPIUtil.autoScaleDown(new Point(rect.left, rect.top))));
        int x2 = rect.right - rect.left;
        int y2 = rect.bottom - rect.top;
        if (y2 < 0 || x2 < 0 || x2 == 0 && y2 == 0) {
            return 0;
        }
        this.size = new Point(x2, y2);
        return 0;
    }

    int setMenuBarVisible(long sender, int visible) {
        this.menuBar = visible == 1;
        return 0;
    }

    int setStatusBarVisible(long sender, int visible) {
        this.statusBar = visible == 1;
        return 0;
    }

    int setStatusText(long sender, long text2) {
        String statusText = WebKit.extractBSTR(text2);
        if (statusText.length() == 0) {
            return 0;
        }
        StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
        statusTextEvent.display = this.browser.getDisplay();
        statusTextEvent.widget = this.browser;
        statusTextEvent.text = statusText;
        StatusTextListener[] statusTextListeners = this.browser.webBrowser.statusTextListeners;
        int i2 = 0;
        while (i2 < statusTextListeners.length) {
            statusTextListeners[i2].changed(statusTextEvent);
            ++i2;
        }
        return 0;
    }

    int setToolbarsVisible(long sender, int visible) {
        this.toolBar = visible == 1;
        return 0;
    }

    void showAlertMessage(String title2, String message2) {
        Shell parent = this.browser.getShell();
        final Shell dialog2 = new Shell(parent, 67680);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 20;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialog2.setLayout(layout);
        dialog2.setText(title2);
        Label label2 = new Label(dialog2, 0);
        Image image = dialog2.getDisplay().getSystemImage(8);
        label2.setImage(image);
        label2 = new Label(dialog2, 64);
        label2.setText(message2);
        Monitor monitor = parent.getMonitor();
        int maxWidth = monitor.getBounds().width * 2 / 3;
        int width = label2.computeSize((int)-1, (int)-1).x;
        GridData data2 = new GridData(4, 0x1000000, true, false);
        data2.widthHint = Math.min(width, maxWidth);
        label2.setLayoutData(data2);
        Button ok = new Button(dialog2, 8);
        ok.setText(SWT.getMessage("SWT_OK"));
        width = ok.computeSize((int)-1, (int)-1).x;
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = 0x1000000;
        layoutData.verticalAlignment = 0x1000000;
        layoutData.horizontalSpan = 2;
        layoutData.widthHint = Math.max(width, 75);
        ok.setLayoutData(layoutData);
        ok.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e2) {
                dialog2.dispose();
            }
        });
        dialog2.setDefaultButton(ok);
        dialog2.pack();
        Rectangle parentSize = parent.getBounds();
        Rectangle dialogSize = dialog2.getBounds();
        int x2 = parent.getLocation().x + (parentSize.width - dialogSize.width) / 2;
        int y2 = parent.getLocation().y + (parentSize.height - dialogSize.height) / 2;
        dialog2.setLocation(x2, y2);
        dialog2.open();
        Display display = this.browser.getDisplay();
        while (!dialog2.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    int showConfirmPanel(String title2, String message2) {
        Shell parent = this.browser.getShell();
        final Shell dialog2 = new Shell(parent, 67680);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 20;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialog2.setLayout(layout);
        dialog2.setText(title2);
        Label label2 = new Label(dialog2, 0);
        Image image = dialog2.getDisplay().getSystemImage(4);
        label2.setImage(image);
        label2.setLayoutData(new GridData());
        label2 = new Label(dialog2, 64);
        label2.setText(message2);
        Monitor monitor = parent.getMonitor();
        int maxWidth = monitor.getBounds().width * 2 / 3;
        int width = label2.computeSize((int)-1, (int)-1).x;
        GridData data2 = new GridData(4, 0x1000000, true, false);
        data2.widthHint = Math.min(width, maxWidth);
        label2.setLayoutData(data2);
        Composite buttons = new Composite(dialog2, 0);
        data2 = new GridData(0x1000000, 0x1000000, true, true, 2, 1);
        buttons.setLayoutData(data2);
        buttons.setLayout(new GridLayout(2, true));
        Button ok = new Button(buttons, 8);
        ok.setText(SWT.getMessage("SWT_OK"));
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = 0x1000000;
        layoutData.verticalAlignment = 0x1000000;
        ok.setLayoutData(layoutData);
        Button cancel = new Button(buttons, 8);
        cancel.setText(SWT.getMessage("SWT_Cancel"));
        cancel.setLayoutData(layoutData);
        width = cancel.computeSize((int)-1, (int)-1).x;
        layoutData.widthHint = Math.max(width, 75);
        final int[] result2 = new int[1];
        ok.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e2) {
                result2[0] = 32;
                dialog2.dispose();
            }
        });
        cancel.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e2) {
                result2[0] = 256;
                dialog2.dispose();
            }
        });
        dialog2.setDefaultButton(ok);
        dialog2.pack();
        Rectangle parentSize = parent.getBounds();
        Rectangle dialogSize = dialog2.getBounds();
        int x2 = parent.getLocation().x + (parentSize.width - dialogSize.width) / 2;
        int y2 = parent.getLocation().y + (parentSize.height - dialogSize.height) / 2;
        dialog2.setLocation(x2, y2);
        dialog2.open();
        Display display = this.browser.getDisplay();
        while (!dialog2.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return result2[0];
    }

    String showTextPrompter(String title2, String message2, String defaultText) {
        Shell parent = this.browser.getShell();
        final Shell dialog2 = new Shell(parent, 67680);
        dialog2.setLayout(new GridLayout());
        dialog2.setText(title2);
        Label label2 = new Label(dialog2, 0);
        label2.setLayoutData(new GridData(768));
        label2.setText(message2);
        final Text textBox = new Text(dialog2, 2052);
        GridData data2 = new GridData(768);
        data2.widthHint = 300;
        textBox.setLayoutData(data2);
        textBox.setText(defaultText);
        Composite buttons = new Composite(dialog2, 0);
        buttons.setLayout(new GridLayout(2, true));
        buttons.setLayoutData(new GridData(64));
        Button ok = new Button(buttons, 8);
        ok.setText(SWT.getMessage("SWT_OK"));
        ok.setLayoutData(new GridData(768));
        final String[] result2 = new String[1];
        ok.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e2) {
                result2[0] = textBox.getText();
                dialog2.dispose();
            }
        });
        Button cancel = new Button(buttons, 8);
        cancel.setText(SWT.getMessage("SWT_Cancel"));
        cancel.setLayoutData(new GridData(768));
        cancel.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e2) {
                dialog2.dispose();
            }
        });
        dialog2.setDefaultButton(ok);
        dialog2.pack();
        Rectangle parentSize = parent.getBounds();
        Rectangle dialogSize = dialog2.getBounds();
        int x2 = parent.getLocation().x + (parentSize.width - dialogSize.width) / 2;
        int y2 = parent.getLocation().y + (parentSize.height - dialogSize.height) / 2;
        dialog2.setLocation(x2, y2);
        dialog2.open();
        Display display = this.browser.getDisplay();
        while (!dialog2.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return result2[0];
    }

    int takeFocus(long sender, int forward) {
        int traveralCode = forward == 0 ? 8 : 16;
        ((WebKit)this.browser.webBrowser).traverseOut = true;
        this.browser.traverse(traveralCode);
        return 0;
    }

    int webViewClose(long sender) {
        WindowEvent newEvent = new WindowEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        CloseWindowListener[] closeWindowListeners = this.browser.webBrowser.closeWindowListeners;
        int i2 = 0;
        while (i2 < closeWindowListeners.length) {
            closeWindowListeners[i2].close(newEvent);
            ++i2;
        }
        this.browser.dispose();
        return 0;
    }

    int webViewFrame(long sender, long frame) {
        RECT rect = new RECT();
        OS.MoveMemory(frame, rect, RECT.sizeof);
        return 0;
    }

    int webViewShow(long sender) {
        WindowEvent newEvent = new WindowEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        if (this.location != null) {
            newEvent.location = this.location;
        }
        if (this.size != null) {
            newEvent.size = this.size;
        }
        newEvent.addressBar = this.toolBar;
        newEvent.menuBar = this.menuBar;
        newEvent.statusBar = this.statusBar;
        newEvent.toolBar = this.toolBar;
        VisibilityWindowListener[] visibilityWindowListeners = this.browser.webBrowser.visibilityWindowListeners;
        int i2 = 0;
        while (i2 < visibilityWindowListeners.length) {
            visibilityWindowListeners[i2].show(newEvent);
            ++i2;
        }
        this.location = null;
        this.size = null;
        return 0;
    }
}

