/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.ode.FieldEquationsMapper;
import org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import org.apache.commons.math3.ode.nonstiff.MidpointFieldStepInterpolator;
import org.apache.commons.math3.ode.nonstiff.RungeKuttaFieldIntegrator;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidpointFieldIntegrator<T extends RealFieldElement<T>>
extends RungeKuttaFieldIntegrator<T> {
    public MidpointFieldIntegrator(Field<T> field2, T step) {
        super(field2, "midpoint", step);
    }

    @Override
    public T[] getC() {
        RealFieldElement[] c2 = (RealFieldElement[])MathArrays.buildArray(this.getField(), 1);
        c2[0] = (RealFieldElement)((RealFieldElement)this.getField().getOne()).multiply(0.5);
        return c2;
    }

    @Override
    public T[][] getA() {
        RealFieldElement[][] a2 = (RealFieldElement[][])MathArrays.buildArray(this.getField(), 1, 1);
        a2[0][0] = this.fraction(1, 2);
        return a2;
    }

    @Override
    public T[] getB() {
        RealFieldElement[] b2 = (RealFieldElement[])MathArrays.buildArray(this.getField(), 2);
        b2[0] = (RealFieldElement)this.getField().getZero();
        b2[1] = (RealFieldElement)this.getField().getOne();
        return b2;
    }

    @Override
    protected MidpointFieldStepInterpolator<T> createInterpolator(boolean forward, T[][] yDotK, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldEquationsMapper<T> mapper) {
        return new MidpointFieldStepInterpolator(this.getField(), forward, yDotK, globalPreviousState, globalCurrentState, globalPreviousState, globalCurrentState, mapper);
    }
}

