/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.Configuration;
import proguard.DataEntryWriterFactory;
import proguard.InputReader;
import proguard.classfile.ClassPool;
import proguard.classfile.util.ClassUtil;
import proguard.io.ClassFilter;
import proguard.io.ClassRewriter;
import proguard.io.DataEntryCopier;
import proguard.io.DataEntryObfuscator;
import proguard.io.DataEntryReader;
import proguard.io.DataEntryRenamer;
import proguard.io.DataEntryRewriter;
import proguard.io.DataEntryWriter;
import proguard.io.DirectoryFilter;
import proguard.io.ManifestRewriter;
import proguard.io.NameFilter;

public class OutputWriter {
    private final Configuration configuration;

    public OutputWriter(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool classPool) throws IOException {
        String string;
        ClassPathEntry classPathEntry;
        ClassPathEntry classPathEntry2;
        int n;
        ClassPath classPath = this.configuration.programJars;
        ClassPathEntry classPathEntry3 = classPath.get(0);
        if (classPathEntry3.isOutput()) {
            throw new IOException("The output jar [" + classPathEntry3.getName() + "] must be specified after an input jar, or it will be empty.");
        }
        for (n = 0; n < classPath.size() - 1; ++n) {
            classPathEntry2 = classPath.get(n);
            if (!classPathEntry2.isOutput() || classPathEntry2.getFilter() != null || classPathEntry2.getJarFilter() != null || classPathEntry2.getWarFilter() != null || classPathEntry2.getEarFilter() != null || classPathEntry2.getZipFilter() != null || !classPath.get(n + 1).isOutput()) continue;
            throw new IOException("The output jar [" + classPathEntry2.getName() + "] must have a filter, or all subsequent output jars will be empty.");
        }
        for (n = 0; n < classPath.size() - 1; ++n) {
            classPathEntry2 = classPath.get(n);
            if (!classPathEntry2.isOutput()) continue;
            for (int i = 0; i < classPath.size(); ++i) {
                classPathEntry = classPath.get(i);
                if (classPathEntry.isOutput() || !classPathEntry2.getFile().equals(classPathEntry.getFile())) continue;
                throw new IOException("The output jar [" + classPathEntry2.getName() + "] must be different from all input jars.");
            }
        }
        if (this.configuration.obfuscate && this.configuration.useMixedCaseClassNames && this.configuration.classObfuscationDictionary == null && (this.configuration.note == null || !this.configuration.note.isEmpty()) && ((string = System.getProperty("os.name").toLowerCase()).startsWith("windows") || string.startsWith("mac os"))) {
            for (int i = 0; i < classPath.size(); ++i) {
                ClassPathEntry classPathEntry4 = classPath.get(i);
                if (!classPathEntry4.isOutput() || classPathEntry4.isJar() || classPathEntry4.isWar() || classPathEntry4.isEar() || classPathEntry4.isZip()) continue;
                System.out.println("Note: you're writing the processed class files to a directory [" + classPathEntry4.getName() + "].");
                System.out.println("      This will likely cause problems with obfuscated mixed-case class names.");
                System.out.println("      You should consider writing the output to a jar file, or otherwise");
                System.out.println("      specify '-dontusemixedcaseclassnames'.");
                break;
            }
        }
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < classPath.size(); ++i) {
            classPathEntry = classPath.get(i);
            if (!classPathEntry.isOutput()) {
                n3 = i;
                continue;
            }
            int n4 = i + 1;
            if (n4 != classPath.size() && classPath.get(n4).isOutput()) continue;
            this.writeOutput(classPool, classPath, n2, n3 + 1, n4);
            n2 = n4;
        }
    }

    private void writeOutput(ClassPool classPool, ClassPath classPath, int n, int n2, int n3) throws IOException {
        try {
            Object object;
            Object object2;
            DataEntryCopier dataEntryCopier;
            DataEntryWriter dataEntryWriter = DataEntryWriterFactory.createDataEntryWriter(classPath, n2, n3);
            ClassRewriter classRewriter = new ClassRewriter(classPool, dataEntryWriter);
            DataEntryReader dataEntryReader = dataEntryCopier = new DataEntryCopier(dataEntryWriter);
            if (this.configuration.adaptResourceFileContents != null) {
                dataEntryReader = new NameFilter(this.configuration.adaptResourceFileContents, (DataEntryReader)new NameFilter("META-INF/MANIFEST.MF,META-INF/*.SF", (DataEntryReader)new ManifestRewriter(classPool, dataEntryWriter), (DataEntryReader)new DataEntryRewriter(classPool, dataEntryWriter)), dataEntryReader);
            }
            if (this.configuration.adaptResourceFileNames != null) {
                object2 = OutputWriter.createPackagePrefixMap(classPool);
                dataEntryReader = new NameFilter(this.configuration.adaptResourceFileNames, (DataEntryReader)new DataEntryObfuscator(classPool, (Map)object2, dataEntryReader), dataEntryReader);
            }
            object2 = null;
            if (this.configuration.keepDirectories != null) {
                object = OutputWriter.createPackagePrefixMap(classPool);
                object2 = new NameFilter(this.configuration.keepDirectories, (DataEntryReader)new DataEntryRenamer((Map)object, dataEntryCopier, dataEntryCopier));
            }
            object = new ClassFilter(classRewriter, (DataEntryReader)new DirectoryFilter((DataEntryReader)object2, dataEntryReader));
            new InputReader(this.configuration).readInput("  Copying resources from program ", classPath, n, n2, (DataEntryReader)object);
            dataEntryWriter.close();
        }
        catch (IOException iOException) {
            throw (IOException)new IOException("Can't write [" + classPath.get(n2).getName() + "] (" + iOException.getMessage() + ")").initCause(iOException);
        }
    }

    private static Map createPackagePrefixMap(ClassPool classPool) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = classPool.classNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = ClassUtil.internalPackagePrefix(string);
            String string3 = (String)hashMap.get(string2);
            if (string3 != null && string3.equals(string2)) continue;
            String string4 = classPool.getClass(string).getName();
            String string5 = ClassUtil.internalPackagePrefix(string4);
            hashMap.put(string2, string5);
        }
        return hashMap;
    }
}

