/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader.datablock;

import com.monstarmike.tlmreader.datablock.HeaderBlock;
import java.util.Arrays;

public class HeaderNameBlock
extends HeaderBlock {
    String modelName;
    byte modelNumber;
    byte modelType;
    byte bindInfo;

    public static boolean isHeaderName(byte[] bytes) {
        return bytes.length > 6 && bytes[4] != bytes[5];
    }

    public String getModelName() {
        return this.modelName;
    }

    public int getModelNumber() {
        return this.modelNumber;
    }

    public String getModelType() {
        switch (this.modelType) {
            case 0: {
                return "Fixed Wing";
            }
            case 1: {
                return "Helicopter";
            }
        }
        return "Sailplane";
    }

    public String getBindInfo() {
        switch (this.bindInfo) {
            case 1: {
                return "DSM2 6000";
            }
            case 2: {
                return "DSM2 8000";
            }
            case 3: {
                return "DSMX 8000";
            }
        }
        return "DSMX 6000";
    }

    public HeaderNameBlock(byte[] rawData) {
        super(rawData);
        this.decode(rawData);
    }

    private void decode(byte[] rawData) {
        this.modelType = rawData[5];
        this.modelType = rawData[5];
        this.bindInfo = rawData[6];
        int offset = 12;
        while (offset < 36 && rawData[offset] != 0) {
            offset = (short)(offset + 1);
        }
        this.modelName = new String(Arrays.copyOfRange(rawData, 10, offset)).trim();
        this.modelNumber = (byte)(rawData[4] + 1);
    }

    public String toString() {
        return "NameHeader; modelName: " + this.getModelName() + ", modelNumber: " + this.getModelNumber() + ", modelType: " + this.getModelType() + ", bindInfo: " + this.getBindInfo();
    }
}

