/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.integration.gauss;

import org.apache.commons.math3.analysis.integration.gauss.BaseRuleFactory;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HermiteRuleFactory
extends BaseRuleFactory<Double> {
    private static final double SQRT_PI = 1.772453850905516;
    private static final double H0 = 0.7511255444649425;
    private static final double H1 = 1.0622519320271968;

    @Override
    protected Pair<Double[], Double[]> computeRule(int numberOfPoints) throws DimensionMismatchException {
        if (numberOfPoints == 1) {
            return new Pair<Double[], Double[]>(new Double[]{0.0}, new Double[]{1.772453850905516});
        }
        int lastNumPoints = numberOfPoints - 1;
        Double[] previousPoints = (Double[])this.getRuleInternal(lastNumPoints).getFirst();
        Double[] points = new Double[numberOfPoints];
        Double[] weights = new Double[numberOfPoints];
        double sqrtTwoTimesLastNumPoints = FastMath.sqrt(2 * lastNumPoints);
        double sqrtTwoTimesNumPoints = FastMath.sqrt(2 * numberOfPoints);
        int iMax = numberOfPoints / 2;
        for (int i2 = 0; i2 < iMax; ++i2) {
            double a2 = i2 == 0 ? -sqrtTwoTimesLastNumPoints : previousPoints[i2 - 1];
            double b2 = iMax == 1 ? -0.5 : previousPoints[i2];
            double hma = 0.7511255444649425;
            double ha = 1.0622519320271968 * a2;
            double hmb = 0.7511255444649425;
            double hb = 1.0622519320271968 * b2;
            for (int j2 = 1; j2 < numberOfPoints; ++j2) {
                double jp1 = j2 + 1;
                double s2 = FastMath.sqrt(2.0 / jp1);
                double sm = FastMath.sqrt((double)j2 / jp1);
                double hpa = s2 * a2 * ha - sm * hma;
                double hpb = s2 * b2 * hb - sm * hmb;
                hma = ha;
                ha = hpa;
                hmb = hb;
                hb = hpb;
            }
            double c2 = 0.5 * (a2 + b2);
            double hmc = 0.7511255444649425;
            double hc = 1.0622519320271968 * c2;
            boolean done = false;
            while (!done) {
                done = b2 - a2 <= Math.ulp(c2);
                hmc = 0.7511255444649425;
                hc = 1.0622519320271968 * c2;
                for (int j3 = 1; j3 < numberOfPoints; ++j3) {
                    double jp1 = j3 + 1;
                    double s3 = FastMath.sqrt(2.0 / jp1);
                    double sm = FastMath.sqrt((double)j3 / jp1);
                    double hpc = s3 * c2 * hc - sm * hmc;
                    hmc = hc;
                    hc = hpc;
                }
                if (done) continue;
                if (ha * hc < 0.0) {
                    b2 = c2;
                    hmb = hmc;
                    hb = hc;
                } else {
                    a2 = c2;
                    hma = hmc;
                    ha = hc;
                }
                c2 = 0.5 * (a2 + b2);
            }
            double d2 = sqrtTwoTimesNumPoints * hmc;
            double w2 = 2.0 / (d2 * d2);
            points[i2] = c2;
            weights[i2] = w2;
            int idx = lastNumPoints - i2;
            points[idx] = -c2;
            weights[idx] = w2;
        }
        if (numberOfPoints % 2 != 0) {
            double hm = 0.7511255444649425;
            for (int j4 = 1; j4 < numberOfPoints; j4 += 2) {
                double jp1 = j4 + 1;
                hm = -FastMath.sqrt((double)j4 / jp1) * hm;
            }
            double d3 = sqrtTwoTimesNumPoints * hm;
            double w3 = 2.0 / (d3 * d3);
            points[iMax] = 0.0;
            weights[iMax] = w3;
        }
        return new Pair<Double[], Double[]>(points, weights);
    }
}

