/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader.datablock;

import com.monstarmike.tlmreader.datablock.DataBlock;
import com.monstarmike.tlmreader.primitives.Ints;
import com.monstarmike.tlmreader.primitives.Shorts;
import com.sun.istack.Nullable;

public final class JetCatBlock
extends DataBlock {
    private byte rawECUStatus;
    private byte throttlePercentage;
    private double packVoltage;
    private double pumpVoltage;
    private int rpm;
    private short egt;
    private byte rawOffCondition;

    public byte getRawECUStatus() {
        return this.rawECUStatus;
    }

    public byte getThrottlePercentage() {
        return this.throttlePercentage;
    }

    public double getPackVoltage() {
        return this.packVoltage;
    }

    public double getPumpVoltage() {
        return this.pumpVoltage;
    }

    public int getRPM() {
        return this.rpm;
    }

    public short getEGT() {
        return this.egt;
    }

    public byte getRawOffCondition() {
        return this.rawOffCondition;
    }

    public JetCatBlock(byte[] rawData) {
        super(rawData);
        this.decode(rawData);
        this.measurementNames.add("RawECUStatus JC");
        this.measurementNames.add("Throttle JC");
        this.measurementNames.add("PackVoltage JC");
        this.measurementNames.add("PumpVoltage JC");
        this.measurementNames.add("RPM JC");
        this.measurementNames.add("EGT JC");
        this.measurementNames.add("RawOffCondition JC");
        this.measurementUnits.add("");
        this.measurementUnits.add("%");
        this.measurementUnits.add("V");
        this.measurementUnits.add("V");
        this.measurementUnits.add("1/min");
        this.measurementUnits.add("");
        this.measurementUnits.add("");
        this.measurementFactors.add(1.0);
        this.measurementFactors.add(1.0);
        this.measurementFactors.add(1.0);
        this.measurementFactors.add(1.0);
        this.measurementFactors.add(1.0);
        this.measurementFactors.add(1.0);
        this.measurementFactors.add(1.0);
    }

    private void decode(byte[] rawData) {
        this.rawECUStatus = rawData[6];
        this.throttlePercentage = rawData[7];
        this.packVoltage = (double)rawData[8] * 100.0 + (double)rawData[9] / 100.0;
        this.pumpVoltage = (double)rawData[10] * 100.0 + (double)rawData[11] / 100.0;
        this.rpm = Ints.fromBytes(rawData[12], rawData[13], rawData[14], rawData[15]);
        this.egt = Shorts.fromBytes(rawData[16], rawData[17]);
        this.rawOffCondition = rawData[18];
        this.measurementValues.add(Integer.valueOf(this.getRawECUStatus()));
        this.measurementValues.add(Integer.valueOf(this.getThrottlePercentage()));
        this.measurementValues.add((int)this.getPackVoltage());
        this.measurementValues.add((int)this.getPumpVoltage());
        this.measurementValues.add(this.getRPM());
        this.measurementValues.add(Integer.valueOf(this.getEGT()));
        this.measurementValues.add(Integer.valueOf(this.getRawOffCondition()));
    }

    @Override
    public boolean areValuesEquals(DataBlock block) {
        if (block instanceof JetCatBlock) {
            JetCatBlock jcat = (JetCatBlock)block;
            return jcat.rawECUStatus == this.rawECUStatus && jcat.throttlePercentage == this.throttlePercentage && jcat.packVoltage == this.packVoltage && jcat.pumpVoltage == this.pumpVoltage && jcat.rpm == this.rpm && jcat.egt == this.egt && jcat.rawOffCondition == this.rawOffCondition;
        }
        return false;
    }

    public static enum ECUStatus {

    }

    static enum JETCAT_ECU_OFF_CONDITIONS {
        JETCAT_ECU_OFF_No_Off_Condition_defined,
        JETCAT_ECU_OFF_Shut_down_via_RC,
        JETCAT_ECU_OFF_Overtemperature,
        JETCAT_ECU_OFF_Ignition_timeout,
        JETCAT_ECU_OFF_Acceleration_time_out,
        JETCAT_ECU_OFF_Acceleration_too_slow,
        JETCAT_ECU_OFF_Over_RPM,
        JETCAT_ECU_OFF_Low_Rpm_Off,
        JETCAT_ECU_OFF_Low_Battery,
        JETCAT_ECU_OFF_Auto_Off,
        JETCAT_ECU_OFF_Low_temperature_Off,
        JETCAT_ECU_OFF_Hi_Temp_Off,
        JETCAT_ECU_OFF_Glow_Plug_defective,
        JETCAT_ECU_OFF_Watch_Dog_Timer,
        JETCAT_ECU_OFF_Fail_Safe_Off,
        JETCAT_ECU_OFF_Manual_Off,
        JETCAT_ECU_OFF_Power_fail,
        JETCAT_ECU_OFF_Temp_Sensor_fail,
        JETCAT_ECU_OFF_Fuel_fail,
        JETCAT_ECU_OFF_Prop_fail,
        JETCAT_ECU_OFF_2nd_Engine_fail,
        JETCAT_ECU_OFF_2nd_Engine_Diff_Too_High,
        JETCAT_ECU_OFF_2nd_Engine_No_Comm,
        JETCAT_ECU_MAX_OFF_COND,
        JETCENT_ECU_OFF_No_Off_Condition_defined,
        JETCENT_ECU_OFF_IGNITION_ERROR,
        JETCENT_ECU_OFF_PREHEAT_ERROR,
        JETCENT_ECU_OFF_SWITCHOVER_ERROR,
        JETCENT_ECU_OFF_STARTER_MOTOR_ERROR,
        JETCENT_ECU_OFF_TO_IDLE_ERROR,
        JETCENT_ECU_OFF_ACCELERATION_ERROR,
        JETCENT_ECU_OFF_IGNITER_BAD,
        JETCENT_ECU_OFF_MIN_PUMP_OK,
        JETCENT_ECU_OFF_MAX_PUMP_OK,
        JETCENT_ECU_OFF_LOW_RX_BATTERY,
        JETCENT_ECU_OFF_LOW_ECU_BATTERY,
        JETCENT_ECU_OFF_NO_RX,
        JETCENT_ECU_OFF_TRIM_DOWN,
        JETCENT_ECU_OFF_TRIM_UP,
        JETCENT_ECU_OFF_FAILSAFE,
        JETCENT_ECU_OFF_FULL,
        JETCENT_ECU_OFF_RX_SETUP_ERROR,
        JETCENT_ECU_OFF_TEMP_SENSOR_ERROR,
        JETCENT_ECU_OFF_COM_TURBINE_ERROR,
        JETCENT_ECU_OFF_MAX_TEMP,
        JETCENT_ECU_OFF_MAX_AMPS,
        JETCENT_ECU_OFF_LOW_RPM,
        JETCENT_ECU_OFF_ERROR_RPM_SENSOR,
        JETCENT_ECU_OFF_MAX_PUMP,
        JETCENT_ECU_MAX_OFF_COND;

        public static final JETCAT_ECU_OFF_CONDITIONS[] VALUES;

        static {
            VALUES = JETCAT_ECU_OFF_CONDITIONS.values();
        }

        @Nullable
        JETCAT_ECU_OFF_CONDITIONS fromOrdinal(int ordinal) {
            if (ordinal >= 0 && ordinal < VALUES.length) {
                return VALUES[ordinal];
            }
            return null;
        }
    }

    static enum JETCAT_ECU_TURBINE_STATE {
        JETCAT_ECU_STATE_OFF(0),
        JETCAT_ECU_STATE_WAIT_for_RPM(1),
        JETCAT_ECU_STATE_Ignite(2),
        JETCAT_ECU_STATE_Accelerate(3),
        JETCAT_ECU_STATE_Stabilise(4),
        JETCAT_ECU_STATE_Learn_HI(5),
        JETCAT_ECU_STATE_Learn_LO(6),
        JETCAT_ECU_STATE_UNDEFINED(7),
        JETCAT_ECU_STATE_Slow_Down(8),
        JETCAT_ECU_STATE_Manual(9),
        JETCAT_ECU_STATE_AutoOff(16),
        JETCAT_ECU_STATE_Run(17),
        JETCAT_ECU_STATE_Accleleration_delay(18),
        JETCAT_ECU_STATE_SpeedReg(19),
        JETCAT_ECU_STATE_Two_Shaft_Regulate(20),
        JETCAT_ECU_STATE_PreHeat1(21),
        JETCAT_ECU_STATE_PreHeat2(22),
        JETCAT_ECU_STATE_MainFStart(23),
        JETCAT_ECU_STATE_NotUsed(24),
        JETCAT_ECU_STATE_KeroFullOn(25),
        EVOJET_ECU_STATE_off(32),
        EVOJET_ECU_STATE_ignt(33),
        EVOJET_ECU_STATE_acce(34),
        EVOJET_ECU_STATE_run(35),
        EVOJET_ECU_STATE_cal(36),
        EVOJET_ECU_STATE_cool(37),
        EVOJET_ECU_STATE_fire(38),
        EVOJET_ECU_STATE_glow(39),
        EVOJET_ECU_STATE_heat(40),
        EVOJET_ECU_STATE_idle(41),
        EVOJET_ECU_STATE_lock(42),
        EVOJET_ECU_STATE_rel(43),
        EVOJET_ECU_STATE_spin(44),
        EVOJET_ECU_STATE_stop(45),
        HORNET_ECU_STATE_OFF(48),
        HORNET_ECU_STATE_SLOWDOWN(49),
        HORNET_ECU_STATE_COOL_DOWN(50),
        HORNET_ECU_STATE_AUTO(51),
        HORNET_ECU_STATE_AUTO_HC(52),
        HORNET_ECU_STATE_BURNER_ON(53),
        HORNET_ECU_STATE_CAL_IDLE(54),
        HORNET_ECU_STATE_CALIBRATE(55),
        HORNET_ECU_STATE_DEV_DELAY(56),
        HORNET_ECU_STATE_EMERGENCY(57),
        HORNET_ECU_STATE_FUEL_HEAT(58),
        HORNET_ECU_STATE_FUEL_IGNITE(59),
        HORNET_ECU_STATE_GO_IDLE(60),
        HORNET_ECU_STATE_PROP_IGNITE(61),
        HORNET_ECU_STATE_RAMP_DELAY(62),
        HORNET_ECU_STATE_RAMP_UP(63),
        HORNET_ECU_STATE_STANDBY(64),
        HORNET_ECU_STATE_STEADY(65),
        HORNET_ECU_STATE_WAIT_ACC(66),
        HORNET_ECU_STATE_ERROR(67),
        XICOY_ECU_STATE_Temp_High(80),
        XICOY_ECU_STATE_Trim_Low(81),
        XICOY_ECU_STATE_Set_Idle(82),
        XICOY_ECU_STATE_Ready(83),
        XICOY_ECU_STATE_Ignition(84),
        XICOY_ECU_STATE_Fuel_Ramp(85),
        XICOY_ECU_STATE_Glow_Test(86),
        XICOY_ECU_STATE_Running(87),
        XICOY_ECU_STATE_Stop(88),
        XICOY_ECU_STATE_Flameout(89),
        XICOY_ECU_STATE_Speed_Low(90),
        XICOY_ECU_STATE_Cooling(91),
        XICOY_ECU_STATE_Igniter_Bad(92),
        XICOY_ECU_STATE_Starter_F(93),
        XICOY_ECU_STATE_Weak_Fuel(94),
        XICOY_ECU_STATE_Start_On(95),
        XICOY_ECU_STATE_Pre_Heat(96),
        XICOY_ECU_STATE_Battery(97),
        XICOY_ECU_STATE_Time_Out(98),
        XICOY_ECU_STATE_Overload(99),
        XICOY_ECU_STATE_Igniter_Fail(100),
        XICOY_ECU_STATE_Burner_On(101),
        XICOY_ECU_STATE_Starting(102),
        XICOY_ECU_STATE_SwitchOver(103),
        XICOY_ECU_STATE_Cal_Pump(104),
        XICOY_ECU_STATE_Pump_Limit(105),
        XICOY_ECU_STATE_No_Engine(106),
        XICOY_ECU_STATE_Pwr_Boost(107),
        XICOY_ECU_STATE_Run_Idle(108),
        XICOY_ECU_STATE_Run_Max(109),
        JETCENT_ECU_STATE_STOP(116),
        JETCENT_ECU_STATE_GLOW_TEST(117),
        JETCENT_ECU_STATE_STARTER_TEST(118),
        JETCENT_ECU_STATE_PRIME_FUEL(119),
        JETCENT_ECU_STATE_PRIME_BURNER(120),
        JETCENT_ECU_STATE_MAN_COOL(121),
        JETCENT_ECU_STATE_AUTO_COOL(122),
        JETCENT_ECU_STATE_IGN_HEAT(123),
        JETCENT_ECU_STATE_IGNITION(124),
        JETCENT_ECU_STATE_PREHEAT(125),
        JETCENT_ECU_STATE_SWITCHOVER(126),
        JETCENT_ECU_STATE_TO_IDLE(127),
        JETCENT_ECU_STATE_RUNNING(128),
        JETCENT_ECU_STATE_STOP_ERROR(129),
        SWIWIN_ECU_STATE_STOP(144),
        SWIWIN_ECU_STATE_READY(145),
        SWIWIN_ECU_STATE_IGNITION(146),
        SWIWIN_ECU_STATE_PREHEAT(147),
        SWIWIN_ECU_STATE_FUEL_RAMP(148),
        SWIWIN_ECU_STATE_RUNNING(149),
        SWIWIN_ECU_STATE_COOLING(150),
        SWIWIN_ECU_STATE_RESTART_SWOVER(151),
        SWIWIN_ECU_STATE_NOTUSED(152),
        TURBINE_ECU_MAX_STATE(159);

        private byte id;
        public static final JETCAT_ECU_TURBINE_STATE[] VALUES;

        static {
            VALUES = JETCAT_ECU_TURBINE_STATE.values();
        }

        private JETCAT_ECU_TURBINE_STATE(int newId) {
            this.id = (byte)newId;
        }

        @Nullable
        JETCAT_ECU_TURBINE_STATE fromStateByte(int stateByte) {
            JETCAT_ECU_TURBINE_STATE[] jETCAT_ECU_TURBINE_STATEArray = VALUES;
            int n = VALUES.length;
            int n2 = 0;
            while (n2 < n) {
                JETCAT_ECU_TURBINE_STATE tmpState = jETCAT_ECU_TURBINE_STATEArray[n2];
                if (tmpState.id == stateByte) {
                    return tmpState;
                }
                ++n2;
            }
            return null;
        }
    }

    public static enum OffStatus {

    }
}

