/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.GestureListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TouchListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.win32.CREATESTRUCT;
import org.eclipse.swt.internal.win32.DRAWITEMSTRUCT;
import org.eclipse.swt.internal.win32.FLICK_DATA;
import org.eclipse.swt.internal.win32.FLICK_POINT;
import org.eclipse.swt.internal.win32.GESTURECONFIG;
import org.eclipse.swt.internal.win32.GESTUREINFO;
import org.eclipse.swt.internal.win32.HELPINFO;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MEASUREITEMSTRUCT;
import org.eclipse.swt.internal.win32.MENUITEMINFO;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TOUCHINPUT;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Touch;
import org.eclipse.swt.widgets.TouchSource;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public abstract class Control
extends Widget
implements Drawable {
    public long handle;
    Composite parent;
    Cursor cursor;
    Menu menu;
    Menu activeMenu;
    String toolTipText;
    Object layoutData;
    Accessible accessible;
    Image backgroundImage;
    Region region;
    Font font;
    int drawCount;
    int foreground;
    int background;
    int backgroundAlpha = 255;
    long hPrevIMC;

    Control() {
    }

    public Control(Composite parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget();
    }

    public void addControlListener(ControlListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addDragDetectListener(DragDetectListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(29, typedListener);
    }

    public void addFocusListener(FocusListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(15, typedListener);
        this.addListener(16, typedListener);
    }

    public void addGestureListener(GestureListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(48, typedListener);
    }

    public void addHelpListener(HelpListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(28, typedListener);
    }

    public void addKeyListener(KeyListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    public void addMenuDetectListener(MenuDetectListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(35, typedListener);
    }

    public void addMouseListener(MouseListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(3, typedListener);
        this.addListener(4, typedListener);
        this.addListener(8, typedListener);
    }

    public void addMouseTrackListener(MouseTrackListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(6, typedListener);
        this.addListener(7, typedListener);
        this.addListener(32, typedListener);
    }

    public void addMouseMoveListener(MouseMoveListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(5, typedListener);
    }

    public void addMouseWheelListener(MouseWheelListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(37, typedListener);
    }

    public void addPaintListener(PaintListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(9, typedListener);
    }

    public void addTouchListener(TouchListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(47, typedListener);
    }

    public void addTraverseListener(TraverseListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(31, typedListener);
    }

    int binarySearch(int[] indices, int start, int end, int index) {
        int low = start;
        int high = end - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            if (indices[mid] == index) {
                return mid;
            }
            if (indices[mid] < index) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return -low - 1;
    }

    long borderHandle() {
        return this.handle;
    }

    void checkBackground() {
        Shell shell = this.getShell();
        if (this == shell) {
            return;
        }
        this.state &= 0xFFFFFBFF;
        Composite composite = this.parent;
        while (true) {
            int mode;
            if ((mode = composite.backgroundMode) != 0 || this.backgroundAlpha == 0) {
                if (mode == 1 || this.backgroundAlpha == 0) {
                    Control control = this;
                    do {
                        if ((control.state & 0x100) != 0) continue;
                        return;
                    } while ((control = control.parent) != composite);
                }
                this.state |= 0x400;
                return;
            }
            if (composite == shell) break;
            composite = composite.parent;
        }
    }

    void checkBorder() {
        if (this.getBorderWidthInPixels() == 0) {
            this.style &= 0xFFFFF7FF;
        }
    }

    void checkBuffered() {
        this.style &= 0xDFFFFFFF;
    }

    void checkComposited() {
    }

    boolean checkHandle(long hwnd) {
        return hwnd == this.handle;
    }

    void checkMirrored() {
        int bits;
        if ((this.style & 0x4000000) != 0 && ((bits = OS.GetWindowLong(this.handle, -20)) & 0x400000) != 0) {
            this.style |= 0x8000000;
        }
    }

    public Point computeSize(int wHint, int hHint) {
        return this.computeSize(wHint, hHint, true);
    }

    public Point computeSize(int wHint, int hHint, boolean changed2) {
        this.checkWidget();
        wHint = wHint != -1 ? DPIUtil.autoScaleUp(wHint) : wHint;
        hHint = hHint != -1 ? DPIUtil.autoScaleUp(hHint) : hHint;
        return DPIUtil.autoScaleDown(this.computeSizeInPixels(wHint, hHint, changed2));
    }

    Point computeSizeInPixels(int wHint, int hHint, boolean changed2) {
        int width = 64;
        int height = 64;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidthInPixels();
        return new Point(width += border * 2, height += border * 2);
    }

    Widget computeTabGroup() {
        if (this.isTabGroup()) {
            return this;
        }
        return this.parent.computeTabGroup();
    }

    Control computeTabRoot() {
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int index = 0;
            while (index < tabList.length) {
                if (tabList[index] == this) break;
                ++index;
            }
            if (index == tabList.length && this.isTabGroup()) {
                return this;
            }
        }
        return this.parent.computeTabRoot();
    }

    Widget[] computeTabList() {
        if (this.isTabGroup() && this.getVisible() && this.getEnabled()) {
            return new Widget[]{this};
        }
        return new Widget[0];
    }

    void createHandle() {
        int bits;
        long hwndParent = this.widgetParent();
        this.handle = OS.CreateWindowEx(this.widgetExtStyle(), this.windowClass(), null, this.widgetStyle(), Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, hwndParent, 0L, OS.GetModuleHandle(null), this.widgetCreateStruct());
        if (this.handle == 0L) {
            this.error(2);
        }
        if (((bits = OS.GetWindowLong(this.handle, -16)) & 0x40000000) != 0) {
            OS.SetWindowLongPtr(this.handle, -12, this.handle);
        }
        if (OS.IsDBLocale && hwndParent != 0L) {
            long hIMC = OS.ImmGetContext(hwndParent);
            this.hPrevIMC = OS.ImmAssociateContext(this.handle, hIMC);
            OS.ImmReleaseContext(hwndParent, hIMC);
        }
    }

    void checkGesture() {
        long hHeap;
        long pConfigs;
        int value;
        if (OS.WIN32_VERSION >= OS.VERSION(6, 1) && ((value = OS.GetSystemMetrics(94)) & 0xC0) != 0 && (pConfigs = OS.HeapAlloc(hHeap = OS.GetProcessHeap(), 8, GESTURECONFIG.sizeof)) != 0L) {
            GESTURECONFIG config2 = new GESTURECONFIG();
            config2.dwID = 5;
            config2.dwWant = 1;
            config2.dwBlock = 0;
            OS.MoveMemory(pConfigs, config2, GESTURECONFIG.sizeof);
            OS.SetGestureConfig(this.handle, 0, 1, pConfigs, GESTURECONFIG.sizeof);
            OS.HeapFree(hHeap, 0, pConfigs);
        }
    }

    void createWidget() {
        this.state |= 0x8000;
        this.background = -1;
        this.foreground = -1;
        this.checkOrientation(this.parent);
        this.createHandle();
        this.checkBackground();
        this.checkBuffered();
        this.checkComposited();
        this.register();
        this.subclass();
        this.setDefaultFont();
        this.checkMirrored();
        this.checkBorder();
        this.checkGesture();
        if ((this.state & 0x400) != 0) {
            this.setBackground();
        }
    }

    int defaultBackground() {
        return OS.GetSysColor(15);
    }

    long defaultFont() {
        return this.display.getSystemFont().handle;
    }

    int defaultForeground() {
        return OS.GetSysColor(8);
    }

    void deregister() {
        this.display.removeControl(this.handle);
    }

    @Override
    void destroyWidget() {
        long hwnd = this.topHandle();
        this.releaseHandle();
        if (hwnd != 0L) {
            OS.DestroyWindow(hwnd);
        }
    }

    public boolean dragDetect(Event event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        Point loc = event.getLocationInPixels();
        return this.dragDetect(event.button, event.count, event.stateMask, loc.x, loc.y);
    }

    public boolean dragDetect(MouseEvent event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.dragDetect(event.button, event.count, event.stateMask, DPIUtil.autoScaleUp(event.x), DPIUtil.autoScaleUp(event.y));
    }

    boolean dragDetect(int button2, int count, int stateMask, int x2, int y2) {
        if (button2 != 1 || count != 1) {
            return false;
        }
        boolean dragging = this.dragDetect(this.handle, x2, y2, false, null, null);
        if (OS.GetKeyState(1) < 0 && OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        if (!dragging) {
            if (button2 == 1 && OS.GetKeyState(27) >= 0) {
                int wParam = 0;
                if ((stateMask & 0x40000) != 0) {
                    wParam |= 8;
                }
                if ((stateMask & 0x20000) != 0) {
                    wParam |= 4;
                }
                if ((stateMask & 0x10000) != 0) {
                    wParam |= 0x20;
                }
                if ((stateMask & 0x80000) != 0) {
                    wParam |= 1;
                }
                if ((stateMask & 0x100000) != 0) {
                    wParam |= 0x10;
                }
                if ((stateMask & 0x200000) != 0) {
                    wParam |= 2;
                }
                if ((stateMask & 0x800000) != 0) {
                    wParam |= 0x20;
                }
                if ((stateMask & 0x2000000) != 0) {
                    wParam |= 0x40;
                }
                long lParam = OS.MAKELPARAM(x2, y2);
                OS.SendMessage(this.handle, 514, (long)wParam, lParam);
            }
            return false;
        }
        return this.sendDragEvent(button2, stateMask, x2, y2);
    }

    void drawBackground(long hDC) {
        RECT rect = new RECT();
        OS.GetClientRect(this.handle, rect);
        this.drawBackground(hDC, rect);
    }

    void drawBackground(long hDC, RECT rect) {
        this.drawBackground(hDC, rect, -1, 0, 0);
    }

    void drawBackground(long hDC, RECT rect, int pixel, int tx, int ty) {
        Control control = this.findBackgroundControl();
        if (control != null) {
            if (control.backgroundImage != null) {
                this.fillImageBackground(hDC, control, rect, tx, ty);
                return;
            }
            pixel = control.getBackgroundPixel();
        }
        if (pixel == -1 && (this.state & 0x100) != 0 && OS.IsAppThemed() && (control = this.findThemeControl()) != null) {
            this.fillThemeBackground(hDC, control, rect);
            return;
        }
        if (pixel == -1) {
            pixel = this.getBackgroundPixel();
        }
        this.fillBackground(hDC, pixel, rect);
    }

    void drawImageBackground(long hDC, long hwnd, long hBitmap, RECT rect, int tx, int ty) {
        RECT rect2 = new RECT();
        OS.GetClientRect(hwnd, rect2);
        OS.MapWindowPoints(hwnd, this.handle, rect2, 2);
        long hBrush = this.findBrush(hBitmap, 3);
        POINT lpPoint = new POINT();
        OS.GetWindowOrgEx(hDC, lpPoint);
        OS.SetBrushOrgEx(hDC, -rect2.left - lpPoint.x - tx, -rect2.top - lpPoint.y - ty, lpPoint);
        long hOldBrush = OS.SelectObject(hDC, hBrush);
        OS.PatBlt(hDC, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, 15728673);
        OS.SetBrushOrgEx(hDC, lpPoint.x, lpPoint.y, null);
        OS.SelectObject(hDC, hOldBrush);
    }

    void drawThemeBackground(long hDC, long hwnd, RECT rect) {
    }

    void enableDrag(boolean enabled) {
    }

    void enableWidget(boolean enabled) {
        OS.EnableWindow(this.handle, enabled);
    }

    void fillBackground(long hDC, int pixel, RECT rect) {
        if (rect.left > rect.right || rect.top > rect.bottom) {
            return;
        }
        OS.FillRect(hDC, rect, this.findBrush(pixel, 0));
    }

    void fillImageBackground(long hDC, Control control, RECT rect, int tx, int ty) {
        Image image;
        if (rect.left > rect.right || rect.top > rect.bottom) {
            return;
        }
        if (control != null && (image = control.backgroundImage) != null) {
            control.drawImageBackground(hDC, this.handle, image.handle, rect, tx, ty);
        }
    }

    void fillThemeBackground(long hDC, Control control, RECT rect) {
        if (rect.left > rect.right || rect.top > rect.bottom) {
            return;
        }
        if (control != null) {
            control.drawThemeBackground(hDC, this.handle, rect);
        }
    }

    Control findBackgroundControl() {
        if ((this.background != -1 || this.backgroundImage != null) && this.backgroundAlpha > 0) {
            return this;
        }
        return this.parent != null && (this.state & 0x400) != 0 ? this.parent.findBackgroundControl() : null;
    }

    long findBrush(long value, int lbStyle) {
        return this.parent.findBrush(value, lbStyle);
    }

    Cursor findCursor() {
        if (this.cursor != null) {
            return this.cursor;
        }
        return this.parent.findCursor();
    }

    Control findImageControl() {
        Control control = this.findBackgroundControl();
        return control != null && control.backgroundImage != null ? control : null;
    }

    Control findThemeControl() {
        return this.background == -1 && this.backgroundImage == null ? this.parent.findThemeControl() : null;
    }

    Menu[] findMenus(Control control) {
        if (this.menu != null && this != control) {
            return new Menu[]{this.menu};
        }
        return new Menu[0];
    }

    char findMnemonic(String string2) {
        int index = 0;
        int length = string2.length();
        while (true) {
            if (index < length && string2.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return '\u0000';
            }
            if (string2.charAt(index) != '&') {
                return string2.charAt(index);
            }
            if (++index >= length) break;
        }
        return '\u0000';
    }

    void fixChildren(Shell newShell, Shell oldShell, Decorations newDecorations, Decorations oldDecorations, Menu[] menus) {
        oldShell.fixShell(newShell, this);
        oldDecorations.fixDecorations(newDecorations, this, menus);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void fixFocus(Control focusControl) {
        Shell shell = this.getShell();
        Control control = this;
        Display display = this.display;
        boolean oldFixFocus = display.fixFocus;
        display.fixFocus = true;
        try {
            while (control != shell && (control = control.parent) != null) {
                if (!control.setFocus()) continue;
                return;
            }
        }
        finally {
            display.fixFocus = oldFixFocus;
        }
        shell.setSavedFocus(focusControl);
        OS.SetFocus(0L);
    }

    public boolean forceFocus() {
        this.checkWidget();
        if (this.display.focusEvent == 16) {
            return false;
        }
        Decorations shell = this.menuShell();
        shell.setSavedFocus(this);
        if (!(this.isEnabled() && this.isVisible() && this.isActive())) {
            return false;
        }
        if (this.isFocusControl()) {
            return true;
        }
        shell.setSavedFocus(null);
        OS.SetFocus(this.handle);
        if (this.isDisposed()) {
            return false;
        }
        shell.setSavedFocus(this);
        return this.isFocusControl();
    }

    void forceResize() {
        if (this.parent == null) {
            return;
        }
        WINDOWPOS[] lpwp = this.parent.lpwp;
        if (lpwp == null) {
            return;
        }
        int i2 = 0;
        while (i2 < lpwp.length) {
            WINDOWPOS wp = lpwp[i2];
            if (wp != null && wp.hwnd == this.handle) {
                OS.SetWindowPos(wp.hwnd, 0L, wp.x, wp.y, wp.cx, wp.cy, wp.flags);
                lpwp[i2] = null;
                return;
            }
            ++i2;
        }
    }

    public Accessible getAccessible() {
        this.checkWidget();
        if (this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return this.accessible;
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.backgroundAlpha == 0) {
            Color color = Color.win32_new(this.display, this.background, 0);
            return color;
        }
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return Color.win32_new(this.display, control.getBackgroundPixel(), this.backgroundAlpha);
    }

    public Image getBackgroundImage() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return control.backgroundImage;
    }

    int getBackgroundPixel() {
        return this.background != -1 ? this.background : this.defaultBackground();
    }

    public int getBorderWidth() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getBorderWidthInPixels());
    }

    int getBorderWidthInPixels() {
        long borderHandle = this.borderHandle();
        int bits1 = OS.GetWindowLong(borderHandle, -20);
        if ((bits1 & 0x200) != 0) {
            return OS.GetSystemMetrics(45);
        }
        if ((bits1 & 0x20000) != 0) {
            return OS.GetSystemMetrics(5);
        }
        int bits2 = OS.GetWindowLong(borderHandle, -16);
        if ((bits2 & 0x800000) != 0) {
            return OS.GetSystemMetrics(5);
        }
        return 0;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    Rectangle getBoundsInPixels() {
        this.forceResize();
        RECT rect = new RECT();
        OS.GetWindowRect(this.topHandle(), rect);
        long hwndParent = this.parent == null ? 0L : this.parent.handle;
        OS.MapWindowPoints(0L, hwndParent, rect, 2);
        int width = rect.right - rect.left;
        int height = rect.bottom - rect.top;
        return new Rectangle(rect.left, rect.top, width, height);
    }

    int getCodePage() {
        return 0;
    }

    String getClipboardText() {
        String string2 = "";
        if (OS.OpenClipboard(0L)) {
            long hMem = OS.GetClipboardData(13);
            if (hMem != 0L) {
                int byteCount = OS.GlobalSize(hMem) / 2 * 2;
                long ptr = OS.GlobalLock(hMem);
                if (ptr != 0L) {
                    TCHAR buffer = new TCHAR(0, byteCount / 2);
                    OS.MoveMemory(buffer, ptr, byteCount);
                    string2 = buffer.toString(0, buffer.strlen());
                    OS.GlobalUnlock(hMem);
                }
            }
            OS.CloseClipboard();
        }
        return string2;
    }

    public Cursor getCursor() {
        this.checkWidget();
        return this.cursor;
    }

    public boolean getDragDetect() {
        this.checkWidget();
        return (this.state & 0x8000) != 0;
    }

    boolean getDrawing() {
        return this.drawCount <= 0;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return OS.IsWindowEnabled(this.handle);
    }

    public Font getFont() {
        this.checkWidget();
        if (this.font != null) {
            return this.font;
        }
        long hFont = OS.SendMessage(this.handle, 49, 0L, 0L);
        if (hFont == 0L) {
            hFont = this.defaultFont();
        }
        return Font.win32_new(this.display, hFont);
    }

    public Color getForeground() {
        this.checkWidget();
        return Color.win32_new(this.display, this.getForegroundPixel());
    }

    int getForegroundPixel() {
        return this.foreground != -1 ? this.foreground : this.defaultForeground();
    }

    public Object getLayoutData() {
        this.checkWidget();
        return this.layoutData;
    }

    public Point getLocation() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getLocationInPixels());
    }

    Point getLocationInPixels() {
        this.forceResize();
        RECT rect = new RECT();
        OS.GetWindowRect(this.topHandle(), rect);
        long hwndParent = this.parent == null ? 0L : this.parent.handle;
        OS.MapWindowPoints(0L, hwndParent, rect, 2);
        return new Point(rect.left, rect.top);
    }

    @Override
    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    public Monitor getMonitor() {
        this.checkWidget();
        long hmonitor = OS.MonitorFromWindow(this.handle, 2);
        return this.display.getMonitor(hmonitor);
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Composite getParent() {
        this.checkWidget();
        return this.parent;
    }

    Control[] getPath() {
        int count = 0;
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell) {
            ++count;
            control = control.parent;
        }
        control = this;
        Control[] result2 = new Control[count];
        while (control != shell) {
            result2[--count] = control;
            control = control.parent;
        }
        return result2;
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public Point getSize() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getSizeInPixels());
    }

    Point getSizeInPixels() {
        this.forceResize();
        RECT rect = new RECT();
        OS.GetWindowRect(this.topHandle(), rect);
        int width = rect.right - rect.left;
        int height = rect.bottom - rect.top;
        return new Point(width, height);
    }

    int getSlightlyDifferentColor(int pixel) {
        return this.getDifferentColor(pixel, 0.1);
    }

    int getDifferentColor(int pixel) {
        return this.getDifferentColor(pixel, 0.2);
    }

    int getDifferentColor(int pixel, double factor) {
        int red = pixel & 0xFF;
        int green = (pixel & 0xFF00) >> 8;
        int blue = (pixel & 0xFF0000) >> 16;
        red = (int)((long)red + this.calcDiff(red, factor));
        green = (int)((long)green + this.calcDiff(green, factor));
        blue = (int)((long)blue + this.calcDiff(blue, factor));
        return red & 0xFF | (green & 0xFF) << 8 | (blue & 0xFF) << 16;
    }

    long calcDiff(int component, double factor) {
        if (component > 127) {
            return Math.round((double)(component * -1) * factor);
        }
        return Math.round((double)(255 - component) * factor);
    }

    int getSlightlyDifferentBackgroundColor(int pixel) {
        int offset = 8;
        int red = pixel & 0xFF;
        int green = (pixel & 0xFF00) >> 8;
        int blue = (pixel & 0xFF0000) >> 16;
        red = red > 127 ? red - offset : red + offset;
        green = green > 127 ? green - offset : green + offset;
        blue = blue > 127 ? blue - offset : blue + offset;
        return red & 0xFF | (green & 0xFF) << 8 | (blue & 0xFF) << 16;
    }

    public int getTextDirection() {
        this.checkWidget();
        int flags = 0x402000;
        int bits = OS.GetWindowLong(this.handle, -20) & flags;
        return bits == 0 || bits == flags ? 0x2000000 : 0x4000000;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getTouchEnabled() {
        this.checkWidget();
        return OS.IsTouchWindow(this.handle, null);
    }

    public boolean getVisible() {
        this.checkWidget();
        if (!this.getDrawing()) {
            return (this.state & 0x10) == 0;
        }
        int bits = OS.GetWindowLong(this.handle, -16);
        return (bits & 0x10000000) != 0;
    }

    boolean hasCursor() {
        RECT rect = new RECT();
        if (!OS.GetClientRect(this.handle, rect)) {
            return false;
        }
        OS.MapWindowPoints(this.handle, 0L, rect, 2);
        POINT pt = new POINT();
        return OS.GetCursorPos(pt) && OS.PtInRect(rect, pt);
    }

    boolean hasCustomBackground() {
        return this.background != -1;
    }

    boolean hasCustomForeground() {
        return this.foreground != -1;
    }

    boolean hasFocus() {
        long hwndFocus = OS.GetFocus();
        while (hwndFocus != 0L) {
            if (hwndFocus == this.handle) {
                return true;
            }
            if (this.display.getControl(hwndFocus) != null) {
                return false;
            }
            hwndFocus = OS.GetParent(hwndFocus);
        }
        return false;
    }

    @Override
    public long internal_new_GC(GCData data2) {
        this.checkWidget();
        long hwnd = this.handle;
        if (data2 != null && data2.hwnd != 0L) {
            hwnd = data2.hwnd;
        }
        if (data2 != null) {
            data2.hwnd = hwnd;
        }
        long hDC = 0L;
        hDC = data2 == null || data2.ps == null ? OS.GetDC(hwnd) : OS.BeginPaint(hwnd, data2.ps);
        if (hDC == 0L) {
            this.error(2);
        }
        if (data2 != null) {
            int background;
            Control control;
            int mask = 0x6000000;
            if ((data2.style & mask) != 0) {
                data2.layout = (data2.style & 0x4000000) != 0 ? 1 : 0;
            } else {
                int flags = OS.GetLayout(hDC);
                data2.style = (flags & 1) != 0 ? (data2.style |= 0xC000000) : (data2.style |= 0x2000000);
            }
            data2.device = this.display;
            int foreground = this.getForegroundPixel();
            if (foreground != OS.GetTextColor(hDC)) {
                data2.foreground = foreground;
            }
            if ((control = this.findBackgroundControl()) == null) {
                control = this;
            }
            if ((background = control.getBackgroundPixel()) != OS.GetBkColor(hDC)) {
                data2.background = background;
            }
            data2.font = this.font != null ? this.font : Font.win32_new(this.display, OS.SendMessage(hwnd, 49, 0L, 0L));
            data2.uiState = (int)OS.SendMessage(hwnd, 297, 0L, 0L);
        }
        return hDC;
    }

    @Override
    public void internal_dispose_GC(long hDC, GCData data2) {
        this.checkWidget();
        long hwnd = this.handle;
        if (data2 != null && data2.hwnd != 0L) {
            hwnd = data2.hwnd;
        }
        if (data2 == null || data2.ps == null) {
            OS.ReleaseDC(hwnd, hDC);
        } else {
            OS.EndPaint(hwnd, data2.ps);
        }
    }

    boolean isActive() {
        Shell dialogShell;
        Dialog dialog2 = this.display.getModalDialog();
        if (dialog2 != null && (dialogShell = dialog2.parent) != null && !dialogShell.isDisposed() && dialogShell != this.getShell()) {
            return false;
        }
        Shell shell = null;
        Shell[] modalShells = this.display.modalShells;
        if (modalShells != null) {
            int bits = 196608;
            int index = modalShells.length;
            while (--index >= 0) {
                Shell modal = modalShells[index];
                if (modal == null) continue;
                if ((modal.style & bits) != 0) {
                    Control control = this;
                    while (control != null) {
                        if (control == modal) break;
                        control = control.parent;
                    }
                    if (control == modal) break;
                    return false;
                }
                if ((modal.style & 0x8000) == 0) continue;
                if (shell == null) {
                    shell = this.getShell();
                }
                if (modal.parent != shell) continue;
                return false;
            }
        }
        if (shell == null) {
            shell = this.getShell();
        }
        return shell.getEnabled();
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        Control focusControl = this.display.focusControl;
        if (focusControl != null && !focusControl.isDisposed()) {
            return this == focusControl;
        }
        return this.hasFocus();
    }

    boolean isFocusAncestor(Control control) {
        while (control != null && control != this && !(control instanceof Shell)) {
            control = control.parent;
        }
        return control == this;
    }

    public boolean isReparentable() {
        this.checkWidget();
        return true;
    }

    boolean isShowing() {
        if (!this.isVisible()) {
            return false;
        }
        Control control = this;
        while (control != null) {
            Point size = control.getSizeInPixels();
            if (size.x == 0 || size.y == 0) {
                return false;
            }
            control = control.parent;
        }
        return true;
    }

    boolean isTabGroup() {
        int bits;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i2 = 0;
            while (i2 < tabList.length) {
                if (tabList[i2] == this) {
                    return true;
                }
                ++i2;
            }
        }
        return ((bits = OS.GetWindowLong(this.handle, -16)) & 0x10000) != 0;
    }

    boolean isTabItem() {
        int bits;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i2 = 0;
            while (i2 < tabList.length) {
                if (tabList[i2] == this) {
                    return false;
                }
                ++i2;
            }
        }
        if (((bits = OS.GetWindowLong(this.handle, -16)) & 0x10000) != 0) {
            return false;
        }
        long code = OS.SendMessage(this.handle, 135, 0L, 0L);
        if ((code & 0x100L) != 0L) {
            return false;
        }
        if ((code & 4L) != 0L) {
            return false;
        }
        if ((code & 1L) != 0L) {
            return false;
        }
        return (code & 2L) == 0L;
    }

    public boolean isVisible() {
        this.checkWidget();
        if (OS.IsWindowVisible(this.handle)) {
            return true;
        }
        return this.getVisible() && this.parent.isVisible();
    }

    @Override
    void mapEvent(long hwnd, Event event) {
        if (hwnd != this.handle) {
            POINT point = new POINT();
            Point loc = event.getLocationInPixels();
            point.x = loc.x;
            point.y = loc.y;
            OS.MapWindowPoints(hwnd, this.handle, point, 1);
            event.setLocationInPixels(point.x, point.y);
        }
    }

    void markLayout(boolean changed2, boolean all) {
    }

    Decorations menuShell() {
        return this.parent.menuShell();
    }

    boolean mnemonicHit(char key2) {
        return false;
    }

    boolean mnemonicMatch(char key2) {
        return false;
    }

    public void moveAbove(Control control) {
        this.checkWidget();
        long topHandle = this.topHandle();
        long hwndAbove = 0L;
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
            long hwnd = control.topHandle();
            if (hwnd == 0L || hwnd == topHandle) {
                return;
            }
            hwndAbove = OS.GetWindow(hwnd, 3);
            if (hwndAbove == 0L || hwndAbove == hwnd) {
                hwndAbove = 0L;
            }
        }
        int flags = 19;
        OS.SetWindowPos(topHandle, hwndAbove, 0, 0, 0, 0, flags);
    }

    public void moveBelow(Control control) {
        this.checkWidget();
        long topHandle = this.topHandle();
        long hwndAbove = 1L;
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
            hwndAbove = control.topHandle();
        } else {
            Shell shell = this.getShell();
            if (this == shell && this.parent != null) {
                long hwndParent;
                long hwnd = hwndParent = this.parent.handle;
                hwndAbove = OS.GetWindow(hwnd, 3);
                while (hwndAbove != 0L && hwndAbove != hwnd) {
                    if (OS.GetWindow(hwndAbove, 4) == hwndParent) break;
                    hwnd = hwndAbove;
                    hwndAbove = OS.GetWindow(hwnd, 3);
                }
                if (hwndAbove == hwnd) {
                    return;
                }
            }
        }
        if (hwndAbove == 0L || hwndAbove == topHandle) {
            return;
        }
        int flags = 19;
        OS.SetWindowPos(topHandle, hwndAbove, 0, 0, 0, 0, flags);
    }

    Accessible new_Accessible(Control control) {
        return Accessible.internal_new_Accessible(this);
    }

    @Override
    GC new_GC(GCData data2) {
        return GC.win32_new(this, data2);
    }

    public void pack() {
        this.checkWidget();
        this.pack(true);
    }

    public void pack(boolean changed2) {
        this.checkWidget();
        this.setSize(this.computeSize(-1, -1, changed2));
    }

    public boolean print(GC gc) {
        this.checkWidget();
        if (gc == null) {
            this.error(4);
        }
        if (gc.isDisposed()) {
            this.error(5);
        }
        long topHandle = this.topHandle();
        long hdc = gc.handle;
        int state = 0;
        long gdipGraphics = gc.getGCData().gdipGraphics;
        if (gdipGraphics != 0L) {
            long clipRgn = 0L;
            Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 3);
            long rgn = Gdip.Region_new();
            if (rgn == 0L) {
                this.error(2);
            }
            Gdip.Graphics_GetClip(gdipGraphics, rgn);
            if (!Gdip.Region_IsInfinite(rgn, gdipGraphics)) {
                clipRgn = Gdip.Region_GetHRGN(rgn, gdipGraphics);
            }
            Gdip.Region_delete(rgn);
            Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 4);
            float[] lpXform = null;
            long matrix = Gdip.Matrix_new(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            if (matrix == 0L) {
                this.error(2);
            }
            Gdip.Graphics_GetTransform(gdipGraphics, matrix);
            if (!Gdip.Matrix_IsIdentity(matrix)) {
                lpXform = new float[6];
                Gdip.Matrix_GetElements(matrix, lpXform);
            }
            Gdip.Matrix_delete(matrix);
            hdc = Gdip.Graphics_GetHDC(gdipGraphics);
            state = OS.SaveDC(hdc);
            if (lpXform != null) {
                OS.SetGraphicsMode(hdc, 2);
                OS.SetWorldTransform(hdc, lpXform);
            }
            if (clipRgn != 0L) {
                OS.SelectClipRgn(hdc, clipRgn);
                OS.DeleteObject(clipRgn);
            }
        }
        int flags = 384;
        OS.RedrawWindow(topHandle, null, 0L, flags);
        this.printWidget(topHandle, hdc, gc);
        if (gdipGraphics != 0L) {
            OS.RestoreDC(hdc, state);
            Gdip.Graphics_ReleaseHDC(gdipGraphics, hdc);
        }
        return true;
    }

    void printWidget(long hwnd, long hdc, GC gc) {
        boolean success = false;
        if (OS.GetDeviceCaps(gc.handle, 2) != 2) {
            boolean fixPrintWindow;
            long hwndParent;
            long hwndShell = hwndParent = OS.GetParent(hwnd);
            while (OS.GetParent(hwndShell) != 0L) {
                if (OS.GetWindow(hwndShell, 4) != 0L) break;
                hwndShell = OS.GetParent(hwndShell);
            }
            RECT rect1 = new RECT();
            OS.GetWindowRect(hwnd, rect1);
            boolean bl = fixPrintWindow = !OS.IsWindowVisible(hwnd);
            if (!fixPrintWindow) {
                RECT rect2 = new RECT();
                OS.GetWindowRect(hwndShell, rect2);
                OS.IntersectRect(rect2, rect1, rect2);
                boolean bl2 = fixPrintWindow = !OS.EqualRect(rect2, rect1);
            }
            if (!fixPrintWindow) {
                long rgn = OS.CreateRectRgn(0, 0, 0, 0);
                long parent = OS.GetParent(hwnd);
                while (parent != hwndShell && !fixPrintWindow) {
                    if (OS.GetWindowRgn(parent, rgn) != 0) {
                        fixPrintWindow = true;
                    }
                    parent = OS.GetParent(parent);
                }
                OS.DeleteObject(rgn);
            }
            int bits1 = OS.GetWindowLong(hwnd, -16);
            int bits2 = OS.GetWindowLong(hwnd, -20);
            long hwndInsertAfter = OS.GetWindow(hwnd, 3);
            if (hwndInsertAfter == 0L || hwndInsertAfter == hwnd) {
                hwndInsertAfter = 0L;
            }
            if (fixPrintWindow) {
                int x2 = OS.GetSystemMetrics(76);
                int y2 = OS.GetSystemMetrics(77);
                int width = OS.GetSystemMetrics(78);
                int height = OS.GetSystemMetrics(79);
                int flags = 53;
                if ((bits1 & 0x10000000) != 0) {
                    OS.DefWindowProc(hwnd, 11, 0L, 0L);
                }
                OS.SetWindowPos(hwnd, 0L, x2 + width, y2 + height, 0, 0, flags);
                OS.SetWindowLong(hwnd, -16, bits1 & 0xBFFFFFFF | Integer.MIN_VALUE);
                OS.SetWindowLong(hwnd, -20, bits2 | 0x80);
                Shell shell = this.getShell();
                Control savedFocus = shell.savedFocus;
                OS.SetParent(hwnd, 0L);
                shell.setSavedFocus(savedFocus);
                if ((bits1 & 0x10000000) != 0) {
                    OS.DefWindowProc(hwnd, 11, 1L, 0L);
                }
            }
            if ((bits1 & 0x10000000) == 0) {
                OS.ShowWindow(hwnd, 5);
            }
            success = OS.PrintWindow(hwnd, hdc, 0);
            if ((bits1 & 0x10000000) == 0) {
                OS.ShowWindow(hwnd, 0);
            }
            if (fixPrintWindow) {
                if ((bits1 & 0x10000000) != 0) {
                    OS.DefWindowProc(hwnd, 11, 0L, 0L);
                }
                OS.SetWindowLong(hwnd, -16, bits1);
                OS.SetWindowLong(hwnd, -20, bits2);
                OS.SetParent(hwnd, hwndParent);
                OS.MapWindowPoints(0L, hwndParent, rect1, 2);
                int flags = 49;
                OS.SetWindowPos(hwnd, hwndInsertAfter, rect1.left, rect1.top, rect1.right - rect1.left, rect1.bottom - rect1.top, flags);
                if ((bits1 & 0x10000000) != 0) {
                    OS.DefWindowProc(hwnd, 11, 1L, 0L);
                }
            }
        }
        if (!success) {
            int flags = 30;
            OS.SendMessage(hwnd, 791, hdc, flags);
        }
    }

    public void requestLayout() {
        this.getShell().layout(new Control[]{this}, 4);
    }

    public void redraw() {
        this.checkWidget();
        this.redraw(false);
    }

    void redraw(boolean all) {
        if (!OS.IsWindowVisible(this.handle)) {
            return;
        }
        int flags = 1029;
        if (all) {
            flags |= 0x80;
        }
        OS.RedrawWindow(this.handle, null, 0L, flags);
    }

    public void redraw(int x2, int y2, int width, int height, boolean all) {
        this.checkWidget();
        x2 = DPIUtil.autoScaleUp(x2);
        y2 = DPIUtil.autoScaleUp(y2);
        width = DPIUtil.autoScaleUp(width);
        height = DPIUtil.autoScaleUp(height);
        this.redrawInPixels(x2, y2, width, height, all);
    }

    void redrawInPixels(int x2, int y2, int width, int height, boolean all) {
        if (width <= 0 || height <= 0) {
            return;
        }
        if (!OS.IsWindowVisible(this.handle)) {
            return;
        }
        RECT rect = new RECT();
        OS.SetRect(rect, x2, y2, x2 + width, y2 + height);
        int flags = 1029;
        if (all) {
            flags |= 0x80;
        }
        OS.RedrawWindow(this.handle, rect, 0L, flags);
    }

    boolean redrawChildren() {
        if (!OS.IsWindowVisible(this.handle)) {
            return false;
        }
        Control control = this.findBackgroundControl();
        if (control == null) {
            if ((this.state & 0x100) != 0 && OS.IsAppThemed()) {
                OS.InvalidateRect(this.handle, null, true);
                return true;
            }
        } else if (control.backgroundImage != null) {
            OS.InvalidateRect(this.handle, null, true);
            return true;
        }
        return false;
    }

    void register() {
        this.display.addControl(this.handle, this);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.handle = 0L;
        this.parent = null;
    }

    @Override
    void releaseParent() {
        this.parent.removeControl(this);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (OS.IsDBLocale) {
            OS.ImmAssociateContext(this.handle, this.hPrevIMC);
            this.hPrevIMC = 0L;
        }
        if (this.toolTipText != null) {
            this.setToolTipText(this.getShell(), null);
        }
        this.toolTipText = null;
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.backgroundImage = null;
        this.menu = null;
        this.cursor = null;
        this.unsubclass();
        this.deregister();
        this.layoutData = null;
        if (this.accessible != null) {
            this.accessible.internal_dispose_Accessible();
        }
        this.accessible = null;
        this.region = null;
        this.font = null;
    }

    public void removeControlListener(ControlListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener2);
        this.eventTable.unhook(11, listener2);
    }

    public void removeDragDetectListener(DragDetectListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(29, listener2);
    }

    public void removeFocusListener(FocusListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(15, listener2);
        this.eventTable.unhook(16, listener2);
    }

    public void removeGestureListener(GestureListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(48, listener2);
    }

    public void removeHelpListener(HelpListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener2);
    }

    public void removeKeyListener(KeyListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, listener2);
        this.eventTable.unhook(1, listener2);
    }

    public void removeMenuDetectListener(MenuDetectListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(35, listener2);
    }

    public void removeMouseTrackListener(MouseTrackListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(6, listener2);
        this.eventTable.unhook(7, listener2);
        this.eventTable.unhook(32, listener2);
    }

    public void removeMouseListener(MouseListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(3, listener2);
        this.eventTable.unhook(4, listener2);
        this.eventTable.unhook(8, listener2);
    }

    public void removeMouseMoveListener(MouseMoveListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(5, listener2);
    }

    public void removeMouseWheelListener(MouseWheelListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(37, listener2);
    }

    public void removePaintListener(PaintListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(9, listener2);
    }

    public void removeTouchListener(TouchListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(47, listener2);
    }

    public void removeTraverseListener(TraverseListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(31, listener2);
    }

    int resolveTextDirection() {
        return 0;
    }

    void showWidget(boolean visible) {
        long topHandle = this.topHandle();
        OS.ShowWindow(topHandle, visible ? 5 : 0);
        if (this.handle != topHandle) {
            OS.ShowWindow(this.handle, visible ? 5 : 0);
        }
    }

    @Override
    boolean sendFocusEvent(int type2) {
        Shell shell = this.getShell();
        Display display = this.display;
        display.focusEvent = type2;
        display.focusControl = this;
        this.sendEvent(type2);
        display.focusEvent = 0;
        display.focusControl = null;
        if (!shell.isDisposed()) {
            switch (type2) {
                case 15: {
                    shell.setActiveControl(this);
                    break;
                }
                case 16: {
                    if (shell == display.getActiveShell()) break;
                    shell.setActiveControl(null);
                }
            }
        }
        return true;
    }

    boolean sendGestureEvent(GESTUREINFO gi) {
        if (gi.hwndTarget != this.handle) {
            return true;
        }
        Event event = new Event();
        int type2 = 0;
        Point globalPt = new Point(gi.x, gi.y);
        Point point = this.toControlInPixels(globalPt.x, globalPt.y);
        event.setLocationInPixels(point.x, point.y);
        switch (gi.dwID) {
            case 3: {
                type2 = 48;
                event.detail = 32;
                int fingerDistance = OS.LODWORD(gi.ullArguments);
                if ((gi.dwFlags & 1) != 0) {
                    event.detail = 2;
                    this.display.magStartDistance = this.display.lastDistance = (double)fingerDistance;
                } else if ((gi.dwFlags & 4) != 0) {
                    event.detail = 4;
                }
                if ((double)fingerDistance == this.display.lastDistance && event.detail == 32) {
                    return true;
                }
                if (fingerDistance != 0) {
                    event.magnification = (double)fingerDistance / this.display.magStartDistance;
                }
                this.display.lastDistance = fingerDistance;
                break;
            }
            case 4: {
                type2 = 48;
                event.detail = 64;
                if ((gi.dwFlags & 1) != 0) {
                    event.detail = 2;
                    this.display.lastX = point.x;
                    this.display.lastY = point.y;
                } else if ((gi.dwFlags & 4) != 0) {
                    event.detail = 4;
                }
                if (this.display.lastX == point.x && this.display.lastY == point.y && event.detail == 64) {
                    return true;
                }
                event.xDirection = point.x - this.display.lastX;
                event.yDirection = point.y - this.display.lastY;
                this.display.lastX = point.x;
                this.display.lastY = point.y;
                break;
            }
            case 5: {
                type2 = 48;
                event.detail = 8;
                double rotationInRadians = OS.GID_ROTATE_ANGLE_FROM_ARGUMENT(OS.LODWORD(gi.ullArguments));
                if ((gi.dwFlags & 1) != 0) {
                    event.detail = 2;
                    this.display.rotationAngle = rotationInRadians;
                } else if ((gi.dwFlags & 4) != 0) {
                    event.detail = 4;
                }
                if (this.display.rotationAngle == rotationInRadians && event.detail == 8) {
                    return true;
                }
                event.rotation = rotationInRadians * 180.0 / Math.PI;
                this.display.rotationAngle = rotationInRadians;
                break;
            }
        }
        if (type2 == 0) {
            return true;
        }
        this.setInputState(event, type2);
        this.sendEvent(type2, event);
        return event.doit;
    }

    void sendMove() {
        this.sendEvent(10);
    }

    void sendResize() {
        this.sendEvent(11);
    }

    void sendTouchEvent(TOUCHINPUT[] touchInput) {
        Event event = new Event();
        POINT pt = new POINT();
        OS.GetCursorPos(pt);
        OS.ScreenToClient(this.handle, pt);
        event.setLocationInPixels(pt.x, pt.y);
        Touch[] touches = new Touch[touchInput.length];
        Monitor monitor = this.getMonitor();
        int i2 = 0;
        while (i2 < touchInput.length) {
            TOUCHINPUT ti = touchInput[i2];
            TouchSource inputSource = this.display.findTouchSource(ti.hSource, monitor);
            int state = 0;
            if ((ti.dwFlags & 2) != 0) {
                state = 1;
            }
            if ((ti.dwFlags & 4) != 0) {
                state = 4;
            }
            if ((ti.dwFlags & 1) != 0) {
                state = 2;
            }
            boolean primary = (ti.dwFlags & 0x10) != 0;
            int x2 = (int)OS.TOUCH_COORD_TO_PIXEL(ti.x);
            int y2 = (int)OS.TOUCH_COORD_TO_PIXEL(ti.y);
            touches[i2] = new Touch(ti.dwID, inputSource, state, primary, x2, y2);
            ++i2;
        }
        event.touches = touches;
        this.setInputState(event, 47);
        this.postEvent(47, event);
    }

    void setBackground() {
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        if (control.backgroundImage != null) {
            Shell shell = this.getShell();
            shell.releaseBrushes();
            this.setBackgroundImage(control.backgroundImage.handle);
        } else {
            this.setBackgroundPixel(control.background == -1 ? control.defaultBackground() : control.background);
        }
    }

    public void setBackground(Color color) {
        this.checkWidget();
        this._setBackground(color);
        if (color != null) {
            this.updateBackgroundMode();
        }
    }

    private void _setBackground(Color color) {
        int pixel = -1;
        int alpha = 255;
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            pixel = color.handle;
            alpha = color.getAlpha();
        }
        if (pixel == this.background && alpha == this.backgroundAlpha) {
            return;
        }
        this.background = pixel;
        this.backgroundAlpha = alpha;
        this.updateBackgroundColor();
    }

    public void setBackgroundImage(Image image) {
        this.checkWidget();
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            if (image.type != 0) {
                this.error(5);
            }
        }
        if (this.backgroundImage == image && this.backgroundAlpha > 0) {
            return;
        }
        this.backgroundAlpha = 255;
        this.backgroundImage = image;
        Shell shell = this.getShell();
        shell.releaseBrushes();
        this.updateBackgroundImage();
    }

    void setBackgroundImage(long hBitmap) {
        int flags = 1029;
        OS.RedrawWindow(this.handle, null, 0L, flags);
    }

    void setBackgroundPixel(int pixel) {
        int flags = 1029;
        OS.RedrawWindow(this.handle, null, 0L, flags);
    }

    public void setBounds(int x2, int y2, int width, int height) {
        this.checkWidget();
        x2 = DPIUtil.autoScaleUp(x2);
        y2 = DPIUtil.autoScaleUp(y2);
        width = DPIUtil.autoScaleUp(width);
        height = DPIUtil.autoScaleUp(height);
        this.setBoundsInPixels(x2, y2, width, height);
    }

    void setBoundsInPixels(int x2, int y2, int width, int height) {
        int flags = 52;
        this.setBoundsInPixels(x2, y2, Math.max(0, width), Math.max(0, height), flags);
    }

    void setBoundsInPixels(int x2, int y2, int width, int height, int flags) {
        this.setBoundsInPixels(x2, y2, width, height, flags, true);
    }

    void setBoundsInPixels(int x2, int y2, int width, int height, int flags, boolean defer) {
        if (this.findImageControl() != null) {
            if (this.backgroundImage == null) {
                flags |= 0x100;
            }
        } else if (OS.GetWindow(this.handle, 5) == 0L && OS.IsAppThemed() && this.findThemeControl() != null) {
            flags |= 0x100;
        }
        long topHandle = this.topHandle();
        if (defer && this.parent != null) {
            this.forceResize();
            if (this.parent.lpwp != null) {
                int index = 0;
                WINDOWPOS[] lpwp = this.parent.lpwp;
                while (index < lpwp.length) {
                    if (lpwp[index] == null) break;
                    ++index;
                }
                if (index == lpwp.length) {
                    WINDOWPOS[] newLpwp = new WINDOWPOS[lpwp.length + 4];
                    System.arraycopy(lpwp, 0, newLpwp, 0, lpwp.length);
                    lpwp = newLpwp;
                    this.parent.lpwp = newLpwp;
                }
                WINDOWPOS wp = new WINDOWPOS();
                wp.hwnd = topHandle;
                wp.x = x2;
                wp.y = y2;
                wp.cx = width;
                wp.cy = height;
                wp.flags = flags;
                lpwp[index] = wp;
                return;
            }
        }
        OS.SetWindowPos(topHandle, 0L, x2, y2, width, height, flags);
    }

    public void setBounds(Rectangle rect) {
        this.checkWidget();
        if (rect == null) {
            this.error(4);
        }
        this.setBoundsInPixels(DPIUtil.autoScaleUp(rect));
    }

    void setBoundsInPixels(Rectangle rect) {
        this.setBoundsInPixels(rect.x, rect.y, rect.width, rect.height);
    }

    public void setCapture(boolean capture) {
        this.checkWidget();
        if (capture) {
            OS.SetCapture(this.handle);
        } else if (OS.GetCapture() == this.handle) {
            OS.ReleaseCapture();
        }
    }

    void setCursor() {
        long lParam = OS.MAKELPARAM(1, 512);
        OS.SendMessage(this.handle, 32, this.handle, lParam);
    }

    public void setCursor(Cursor cursor) {
        Control control;
        this.checkWidget();
        if (cursor != null && cursor.isDisposed()) {
            this.error(5);
        }
        this.cursor = cursor;
        long hwndCursor = OS.GetCapture();
        if (hwndCursor == 0L) {
            POINT pt = new POINT();
            if (!OS.GetCursorPos(pt)) {
                return;
            }
            long hwnd = hwndCursor = OS.WindowFromPoint(pt);
            while (hwnd != 0L && hwnd != this.handle) {
                hwnd = OS.GetParent(hwnd);
            }
            if (hwnd == 0L) {
                return;
            }
        }
        if ((control = this.display.getControl(hwndCursor)) == null) {
            control = this;
        }
        control.setCursor();
    }

    void setDefaultFont() {
        long hFont = this.display.getSystemFont().handle;
        OS.SendMessage(this.handle, 48, hFont, 0L);
    }

    public void setDragDetect(boolean dragDetect) {
        this.checkWidget();
        this.state = dragDetect ? (this.state |= 0x8000) : (this.state &= 0xFFFF7FFF);
        this.enableDrag(dragDetect);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        Control control = null;
        boolean fixFocus = false;
        if (!enabled && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            fixFocus = this.isFocusAncestor(control);
        }
        this.enableWidget(enabled);
        if (fixFocus) {
            this.fixFocus(control);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        if ((this.style & 0x80000) != 0) {
            return false;
        }
        return this.forceFocus();
    }

    public void setFont(Font font) {
        this.checkWidget();
        long hFont = 0L;
        if (font != null) {
            if (font.isDisposed()) {
                this.error(5);
            }
            hFont = font.handle;
        }
        this.font = font;
        if (hFont == 0L) {
            hFont = this.defaultFont();
        }
        OS.SendMessage(this.handle, 48, hFont, 1L);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        int pixel = -1;
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            pixel = color.handle;
        }
        if (pixel == this.foreground) {
            return;
        }
        this.foreground = pixel;
        this.setForegroundPixel(pixel);
    }

    void setForegroundPixel(int pixel) {
        OS.InvalidateRect(this.handle, null, true);
    }

    public void setLayoutData(Object layoutData) {
        this.checkWidget();
        this.layoutData = layoutData;
    }

    public void setLocation(int x2, int y2) {
        this.checkWidget();
        x2 = DPIUtil.autoScaleUp(x2);
        y2 = DPIUtil.autoScaleUp(y2);
        this.setLocationInPixels(x2, y2);
    }

    void setLocationInPixels(int x2, int y2) {
        int flags = 53;
        this.setBoundsInPixels(x2, y2, 0, 0, flags);
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        location = DPIUtil.autoScaleUp(location);
        this.setLocationInPixels(location.x, location.y);
    }

    public void setMenu(Menu menu2) {
        this.checkWidget();
        if (menu2 != null) {
            if (menu2.isDisposed()) {
                this.error(5);
            }
            if ((menu2.style & 8) == 0) {
                this.error(37);
            }
            if (menu2.parent != this.menuShell()) {
                this.error(32);
            }
        }
        this.menu = menu2;
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
        int flags = 0x6000000;
        if ((orientation & flags) == 0 || (orientation & flags) == flags) {
            return;
        }
        this.style &= 0xF7FFFFFF;
        this.style &= ~flags;
        this.style |= orientation & flags;
        this.style &= Integer.MAX_VALUE;
        this.updateOrientation();
        this.checkMirrored();
    }

    boolean setRadioFocus(boolean tabbing) {
        return false;
    }

    boolean setRadioSelection(boolean value) {
        return false;
    }

    public void setRedraw(boolean redraw) {
        int bits;
        this.checkWidget();
        if (this.drawCount == 0 && ((bits = OS.GetWindowLong(this.handle, -16)) & 0x10000000) == 0) {
            this.state |= 0x10;
        }
        if (redraw) {
            if (--this.drawCount == 0) {
                long topHandle = this.topHandle();
                OS.SendMessage(topHandle, 11, 1L, 0L);
                if (this.handle != topHandle) {
                    OS.SendMessage(this.handle, 11, 1L, 0L);
                }
                if ((this.state & 0x10) != 0) {
                    this.state &= 0xFFFFFFEF;
                    OS.ShowWindow(topHandle, 0);
                    if (this.handle != topHandle) {
                        OS.ShowWindow(this.handle, 0);
                    }
                } else {
                    int flags = 1157;
                    OS.RedrawWindow(topHandle, null, 0L, flags);
                }
            }
        } else if (this.drawCount++ == 0) {
            long topHandle = this.topHandle();
            OS.SendMessage(topHandle, 11, 0L, 0L);
            if (this.handle != topHandle) {
                OS.SendMessage(this.handle, 11, 0L, 0L);
            }
        }
    }

    public void setRegion(Region region2) {
        this.checkWidget();
        if (region2 != null && region2.isDisposed()) {
            this.error(5);
        }
        long hRegion = 0L;
        if (region2 != null) {
            hRegion = OS.CreateRectRgn(0, 0, 0, 0);
            OS.CombineRgn(hRegion, region2.handle, hRegion, 2);
        }
        OS.SetWindowRgn(this.handle, hRegion, true);
        this.region = region2;
    }

    public void setSize(int width, int height) {
        this.checkWidget();
        width = DPIUtil.autoScaleUp(width);
        height = DPIUtil.autoScaleUp(height);
        this.setSizeInPixels(width, height);
    }

    void setSizeInPixels(int width, int height) {
        int flags = 54;
        this.setBoundsInPixels(0, 0, Math.max(0, width), Math.max(0, height), flags);
    }

    public void setSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        size = DPIUtil.autoScaleUp(size);
        this.setSizeInPixels(size.x, size.y);
    }

    @Override
    boolean setTabItemFocus() {
        if (!this.isShowing()) {
            return false;
        }
        return this.forceFocus();
    }

    public void setTextDirection(int textDirection) {
        this.checkWidget();
        this.updateTextDirection(textDirection &= 0x6000000);
        this.state = textDirection == 0x6000000 ? (this.state |= 0x400000) : (this.state &= 0xFFBFFFFF);
    }

    public void setToolTipText(String string2) {
        this.checkWidget();
        this.toolTipText = string2;
        this.setToolTipText(this.getShell(), string2);
    }

    void setToolTipText(Shell shell, String string2) {
        shell.setToolTipText(this.handle, string2);
    }

    public void setTouchEnabled(boolean enabled) {
        this.checkWidget();
        if (enabled) {
            OS.RegisterTouchWindow(this.handle, 0);
        } else {
            OS.UnregisterTouchWindow(this.handle);
        }
    }

    public void setVisible(boolean visible) {
        int bits;
        this.checkWidget();
        if (!this.getDrawing() ? (this.state & 0x10) == 0 == visible : ((bits = OS.GetWindowLong(this.handle, -16)) & 0x10000000) != 0 == visible) {
            return;
        }
        if (visible) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
        }
        Control control = null;
        boolean fixFocus = false;
        if (!visible && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            fixFocus = this.isFocusAncestor(control);
        }
        if (!this.getDrawing()) {
            this.state = visible ? this.state & 0xFFFFFFEF : this.state | 0x10;
        } else {
            this.showWidget(visible);
            if (this.isDisposed()) {
                return;
            }
        }
        if (!visible) {
            this.sendEvent(23);
            if (this.isDisposed()) {
                return;
            }
        }
        if (fixFocus) {
            this.fixFocus(control);
        }
    }

    void sort(int[] items) {
        int length = items.length;
        int gap = length / 2;
        while (gap > 0) {
            int i2 = gap;
            while (i2 < length) {
                int j2 = i2 - gap;
                while (j2 >= 0) {
                    if (items[j2] <= items[j2 + gap]) {
                        int swap = items[j2];
                        items[j2] = items[j2 + gap];
                        items[j2 + gap] = swap;
                    }
                    j2 -= gap;
                }
                ++i2;
            }
            gap /= 2;
        }
    }

    void subclass() {
        long newProc;
        long oldProc = this.windowProc();
        if (oldProc == (newProc = this.display.windowProc)) {
            return;
        }
        OS.SetWindowLongPtr(this.handle, -4, newProc);
    }

    public Point toControl(int x2, int y2) {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.toControlInPixels(DPIUtil.autoScaleUp(x2), DPIUtil.autoScaleUp(y2)));
    }

    Point toControlInPixels(int x2, int y2) {
        POINT pt = new POINT();
        pt.x = x2;
        pt.y = y2;
        OS.ScreenToClient(this.handle, pt);
        return new Point(pt.x, pt.y);
    }

    public Point toControl(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        point = DPIUtil.autoScaleUp(point);
        return DPIUtil.autoScaleDown(this.toControlInPixels(point.x, point.y));
    }

    public Point toDisplay(int x2, int y2) {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.toDisplayInPixels(DPIUtil.autoScaleUp(x2), DPIUtil.autoScaleUp(y2)));
    }

    Point toDisplayInPixels(int x2, int y2) {
        POINT pt = new POINT();
        pt.x = x2;
        pt.y = y2;
        OS.ClientToScreen(this.handle, pt);
        return new Point(pt.x, pt.y);
    }

    public Point toDisplay(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        point = DPIUtil.autoScaleUp(point);
        return DPIUtil.autoScaleDown(this.toDisplayInPixels(point.x, point.y));
    }

    long topHandle() {
        return this.handle;
    }

    boolean translateAccelerator(MSG msg) {
        return this.menuShell().translateAccelerator(msg);
    }

    boolean translateMnemonic(Event event, Control control) {
        if (control == this) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        event.doit = this.mnemonicMatch(event.character);
        return this.traverse(event);
    }

    boolean translateMnemonic(MSG msg) {
        Decorations shell;
        if (msg.wParam < 32L) {
            return false;
        }
        long hwnd = msg.hwnd;
        if (OS.GetKeyState(18) >= 0) {
            long code = OS.SendMessage(hwnd, 135, 0L, 0L);
            if ((code & 4L) != 0L) {
                return false;
            }
            if ((code & 0x2000L) == 0L) {
                return false;
            }
        }
        if ((shell = this.menuShell()).isVisible() && shell.isEnabled()) {
            this.display.lastAscii = (int)msg.wParam;
            this.display.lastDead = false;
            this.display.lastNull = false;
            Event event = new Event();
            event.detail = 128;
            if (this.setKeyState(event, 31, msg.wParam, msg.lParam)) {
                return this.translateMnemonic(event, null) || shell.translateMnemonic(event, this);
            }
        }
        return false;
    }

    boolean translateTraversal(MSG msg) {
        long hwnd = msg.hwnd;
        int key2 = (int)msg.wParam;
        if (key2 == 18) {
            if ((msg.lParam & 0x40000000L) == 0L) {
                OS.SendMessage(hwnd, 295, 3L, 0L);
            }
            return false;
        }
        int detail = 0;
        boolean doit = true;
        boolean all = false;
        boolean lastVirtual = false;
        int lastKey = key2;
        int lastAscii = 0;
        switch (key2) {
            case 27: {
                all = true;
                lastAscii = 27;
                long code = OS.SendMessage(hwnd, 135, 0L, 0L);
                if ((code & 4L) != 0L && (code & 8L) == 0L) {
                    doit = false;
                }
                detail = 2;
                break;
            }
            case 13: {
                all = true;
                lastAscii = 13;
                long code = OS.SendMessage(hwnd, 135, 0L, 0L);
                if ((code & 4L) != 0L) {
                    doit = false;
                }
                detail = 4;
                break;
            }
            case 9: {
                lastAscii = 9;
                boolean next = OS.GetKeyState(16) >= 0;
                long code = OS.SendMessage(hwnd, 135, 0L, 0L);
                if ((code & 6L) != 0L) {
                    if ((code & 8L) != 0L) {
                        if (next && OS.GetKeyState(17) >= 0) {
                            doit = false;
                        }
                    } else {
                        doit = false;
                    }
                }
                detail = next ? 16 : 8;
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                boolean next;
                lastVirtual = true;
                long code = OS.SendMessage(hwnd, 135, 0L, 0L);
                if ((code & 1L) != 0L) {
                    doit = false;
                }
                boolean bl = next = key2 == 40 || key2 == 39;
                if (this.parent != null && (this.parent.style & 0x8000000) != 0 && (key2 == 37 || key2 == 39)) {
                    next = !next;
                }
                detail = next ? 64 : 32;
                break;
            }
            case 33: 
            case 34: {
                all = true;
                lastVirtual = true;
                if (OS.GetKeyState(17) >= 0) {
                    return false;
                }
                long code = OS.SendMessage(hwnd, 135, 0L, 0L);
                if ((code & 4L) != 0L && (code & 8L) == 0L) {
                    doit = false;
                }
                detail = key2 == 33 ? 256 : 512;
                break;
            }
            default: {
                return false;
            }
        }
        Event event = new Event();
        event.doit = doit;
        event.detail = detail;
        this.display.lastKey = lastKey;
        this.display.lastAscii = lastAscii;
        this.display.lastVirtual = lastVirtual;
        this.display.lastDead = false;
        this.display.lastNull = false;
        if (!this.setKeyState(event, 31, msg.wParam, msg.lParam)) {
            return false;
        }
        Shell shell = this.getShell();
        Control control = this;
        do {
            if (control.traverse(event)) {
                OS.SendMessage(hwnd, 295, 3L, 0L);
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (all && control != null);
        return false;
    }

    boolean traverse(Event event) {
        this.sendEvent(31, event);
        if (this.isDisposed()) {
            return true;
        }
        if (!event.doit) {
            return false;
        }
        switch (event.detail) {
            case 0: {
                return true;
            }
            case 2: {
                return this.traverseEscape();
            }
            case 4: {
                return this.traverseReturn();
            }
            case 16: {
                return this.traverseGroup(true);
            }
            case 8: {
                return this.traverseGroup(false);
            }
            case 64: {
                return this.traverseItem(true);
            }
            case 32: {
                return this.traverseItem(false);
            }
            case 128: {
                return this.traverseMnemonic(event.character);
            }
            case 512: {
                return this.traversePage(true);
            }
            case 256: {
                return this.traversePage(false);
            }
        }
        return false;
    }

    public boolean traverse(int traversal) {
        this.checkWidget();
        Event event = new Event();
        event.doit = true;
        event.detail = traversal;
        return this.traverse(event);
    }

    public boolean traverse(int traversal, Event event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.traverse(traversal, event.character, event.keyCode, event.keyLocation, event.stateMask, event.doit);
    }

    public boolean traverse(int traversal, KeyEvent event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.traverse(traversal, event.character, event.keyCode, event.keyLocation, event.stateMask, event.doit);
    }

    boolean traverse(int traversal, char character, int keyCode, int keyLocation, int stateMask, boolean doit) {
        if (traversal == 0) {
            switch (keyCode) {
                case 27: {
                    traversal = 2;
                    doit = true;
                    break;
                }
                case 13: {
                    traversal = 4;
                    doit = true;
                    break;
                }
                case 0x1000002: 
                case 0x1000004: {
                    traversal = 64;
                    doit = false;
                    break;
                }
                case 0x1000001: 
                case 0x1000003: {
                    traversal = 32;
                    doit = false;
                    break;
                }
                case 9: {
                    traversal = (stateMask & 0x20000) != 0 ? 8 : 16;
                    doit = true;
                    break;
                }
                case 0x1000006: {
                    if ((stateMask & 0x40000) == 0) break;
                    traversal = 512;
                    doit = true;
                    break;
                }
                case 0x1000005: {
                    if ((stateMask & 0x40000) == 0) break;
                    traversal = 256;
                    doit = true;
                    break;
                }
                default: {
                    if (character == '\u0000' || (stateMask & 0x50000) != 65536) break;
                    traversal = 128;
                    doit = true;
                }
            }
        }
        Event event = new Event();
        event.character = character;
        event.detail = traversal;
        event.doit = doit;
        event.keyCode = keyCode;
        event.keyLocation = keyLocation;
        event.stateMask = stateMask;
        Shell shell = this.getShell();
        boolean all = false;
        switch (traversal) {
            case 2: 
            case 4: 
            case 256: 
            case 512: {
                all = true;
            }
            case 8: 
            case 16: 
            case 32: 
            case 64: {
                break;
            }
            case 128: {
                return this.translateMnemonic(event, null) || shell.translateMnemonic(event, this);
            }
            default: {
                return false;
            }
        }
        Control control = this;
        do {
            if (control.traverse(event)) {
                OS.SendMessage(this.handle, 295, 3L, 0L);
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (all && control != null);
        return false;
    }

    boolean traverseEscape() {
        return false;
    }

    boolean traverseGroup(boolean next) {
        Control root2 = this.computeTabRoot();
        Widget group2 = this.computeTabGroup();
        Widget[] list2 = root2.computeTabList();
        int length = list2.length;
        int index = 0;
        while (index < length) {
            if (list2[index] == group2) break;
            ++index;
        }
        if (index == length) {
            return false;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Widget widget = list2[index];
            if (widget.isDisposed() || !widget.setTabGroupFocus()) continue;
            return true;
        }
        if (group2.isDisposed()) {
            return false;
        }
        return group2.setTabGroupFocus();
    }

    boolean traverseItem(boolean next) {
        Control[] children = this.parent._getChildren();
        int length = children.length;
        int index = 0;
        while (index < length) {
            if (children[index] == this) break;
            ++index;
        }
        if (index == length) {
            return false;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Control child = children[index];
            if (child.isDisposed() || !child.isTabItem() || !child.setTabItemFocus()) continue;
            return true;
        }
        return false;
    }

    boolean traverseMnemonic(char key2) {
        if (this.mnemonicHit(key2)) {
            OS.SendMessage(this.handle, 295, 3L, 0L);
            return true;
        }
        return false;
    }

    boolean traversePage(boolean next) {
        return false;
    }

    boolean traverseReturn() {
        return false;
    }

    void unsubclass() {
        long oldProc = this.display.windowProc;
        long newProc = this.windowProc();
        if (oldProc == newProc) {
            return;
        }
        OS.SetWindowLongPtr(this.handle, -4, newProc);
    }

    public void update() {
        this.checkWidget();
        this.update(false);
    }

    void update(boolean all) {
        int flags = 256;
        if (all) {
            flags |= 0x80;
        }
        OS.RedrawWindow(this.handle, null, 0L, flags);
    }

    void updateBackgroundColor() {
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        this.setBackgroundPixel(control.background);
    }

    void updateBackgroundImage() {
        Control control = this.findBackgroundControl();
        Image image = control != null ? control.backgroundImage : this.backgroundImage;
        this.setBackgroundImage(image != null ? image.handle : 0L);
    }

    void updateBackgroundMode() {
        int oldState = this.state & 0x400;
        this.checkBackground();
        if (oldState != (this.state & 0x400)) {
            this.setBackground();
        }
    }

    void updateFont(Font oldFont, Font newFont) {
        if (this.getFont().equals(oldFont)) {
            this.setFont(newFont);
        }
    }

    void updateLayout(boolean resize, boolean all) {
    }

    void updateOrientation() {
        int bits = OS.GetWindowLong(this.handle, -20);
        bits = (this.style & 0x4000000) != 0 ? (bits |= 0x400000) : (bits &= 0xFFBFFFFF);
        OS.SetWindowLong(this.handle, -20, bits &= 0xFFFFDFFF);
        OS.InvalidateRect(this.handle, null, true);
    }

    boolean updateTextDirection(int textDirection) {
        boolean newRtl;
        int flags;
        if (textDirection == 0x6000000) {
            textDirection = this.resolveTextDirection();
            this.state |= 0x400000;
        } else {
            this.state &= 0xFFBFFFFF;
        }
        if (textDirection == 0) {
            return false;
        }
        int bits = OS.GetWindowLong(this.handle, -20);
        boolean oldRtl = (bits & (flags = 0x402000)) != 0 && (bits & flags) != flags;
        boolean bl = newRtl = textDirection == 0x4000000;
        if (newRtl == oldRtl) {
            return false;
        }
        boolean bl2 = oldRtl = (bits & 0x400000) != 0;
        if (newRtl != oldRtl) {
            bits |= 0x2000;
            this.style |= Integer.MIN_VALUE;
        } else {
            bits &= 0xFFFFDFFF;
            this.style &= Integer.MAX_VALUE;
        }
        OS.SetWindowLong(this.handle, -20, bits);
        OS.InvalidateRect(this.handle, null, true);
        return true;
    }

    CREATESTRUCT widgetCreateStruct() {
        return null;
    }

    int widgetExtStyle() {
        int bits = 0;
        if ((this.style & 0x800) != 0) {
            bits |= 0x200;
        }
        bits |= 0x100000;
        if ((this.style & 0x4000000) != 0) {
            bits |= 0x400000;
        }
        if ((this.style & Integer.MIN_VALUE) != 0) {
            bits |= 0x2000;
        }
        return bits;
    }

    long widgetParent() {
        return this.parent.handle;
    }

    int widgetStyle() {
        int bits = 0x54000000;
        return bits;
    }

    public boolean setParent(Composite parent) {
        long topHandle;
        this.checkWidget();
        if (parent == null) {
            this.error(4);
        }
        if (parent.isDisposed()) {
            this.error(5);
        }
        if (this.parent == parent) {
            return true;
        }
        if (!this.isReparentable()) {
            return false;
        }
        this.releaseParent();
        Shell newShell = parent.getShell();
        Shell oldShell = this.getShell();
        Decorations newDecorations = parent.menuShell();
        Decorations oldDecorations = this.menuShell();
        if (oldShell != newShell || oldDecorations != newDecorations) {
            Menu[] menus = oldShell.findMenus(this);
            this.fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
        }
        if (OS.SetParent(topHandle = this.topHandle(), parent.handle) == 0L) {
            return false;
        }
        this.parent = parent;
        int flags = 19;
        OS.SetWindowPos(topHandle, 1L, 0, 0, 0, 0, flags);
        this.reskin(1);
        return true;
    }

    abstract TCHAR windowClass();

    abstract long windowProc();

    long windowProc(long hwnd, int msg, long wParam, long lParam) {
        Display display = this.display;
        LRESULT result2 = null;
        switch (msg) {
            case 6: {
                result2 = this.WM_ACTIVATE(wParam, lParam);
                break;
            }
            case 533: {
                result2 = this.WM_CAPTURECHANGED(wParam, lParam);
                break;
            }
            case 295: {
                result2 = this.WM_CHANGEUISTATE(wParam, lParam);
                break;
            }
            case 258: {
                result2 = this.WM_CHAR(wParam, lParam);
                break;
            }
            case 771: {
                result2 = this.WM_CLEAR(wParam, lParam);
                break;
            }
            case 16: {
                result2 = this.WM_CLOSE(wParam, lParam);
                break;
            }
            case 273: {
                result2 = this.WM_COMMAND(wParam, lParam);
                break;
            }
            case 123: {
                result2 = this.WM_CONTEXTMENU(wParam, lParam);
                break;
            }
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: {
                result2 = this.WM_CTLCOLOR(wParam, lParam);
                break;
            }
            case 768: {
                result2 = this.WM_CUT(wParam, lParam);
                break;
            }
            case 2: {
                result2 = this.WM_DESTROY(wParam, lParam);
                break;
            }
            case 43: {
                result2 = this.WM_DRAWITEM(wParam, lParam);
                break;
            }
            case 22: {
                result2 = this.WM_ENDSESSION(wParam, lParam);
                break;
            }
            case 289: {
                result2 = this.WM_ENTERIDLE(wParam, lParam);
                break;
            }
            case 20: {
                result2 = this.WM_ERASEBKGND(wParam, lParam);
                break;
            }
            case 281: {
                result2 = this.WM_GESTURE(wParam, lParam);
                break;
            }
            case 135: {
                result2 = this.WM_GETDLGCODE(wParam, lParam);
                break;
            }
            case 49: {
                result2 = this.WM_GETFONT(wParam, lParam);
                break;
            }
            case 61: {
                result2 = this.WM_GETOBJECT(wParam, lParam);
                break;
            }
            case 36: {
                result2 = this.WM_GETMINMAXINFO(wParam, lParam);
                break;
            }
            case 83: {
                result2 = this.WM_HELP(wParam, lParam);
                break;
            }
            case 276: {
                result2 = this.WM_HSCROLL(wParam, lParam);
                break;
            }
            case 646: {
                result2 = this.WM_IME_CHAR(wParam, lParam);
                break;
            }
            case 271: {
                result2 = this.WM_IME_COMPOSITION(wParam, lParam);
                break;
            }
            case 269: {
                result2 = this.WM_IME_COMPOSITION_START(wParam, lParam);
                break;
            }
            case 270: {
                result2 = this.WM_IME_ENDCOMPOSITION(wParam, lParam);
                break;
            }
            case 279: {
                result2 = this.WM_INITMENUPOPUP(wParam, lParam);
                break;
            }
            case 81: {
                result2 = this.WM_INPUTLANGCHANGE(wParam, lParam);
                break;
            }
            case 786: {
                result2 = this.WM_HOTKEY(wParam, lParam);
                break;
            }
            case 256: {
                result2 = this.WM_KEYDOWN(wParam, lParam);
                break;
            }
            case 257: {
                result2 = this.WM_KEYUP(wParam, lParam);
                break;
            }
            case 8: {
                result2 = this.WM_KILLFOCUS(wParam, lParam);
                break;
            }
            case 515: {
                result2 = this.WM_LBUTTONDBLCLK(wParam, lParam);
                break;
            }
            case 513: {
                result2 = this.WM_LBUTTONDOWN(wParam, lParam);
                break;
            }
            case 514: {
                result2 = this.WM_LBUTTONUP(wParam, lParam);
                break;
            }
            case 521: {
                result2 = this.WM_MBUTTONDBLCLK(wParam, lParam);
                break;
            }
            case 519: {
                result2 = this.WM_MBUTTONDOWN(wParam, lParam);
                break;
            }
            case 520: {
                result2 = this.WM_MBUTTONUP(wParam, lParam);
                break;
            }
            case 44: {
                result2 = this.WM_MEASUREITEM(wParam, lParam);
                break;
            }
            case 288: {
                result2 = this.WM_MENUCHAR(wParam, lParam);
                break;
            }
            case 287: {
                result2 = this.WM_MENUSELECT(wParam, lParam);
                break;
            }
            case 33: {
                result2 = this.WM_MOUSEACTIVATE(wParam, lParam);
                break;
            }
            case 673: {
                result2 = this.WM_MOUSEHOVER(wParam, lParam);
                break;
            }
            case 675: {
                result2 = this.WM_MOUSELEAVE(wParam, lParam);
                break;
            }
            case 512: {
                result2 = this.WM_MOUSEMOVE(wParam, lParam);
                break;
            }
            case 522: {
                result2 = this.WM_MOUSEWHEEL(wParam, lParam);
                break;
            }
            case 526: {
                result2 = this.WM_MOUSEHWHEEL(wParam, lParam);
                break;
            }
            case 3: {
                result2 = this.WM_MOVE(wParam, lParam);
                break;
            }
            case 134: {
                result2 = this.WM_NCACTIVATE(wParam, lParam);
                break;
            }
            case 131: {
                result2 = this.WM_NCCALCSIZE(wParam, lParam);
                break;
            }
            case 132: {
                result2 = this.WM_NCHITTEST(wParam, lParam);
                break;
            }
            case 161: {
                result2 = this.WM_NCLBUTTONDOWN(wParam, lParam);
                break;
            }
            case 133: {
                result2 = this.WM_NCPAINT(wParam, lParam);
                break;
            }
            case 78: {
                result2 = this.WM_NOTIFY(wParam, lParam);
                break;
            }
            case 15: {
                result2 = this.WM_PAINT(wParam, lParam);
                break;
            }
            case 528: {
                result2 = this.WM_PARENTNOTIFY(wParam, lParam);
                break;
            }
            case 770: {
                result2 = this.WM_PASTE(wParam, lParam);
                break;
            }
            case 791: {
                result2 = this.WM_PRINT(wParam, lParam);
                break;
            }
            case 792: {
                result2 = this.WM_PRINTCLIENT(wParam, lParam);
                break;
            }
            case 17: {
                result2 = this.WM_QUERYENDSESSION(wParam, lParam);
                break;
            }
            case 19: {
                result2 = this.WM_QUERYOPEN(wParam, lParam);
                break;
            }
            case 518: {
                result2 = this.WM_RBUTTONDBLCLK(wParam, lParam);
                break;
            }
            case 516: {
                result2 = this.WM_RBUTTONDOWN(wParam, lParam);
                break;
            }
            case 517: {
                result2 = this.WM_RBUTTONUP(wParam, lParam);
                break;
            }
            case 32: {
                result2 = this.WM_SETCURSOR(wParam, lParam);
                break;
            }
            case 7: {
                result2 = this.WM_SETFOCUS(wParam, lParam);
                break;
            }
            case 48: {
                result2 = this.WM_SETFONT(wParam, lParam);
                break;
            }
            case 26: {
                result2 = this.WM_SETTINGCHANGE(wParam, lParam);
                break;
            }
            case 11: {
                result2 = this.WM_SETREDRAW(wParam, lParam);
                break;
            }
            case 24: {
                result2 = this.WM_SHOWWINDOW(wParam, lParam);
                break;
            }
            case 5: {
                result2 = this.WM_SIZE(wParam, lParam);
                break;
            }
            case 262: {
                result2 = this.WM_SYSCHAR(wParam, lParam);
                break;
            }
            case 21: {
                result2 = this.WM_SYSCOLORCHANGE(wParam, lParam);
                break;
            }
            case 274: {
                result2 = this.WM_SYSCOMMAND(wParam, lParam);
                break;
            }
            case 260: {
                result2 = this.WM_SYSKEYDOWN(wParam, lParam);
                break;
            }
            case 261: {
                result2 = this.WM_SYSKEYUP(wParam, lParam);
                break;
            }
            case 715: {
                result2 = this.WM_TABLET_FLICK(wParam, lParam);
                break;
            }
            case 275: {
                result2 = this.WM_TIMER(wParam, lParam);
                break;
            }
            case 576: {
                result2 = this.WM_TOUCH(wParam, lParam);
                break;
            }
            case 772: {
                result2 = this.WM_UNDO(wParam, lParam);
                break;
            }
            case 293: {
                result2 = this.WM_UNINITMENUPOPUP(wParam, lParam);
                break;
            }
            case 296: {
                result2 = this.WM_UPDATEUISTATE(wParam, lParam);
                break;
            }
            case 277: {
                result2 = this.WM_VSCROLL(wParam, lParam);
                break;
            }
            case 71: {
                result2 = this.WM_WINDOWPOSCHANGED(wParam, lParam);
                break;
            }
            case 70: {
                result2 = this.WM_WINDOWPOSCHANGING(wParam, lParam);
                break;
            }
            case 525: {
                result2 = this.WM_XBUTTONDBLCLK(wParam, lParam);
                break;
            }
            case 523: {
                result2 = this.WM_XBUTTONDOWN(wParam, lParam);
                break;
            }
            case 524: {
                result2 = this.WM_XBUTTONUP(wParam, lParam);
                break;
            }
            case 736: {
                result2 = this.WM_DPICHANGED(wParam, lParam);
            }
        }
        if (result2 != null) {
            return result2.value;
        }
        display.sendPreExternalEventDispatchEvent();
        try {
            long l2 = this.callWindowProc(hwnd, msg, wParam, lParam);
            return l2;
        }
        finally {
            display.sendPostExternalEventDispatchEvent();
        }
    }

    LRESULT WM_ACTIVATE(long wParam, long lParam) {
        return null;
    }

    LRESULT WM_CAPTURECHANGED(long wParam, long lParam) {
        return this.wmCaptureChanged(this.handle, wParam, lParam);
    }

    LRESULT WM_CHANGEUISTATE(long wParam, long lParam) {
        if ((this.state & 0x100000) != 0) {
            return LRESULT.ZERO;
        }
        return null;
    }

    LRESULT WM_CHAR(long wParam, long lParam) {
        return this.wmChar(this.handle, wParam, lParam);
    }

    LRESULT WM_CLEAR(long wParam, long lParam) {
        return null;
    }

    LRESULT WM_CLOSE(long wParam, long lParam) {
        return null;
    }

    LRESULT WM_COMMAND(long wParam, long lParam) {
        if (lParam == 0L) {
            int id;
            MenuItem item2;
            Decorations shell = this.menuShell();
            if (shell.isEnabled() && (item2 = this.display.getMenuItem(id = OS.LOWORD(wParam))) != null && item2.isEnabled()) {
                return item2.wmCommandChild(wParam, lParam);
            }
            return null;
        }
        Control control = this.display.getControl(lParam);
        if (control == null) {
            return null;
        }
        return control.wmCommandChild(wParam, lParam);
    }

    LRESULT WM_CONTEXTMENU(long wParam, long lParam) {
        return this.wmContextMenu(this.handle, wParam, lParam);
    }

    LRESULT WM_CTLCOLOR(long wParam, long lParam) {
        Control control = this.display.getControl(lParam);
        if (control == null) {
            return null;
        }
        return control.wmColorChild(wParam, lParam);
    }

    LRESULT WM_CUT(long wParam, long lParam) {
        return null;
    }

    LRESULT WM_DESTROY(long wParam, long lParam) {
        OS.KillTimer(this.handle, 110L);
        return null;
    }

    LRESULT WM_DPICHANGED(long wParam, long lParam) {
        int oldSWTZoom;
        int nativeZoom = DPIUtil.mapDPIToZoom(OS.HIWORD(wParam));
        int newSWTZoom = DPIUtil.getZoomForAutoscaleProperty(nativeZoom);
        if (newSWTZoom != (oldSWTZoom = DPIUtil.getDeviceZoom())) {
            Event event = new Event();
            event.type = 55;
            event.widget = this;
            event.detail = newSWTZoom;
            event.doit = true;
            this.notifyListeners(55, event);
            return LRESULT.ZERO;
        }
        return LRESULT.ONE;
    }

    LRESULT WM_DRAWITEM(long wParam, long lParam) {
        DRAWITEMSTRUCT struct = new DRAWITEMSTRUCT();
        OS.MoveMemory(struct, lParam, DRAWITEMSTRUCT.sizeof);
        if (struct.CtlType == 1) {
            MenuItem item2 = this.display.getMenuItem(struct.itemID);
            if (item2 == null) {
                return null;
            }
            return item2.wmDrawChild(wParam, lParam);
        }
        Control control = this.display.getControl(struct.hwndItem);
        if (control == null) {
            return null;
        }
        return control.wmDrawChild(wParam, lParam);
    }

    LRESULT WM_ENDSESSION(long wParam, long lParam) {
        return null;
    }

    LRESULT WM_ENTERIDLE(long wParam, long lParam) {
        return null;
    }

    LRESULT WM_ERASEBKGND(long wParam, long lParam) {
        if ((this.state & 0x200) != 0 && this.findImageControl() != null) {
            return LRESULT.ONE;
        }
        if ((this.state & 0x100) != 0 && OS.IsAppThemed() && this.findThemeControl() != null) {
            return LRESULT.ONE;
        }
        return null;
    }

    LRESULT WM_GESTURE(long wParam, long lParam) {
        if (this.hooks(48) || this.filters(48)) {
            GESTUREINFO gi = new GESTUREINFO();
            gi.cbSize = GESTUREINFO.sizeof;
            if (OS.GetGestureInfo(lParam, gi) && !this.sendGestureEvent(gi)) {
                OS.CloseGestureInfoHandle(lParam);
                return LRESULT.ZERO;
            }
        }
        return null;
    }

    LRESULT WM_GETDLGCODE(long wParam, long lParam) {
        return null;
    }

    LRESULT WM_GETFONT(long wParam, long lParam) {
        return null;
    }

    LRESULT WM_GETOBJECT(long wParam, long lParam) {
        long result2;
        if (this.accessible != null && (result2 = this.accessible.internal_WM_GETOBJECT(wParam, lParam)) != 0L) {
            return new LRESULT(result2);
        }
        return null;
    }

    LRESULT WM_GETMINMAXINFO(long wParam, long lParam) {
        return null;
    }

    LRESULT WM_HOTKEY(long wParam, long lParam) {
        return null;
    }

    LRESULT WM_HELP(long wParam, long lParam) {
        HELPINFO lphi = new HELPINFO();
        OS.MoveMemory(lphi, lParam, HELPINFO.sizeof);
        Decorations shell = this.menuShell();
        if (!shell.isEnabled()) {
            return null;
        }
        if (lphi.iContextType == 2) {
            MenuItem item2 = this.display.getMenuItem(lphi.iCtrlId);
            if (item2 != null && item2.isEnabled()) {
                Widget widget = null;
                if (item2.hooks(28)) {
                    widget = item2;
                } else {
                    Menu menu2 = item2.parent;
                    if (menu2.hooks(28)) {
                        widget = menu2;
                    }
                }
                if (widget != null) {
                    long hwndShell = shell.handle;
                    OS.SendMessage(hwndShell, 31, 0L, 0L);
                    widget.postEvent(28);
                    return LRESULT.ONE;
                }
            }
            return null;
        }
        if (this.hooks(28)) {
            this.postEvent(28);
            return LRESULT.ONE;
        }
        return null;
    }

    LRESULT WM_HSCROLL(long wParam, long lParam) {
        Control control = this.display.getControl(lParam);
        if (control == null) {
            return null;
        }
        return control.wmScrollChild(wParam, lParam);
    }

    LRESULT WM_IME_CHAR(long wParam, long lParam) {
        return this.wmIMEChar(this.handle, wParam, lParam);
    }

    LRESULT WM_IME_COMPOSITION(long wParam, long lParam) {
        return null;
    }

    LRESULT WM_IME_COMPOSITION_START(long wParam, long lParam) {
        return null;
    }

    LRESULT WM_IME_ENDCOMPOSITION(long wParam, long lParam) {
        return null;
    }

    LRESULT WM_UNINITMENUPOPUP(long wParam, long lParam) {
        Menu hiddenMenu = this.menuShell().findMenu(wParam);
        if (hiddenMenu != null) {
            Shell shell = this.getShell();
            hiddenMenu.sendEvent(23);
            if (hiddenMenu == shell.activeMenu) {
                shell.activeMenu = null;
            }
        }
        return null;
    }

    LRESULT WM_INITMENUPOPUP(long wParam, long lParam) {
        if (this.display.accelKeyHit) {
            return null;
        }
        Shell shell = this.getShell();
        Menu oldMenu = shell.activeMenu;
        Menu newMenu = null;
        if (OS.HIWORD(lParam) == 0 && (newMenu = this.menuShell().findMenu(wParam)) != null) {
            newMenu.update();
        }
        Menu menu2 = newMenu;
        while (menu2 != null && menu2 != oldMenu) {
            menu2 = menu2.getParentMenu();
        }
        if (menu2 == null) {
            menu2 = shell.activeMenu;
            while (menu2 != null) {
                menu2.sendEvent(23);
                if (menu2.isDisposed()) break;
                menu2 = menu2.getParentMenu();
                Menu ancestor = newMenu;
                while (ancestor != null && ancestor != menu2) {
                    ancestor = ancestor.getParentMenu();
                }
                if (ancestor != null) break;
            }
        }
        if (newMenu != null && newMenu.isDisposed()) {
            newMenu = null;
        }
        shell.activeMenu = newMenu;
        if (newMenu != null && newMenu != oldMenu) {
            newMenu.sendEvent(22);
        }
        return null;
    }

    LRESULT WM_INPUTLANGCHANGE(long wParam, long lParam) {
        this.menuShell().destroyAccelerators();
        return null;
    }

    LRESULT WM_KEYDOWN(long wParam, long lParam) {
        return this.wmKeyDown(this.handle, wParam, lParam);
    }

    LRESULT WM_KEYUP(long wParam, long lParam) {
        return this.wmKeyUp(this.handle, wParam, lParam);
    }

    LRESULT WM_KILLFOCUS(long wParam, long lParam) {
        return this.wmKillFocus(this.handle, wParam, lParam);
    }

    LRESULT WM_LBUTTONDBLCLK(long wParam, long lParam) {
        return this.wmLButtonDblClk(this.handle, wParam, lParam);
    }

    LRESULT WM_LBUTTONDOWN(long wParam, long lParam) {
        return this.wmLButtonDown(this.handle, wParam, lParam);
    }

    LRESULT WM_LBUTTONUP(long wParam, long lParam) {
        return this.wmLButtonUp(this.handle, wParam, lParam);
    }

    LRESULT WM_MBUTTONDBLCLK(long wParam, long lParam) {
        return this.wmMButtonDblClk(this.handle, wParam, lParam);
    }

    LRESULT WM_MBUTTONDOWN(long wParam, long lParam) {
        return this.wmMButtonDown(this.handle, wParam, lParam);
    }

    LRESULT WM_MBUTTONUP(long wParam, long lParam) {
        return this.wmMButtonUp(this.handle, wParam, lParam);
    }

    LRESULT WM_MEASUREITEM(long wParam, long lParam) {
        MEASUREITEMSTRUCT struct = new MEASUREITEMSTRUCT();
        OS.MoveMemory(struct, lParam, MEASUREITEMSTRUCT.sizeof);
        if (struct.CtlType == 1) {
            MenuItem item2 = this.display.getMenuItem(struct.itemID);
            if (item2 == null) {
                return null;
            }
            return item2.wmMeasureChild(wParam, lParam);
        }
        long hwnd = OS.GetDlgItem(this.handle, struct.CtlID);
        Control control = this.display.getControl(hwnd);
        if (control == null) {
            return null;
        }
        return control.wmMeasureChild(wParam, lParam);
    }

    LRESULT WM_MENUCHAR(long wParam, long lParam) {
        int type2 = OS.HIWORD(wParam);
        if (type2 == 0 || type2 == 8192) {
            this.display.mnemonicKeyHit = false;
            return new LRESULT(OS.MAKELRESULT(0, 1));
        }
        return null;
    }

    LRESULT WM_MENUSELECT(long wParam, long lParam) {
        int code = OS.HIWORD(wParam);
        Shell shell = this.getShell();
        OS.KillTimer(this.handle, 110L);
        if (this.activeMenu != null) {
            this.activeMenu.hideCurrentToolTip();
        }
        if (code == 65535 && lParam == 0L) {
            Menu menu2 = shell.activeMenu;
            while (menu2 != null) {
                this.display.mnemonicKeyHit = true;
                menu2.sendEvent(23);
                if (menu2.isDisposed()) break;
                menu2 = menu2.getParentMenu();
            }
            shell.activeMenu = null;
            return null;
        }
        if ((code & 0x2000) != 0) {
            return null;
        }
        if ((code & 0x80) != 0) {
            MenuItem item2 = null;
            Decorations menuShell = this.menuShell();
            if ((code & 0x10) != 0) {
                Menu newMenu;
                int index = OS.LOWORD(wParam);
                MENUITEMINFO info = new MENUITEMINFO();
                info.cbSize = MENUITEMINFO.sizeof;
                info.fMask = 4;
                if (OS.GetMenuItemInfo(lParam, index, true, info) && (newMenu = menuShell.findMenu(info.hSubMenu)) != null) {
                    item2 = newMenu.cascade;
                    this.activeMenu = newMenu;
                    this.activeMenu.selectedMenuItem = newMenu.cascade;
                    OS.SetTimer(this.handle, 110L, 1045, 0L);
                }
            } else {
                Menu newMenu = menuShell.findMenu(lParam);
                if (newMenu != null) {
                    int id = OS.LOWORD(wParam);
                    item2 = this.display.getMenuItem(id);
                }
                Menu menu3 = this.activeMenu = newMenu == null ? this.menu : newMenu;
                if (item2 != null && this.activeMenu != null) {
                    this.activeMenu.selectedMenuItem = item2;
                    OS.SetTimer(this.handle, 110L, 1045, 0L);
                }
            }
            if (item2 != null) {
                item2.sendEvent(30);
            }
        }
        return null;
    }

    LRESULT WM_MOUSEACTIVATE(long wParam, long lParam) {
        return null;
    }

    LRESULT WM_MOUSEHOVER(long wParam, long lParam) {
        return this.wmMouseHover(this.handle, wParam, lParam);
    }

    LRESULT WM_MOUSELEAVE(long wParam, long lParam) {
        this.getShell().fixToolTip();
        return this.wmMouseLeave(this.handle, wParam, lParam);
    }

    LRESULT WM_MOUSEMOVE(long wParam, long lParam) {
        return this.wmMouseMove(this.handle, wParam, lParam);
    }

    LRESULT WM_MOUSEWHEEL(long wParam, long lParam) {
        return this.wmMouseWheel(this.handle, wParam, lParam);
    }

    LRESULT WM_MOUSEHWHEEL(long wParam, long lParam) {
        return this.wmMouseHWheel(this.handle, wParam, lParam);
    }

    LRESULT WM_MOVE(long wParam, long lParam) {
        this.state |= 0x10000;
        if (this.findImageControl() != null) {
            if (this != this.getShell()) {
                this.redrawChildren();
            }
        } else if ((this.state & 0x100) != 0 && OS.IsAppThemed() && OS.IsWindowVisible(this.handle) && this.findThemeControl() != null) {
            this.redrawChildren();
        }
        if ((this.state & 0x20000) == 0) {
            this.sendEvent(10);
        }
        return null;
    }

    LRESULT WM_NCACTIVATE(long wParam, long lParam) {
        return null;
    }

    LRESULT WM_NCCALCSIZE(long wParam, long lParam) {
        return null;
    }

    LRESULT WM_NCHITTEST(long wParam, long lParam) {
        if (!OS.IsWindowEnabled(this.handle)) {
            return null;
        }
        if (!this.isActive()) {
            return new LRESULT(-1L);
        }
        return null;
    }

    LRESULT WM_NCLBUTTONDOWN(long wParam, long lParam) {
        return null;
    }

    LRESULT WM_NCPAINT(long wParam, long lParam) {
        return this.wmNCPaint(this.handle, wParam, lParam);
    }

    LRESULT WM_NOTIFY(long wParam, long lParam) {
        NMHDR hdr = new NMHDR();
        OS.MoveMemory(hdr, lParam, NMHDR.sizeof);
        return this.wmNotify(hdr, wParam, lParam);
    }

    LRESULT WM_PAINT(long wParam, long lParam) {
        if ((this.state & 0x1000) != 0) {
            return LRESULT.ZERO;
        }
        return this.wmPaint(this.handle, wParam, lParam);
    }

    LRESULT WM_PARENTNOTIFY(long wParam, long lParam) {
        return null;
    }

    LRESULT WM_PASTE(long wParam, long lParam) {
        return null;
    }

    LRESULT WM_PRINT(long wParam, long lParam) {
        return this.wmPrint(this.handle, wParam, lParam);
    }

    LRESULT WM_PRINTCLIENT(long wParam, long lParam) {
        return null;
    }

    LRESULT WM_QUERYENDSESSION(long wParam, long lParam) {
        return null;
    }

    LRESULT WM_QUERYOPEN(long wParam, long lParam) {
        return null;
    }

    LRESULT WM_RBUTTONDBLCLK(long wParam, long lParam) {
        return this.wmRButtonDblClk(this.handle, wParam, lParam);
    }

    LRESULT WM_RBUTTONDOWN(long wParam, long lParam) {
        return this.wmRButtonDown(this.handle, wParam, lParam);
    }

    LRESULT WM_RBUTTONUP(long wParam, long lParam) {
        return this.wmRButtonUp(this.handle, wParam, lParam);
    }

    LRESULT WM_SETCURSOR(long wParam, long lParam) {
        short hitTest = (short)OS.LOWORD(lParam);
        if (hitTest == 1) {
            Control control = this.display.getControl(wParam);
            if (control == null) {
                return null;
            }
            Cursor cursor = control.findCursor();
            if (cursor != null) {
                OS.SetCursor(cursor.handle);
                return LRESULT.ONE;
            }
        }
        return null;
    }

    LRESULT WM_SETFOCUS(long wParam, long lParam) {
        return this.wmSetFocus(this.handle, wParam, lParam);
    }

    LRESULT WM_SETTINGCHANGE(long wParam, long lParam) {
        return null;
    }

    LRESULT WM_SETFONT(long wParam, long lParam) {
        return null;
    }

    LRESULT WM_SETREDRAW(long wParam, long lParam) {
        return null;
    }

    LRESULT WM_SHOWWINDOW(long wParam, long lParam) {
        return null;
    }

    LRESULT WM_SIZE(long wParam, long lParam) {
        this.state |= 0x40000;
        if ((this.state & 0x80000) == 0) {
            this.sendEvent(11);
        }
        return null;
    }

    LRESULT WM_SYSCHAR(long wParam, long lParam) {
        return this.wmSysChar(this.handle, wParam, lParam);
    }

    LRESULT WM_SYSCOLORCHANGE(long wParam, long lParam) {
        return null;
    }

    /*
     * Handled duff style switch with additional control
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    LRESULT WM_SYSCOMMAND(long wParam, long lParam) {
        Decorations shell;
        if ((wParam & 0xF000L) == 0L) {
            MenuItem item2;
            Decorations shell2 = this.menuShell();
            if (!shell2.isEnabled() || (item2 = this.display.getMenuItem(OS.LOWORD(wParam))) == null) return LRESULT.ZERO;
            item2.wmCommandChild(wParam, lParam);
            return LRESULT.ZERO;
        }
        int cmd = (int)wParam & 0xFFF0;
        int n2 = 0;
        block5: do {
            int i2;
            MenuItem[] items;
            switch (n2 == 0 ? cmd : n2) {
                case 61696: {
                    char key2;
                    if (lParam == 0L) {
                        n2 = 61552;
                        shell = this.menuShell();
                        Menu menu2 = shell.getMenuBar();
                        if (menu2 != null) continue block5;
                        n2 = 61552;
                        Control control = this.display._getFocusControl();
                        if (control == null) continue block5;
                        if (!control.hooks(1)) {
                            n2 = 61552;
                            if (!control.hooks(2)) continue block5;
                        }
                        this.display.mnemonicKeyHit = false;
                        return LRESULT.ZERO;
                    }
                    if (!this.hooks(1)) {
                        n2 = 61552;
                        if (!this.hooks(2)) continue block5;
                    }
                    n2 = 61552;
                    if (lParam == 32L) continue block5;
                    shell = this.menuShell();
                    Menu menu3 = shell.getMenuBar();
                    if (menu3 != null) {
                        n2 = 61552;
                        key2 = (char)lParam;
                        if (key2 == '\u0000') continue block5;
                        key2 = Character.toUpperCase(key2);
                        items = menu3.getItems();
                        i2 = 0;
                        if (true) {
                            n2 = 61552;
                            if (i2 >= items.length) continue block5;
                        }
                    } else {
                        this.display.mnemonicKeyHit = false;
                        n2 = 61552;
                        continue block5;
                    }
                }
                case 61472: {
                    this.menuShell().saveFocus();
                    return null;
                }
                default: {
                    return null;
                }
                do {
                    char ch;
                    char key2;
                    MenuItem item3 = items[i2];
                    String text2 = item3.getText();
                    char mnemonic = this.findMnemonic(text2);
                    if (text2.length() > 0 && mnemonic == '\u0000' && Character.toUpperCase(ch = text2.charAt(0)) == key2) {
                        this.display.mnemonicKeyHit = false;
                        return LRESULT.ZERO;
                    }
                    ++i2;
                    n2 = 61552;
                } while (i2 < items.length);
                case 61552: 
                case 61568: 
            }
            break;
        } while (true);
        if ((shell = this.menuShell()).isEnabled() && shell.isActive()) return null;
        return LRESULT.ZERO;
    }

    LRESULT WM_SYSKEYDOWN(long wParam, long lParam) {
        return this.wmSysKeyDown(this.handle, wParam, lParam);
    }

    LRESULT WM_SYSKEYUP(long wParam, long lParam) {
        return this.wmSysKeyUp(this.handle, wParam, lParam);
    }

    LRESULT WM_TABLET_FLICK(long wParam, long lParam) {
        if (!this.hooks(48) && !this.filters(48)) {
            return null;
        }
        Event event = new Event();
        FLICK_DATA fData = new FLICK_DATA();
        long[] source = new long[]{wParam};
        OS.MoveMemory(fData, source, OS.FLICK_DATA_sizeof());
        FLICK_POINT fPoint = new FLICK_POINT();
        source[0] = lParam;
        OS.MoveMemory(fPoint, source, OS.FLICK_POINT_sizeof());
        switch (fData.iFlickDirection) {
            case 0: {
                event.xDirection = 1;
                event.yDirection = 0;
                break;
            }
            case 1: {
                event.xDirection = 1;
                event.yDirection = -1;
                break;
            }
            case 2: {
                event.xDirection = 0;
                event.yDirection = -1;
                break;
            }
            case 3: {
                event.xDirection = -1;
                event.yDirection = -1;
                break;
            }
            case 4: {
                event.xDirection = -1;
                event.yDirection = 0;
                break;
            }
            case 5: {
                event.xDirection = -1;
                event.yDirection = 1;
                break;
            }
            case 6: {
                event.xDirection = 0;
                event.yDirection = 1;
                break;
            }
            case 7: {
                event.xDirection = 1;
                event.yDirection = 1;
            }
        }
        event.setLocationInPixels(fPoint.x, fPoint.y);
        event.type = 48;
        event.detail = 16;
        this.setInputState(event, 48);
        this.sendEvent(48, event);
        return event.doit ? null : LRESULT.ONE;
    }

    LRESULT WM_TOUCH(long wParam, long lParam) {
        LRESULT result2 = null;
        if (this.hooks(47) || this.filters(47)) {
            int cInputs = OS.LOWORD(wParam);
            long hHeap = OS.GetProcessHeap();
            long pInputs = OS.HeapAlloc(hHeap, 8, cInputs * TOUCHINPUT.sizeof);
            if (pInputs != 0L) {
                if (OS.GetTouchInputInfo(lParam, cInputs, pInputs, TOUCHINPUT.sizeof)) {
                    TOUCHINPUT[] ti = new TOUCHINPUT[cInputs];
                    int i2 = 0;
                    while (i2 < cInputs) {
                        ti[i2] = new TOUCHINPUT();
                        OS.MoveMemory(ti[i2], pInputs + (long)(i2 * TOUCHINPUT.sizeof), TOUCHINPUT.sizeof);
                        ++i2;
                    }
                    this.sendTouchEvent(ti);
                    OS.CloseTouchInputHandle(lParam);
                    result2 = LRESULT.ZERO;
                }
                OS.HeapFree(hHeap, 0, pInputs);
            }
        }
        return result2;
    }

    LRESULT WM_TIMER(long wParam, long lParam) {
        if (wParam == 110L && this.activeMenu != null) {
            OS.KillTimer(this.handle, 110L);
            this.activeMenu.wmTimer(wParam, lParam);
        }
        return null;
    }

    LRESULT WM_UNDO(long wParam, long lParam) {
        return null;
    }

    LRESULT WM_UPDATEUISTATE(long wParam, long lParam) {
        return null;
    }

    LRESULT WM_VSCROLL(long wParam, long lParam) {
        Control control = this.display.getControl(lParam);
        if (control == null) {
            return null;
        }
        return control.wmScrollChild(wParam, lParam);
    }

    LRESULT WM_WINDOWPOSCHANGED(long wParam, long lParam) {
        try {
            ++this.display.resizeCount;
            long code = this.callWindowProc(this.handle, 71, wParam, lParam);
            LRESULT lRESULT = code == 0L ? LRESULT.ZERO : new LRESULT(code);
            return lRESULT;
        }
        finally {
            --this.display.resizeCount;
        }
    }

    LRESULT WM_WINDOWPOSCHANGING(long wParam, long lParam) {
        Shell shell;
        if (!this.getDrawing() && (shell = this.getShell()) != this) {
            WINDOWPOS lpwp = new WINDOWPOS();
            OS.MoveMemory(lpwp, lParam, WINDOWPOS.sizeof);
            if ((lpwp.flags & 2) == 0 || (lpwp.flags & 1) == 0) {
                RECT rect = new RECT();
                OS.GetWindowRect(this.topHandle(), rect);
                int width = rect.right - rect.left;
                int height = rect.bottom - rect.top;
                if (width != 0 && height != 0) {
                    long hwndParent = this.parent == null ? 0L : this.parent.handle;
                    OS.MapWindowPoints(0L, hwndParent, rect, 2);
                    long rgn1 = OS.CreateRectRgn(rect.left, rect.top, rect.right, rect.bottom);
                    long rgn2 = OS.CreateRectRgn(lpwp.x, lpwp.y, lpwp.x + lpwp.cx, lpwp.y + lpwp.cy);
                    OS.CombineRgn(rgn1, rgn1, rgn2, 4);
                    int flags = 1157;
                    OS.RedrawWindow(hwndParent, null, rgn1, flags);
                    OS.DeleteObject(rgn1);
                    OS.DeleteObject(rgn2);
                }
            }
        }
        return null;
    }

    LRESULT WM_XBUTTONDBLCLK(long wParam, long lParam) {
        return this.wmXButtonDblClk(this.handle, wParam, lParam);
    }

    LRESULT WM_XBUTTONDOWN(long wParam, long lParam) {
        return this.wmXButtonDown(this.handle, wParam, lParam);
    }

    LRESULT WM_XBUTTONUP(long wParam, long lParam) {
        return this.wmXButtonUp(this.handle, wParam, lParam);
    }

    LRESULT wmColorChild(long wParam, long lParam) {
        Control control = this.findBackgroundControl();
        if (control == null) {
            if ((this.state & 0x100) != 0 && OS.IsAppThemed() && (control = this.findThemeControl()) != null) {
                RECT rect = new RECT();
                OS.GetClientRect(this.handle, rect);
                OS.SetTextColor(wParam, this.getForegroundPixel());
                OS.SetBkColor(wParam, this.getBackgroundPixel());
                this.fillThemeBackground(wParam, control, rect);
                OS.SetBkMode(wParam, 1);
                return new LRESULT(OS.GetStockObject(5));
            }
            if (this.foreground == -1) {
                return null;
            }
        }
        if (control == null) {
            control = this;
        }
        int forePixel = this.getForegroundPixel();
        int backPixel = control.getBackgroundPixel();
        OS.SetTextColor(wParam, forePixel);
        OS.SetBkColor(wParam, backPixel);
        if (control.backgroundImage != null) {
            RECT rect = new RECT();
            OS.GetClientRect(this.handle, rect);
            long hwnd = control.handle;
            long hBitmap = control.backgroundImage.handle;
            OS.MapWindowPoints(this.handle, hwnd, rect, 2);
            POINT lpPoint = new POINT();
            OS.GetWindowOrgEx(wParam, lpPoint);
            OS.SetBrushOrgEx(wParam, -rect.left - lpPoint.x, -rect.top - lpPoint.y, lpPoint);
            long hBrush = this.findBrush(hBitmap, 3);
            if ((this.state & 0x200) != 0) {
                long hOldBrush = OS.SelectObject(wParam, hBrush);
                OS.MapWindowPoints(hwnd, this.handle, rect, 2);
                OS.PatBlt(wParam, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, 15728673);
                OS.SelectObject(wParam, hOldBrush);
            }
            OS.SetBkMode(wParam, 1);
            return new LRESULT(hBrush);
        }
        long hBrush = this.findBrush(backPixel, 0);
        if ((this.state & 0x200) != 0) {
            RECT rect = new RECT();
            OS.GetClientRect(this.handle, rect);
            long hOldBrush = OS.SelectObject(wParam, hBrush);
            OS.PatBlt(wParam, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, 15728673);
            OS.SelectObject(wParam, hOldBrush);
        }
        return new LRESULT(hBrush);
    }

    LRESULT wmCommandChild(long wParam, long lParam) {
        return null;
    }

    LRESULT wmDrawChild(long wParam, long lParam) {
        return null;
    }

    LRESULT wmMeasureChild(long wParam, long lParam) {
        return null;
    }

    LRESULT wmNotify(NMHDR hdr, long wParam, long lParam) {
        Control control = this.display.getControl(hdr.hwndFrom);
        if (control == null) {
            return null;
        }
        return control.wmNotifyChild(hdr, wParam, lParam);
    }

    LRESULT wmNotifyChild(NMHDR hdr, long wParam, long lParam) {
        return null;
    }

    LRESULT wmScrollChild(long wParam, long lParam) {
        return null;
    }
}

