/*
 * Decompiled with CFR 0.152.
 */
package gde.device.smmodellbau;

import gde.GDE;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceDialog;
import gde.device.IDevice;
import gde.device.MeasurementType;
import gde.device.smmodellbau.GPSLoggerDialog;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.MeasurementControl;
import gde.ui.MeasurementControlConfigurable;
import gde.ui.SWTResourceManager;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class GPSLoggerVisualizationControl
extends Composite {
    private static final String MLINK_EXTEND_ML = "_ML";
    private static final String UNILOG_EXTEND_UL = "_UL";
    static final Logger log = Logger.getLogger(GPSLoggerVisualizationControl.class.getName());
    Composite measurementComposite;
    Button measurement;
    Button inputFileButton;
    Composite buttonComposite;
    Label measurementUnitLabel;
    Label measurementSymbolLabel;
    Label tabItemLabel;
    boolean isVisibilityChanged = false;
    final Widget parent;
    final IDevice device;
    final DataExplorer application;
    final Channels channels;
    final GPSLoggerDialog dialog;
    final int channelConfigNumber;
    final String typeName;
    final int measurementCount;
    final int measurementOffset;
    final List<Composite> measurementTypes = new ArrayList<Composite>();

    public GPSLoggerVisualizationControl(Composite parentComposite, FormData useLayoutData, GPSLoggerDialog parentDialog, int useChannelConfigNumber, IDevice useDevice, String useName, int useMeasurementOffset, int useMeasurementCount) {
        super(parentComposite, 0);
        this.parent = parentComposite;
        this.dialog = parentDialog;
        this.device = useDevice;
        this.typeName = useName;
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.channelConfigNumber = useChannelConfigNumber;
        this.measurementOffset = useMeasurementOffset;
        this.measurementCount = useMeasurementCount;
        this.setLayoutData(useLayoutData);
        GridLayout mainTabCompositeLayout = new GridLayout();
        mainTabCompositeLayout.makeColumnsEqualWidth = true;
        this.setLayout((Layout)mainTabCompositeLayout);
        this.create();
    }

    void create() {
        if (this.typeName.equals(Messages.getString((String)"GDE_MSGT2010"))) {
            this.tabItemLabel = new Label((Composite)this, 0x1000000);
            GridData tabItemLabelLData = new GridData();
            tabItemLabelLData.horizontalAlignment = 2;
            tabItemLabelLData.verticalAlignment = 1;
            tabItemLabelLData.heightHint = 18;
            tabItemLabelLData.widthHint = 250;
            this.tabItemLabel.setLayoutData((Object)tabItemLabelLData);
            this.tabItemLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE + 2), (int)1));
            this.tabItemLabel.setText(this.typeName);
        }
        int activeChannelNumber = this.application.getActiveChannelNumber();
        RecordSet activeRecordSet = this.application.getActiveRecordSet();
        List measurementNames = this.device.getChannelMeasuremtsReplacedNames(this.channelConfigNumber);
        if (this.channelConfigNumber == 1) {
            Ai = 1;
            if (activeChannelNumber == 1 && activeRecordSet != null) {
                for (i = this.measurementOffset; i < this.measurementOffset + this.measurementCount; ++i) {
                    try {
                        MeasurementType measurementType = (MeasurementType)measurementNames.get(i);
                        if (this.typeName.startsWith(Messages.getString((String)"GDE_MSGT2012"))) {
                            if (i < activeRecordSet.size()) {
                                measurementType = this.getRecordSetMeasurementType(activeRecordSet, i);
                            }
                            this.measurementTypes.add((Composite)new MeasurementControlConfigurable((Composite)this, (DeviceDialog)this.dialog, this.channelConfigNumber, i, measurementType, this.device, 1, " " + (i - this.measurementOffset), MLINK_EXTEND_ML));
                            this.device.storeDeviceProperties();
                            continue;
                        }
                        if (this.typeName.startsWith(Messages.getString((String)"GDE_MSGT2011")) && i >= this.measurementOffset + this.measurementCount - 3) {
                            if (i < activeRecordSet.size()) {
                                measurementType = this.getRecordSetMeasurementType(activeRecordSet, i);
                            }
                            this.measurementTypes.add((Composite)new MeasurementControlConfigurable((Composite)this, (DeviceDialog)this.dialog, this.channelConfigNumber, i, measurementType, this.device, 1, "A" + Ai++, UNILOG_EXTEND_UL));
                            this.device.storeDeviceProperties();
                            continue;
                        }
                        this.measurementTypes.add((Composite)new MeasurementControl((Composite)this, (DeviceDialog)this.dialog, this.channelConfigNumber, i, measurementType, this.device, 1));
                        continue;
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, e.getMessage());
                    }
                }
            } else {
                for (i = this.measurementOffset; i < this.measurementOffset + this.measurementCount; ++i) {
                    try {
                        MeasurementType measurementType = (MeasurementType)this.device.getChannelMeasuremtsReplacedNames(this.channelConfigNumber).get(i);
                        if (this.typeName.startsWith(Messages.getString((String)"GDE_MSGT2012"))) {
                            this.measurementTypes.add((Composite)new MeasurementControlConfigurable((Composite)this, (DeviceDialog)this.dialog, this.channelConfigNumber, i, measurementType, this.device, 1, " " + (i - this.measurementOffset), MLINK_EXTEND_ML));
                            continue;
                        }
                        if (this.typeName.startsWith(Messages.getString((String)"GDE_MSGT2011")) && i >= this.measurementOffset + this.measurementCount - 3) {
                            this.measurementTypes.add((Composite)new MeasurementControlConfigurable((Composite)this, (DeviceDialog)this.dialog, this.channelConfigNumber, i, measurementType, this.device, 1, "A" + Ai++, UNILOG_EXTEND_UL));
                            continue;
                        }
                        this.measurementTypes.add((Composite)new MeasurementControl((Composite)this, (DeviceDialog)this.dialog, this.channelConfigNumber, i, measurementType, this.device, 1));
                        continue;
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, e.getMessage());
                    }
                }
            }
        } else if (this.channelConfigNumber == 2) {
            Ai = 1;
            if (activeChannelNumber == 2 && activeRecordSet != null) {
                for (i = this.measurementOffset; i < this.measurementOffset + this.measurementCount; ++i) {
                    try {
                        MeasurementType measurementType = (MeasurementType)measurementNames.get(i);
                        if (this.typeName.startsWith(Messages.getString((String)"GDE_MSGT2012"))) {
                            if (i < activeRecordSet.size()) {
                                measurementType = this.getRecordSetMeasurementType(activeRecordSet, i);
                            }
                            this.measurementTypes.add((Composite)new MeasurementControlConfigurable((Composite)this, (DeviceDialog)this.dialog, this.channelConfigNumber, i, measurementType, this.device, 1, " " + (i - this.measurementOffset), MLINK_EXTEND_ML));
                            this.device.storeDeviceProperties();
                            continue;
                        }
                        if (this.typeName.startsWith(Messages.getString((String)"GDE_MSGT2011")) && i >= this.measurementOffset + this.measurementCount - 4 && i != this.measurementOffset + this.measurementCount - 1) {
                            if (i < activeRecordSet.size()) {
                                measurementType = this.getRecordSetMeasurementType(activeRecordSet, i);
                            }
                            this.measurementTypes.add((Composite)new MeasurementControlConfigurable((Composite)this, (DeviceDialog)this.dialog, this.channelConfigNumber, i, measurementType, this.device, 1, "A" + Ai++, UNILOG_EXTEND_UL));
                            this.device.storeDeviceProperties();
                            continue;
                        }
                        this.measurementTypes.add((Composite)new MeasurementControl((Composite)this, (DeviceDialog)this.dialog, this.channelConfigNumber, i, measurementType, this.device, 1));
                        continue;
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, e.getMessage());
                    }
                }
            } else {
                for (i = this.measurementOffset; i < this.measurementOffset + this.measurementCount; ++i) {
                    try {
                        MeasurementType measurementType = (MeasurementType)this.device.getChannelMeasuremtsReplacedNames(this.channelConfigNumber).get(i);
                        if (this.typeName.startsWith(Messages.getString((String)"GDE_MSGT2012"))) {
                            this.measurementTypes.add((Composite)new MeasurementControlConfigurable((Composite)this, (DeviceDialog)this.dialog, this.channelConfigNumber, i, measurementType, this.device, 1, " " + (i - this.measurementOffset), MLINK_EXTEND_ML));
                            continue;
                        }
                        if (this.typeName.startsWith(Messages.getString((String)"GDE_MSGT2011")) && i >= this.measurementOffset + this.measurementCount - 4 && i != this.measurementOffset + this.measurementCount - 1) {
                            this.measurementTypes.add((Composite)new MeasurementControlConfigurable((Composite)this, (DeviceDialog)this.dialog, this.channelConfigNumber, i, measurementType, this.device, 1, "A" + Ai++, UNILOG_EXTEND_UL));
                            continue;
                        }
                        this.measurementTypes.add((Composite)new MeasurementControl((Composite)this, (DeviceDialog)this.dialog, this.channelConfigNumber, i, measurementType, this.device, 1));
                        continue;
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, e.getMessage());
                    }
                }
            }
        }
        Composite textComposite = new Composite((Composite)this, 0);
        textComposite.setLayout((Layout)new RowLayout(256));
        GridData thisLData = new GridData();
        thisLData.horizontalSpan = 1;
        thisLData.horizontalAlignment = 1;
        thisLData.verticalAlignment = 1;
        thisLData.heightHint = 60;
        textComposite.setLayoutData((Object)thisLData);
        textComposite.layout();
        Label attentionText = new Label(textComposite, 0x1000040);
        attentionText.setLayoutData((Object)new RowData(300, 100));
        attentionText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)1));
        attentionText.setForeground(SWTResourceManager.getColor((int)3));
        attentionText.setText(Messages.getString((String)"GDE_MSGW2002"));
        this.measurementTypes.add(textComposite);
    }

    private MeasurementType getRecordSetMeasurementType(RecordSet activeRecordSet, int i) {
        Record record = activeRecordSet.get(i);
        MeasurementType measurementType = new MeasurementType();
        measurementType.setName(record.getName());
        this.device.setMeasurementName(this.channelConfigNumber, i, record.getName());
        measurementType.setSymbol(record.getSymbol());
        this.device.setMeasurementSymbol(this.channelConfigNumber, i, record.getSymbol());
        measurementType.setUnit(record.getUnit());
        this.device.setMeasurementUnit(this.channelConfigNumber, i, record.getUnit());
        measurementType.setActive(Boolean.valueOf(record.isActive()));
        this.device.setMeasurementActive(this.channelConfigNumber, i, record.isActive());
        return measurementType;
    }
}

