/*
 * Decompiled with CFR 0.152.
 */
package org.usb4java.javax;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.usb.UsbConfiguration;
import javax.usb.UsbConfigurationDescriptor;
import javax.usb.UsbException;
import org.usb4java.ConfigDescriptor;
import org.usb4java.DeviceHandle;
import org.usb4java.InterfaceDescriptor;
import org.usb4java.LibUsb;
import org.usb4java.javax.AbstractDevice;
import org.usb4java.javax.ExceptionUtils;
import org.usb4java.javax.Interface;
import org.usb4java.javax.descriptors.SimpleUsbConfigurationDescriptor;

final class Configuration
implements UsbConfiguration {
    private final UsbConfigurationDescriptor descriptor;
    private final AbstractDevice device;
    private final Map<Integer, Map<Integer, Interface>> interfaces = new HashMap<Integer, Map<Integer, Interface>>();
    private final Map<Integer, Interface> activeSettings = new HashMap<Integer, Interface>();

    Configuration(AbstractDevice device, ConfigDescriptor descriptor) {
        this.device = device;
        this.descriptor = new SimpleUsbConfigurationDescriptor(descriptor);
        for (org.usb4java.Interface iface : descriptor.iface()) {
            for (InterfaceDescriptor ifaceDescriptor : iface.altsetting()) {
                int ifaceNumber = ifaceDescriptor.bInterfaceNumber() & 0xFF;
                int settingNumber = ifaceDescriptor.bAlternateSetting() & 0xFF;
                Map<Integer, Interface> settings = this.interfaces.get(ifaceNumber);
                if (settings == null) {
                    settings = new HashMap<Integer, Interface>();
                    this.interfaces.put(ifaceNumber, settings);
                }
                Interface usbInterface = new Interface(this, ifaceDescriptor);
                if (!this.activeSettings.containsKey(ifaceNumber) || ifaceDescriptor.bAlternateSetting() == 0) {
                    this.activeSettings.put(ifaceNumber, usbInterface);
                }
                settings.put(settingNumber, usbInterface);
            }
        }
    }

    private void checkConnected() {
        this.device.checkConnected();
    }

    public boolean isActive() {
        return this.device.getActiveUsbConfigurationNumber() == this.descriptor.bConfigurationValue();
    }

    public List<Interface> getUsbInterfaces() {
        return Collections.unmodifiableList(new ArrayList<Interface>(this.activeSettings.values()));
    }

    Map<Integer, Interface> getSettings(byte number) {
        return this.interfaces.get(number & 0xFF);
    }

    int getNumSettings(byte number) {
        return this.interfaces.get(number & 0xFF).size();
    }

    public Interface getUsbInterface(byte number) {
        return this.activeSettings.get(number & 0xFF);
    }

    void setUsbInterface(byte number, Interface iface) throws UsbException {
        if (this.activeSettings.get(number & 0xFF) != iface) {
            int result = LibUsb.setInterfaceAltSetting((DeviceHandle)this.device.open(), (int)number, (int)iface.getUsbInterfaceDescriptor().bAlternateSetting());
            if (result < 0) {
                throw ExceptionUtils.createPlatformException("Unable to set alternate interface", result);
            }
            this.activeSettings.put(number & 0xFF, iface);
        }
    }

    public boolean containsUsbInterface(byte number) {
        return this.activeSettings.containsKey(number & 0xFF);
    }

    public AbstractDevice getUsbDevice() {
        return this.device;
    }

    public UsbConfigurationDescriptor getUsbConfigurationDescriptor() {
        return this.descriptor;
    }

    public String getConfigurationString() throws UsbException, UnsupportedEncodingException {
        this.checkConnected();
        byte iConfiguration = this.descriptor.iConfiguration();
        if (iConfiguration == 0) {
            return null;
        }
        return this.device.getString(iConfiguration);
    }

    public String toString() {
        return String.format("USB configuration %02x", this.descriptor.bConfigurationValue());
    }
}

