/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import org.apache.commons.math3.analysis.BivariateFunction;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.util.MathArrays;

class BicubicFunction
implements BivariateFunction {
    private static final short N = 4;
    private final double[][] a = new double[4][4];

    BicubicFunction(double[] coeff) {
        for (int j2 = 0; j2 < 4; ++j2) {
            double[] aJ = this.a[j2];
            for (int i2 = 0; i2 < 4; ++i2) {
                aJ[i2] = coeff[i2 * 4 + j2];
            }
        }
    }

    public double value(double x2, double y2) {
        if (x2 < 0.0 || x2 > 1.0) {
            throw new OutOfRangeException(x2, (Number)0, 1);
        }
        if (y2 < 0.0 || y2 > 1.0) {
            throw new OutOfRangeException(y2, (Number)0, 1);
        }
        double x22 = x2 * x2;
        double x3 = x22 * x2;
        double[] pX = new double[]{1.0, x2, x22, x3};
        double y22 = y2 * y2;
        double y3 = y22 * y2;
        double[] pY = new double[]{1.0, y2, y22, y3};
        return this.apply(pX, pY, this.a);
    }

    private double apply(double[] pX, double[] pY, double[][] coeff) {
        double result2 = 0.0;
        for (int i2 = 0; i2 < 4; ++i2) {
            double r2 = MathArrays.linearCombination(coeff[i2], pY);
            result2 += r2 * pX[i2];
        }
        return result2;
    }
}

