/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.DocWriter;
import com.itextpdf.text.Document;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.OutputStreamCounter;
import com.itextpdf.text.pdf.OutputStreamEncryption;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfEncryption;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PdfStream
extends PdfDictionary {
    public static final int DEFAULT_COMPRESSION = -1;
    public static final int NO_COMPRESSION = 0;
    public static final int BEST_SPEED = 1;
    public static final int BEST_COMPRESSION = 9;
    protected boolean compressed = false;
    protected int compressionLevel = 0;
    protected ByteArrayOutputStream streamBytes = null;
    protected InputStream inputStream;
    protected PdfIndirectReference ref;
    protected int inputStreamLength = -1;
    protected PdfWriter writer;
    protected int rawLength;
    static final byte[] STARTSTREAM = DocWriter.getISOBytes("stream\n");
    static final byte[] ENDSTREAM = DocWriter.getISOBytes("\nendstream");
    static final int SIZESTREAM = STARTSTREAM.length + ENDSTREAM.length;

    public PdfStream(byte[] bytes) {
        this.type = 7;
        this.bytes = bytes;
        this.rawLength = bytes.length;
        this.put(PdfName.LENGTH, new PdfNumber(bytes.length));
    }

    public PdfStream(InputStream inputStream2, PdfWriter writer) {
        this.type = 7;
        this.inputStream = inputStream2;
        this.writer = writer;
        this.ref = writer.getPdfIndirectReference();
        this.put(PdfName.LENGTH, this.ref);
    }

    protected PdfStream() {
        this.type = 7;
    }

    public void writeLength() throws IOException {
        if (this.inputStream == null) {
            throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("writelength.can.only.be.called.in.a.contructed.pdfstream.inputstream.pdfwriter", new Object[0]));
        }
        if (this.inputStreamLength == -1) {
            throw new IOException(MessageLocalization.getComposedMessage("writelength.can.only.be.called.after.output.of.the.stream.body", new Object[0]));
        }
        this.writer.addToBody((PdfObject)new PdfNumber(this.inputStreamLength), this.ref, false);
    }

    public int getRawLength() {
        return this.rawLength;
    }

    public void flateCompress() {
        this.flateCompress(-1);
    }

    public void flateCompress(int compressionLevel) {
        if (!Document.compress) {
            return;
        }
        if (this.compressed) {
            return;
        }
        this.compressionLevel = compressionLevel;
        if (this.inputStream != null) {
            this.compressed = true;
            return;
        }
        PdfObject filter2 = PdfReader.getPdfObject(this.get(PdfName.FILTER));
        if (filter2 != null) {
            if (filter2.isName()) {
                if (PdfName.FLATEDECODE.equals(filter2)) {
                    return;
                }
            } else if (filter2.isArray()) {
                if (((PdfArray)filter2).contains(PdfName.FLATEDECODE)) {
                    return;
                }
            } else {
                throw new RuntimeException(MessageLocalization.getComposedMessage("stream.could.not.be.compressed.filter.is.not.a.name.or.array", new Object[0]));
            }
        }
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            Deflater deflater = new Deflater(compressionLevel);
            DeflaterOutputStream zip2 = new DeflaterOutputStream((OutputStream)stream, deflater);
            if (this.streamBytes != null) {
                this.streamBytes.writeTo(zip2);
            } else {
                zip2.write(this.bytes);
            }
            zip2.close();
            deflater.end();
            this.streamBytes = stream;
            this.bytes = null;
            this.put(PdfName.LENGTH, new PdfNumber(this.streamBytes.size()));
            if (filter2 == null) {
                this.put(PdfName.FILTER, PdfName.FLATEDECODE);
            } else {
                PdfArray filters = new PdfArray(filter2);
                filters.add(0, PdfName.FLATEDECODE);
                this.put(PdfName.FILTER, filters);
            }
            this.compressed = true;
        }
        catch (IOException ioe) {
            throw new ExceptionConverter(ioe);
        }
    }

    protected void superToPdf(PdfWriter writer, OutputStream os) throws IOException {
        super.toPdf(writer, os);
    }

    public void toPdf(PdfWriter writer, OutputStream os) throws IOException {
        PdfObject filter2;
        if (this.inputStream != null && this.compressed) {
            this.put(PdfName.FILTER, PdfName.FLATEDECODE);
        }
        PdfEncryption crypto = null;
        if (writer != null) {
            crypto = writer.getEncryption();
        }
        if (crypto != null && (filter2 = this.get(PdfName.FILTER)) != null) {
            PdfArray a2;
            if (PdfName.CRYPT.equals(filter2)) {
                crypto = null;
            } else if (filter2.isArray() && !(a2 = (PdfArray)filter2).isEmpty() && PdfName.CRYPT.equals(a2.getPdfObject(0))) {
                crypto = null;
            }
        }
        PdfObject nn = this.get(PdfName.LENGTH);
        if (crypto != null && nn != null && nn.isNumber()) {
            int sz = ((PdfNumber)nn).intValue();
            this.put(PdfName.LENGTH, new PdfNumber(crypto.calculateStreamSize(sz)));
            this.superToPdf(writer, os);
            this.put(PdfName.LENGTH, nn);
        } else {
            this.superToPdf(writer, os);
        }
        PdfWriter.checkPdfIsoConformance(writer, 9, this);
        os.write(STARTSTREAM);
        if (this.inputStream != null) {
            int n2;
            this.rawLength = 0;
            DeflaterOutputStream def = null;
            OutputStreamCounter osc = new OutputStreamCounter(os);
            OutputStreamEncryption ose = null;
            OutputStream fout = osc;
            if (crypto != null && !crypto.isEmbeddedFilesOnly()) {
                ose = crypto.getEncryptionStream(fout);
                fout = ose;
            }
            Deflater deflater = null;
            if (this.compressed) {
                deflater = new Deflater(this.compressionLevel);
                def = new DeflaterOutputStream(fout, deflater, 32768);
                fout = def;
            }
            byte[] buf = new byte[4192];
            while ((n2 = this.inputStream.read(buf)) > 0) {
                ((OutputStream)fout).write(buf, 0, n2);
                this.rawLength += n2;
            }
            if (def != null) {
                def.finish();
                deflater.end();
            }
            if (ose != null) {
                ose.finish();
            }
            this.inputStreamLength = (int)osc.getCounter();
        } else if (crypto != null && !crypto.isEmbeddedFilesOnly()) {
            byte[] b2 = this.streamBytes != null ? crypto.encryptByteArray(this.streamBytes.toByteArray()) : crypto.encryptByteArray(this.bytes);
            os.write(b2);
        } else if (this.streamBytes != null) {
            this.streamBytes.writeTo(os);
        } else {
            os.write(this.bytes);
        }
        os.write(ENDSTREAM);
    }

    public void writeContent(OutputStream os) throws IOException {
        if (this.streamBytes != null) {
            this.streamBytes.writeTo(os);
        } else if (this.bytes != null) {
            os.write(this.bytes);
        }
    }

    public String toString() {
        if (this.get(PdfName.TYPE) == null) {
            return "Stream";
        }
        return "Stream of type: " + this.get(PdfName.TYPE);
    }
}

