/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.differentiation;

import org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.MultivariateDifferentiableVectorFunction;

public class JacobianFunction
implements MultivariateMatrixFunction {
    private final MultivariateDifferentiableVectorFunction f;

    public JacobianFunction(MultivariateDifferentiableVectorFunction f2) {
        this.f = f2;
    }

    public double[][] value(double[] point) {
        DerivativeStructure[] dsX = new DerivativeStructure[point.length];
        for (int i2 = 0; i2 < point.length; ++i2) {
            dsX[i2] = new DerivativeStructure(point.length, 1, i2, point[i2]);
        }
        DerivativeStructure[] dsY = this.f.value(dsX);
        double[][] y2 = new double[dsY.length][point.length];
        int[] orders = new int[point.length];
        for (int i3 = 0; i3 < dsY.length; ++i3) {
            for (int j2 = 0; j2 < point.length; ++j2) {
                orders[j2] = 1;
                y2[i3][j2] = dsY[i3].getPartialDerivative(orders);
                orders[j2] = 0;
            }
        }
        return y2;
    }
}

