/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.MONITORINFO;
import org.eclipse.swt.internal.win32.NOTIFYICONDATA;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TOOLINFO;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ToolTip
extends Widget {
    Shell parent;
    TrayItem item;
    String text = "";
    String message = "";
    int id;
    int x;
    int y;
    boolean autoHide = true;
    boolean hasLocation;
    boolean visible;
    static final int TIMER_ID = 100;

    public ToolTip(Shell parent, int style) {
        super(parent, ToolTip.checkStyle(style));
        this.parent = parent;
        this.checkOrientation(parent);
        parent.createToolTip(this);
    }

    static int checkStyle(int style) {
        int mask = 11;
        if ((style & mask) == 0) {
            return style;
        }
        return ToolTip.checkBits(style, 2, 8, 1, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    void destroyWidget() {
        if (this.parent != null) {
            this.parent.destroyToolTip(this);
        }
        this.releaseHandle();
    }

    public boolean getAutoHide() {
        this.checkWidget();
        return this.autoHide;
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    public Shell getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean getVisible() {
        this.checkWidget();
        if (this.item != null) {
            return this.visible;
        }
        long hwndToolTip = this.hwndToolTip();
        if (OS.SendMessage(hwndToolTip, 1083, 0L, 0L) != 0L) {
            TOOLINFO lpti = new TOOLINFO();
            lpti.cbSize = TOOLINFO.sizeof;
            if (OS.SendMessage(hwndToolTip, 1083, 0L, lpti) != 0L) {
                return (lpti.uFlags & 1) == 0 && lpti.uId == (long)this.id;
            }
        }
        return false;
    }

    int getWidth() {
        long hwnd = this.parent.handle;
        long hmonitor = OS.MonitorFromWindow(hwnd, 2);
        MONITORINFO lpmi = new MONITORINFO();
        lpmi.cbSize = MONITORINFO.sizeof;
        OS.GetMonitorInfo(hmonitor, lpmi);
        int maxWidth = lpmi.rcWork_right - lpmi.rcWork_left;
        return maxWidth / 4;
    }

    long hwndToolTip() {
        return (this.style & 0x1000) != 0 ? this.parent.balloonTipHandle() : this.parent.toolTipHandle();
    }

    public boolean isVisible() {
        this.checkWidget();
        if (this.item != null) {
            return this.getVisible() && this.item.getVisible();
        }
        return this.getVisible();
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
        this.item = null;
        this.id = -1;
    }

    @Override
    void releaseWidget() {
        long hwndToolTip;
        super.releaseWidget();
        if (this.item == null && this.autoHide && OS.SendMessage(hwndToolTip = this.hwndToolTip(), 1083, 0L, 0L) != 0L) {
            TOOLINFO lpti = new TOOLINFO();
            lpti.cbSize = TOOLINFO.sizeof;
            if (OS.SendMessage(hwndToolTip, 1083, 0L, lpti) != 0L && (lpti.uFlags & 1) == 0 && lpti.uId == (long)this.id) {
                OS.SendMessage(hwndToolTip, 1041, 0L, lpti);
                OS.SendMessage(hwndToolTip, 1052, 0L, 0L);
                OS.KillTimer(hwndToolTip, 100L);
            }
        }
        if (this.item != null && this.item.toolTip == this) {
            this.item.toolTip = null;
        }
        this.item = null;
        this.message = null;
        this.text = null;
    }

    public void removeSelectionListener(SelectionListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener2);
        this.eventTable.unhook(14, listener2);
    }

    public void setAutoHide(boolean autoHide) {
        this.checkWidget();
        this.autoHide = autoHide;
    }

    public void setLocation(int x2, int y2) {
        this.checkWidget();
        this.setLocationInPixels(DPIUtil.autoScaleUp(x2), DPIUtil.autoScaleUp(y2));
    }

    void setLocationInPixels(int x2, int y2) {
        this.x = x2;
        this.y = y2;
        this.hasLocation = true;
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        location = DPIUtil.autoScaleUp(location);
        this.setLocationInPixels(location.x, location.y);
    }

    public void setMessage(String string2) {
        this.checkWidget();
        if (string2 == null) {
            this.error(4);
        }
        this.message = string2;
        this.updateMessage();
    }

    public void setText(String string2) {
        this.checkWidget();
        if (string2 == null) {
            this.error(4);
        }
        this.text = string2;
    }

    void updateMessage() {
        long hwnd = this.hwndToolTip();
        if (OS.SendMessage(hwnd, 1083, 0L, 0L) != 0L) {
            TOOLINFO lpti = new TOOLINFO();
            lpti.cbSize = TOOLINFO.sizeof;
            if (OS.SendMessage(hwnd, 1083, 0L, lpti) != 0L) {
                if (this.message != null && this.message.length() > 0) {
                    long hHeap = OS.GetProcessHeap();
                    TCHAR buffer = new TCHAR(0, this.message, true);
                    int byteCount = buffer.length() * 2;
                    lpti.lpszText = OS.HeapAlloc(hHeap, 8, byteCount);
                    OS.MoveMemory(lpti.lpszText, buffer, byteCount);
                    OS.SendMessage(hwnd, 1081, 0L, lpti);
                    OS.HeapFree(hHeap, 0, lpti.lpszText);
                } else {
                    lpti.lpszText = -1L;
                    OS.SendMessage(hwnd, 1081, 0L, lpti);
                }
            }
        }
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (visible == this.getVisible()) {
            return;
        }
        if (this.item == null) {
            long hwnd = this.parent.handle;
            TOOLINFO lpti = new TOOLINFO();
            lpti.cbSize = TOOLINFO.sizeof;
            lpti.uId = this.id;
            lpti.hwnd = hwnd;
            long hwndToolTip = this.hwndToolTip();
            Shell shell = this.parent.getShell();
            if (this.text.length() != 0) {
                int icon = 0;
                if ((this.style & 2) != 0) {
                    icon = 1;
                }
                if ((this.style & 8) != 0) {
                    icon = 2;
                }
                if ((this.style & 1) != 0) {
                    icon = 3;
                }
                shell.setToolTipTitle(hwndToolTip, this.text, icon);
            } else {
                shell.setToolTipTitle(hwndToolTip, null, 0);
            }
            OS.SendMessage(hwndToolTip, 1048, 0L, this.getWidth());
            if (visible) {
                POINT pt;
                int nX = this.x;
                int nY = this.y;
                if (!this.hasLocation && OS.GetCursorPos(pt = new POINT())) {
                    nX = pt.x;
                    nY = pt.y;
                }
                long lParam = OS.MAKELPARAM(nX, nY);
                OS.SendMessage(hwndToolTip, 1042, 0L, lParam);
                POINT pt2 = new POINT();
                OS.GetCursorPos(pt2);
                RECT rect = new RECT();
                OS.GetClientRect(hwnd, rect);
                OS.MapWindowPoints(hwnd, 0L, rect, 2);
                if (!OS.PtInRect(rect, pt2)) {
                    long hCursor = OS.GetCursor();
                    OS.SetCursor(0L);
                    OS.SetCursorPos(rect.left, rect.top);
                    OS.SendMessage(hwndToolTip, 1041, 1L, lpti);
                    OS.SetCursorPos(pt2.x, pt2.y);
                    OS.SetCursor(hCursor);
                } else {
                    OS.SendMessage(hwndToolTip, 1041, 1L, lpti);
                }
                int time = (int)OS.SendMessage(hwndToolTip, 1045, 2L, 0L);
                OS.SetTimer(hwndToolTip, 100L, time, 0L);
                this.updateMessage();
            } else {
                OS.SendMessage(hwndToolTip, 1041, 0L, lpti);
                OS.SendMessage(hwndToolTip, 1052, 0L, 0L);
                OS.KillTimer(hwndToolTip, 100L);
            }
            return;
        }
        if (this.item != null && visible) {
            NOTIFYICONDATA iconData = new NOTIFYICONDATA();
            char[] szInfoTitle = iconData.szInfoTitle;
            int length1 = Math.min(szInfoTitle.length - 1, this.text.length());
            this.text.getChars(0, length1, szInfoTitle, 0);
            char[] szInfo = iconData.szInfo;
            int length2 = Math.min(szInfo.length - 1, this.message.length());
            this.message.getChars(0, length2, szInfo, 0);
            Display display = this.item.getDisplay();
            iconData.cbSize = NOTIFYICONDATA.sizeof;
            iconData.uID = this.item.id;
            iconData.hWnd = display.hwndMessage;
            iconData.uFlags = 16;
            if ((this.style & 2) != 0) {
                iconData.dwInfoFlags = 1;
            }
            if ((this.style & 8) != 0) {
                iconData.dwInfoFlags = 2;
            }
            if ((this.style & 1) != 0) {
                iconData.dwInfoFlags = 3;
            }
            this.sendEvent(22);
            this.visible = OS.Shell_NotifyIcon(1, iconData);
        }
    }
}

