/*
 * Decompiled with CFR 0.152.
 */
package gde.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class CellVoltageValues {
    static final String $CLASS_NAME = CellVoltageValues.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    public final List<String> voltageLimitsArray = new ArrayList<String>();
    public static final int[] liPoLimits = new int[]{4200, 4200, 4150, 4000, 3300, 3200};
    public static final int[] liIoLimits = new int[]{4100, 4100, 4050, 3900, 3200, 3100};
    public static final int[] liFeLimits = new int[]{3600, 3600, 3450, 3300, 2700, 2600};
    public static final int[] niMhLimits = new int[]{1450, 1450, 1350, 1000, 900, 800};
    static int[] voltageLimits = new int[]{4200, 4200, 4150, 4000, 3300, 3200};
    private static CellVoltageValues cellVoltageValues = null;

    private CellVoltageValues() {
        for (double i = 4.4; i > 0.6; i -= 0.005) {
            this.voltageLimitsArray.add(String.format("%5.3f", i));
        }
    }

    public static CellVoltageValues getCellVoltageValues() {
        if (cellVoltageValues == null) {
            cellVoltageValues = new CellVoltageValues();
        }
        return cellVoltageValues;
    }

    public static int[] getVoltageLimits(CellVoltageTypes cellVoltageType) {
        switch (cellVoltageType.ordinal()) {
            case 0: {
                return CellVoltageValues.setVoltageLimits(liPoLimits);
            }
            case 1: {
                return CellVoltageValues.setVoltageLimits(liIoLimits);
            }
            case 2: {
                return CellVoltageValues.setVoltageLimits(liFeLimits);
            }
            case 3: {
                return CellVoltageValues.setVoltageLimits(niMhLimits);
            }
        }
        return voltageLimits;
    }

    public static int[] getVoltageLimits() {
        return (int[])voltageLimits.clone();
    }

    public static String[] getVoltageLimitsStringArray() {
        return CellVoltageValues.getCellVoltageValues().voltageLimitsArray.toArray(new String[0]);
    }

    public static void setVoltageLimits(int newUpperLimitVoltage, int newUpperLimitColorRed, int newLowerLimitColorGreen, int newBeginSpreadVoltage, int newLowerLimitColorRed, int newLowerLimitVoltage) {
        CellVoltageValues.voltageLimits[0] = newUpperLimitVoltage;
        CellVoltageValues.voltageLimits[1] = newUpperLimitColorRed;
        CellVoltageValues.voltageLimits[2] = newLowerLimitColorGreen;
        CellVoltageValues.voltageLimits[3] = newBeginSpreadVoltage;
        CellVoltageValues.voltageLimits[4] = newLowerLimitColorRed;
        CellVoltageValues.voltageLimits[5] = newLowerLimitVoltage;
    }

    public static int[] setVoltageLimits(int[] newVoltageLimits) {
        if (voltageLimits.length <= newVoltageLimits.length) {
            System.arraycopy(newVoltageLimits, 0, voltageLimits, 0, voltageLimits.length);
        } else if (voltageLimits.length > newVoltageLimits.length) {
            System.arraycopy(newVoltageLimits, 0, voltageLimits, 0, newVoltageLimits.length);
        }
        return voltageLimits;
    }

    public static boolean compareVoltageLimits(int[] limits2compared) {
        return voltageLimits[0] == limits2compared[0] && voltageLimits[1] == limits2compared[1] && voltageLimits[2] == limits2compared[2] && voltageLimits[3] == limits2compared[3] && voltageLimits[4] == limits2compared[4] && voltageLimits[5] == limits2compared[5];
    }

    public static enum CellVoltageTypes {
        LiPo,
        LiIo,
        LiFe,
        NiMh,
        Custom;

    }
}

