/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.tab;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.ObjectData;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.ui.menu.ObjectImageContextMenu;
import gde.ui.menu.TabAreaContextMenu;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Vector;
import java.util.logging.Logger;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ObjectDescriptionWindow
extends CTabItem {
    static final Logger log = Logger.getLogger(ObjectDescriptionWindow.class.getName());
    Composite tabComposite;
    Group editGroup;
    CoolBar editCoolBar;
    GridData editCoolBarLData;
    ToolBar fontSelectToolBar;
    ToolBar editToolBar;
    int toolButtonHeight = 23;
    CoolItem editCoolItem;
    ToolItem fontSelect;
    Composite fontSizeSelectComposite;
    CCombo fontSizeSelectCombo;
    Point fontSizeSelectSize = new Point(GDE.IS_LINUX ? 60 : 40, GDE.IS_LINUX ? 22 : 20);
    ToolItem strikeoutButton;
    ToolItem underlineButton;
    ToolItem italicButton;
    ToolItem boldButton;
    ToolItem fColorButton;
    ToolItem bColorButton;
    ToolItem cutButton;
    ToolItem copyButton;
    ToolItem pasteButton;
    ToolItem printButton;
    Composite styledTextComposite;
    StyledText styledText;
    Group mainObjectCharacterisitcsGroup;
    Composite headerComposite;
    CLabel objectNameLabel;
    CLabel objectName;
    Composite objectTypeComposite;
    CLabel objectTypeLabel;
    Text objectTypeText;
    Composite dateComposite;
    CLabel dateLabel;
    Text dateText;
    Composite statusComposite;
    CCombo statusText;
    CLabel statusLabel;
    Canvas imageCanvas;
    final CTabFolder tabFolder;
    final DataExplorer application;
    final Settings settings;
    final Channels channels;
    Menu imagePopupMenu;
    ObjectImageContextMenu imageContextMenu;
    Menu popupmenu;
    TabAreaContextMenu contextMenu;
    String objectFilePath;
    String activeObjectKey;
    boolean isObjectDataSaved = true;
    Vector<StyleRange> cachedStyles = new Vector();
    ObjectData object;
    Image image;
    Color innerAreaBackground;
    Color surroundingBackground;
    Color textColor;

    public ObjectDescriptionWindow(CTabFolder currentDisplayTab, int style, int position) {
        super(currentDisplayTab, style, position);
        SWTResourceManager.registerResourceUser((Widget)this);
        this.application = DataExplorer.getInstance();
        this.tabFolder = currentDisplayTab;
        this.settings = Settings.getInstance();
        this.channels = Channels.getInstance();
        this.activeObjectKey = this.settings.getActiveObject();
        this.innerAreaBackground = Settings.getInstance().getObjectDescriptionInnerAreaBackground();
        this.surroundingBackground = Settings.getInstance().getObjectDescriptionSurroundingAreaBackground();
        this.textColor = Settings.getInstance().getHeaderCommentColor();
        this.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE + (GDE.IS_LINUX ? 3 : 1), 0));
        this.setText(Messages.getString("GDE_MSGT0403"));
        this.imagePopupMenu = new Menu((Decorations)this.application.getShell(), 8);
        this.imageContextMenu = new ObjectImageContextMenu();
        this.popupmenu = new Menu((Decorations)this.application.getShell(), 8);
        this.contextMenu = new TabAreaContextMenu();
    }

    public boolean isVisible() {
        return !this.isDisposed() && this.getControl() != null && this.getControl().isVisible();
    }

    public void update() {
        this.checkSaveObjectData();
        this.activeObjectKey = this.application.getMenuToolBar().getActiveObjectKey();
        this.objectFilePath = this.settings.getDataFilePath() + "/" + this.activeObjectKey + "/" + this.activeObjectKey + ".zip";
        this.object = new ObjectData(this.objectFilePath);
        if (new File(this.objectFilePath).exists()) {
            this.object.load();
            this.image = this.object.getImage() != null ? SWTResourceManager.getImage(this.object.getImage().getImageData(), this.object.getKey(), this.object.getImageWidth(), this.object.getImageHeight(), true) : null;
        } else {
            this.image = null;
        }
        this.imageCanvas.redraw();
        this.objectName.setText(this.object.getKey().equals(this.settings.getActiveObject()) ? this.object.getKey() : this.settings.getActiveObject());
        this.objectTypeText.setText(this.object.getType());
        this.dateText.setText(this.object.getActivationDate());
        this.statusText.setText(this.object.getStatus());
        FontData fd = this.object.getFontData();
        this.styledText.setFont(SWTResourceManager.getFont((Control)this.application, fd.getHeight(), fd.getStyle()));
        this.styledText.setText(this.object.getStyledText());
        this.styledText.setStyleRanges((StyleRange[])this.object.getStyleRanges().clone());
        int index = 0;
        for (String fontSize : this.fontSizeSelectCombo.getItems()) {
            if (fontSize.equals("" + fd.getHeight())) {
                this.fontSizeSelectCombo.select(index);
                break;
            }
            ++index;
        }
    }

    public void checkSaveObjectData() {
        if (this.object != null && !this.isObjectDataSaved) {
            this.object.setType(this.objectTypeText.getText());
            this.object.setActivationDate(this.dateText.getText());
            this.object.setStatus(this.statusText.getText());
            if (this.image != null) {
                this.object.setImage(SWTResourceManager.getImage(this.image.getImageData(), this.activeObjectKey, this.object.getImageWidth(), this.object.getImageHeight(), false));
            } else {
                this.object.setImage(null);
            }
            this.object.setStyledText(this.styledText.getText());
            this.object.setFont(this.styledText.getFont());
            this.object.setStyleRanges((StyleRange[])this.styledText.getStyleRanges().clone());
            this.object.save();
            this.isObjectDataSaved = true;
            Channel activeChannel = this.channels.getActiveChannel();
            if (activeChannel != null) {
                activeChannel.setUnsaved(Channel.UNSAVED_REASON_CHANGED_OBJECT_DATA);
            }
        }
    }

    public void create() {
        this.tabComposite = new Composite((Composite)this.tabFolder, 0);
        this.setControl((Control)this.tabComposite);
        FormLayout composite1Layout = new FormLayout();
        this.tabComposite.setLayout((Layout)composite1Layout);
        this.tabComposite.setBackground(this.surroundingBackground);
        this.tabComposite.setMenu(this.popupmenu);
        this.tabComposite.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent evt) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "tabComposite.helpRequested " + String.valueOf(evt));
                }
                ObjectDescriptionWindow.this.application.openHelpDialog("", "HelpInfo_93.html");
            }
        });
        this.headerComposite = new Composite(this.tabComposite, 0);
        RowLayout composite2Layout = new RowLayout(256);
        this.headerComposite.setLayout((Layout)composite2Layout);
        FormData composite2LData = new FormData();
        composite2LData.width = 600;
        composite2LData.height = 36;
        composite2LData.left = new FormAttachment(0, 1000, 15);
        composite2LData.top = new FormAttachment(0, 1000, 17);
        this.headerComposite.setLayoutData((Object)composite2LData);
        this.headerComposite.setBackground(this.surroundingBackground);
        this.headerComposite.setMenu(this.popupmenu);
        this.objectNameLabel = new CLabel(this.headerComposite, 0);
        this.objectNameLabel.setText(Messages.getString("GDE_MSGT0404"));
        this.objectNameLabel.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE + 2, 0));
        RowData cLabel1LData = new RowData();
        cLabel1LData.width = 130;
        cLabel1LData.height = 26;
        this.objectNameLabel.setLayoutData((Object)cLabel1LData);
        this.objectNameLabel.setBackground(this.surroundingBackground);
        this.objectNameLabel.setForeground(this.textColor);
        this.objectNameLabel.setMenu(this.popupmenu);
        this.objectName = new CLabel(this.headerComposite, 0);
        this.objectName.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE + 2, 1));
        cLabel1LData = new RowData();
        cLabel1LData.width = 300;
        cLabel1LData.height = 26;
        this.objectName.setLayoutData((Object)cLabel1LData);
        this.objectName.setBackground(this.surroundingBackground);
        this.objectName.setForeground(this.textColor);
        this.objectName.setMenu(this.popupmenu);
        this.mainObjectCharacterisitcsGroup = new Group(this.tabComposite, 0);
        GridLayout group2Layout = new GridLayout();
        group2Layout.makeColumnsEqualWidth = true;
        this.mainObjectCharacterisitcsGroup.setLayout((Layout)group2Layout);
        FormData group2LData = new FormData();
        group2LData.width = 410;
        group2LData.height = 425;
        group2LData.left = new FormAttachment(0, 1000, 15);
        group2LData.top = new FormAttachment(0, 1000, 60);
        this.mainObjectCharacterisitcsGroup.setLayoutData((Object)group2LData);
        this.mainObjectCharacterisitcsGroup.setText(Messages.getString("GDE_MSGT0416"));
        if (!GDE.IS_MAC) {
            this.mainObjectCharacterisitcsGroup.setBackground(this.surroundingBackground);
        }
        this.mainObjectCharacterisitcsGroup.setForeground(this.textColor);
        this.mainObjectCharacterisitcsGroup.setMenu(this.popupmenu);
        this.objectTypeComposite = new Composite((Composite)this.mainObjectCharacterisitcsGroup, 0);
        RowLayout composite1Layout3 = new RowLayout(256);
        this.objectTypeComposite.setLayout((Layout)composite1Layout3);
        GridData typeCompositeLData = new GridData();
        typeCompositeLData.verticalAlignment = 1;
        typeCompositeLData.grabExcessHorizontalSpace = true;
        typeCompositeLData.horizontalAlignment = 1;
        typeCompositeLData.heightHint = GDE.IS_LINUX ? 32 : 28;
        this.objectTypeComposite.setLayoutData((Object)typeCompositeLData);
        if (!GDE.IS_MAC) {
            this.objectTypeComposite.setBackground(this.surroundingBackground);
        }
        this.objectTypeComposite.setMenu(this.popupmenu);
        this.objectTypeLabel = new CLabel(this.objectTypeComposite, 0);
        if (!GDE.IS_MAC) {
            this.objectTypeLabel.setBackground(this.surroundingBackground);
        }
        this.objectTypeLabel.setForeground(this.textColor);
        this.objectTypeLabel.setMenu(this.popupmenu);
        this.objectTypeLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.objectTypeLabel.setText(Messages.getString("GDE_MSGT0425"));
        RowData cLabel1LData1 = new RowData();
        cLabel1LData1.width = 140;
        cLabel1LData1.height = 22;
        this.objectTypeLabel.setLayoutData((Object)cLabel1LData1);
        this.objectTypeLabel.setToolTipText(Messages.getString("GDE_MSGT0405"));
        this.objectTypeText = new Text(this.objectTypeComposite, 2048);
        if (!GDE.IS_MAC) {
            this.objectTypeText.setBackground(this.innerAreaBackground);
        }
        this.objectTypeText.setMenu(this.popupmenu);
        this.objectTypeText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.objectTypeText.setEditable(true);
        RowData cLabel2LData = new RowData();
        cLabel2LData.width = 240;
        cLabel2LData.height = 18;
        this.objectTypeText.setLayoutData((Object)cLabel2LData);
        this.objectTypeText.setToolTipText(Messages.getString("GDE_MSGT0405"));
        this.objectTypeText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "objectTypeText.keyReleased, event=" + String.valueOf(evt));
                }
                ObjectDescriptionWindow.this.isObjectDataSaved = false;
            }
        });
        this.dateComposite = new Composite((Composite)this.mainObjectCharacterisitcsGroup, 0);
        RowLayout composite1Layout1 = new RowLayout(256);
        this.dateComposite.setLayout((Layout)composite1Layout1);
        GridData dateCompositeLData = new GridData();
        dateCompositeLData.grabExcessHorizontalSpace = true;
        dateCompositeLData.verticalAlignment = 1;
        dateCompositeLData.horizontalAlignment = 1;
        dateCompositeLData.heightHint = GDE.IS_LINUX ? 32 : 28;
        this.dateComposite.setLayoutData((Object)dateCompositeLData);
        if (!GDE.IS_MAC) {
            this.dateComposite.setBackground(this.surroundingBackground);
        }
        this.dateComposite.setMenu(this.popupmenu);
        this.dateLabel = new CLabel(this.dateComposite, 0);
        this.dateLabel.setMenu(this.popupmenu);
        this.dateLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        RowData dateLabelLData = new RowData();
        dateLabelLData.width = 140;
        dateLabelLData.height = 22;
        this.dateLabel.setLayoutData((Object)dateLabelLData);
        this.dateLabel.setText(Messages.getString("GDE_MSGT0406"));
        this.dateLabel.setToolTipText(Messages.getString("GDE_MSGT0407"));
        if (!GDE.IS_MAC) {
            this.dateLabel.setBackground(this.surroundingBackground);
        }
        this.dateLabel.setForeground(this.textColor);
        this.dateLabel.setMenu(this.popupmenu);
        this.dateText = new Text(this.dateComposite, 2048);
        this.dateText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        RowData dateTextLData = new RowData();
        dateTextLData.width = GDE.IS_LINUX ? 116 : 118;
        dateTextLData.height = 18;
        this.dateText.setLayoutData((Object)dateTextLData);
        if (!GDE.IS_MAC) {
            this.dateText.setBackground(this.innerAreaBackground);
        }
        this.dateText.setMenu(this.popupmenu);
        this.dateText.setToolTipText(Messages.getString("GDE_MSGT0407"));
        this.dateText.setEditable(true);
        this.dateText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "dateText.keyReleased, event=" + String.valueOf(evt));
                }
                ObjectDescriptionWindow.this.isObjectDataSaved = false;
            }
        });
        this.statusComposite = new Composite((Composite)this.mainObjectCharacterisitcsGroup, 0);
        RowLayout composite1Layout2 = new RowLayout(256);
        this.statusComposite.setLayout((Layout)composite1Layout2);
        GridData statusCompositeLData = new GridData();
        statusCompositeLData.grabExcessHorizontalSpace = true;
        statusCompositeLData.verticalAlignment = 1;
        statusCompositeLData.horizontalAlignment = 1;
        statusCompositeLData.heightHint = GDE.IS_LINUX ? 32 : 28;
        this.statusComposite.setLayoutData((Object)statusCompositeLData);
        if (!GDE.IS_MAC) {
            this.statusComposite.setBackground(this.surroundingBackground);
        }
        this.statusComposite.setMenu(this.popupmenu);
        this.statusLabel = new CLabel(this.statusComposite, 0);
        if (!GDE.IS_MAC) {
            this.statusLabel.setBackground(this.surroundingBackground);
        }
        this.statusLabel.setForeground(this.textColor);
        this.statusLabel.setMenu(this.popupmenu);
        this.statusLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        RowData statusLabelLData = new RowData();
        statusLabelLData.width = 140;
        statusLabelLData.height = 22;
        this.statusLabel.setLayoutData((Object)statusLabelLData);
        this.statusLabel.setText(Messages.getString("GDE_MSGT0410"));
        this.statusLabel.setToolTipText(Messages.getString("GDE_MSGT0411"));
        this.statusText = new CCombo(this.statusComposite, 2048);
        this.statusText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.statusText.setItems(Messages.getString("GDE_MSGT0412").split(";"));
        if (!GDE.IS_MAC) {
            this.statusText.setBackground(this.innerAreaBackground);
        }
        this.statusText.setMenu(this.popupmenu);
        this.statusText.select(0);
        RowData group1LData = new RowData();
        group1LData.width = 120;
        group1LData.height = GDE.IS_LINUX ? 22 : 20;
        this.statusText.setLayoutData((Object)group1LData);
        this.statusText.setBackground(DataExplorer.getInstance().COLOR_WHITE);
        this.statusText.setToolTipText(Messages.getString("GDE_MSGT0411"));
        this.statusText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "statusText.widgetSelected, event=" + String.valueOf(evt));
                }
                ObjectDescriptionWindow.this.isObjectDataSaved = false;
            }
        });
        this.imageCanvas = new Canvas((Composite)this.mainObjectCharacterisitcsGroup, 2048);
        GridData imageCanvasLData = new GridData();
        imageCanvasLData.minimumWidth = 402;
        imageCanvasLData.minimumHeight = 302;
        imageCanvasLData.verticalAlignment = 3;
        imageCanvasLData.widthHint = 402;
        imageCanvasLData.heightHint = 302;
        this.imageCanvas.setLayoutData((Object)imageCanvasLData);
        this.imageCanvas.setToolTipText(Messages.getString("GDE_MSGT0413"));
        if (!GDE.IS_MAC) {
            this.imageCanvas.setBackgroundImage(SWTResourceManager.getImage("gde/resource/" + this.settings.getColorSchemaType() + String.valueOf(this.settings.getLocale()) + "/ObjectImage.gif"));
        }
        this.imageCanvas.setSize(402, 302);
        this.imageCanvas.getClientArea();
        this.imageContextMenu.createMenu(this.imagePopupMenu);
        this.imageCanvas.setMenu(this.imagePopupMenu);
        this.imageCanvas.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                ObjectDescriptionWindow.this.imageContextMenu.chooseImageFile();
            }
        });
        this.imageCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "imageCanvas.paintControl, event=" + String.valueOf(evt));
                }
                ObjectDescriptionWindow.this.contextMenu.createMenu(ObjectDescriptionWindow.this.popupmenu, TabAreaContextMenu.TabMenuType.SIMPLE);
                if (ObjectDescriptionWindow.this.imagePopupMenu.getData("OBJECT_IMAGE_CHANGED") != null && ((Boolean)ObjectDescriptionWindow.this.imagePopupMenu.getData("OBJECT_IMAGE_CHANGED")).booleanValue()) {
                    String imagePath = (String)ObjectDescriptionWindow.this.imagePopupMenu.getData("OBJECT_IMAGE_PATH");
                    if (imagePath != null) {
                        try {
                            ObjectDescriptionWindow.this.image = SWTResourceManager.getImage(new Image((Device)Display.getDefault(), (InputStream)new FileInputStream(imagePath)).getImageData(), ObjectDescriptionWindow.this.object.getKey(), ObjectDescriptionWindow.this.object.getImageWidth(), ObjectDescriptionWindow.this.object.getImageHeight(), true);
                        }
                        catch (FileNotFoundException e) {
                            log.log(Level.WARNING, e.getMessage(), e);
                        }
                    } else {
                        ObjectDescriptionWindow.this.image = null;
                    }
                    ObjectDescriptionWindow.this.object.setImage(ObjectDescriptionWindow.this.image);
                    ObjectDescriptionWindow.this.imagePopupMenu.setData("OBJECT_IMAGE_CHANGED", (Object)false);
                    ObjectDescriptionWindow.this.isObjectDataSaved = false;
                }
                if (ObjectDescriptionWindow.this.image != null) {
                    evt.gc.drawImage(ObjectDescriptionWindow.this.image, 0, 0);
                }
            }
        });
        this.editGroup = new Group(this.tabComposite, 0);
        FormData composite1LData = new FormData();
        composite1LData.height = 425;
        composite1LData.right = new FormAttachment(1000, 1000, -15);
        composite1LData.top = new FormAttachment(0, 1000, 60);
        composite1LData.left = new FormAttachment(0, 1000, 440);
        this.editGroup.setLayoutData((Object)composite1LData);
        this.editGroup.setLayout((Layout)new GridLayout());
        this.editGroup.setText(Messages.getString("GDE_MSGT0414"));
        if (!GDE.IS_MAC) {
            this.editGroup.setBackground(this.surroundingBackground);
        }
        this.editGroup.setForeground(this.textColor);
        this.editGroup.setMenu(this.popupmenu);
        this.editCoolBar = new CoolBar((Composite)this.editGroup, 0x800000);
        this.editCoolBarLData = new GridData();
        this.editCoolBarLData.grabExcessHorizontalSpace = true;
        this.editCoolBarLData.horizontalAlignment = 4;
        this.editCoolBarLData.verticalAlignment = 1;
        this.editCoolBarLData.heightHint = 40;
        this.editCoolBarLData.minimumHeight = 40;
        this.editCoolBar.setLayoutData((Object)this.editCoolBarLData);
        this.editCoolBar.setLayout((Layout)new RowLayout(256));
        if (!GDE.IS_MAC) {
            this.editCoolBar.setBackground(this.surroundingBackground);
        }
        this.editCoolBar.setMenu(this.popupmenu);
        this.editCoolItem = new CoolItem(this.editCoolBar, 0x800000);
        this.fontSelectToolBar = new ToolBar((Composite)this.editCoolBar, 0x800000);
        this.editCoolItem.setControl((Control)this.fontSelectToolBar);
        if (!GDE.IS_MAC) {
            this.fontSelectToolBar.setBackground(this.surroundingBackground);
        }
        new ToolItem(this.fontSelectToolBar, 2);
        this.fontSelect = new ToolItem(this.fontSelectToolBar, 2048);
        if (GDE.isSystemDarkTheme) {
            this.fontSelect.setImage(SWTResourceManager.getImage("gde/resource/FontDark.gif"));
        } else {
            this.fontSelect.setImage(SWTResourceManager.getImage("gde/resource/Font.gif"));
        }
        this.fontSelect.setToolTipText(Messages.getString("GDE_MSGT0417"));
        this.fontSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "fontSelect.widgetSelected, event=" + String.valueOf(evt));
                }
                ObjectDescriptionWindow.this.setFont();
            }
        });
        new ToolItem(this.fontSelectToolBar, 2);
        ToolItem fontSizeSelectComboSep = new ToolItem(this.fontSelectToolBar, 2);
        this.fontSizeSelectComposite = new Composite((Composite)this.fontSelectToolBar, 0x800000);
        if (!GDE.IS_MAC) {
            this.fontSizeSelectComposite.setBackground(this.surroundingBackground);
        }
        this.fontSizeSelectCombo = new CCombo(this.fontSizeSelectComposite, 18440);
        this.fontSizeSelectCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.fontSizeSelectCombo.setItems(new String[]{"6", "7", "8", "9", "10", "12", "14", "16", "18"});
        this.fontSizeSelectCombo.select(3);
        this.fontSizeSelectCombo.setToolTipText(Messages.getString("GDE_MSGT0201"));
        this.fontSizeSelectCombo.setEditable(false);
        this.fontSizeSelectCombo.setBackground(DataExplorer.getInstance().COLOR_WHITE);
        this.fontSizeSelectCombo.setVisibleItemCount(5);
        this.fontSizeSelectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "fontSizeSelectCombo.widgetSelected, event=" + String.valueOf(evt));
                }
                ObjectDescriptionWindow.this.setFontSize(Float.parseFloat(ObjectDescriptionWindow.this.fontSizeSelectCombo.getText()));
            }
        });
        this.toolButtonHeight = this.fontSelect.getBounds().height;
        this.fontSizeSelectCombo.setSize(this.fontSizeSelectSize);
        this.fontSizeSelectComposite.setSize(this.fontSizeSelectSize.x, this.toolButtonHeight);
        this.fontSizeSelectCombo.setLocation(0, (this.toolButtonHeight - this.fontSizeSelectSize.y) / 2);
        fontSizeSelectComboSep.setWidth(this.fontSizeSelectComposite.getSize().x);
        fontSizeSelectComboSep.setControl((Control)this.fontSizeSelectComposite);
        Point size = this.fontSelectToolBar.computeSize(-1, -1);
        this.fontSelectToolBar.setSize(size);
        this.editToolBar = new ToolBar((Composite)this.editCoolBar, 0x800000);
        this.editCoolItem.setControl((Control)this.editToolBar);
        if (!GDE.IS_MAC) {
            this.editToolBar.setBackground(this.surroundingBackground);
        }
        new ToolItem(this.editToolBar, 2);
        this.boldButton = new ToolItem(this.editToolBar, 8);
        this.boldButton.setImage(SWTResourceManager.getImage("gde/resource/Bold.gif"));
        this.boldButton.setToolTipText(Messages.getString("GDE_MSGT0419"));
        this.boldButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "boldButton.widgetSelected, event=" + String.valueOf(evt));
                }
                ObjectDescriptionWindow.this.setStyle((Widget)ObjectDescriptionWindow.this.boldButton);
            }
        });
        new ToolItem(this.editToolBar, 2);
        this.italicButton = new ToolItem(this.editToolBar, 8);
        this.italicButton.setImage(SWTResourceManager.getImage("gde/resource/Italic.gif"));
        this.italicButton.setToolTipText(Messages.getString("GDE_MSGT0420"));
        this.italicButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "italicButton.widgetSelected, event=" + String.valueOf(evt));
                }
                ObjectDescriptionWindow.this.setStyle((Widget)ObjectDescriptionWindow.this.italicButton);
            }
        });
        new ToolItem(this.editToolBar, 2);
        this.underlineButton = new ToolItem(this.editToolBar, 8);
        this.underlineButton.setImage(SWTResourceManager.getImage("gde/resource/Underline.gif"));
        this.underlineButton.setToolTipText(Messages.getString("GDE_MSGT0421"));
        this.underlineButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "underlineButton.widgetSelected, event=" + String.valueOf(evt));
                }
                ObjectDescriptionWindow.this.setStyle((Widget)ObjectDescriptionWindow.this.underlineButton);
            }
        });
        new ToolItem(this.editToolBar, 2);
        this.strikeoutButton = new ToolItem(this.editToolBar, 8);
        this.strikeoutButton.setImage(SWTResourceManager.getImage("gde/resource/Strikeout.gif"));
        this.strikeoutButton.setToolTipText(Messages.getString("GDE_MSGT0422"));
        this.strikeoutButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "strikeoutButton.widgetSelected, event=" + String.valueOf(evt));
                }
                ObjectDescriptionWindow.this.setStyle((Widget)ObjectDescriptionWindow.this.strikeoutButton);
            }
        });
        new ToolItem(this.editToolBar, 2);
        this.fColorButton = new ToolItem(this.editToolBar, 8);
        this.fColorButton.setImage(SWTResourceManager.getImage("gde/resource/fColor.gif"));
        this.fColorButton.setToolTipText(Messages.getString("GDE_MSGT0423"));
        this.fColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "colorItem.widgetSelected, event=" + String.valueOf(evt));
                }
                RGB rgb = new ColorDialog(ObjectDescriptionWindow.this.editToolBar.getShell()).open();
                ObjectDescriptionWindow.this.fColorButton.setData((Object)rgb);
                ObjectDescriptionWindow.this.setStyle((Widget)ObjectDescriptionWindow.this.fColorButton);
            }
        });
        new ToolItem(this.editToolBar, 2);
        this.bColorButton = new ToolItem(this.editToolBar, 8);
        this.bColorButton.setImage(SWTResourceManager.getImage("gde/resource/bColor.gif"));
        this.bColorButton.setToolTipText(Messages.getString("GDE_MSGT0424"));
        this.bColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "colorItem.widgetSelected, event=" + String.valueOf(evt));
                }
                RGB rgb = new ColorDialog(ObjectDescriptionWindow.this.editToolBar.getShell()).open();
                ObjectDescriptionWindow.this.bColorButton.setData((Object)rgb);
                ObjectDescriptionWindow.this.setStyle((Widget)ObjectDescriptionWindow.this.bColorButton);
            }
        });
        new ToolItem(this.editToolBar, 2);
        this.copyButton = new ToolItem(this.editToolBar, 8);
        this.copyButton.setImage(SWTResourceManager.getImage("gde/resource/Copy.gif"));
        this.copyButton.setToolTipText(Messages.getString("GDE_MSGT0426"));
        this.copyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "copyButton.widgetSelected, event=" + String.valueOf(evt));
                }
                ObjectDescriptionWindow.this.handleCutCopy();
                ObjectDescriptionWindow.this.styledText.copy();
            }
        });
        new ToolItem(this.editToolBar, 2);
        this.cutButton = new ToolItem(this.editToolBar, 8);
        this.cutButton.setImage(SWTResourceManager.getImage("gde/resource/Cut.gif"));
        this.cutButton.setToolTipText(Messages.getString("GDE_MSGT0427"));
        this.cutButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "cutButton.widgetSelected, event=" + String.valueOf(evt));
                }
                ObjectDescriptionWindow.this.handleCutCopy();
                ObjectDescriptionWindow.this.styledText.cut();
            }
        });
        new ToolItem(this.editToolBar, 2);
        this.pasteButton = new ToolItem(this.editToolBar, 8);
        this.pasteButton.setImage(SWTResourceManager.getImage("gde/resource/Paste.gif"));
        this.pasteButton.setToolTipText(Messages.getString("GDE_MSGT0428"));
        this.pasteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "pasteButton.widgetSelected, event=" + String.valueOf(evt));
                }
                ObjectDescriptionWindow.this.styledText.paste();
            }
        });
        new ToolItem(this.editToolBar, 2);
        int tmpWidth = size.x;
        size = this.editToolBar.computeSize(-1, -1);
        this.editToolBar.setSize(size);
        this.editCoolBarLData.minimumWidth = 8 + tmpWidth + size.x;
        this.editCoolBar.setLayoutData((Object)this.editCoolBarLData);
        this.styledTextComposite = new Composite((Composite)this.editGroup, 2048);
        FormLayout styledTextCompositeLayout = new FormLayout();
        this.styledTextComposite.setLayout((Layout)styledTextCompositeLayout);
        this.styledTextComposite.setBackground(this.innerAreaBackground);
        GridData styledTextGData = new GridData();
        styledTextGData.minimumWidth = 300;
        styledTextGData.grabExcessHorizontalSpace = true;
        styledTextGData.horizontalAlignment = 4;
        styledTextGData.grabExcessVerticalSpace = true;
        styledTextGData.verticalAlignment = 4;
        this.styledTextComposite.setLayoutData((Object)styledTextGData);
        this.styledText = new StyledText(this.styledTextComposite, 834);
        FormLayout styledTextLayout = new FormLayout();
        this.styledText.setLayout((Layout)styledTextLayout);
        this.styledText.setEditable(true);
        this.styledText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 1));
        this.styledText.setHorizontalIndex(2);
        this.styledText.setTopIndex(1);
        FormData styledTextLData = new FormData();
        styledTextLData.top = new FormAttachment(0, 1000, 5);
        styledTextLData.left = new FormAttachment(0, 1000, 8);
        styledTextLData.bottom = new FormAttachment(1000, 1000, 0);
        styledTextLData.right = new FormAttachment(1000, 1000, 0);
        this.styledText.setLayoutData((Object)styledTextLData);
        if (!GDE.IS_MAC) {
            this.styledText.setBackground(this.innerAreaBackground);
        }
        this.styledText.setMenu(this.popupmenu);
        this.styledText.addExtendedModifyListener(new ExtendedModifyListener(){

            public void modifyText(ExtendedModifyEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "styledText.modifyText, event=" + String.valueOf(evt));
                }
                if (evt.length == 0) {
                    return;
                }
                if (evt.length == 1 || ObjectDescriptionWindow.this.styledText.getTextRange(evt.start, evt.length).equals(ObjectDescriptionWindow.this.styledText.getLineDelimiter())) {
                    int caretOffset = ObjectDescriptionWindow.this.styledText.getCaretOffset();
                    StyleRange style = null;
                    if (caretOffset < ObjectDescriptionWindow.this.styledText.getCharCount()) {
                        style = ObjectDescriptionWindow.this.styledText.getStyleRangeAtOffset(caretOffset);
                    }
                    if (style != null) {
                        style = (StyleRange)style.clone();
                        style.start = evt.start;
                        style.length = evt.length;
                    } else {
                        style = new StyleRange(evt.start, evt.length, null, null, 0);
                    }
                    if (ObjectDescriptionWindow.this.boldButton.getSelection()) {
                        style.fontStyle |= 1;
                    }
                    if (ObjectDescriptionWindow.this.italicButton.getSelection()) {
                        style.fontStyle |= 2;
                    }
                    style.underline = ObjectDescriptionWindow.this.underlineButton.getSelection();
                    style.strikeout = ObjectDescriptionWindow.this.strikeoutButton.getSelection();
                    if (!style.isUnstyled()) {
                        ObjectDescriptionWindow.this.styledText.setStyleRange(style);
                    }
                } else {
                    try {
                        for (int i = 0; i < ObjectDescriptionWindow.this.cachedStyles.size(); ++i) {
                            StyleRange style = ObjectDescriptionWindow.this.cachedStyles.elementAt(i);
                            StyleRange newStyle = (StyleRange)style.clone();
                            newStyle.start = style.start + evt.start;
                            ObjectDescriptionWindow.this.styledText.setStyleRange(newStyle);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.styledText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "styledText.keyReleased, event=" + String.valueOf(evt));
                }
                ObjectDescriptionWindow.this.isObjectDataSaved = false;
            }

            public void keyPressed(KeyEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "styledText.keyPressed, event=" + String.valueOf(evt));
                }
                if ((evt.stateMask & 0x40000) != 0) {
                    if (evt.keyCode == 120) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "SWT.CTRL + 'x'");
                        }
                        ObjectDescriptionWindow.this.handleCutCopy();
                    } else if (evt.keyCode == 99) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "SWT.CTRL + 'c'");
                        }
                        ObjectDescriptionWindow.this.handleCutCopy();
                    } else if (evt.keyCode == 118 && log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "SWT.CTRL + 'v'");
                    }
                }
            }
        });
        this.update();
    }

    public void redrawImageCanvas() {
        this.imageCanvas.redraw();
    }

    void setStyle(Widget widget) {
        Point sel = this.styledText.getSelectionRange();
        if (sel == null || sel.y == 0) {
            return;
        }
        for (int i = sel.x; i < sel.x + sel.y; ++i) {
            StyleRange style;
            StyleRange range = this.styledText.getStyleRangeAtOffset(i);
            if (range != null) {
                style = (StyleRange)range.clone();
                style.start = i;
                style.length = 1;
            } else {
                style = new StyleRange(i, 1, null, null, 0);
            }
            if (widget == this.boldButton) {
                style.fontStyle ^= 1;
            } else if (widget == this.italicButton) {
                style.fontStyle ^= 2;
            } else if (widget == this.underlineButton) {
                style.underline = !style.underline;
            } else if (widget == this.strikeoutButton) {
                style.strikeout = !style.strikeout;
            } else if (widget == this.fColorButton) {
                rgb = (RGB)this.fColorButton.getData();
                style.foreground = SWTResourceManager.getColor(rgb.red, rgb.green, rgb.blue);
            } else if (widget == this.bColorButton) {
                rgb = (RGB)this.bColorButton.getData();
                style.background = SWTResourceManager.getColor(rgb.red, rgb.green, rgb.blue);
            }
            this.styledText.setStyleRange(style);
        }
        this.styledText.setSelectionRange(sel.x + sel.y, 0);
        this.isObjectDataSaved = false;
    }

    void setFont() {
        FontDialog fontDialog = new FontDialog(this.editToolBar.getShell());
        fontDialog.setFontList(this.styledText.getFont().getFontData());
        FontData fontData = fontDialog.open();
        if (fontData != null) {
            this.styledText.setFont(SWTResourceManager.getFont(fontData));
        }
        this.isObjectDataSaved = false;
    }

    void setFontSize(float height) {
        FontData fontData = this.styledText.getFont().getFontData()[0];
        fontData.height = height;
        this.styledText.setFont(SWTResourceManager.getFont(fontData));
        this.isObjectDataSaved = false;
    }

    void handleCutCopy() {
        this.cachedStyles = new Vector();
        Point sel = this.styledText.getSelectionRange();
        int startX = sel.x;
        for (int i = sel.x; i <= sel.x + sel.y - 1; ++i) {
            StyleRange style = this.styledText.getStyleRangeAtOffset(i);
            if (style == null) continue;
            style.start -= startX;
            if (!this.cachedStyles.isEmpty()) {
                StyleRange lastStyle = this.cachedStyles.lastElement();
                if (lastStyle.similarTo(style) && lastStyle.start + lastStyle.length == style.start) {
                    ++lastStyle.length;
                    continue;
                }
                this.cachedStyles.addElement(style);
                continue;
            }
            this.cachedStyles.addElement(style);
        }
    }

    public Image getContentAsImage() {
        if (this.isDisposed()) {
            SWT.error((int)24);
        }
        Rectangle bounds = this.tabFolder.getClientArea();
        Image objectImage = new Image((Device)GDE.display, bounds.width, bounds.height);
        GC imageGC = new GC((Drawable)objectImage);
        this.tabComposite.print(imageGC);
        if (GDE.IS_MAC) {
            this.tabComposite.print(imageGC);
        }
        imageGC.dispose();
        return objectImage;
    }

    public void setInnerAreaBackground(Color newInnerAreaBackground) {
        this.innerAreaBackground = newInnerAreaBackground;
        this.objectTypeText.setBackground(this.innerAreaBackground);
        this.dateText.setBackground(this.innerAreaBackground);
        this.statusText.setBackground(this.innerAreaBackground);
        this.styledTextComposite.setBackground(this.innerAreaBackground);
        this.styledText.setBackground(this.innerAreaBackground);
        this.fontSizeSelectCombo.setBackground(this.innerAreaBackground);
        this.objectTypeText.redraw();
        this.dateText.redraw();
        this.statusText.redraw();
        this.styledTextComposite.redraw();
        this.fontSizeSelectCombo.redraw();
    }

    public void setSurroundingAreaBackground(Color newSurroundingBackground) {
        this.surroundingBackground = newSurroundingBackground;
        this.tabComposite.setBackground(this.surroundingBackground);
        this.headerComposite.setBackground(this.surroundingBackground);
        this.mainObjectCharacterisitcsGroup.setBackground(this.surroundingBackground);
        this.objectNameLabel.setBackground(this.surroundingBackground);
        this.objectName.setBackground(this.surroundingBackground);
        this.objectTypeComposite.setBackground(this.surroundingBackground);
        this.objectTypeLabel.setBackground(this.surroundingBackground);
        this.objectName.setBackground(this.surroundingBackground);
        this.dateComposite.setBackground(this.surroundingBackground);
        this.dateLabel.setBackground(this.surroundingBackground);
        this.statusComposite.setBackground(this.surroundingBackground);
        this.statusLabel.setBackground(this.surroundingBackground);
        this.editGroup.setBackground(this.surroundingBackground);
        this.editCoolBar.setBackground(this.surroundingBackground);
        this.editToolBar.setBackground(this.surroundingBackground);
        this.fontSelectToolBar.setBackground(this.surroundingBackground);
        this.fontSizeSelectComposite.setBackground(this.surroundingBackground);
        this.tabComposite.redraw();
    }

    public ObjectData getObject() {
        return this.object;
    }

    public void setObject(ObjectData object, String newObjectKey) {
        this.isObjectDataSaved = false;
        this.object = new ObjectData(object, newObjectKey);
    }
}

