/*
 * Decompiled with CFR 0.152.
 */
package gde.device.conrad;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.device.DeviceDialog;
import gde.device.conrad.GathererThread;
import gde.device.conrad.VC800;
import gde.device.conrad.VC800SerialPort;
import gde.exception.ApplicationConfigurationException;
import gde.exception.SerialPortException;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.SWTResourceManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class VC800Dialog
extends DeviceDialog {
    static final Logger log = Logger.getLogger(VC800Dialog.class.getName());
    static final String DEVICE_NAME = "VC800";
    Text infoText;
    Button closeButton;
    Button stopCollectDataButton;
    Button startCollectDataButton;
    Composite boundsComposite;
    Group configGroup;
    Composite labelComposite;
    Composite composite2;
    Composite dataComposite;
    CLabel inputTypeLabel;
    CLabel inputTypeUnit;
    CLabel batteryLabel;
    CLabel batteryCondition;
    boolean isBatteryOK = true;
    boolean isConnectionWarned = false;
    boolean isPortOpenedByMe = false;
    Thread updateConfigTread;
    GathererThread dataGatherThread;
    final VC800 device;
    final VC800SerialPort serialPort;
    final Channels channels;
    final Settings settings;
    final HashMap<String, String> configData = new HashMap();

    public VC800Dialog(Shell parent, VC800 useDevice) {
        super(parent);
        this.serialPort = useDevice.getCommunicationPort();
        this.device = useDevice;
        this.channels = Channels.getInstance();
        this.settings = Settings.getInstance();
    }

    public void open() {
        try {
            this.shellAlpha = Settings.getInstance().getDialogAlphaValue();
            this.isAlphaEnabled = Settings.getInstance().isDeviceDialogAlphaEnabled();
            log.log(Level.FINE, "dialogShell.isDisposed() " + String.valueOf(this.dialogShell == null ? "null" : Boolean.valueOf(this.dialogShell.isDisposed())));
            if (this.dialogShell == null || this.dialogShell.isDisposed()) {
                this.dialogShell = this.settings.isDeviceDialogsModal() ? new Shell(this.application.getShell(), 34912) : (this.settings.isDeviceDialogsOnTop() ? new Shell(this.application.getDisplay(), 18528) : new Shell(this.application.getDisplay(), 2144));
                SWTResourceManager.registerResourceUser((Widget)this.dialogShell);
                if (this.isAlphaEnabled) {
                    this.dialogShell.setAlpha(254);
                }
                this.dialogShell.setLayout((Layout)new FormLayout());
                this.dialogShell.setText(this.device.getName() + Messages.getString((String)"GDE_MSGT0273"));
                this.dialogShell.setImage(SWTResourceManager.getImage((String)"gde/resource/ToolBoxHot.gif"));
                this.dialogShell.layout();
                this.dialogShell.pack();
                this.dialogShell.setSize(350, 365);
                this.dialogShell.addListener(31, new Listener(){

                    public void handleEvent(Event event) {
                        switch (event.detail) {
                            case 2: {
                                VC800Dialog.this.dialogShell.close();
                                event.detail = 0;
                                event.doit = false;
                            }
                        }
                    }
                });
                this.dialogShell.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusGained(FocusEvent evt) {
                        log.log(Level.FINER, "dialogShell.focusGained, event=" + String.valueOf(evt));
                        if (!VC800Dialog.this.isConnectionWarned) {
                            try {
                                VC800Dialog.this.updateConfigTread = new Thread("updateConfig"){

                                    @Override
                                    public void run() {
                                        try {
                                            VC800Dialog.this.updateConfig();
                                        }
                                        catch (Exception e) {
                                            VC800Dialog.this.isConnectionWarned = true;
                                            log.log(Level.WARNING, e.getMessage(), e);
                                            VC800Dialog.this.application.openMessageDialog(VC800Dialog.this.getDialogShell(), Messages.getString((String)"GDE_MSGE0024", (Object[])new Object[]{e.getMessage()}));
                                        }
                                        finally {
                                            if (VC800Dialog.this.isPortOpenedByMe) {
                                                VC800Dialog.this.serialPort.close();
                                            }
                                        }
                                    }
                                };
                                VC800Dialog.this.updateConfigTread.start();
                            }
                            catch (RuntimeException e) {
                                log.log(Level.WARNING, e.getMessage(), e);
                            }
                        }
                    }
                });
                this.dialogShell.addHelpListener(new HelpListener(){

                    public void helpRequested(HelpEvent evt) {
                        log.log(Level.FINER, "dialogShell.helpRequested, event=" + String.valueOf(evt));
                        VC800Dialog.this.application.openHelpDialog(VC800Dialog.DEVICE_NAME, "HelpInfo.html");
                    }
                });
                this.dialogShell.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent evt) {
                        log.log(java.util.logging.Level.FINEST, "dialogShell.widgetDisposed, event=" + String.valueOf(evt));
                        VC800Dialog.this.dispose();
                    }
                });
                this.boundsComposite = new Composite((Composite)this.dialogShell, 4);
                FormData boundsCompositeLData = new FormData();
                boundsCompositeLData.left = new FormAttachment(0, 1000, 0);
                boundsCompositeLData.right = new FormAttachment(1000, 1000, 0);
                boundsCompositeLData.top = new FormAttachment(0, 1000, 0);
                boundsCompositeLData.bottom = new FormAttachment(1000, 1000, 0);
                this.boundsComposite.setLayoutData((Object)boundsCompositeLData);
                this.boundsComposite.setLayout((Layout)new FormLayout());
                this.boundsComposite.addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent evt) {
                        log.log(Level.FINER, "boundsComposite.paintControl() " + String.valueOf(evt));
                        if (VC800Dialog.this.dataGatherThread != null && VC800Dialog.this.dataGatherThread.isAlive()) {
                            VC800Dialog.this.startCollectDataButton.setEnabled(false);
                            VC800Dialog.this.stopCollectDataButton.setEnabled(true);
                        } else {
                            VC800Dialog.this.startCollectDataButton.setEnabled(true);
                            VC800Dialog.this.stopCollectDataButton.setEnabled(false);
                        }
                    }
                });
                FormData infoTextLData = new FormData();
                infoTextLData.height = 80;
                infoTextLData.left = new FormAttachment(0, 1000, 12);
                infoTextLData.top = new FormAttachment(0, 1000, 12);
                infoTextLData.right = new FormAttachment(1000, 1000, -12);
                this.infoText = new Text(this.boundsComposite, 66);
                this.infoText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.infoText.setLayoutData((Object)infoTextLData);
                this.infoText.setText(Messages.getString((String)"GDE_MSGT1521"));
                this.infoText.setBackground(SWTResourceManager.getColor((int)22));
                this.infoText.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                FormData startCollectDataButtonLData = new FormData();
                startCollectDataButtonLData.height = 30;
                startCollectDataButtonLData.left = new FormAttachment(0, 1000, 12);
                startCollectDataButtonLData.top = new FormAttachment(0, 1000, 110);
                startCollectDataButtonLData.right = new FormAttachment(1000, 1000, -180);
                this.startCollectDataButton = new Button(this.boundsComposite, 0x1000008);
                this.startCollectDataButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.startCollectDataButton.setLayoutData((Object)startCollectDataButtonLData);
                this.startCollectDataButton.setText(Messages.getString((String)"GDE_MSGT0274"));
                this.startCollectDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        block6: {
                            log.log(Level.FINEST, "startCollectDataButton.widgetSelected, event=" + String.valueOf(evt));
                            if (!VC800Dialog.this.serialPort.isConnected()) {
                                try {
                                    Channel activChannel = Channels.getInstance().getActiveChannel();
                                    if (activChannel == null) break block6;
                                    VC800Dialog.this.dataGatherThread = new GathererThread(VC800Dialog.this.application, VC800Dialog.this.device, VC800Dialog.this.serialPort, activChannel.getNumber(), VC800Dialog.this);
                                    try {
                                        VC800Dialog.this.dataGatherThread.start();
                                    }
                                    catch (RuntimeException e) {
                                        log.log(Level.WARNING, e.getMessage(), e);
                                    }
                                    VC800Dialog.this.boundsComposite.redraw();
                                }
                                catch (Exception e) {
                                    if (VC800Dialog.this.dataGatherThread != null && VC800Dialog.this.dataGatherThread.isCollectDataStopped) {
                                        VC800Dialog.this.dataGatherThread.stopDataGatheringThread(false);
                                    }
                                    VC800Dialog.this.boundsComposite.redraw();
                                    VC800Dialog.this.application.updateGraphicsWindow();
                                    VC800Dialog.this.application.openMessageDialog(VC800Dialog.this.getDialogShell(), Messages.getString((String)"GDE_MSGE0023", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                                }
                            }
                        }
                    }
                });
                this.startCollectDataButton.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                FormData stopColletDataButtonLData = new FormData();
                stopColletDataButtonLData.height = 30;
                stopColletDataButtonLData.left = new FormAttachment(0, 1000, 170);
                stopColletDataButtonLData.top = new FormAttachment(0, 1000, 110);
                stopColletDataButtonLData.right = new FormAttachment(1000, 1000, -12);
                this.stopCollectDataButton = new Button(this.boundsComposite, 0x1000008);
                this.stopCollectDataButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.stopCollectDataButton.setLayoutData((Object)stopColletDataButtonLData);
                this.stopCollectDataButton.setText(Messages.getString((String)"GDE_MSGT0275"));
                this.stopCollectDataButton.setEnabled(false);
                this.stopCollectDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "stopColletDataButton.widgetSelected, event=" + String.valueOf(evt));
                        if (VC800Dialog.this.dataGatherThread != null && VC800Dialog.this.serialPort.isConnected()) {
                            VC800Dialog.this.dataGatherThread.stopDataGatheringThread(false);
                        }
                        VC800Dialog.this.boundsComposite.redraw();
                    }
                });
                this.stopCollectDataButton.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                FormData configGroupLData = new FormData();
                configGroupLData.height = 100;
                configGroupLData.left = new FormAttachment(0, 1000, 12);
                configGroupLData.top = new FormAttachment(0, 1000, 155);
                configGroupLData.right = new FormAttachment(1000, 1000, -12);
                this.configGroup = new Group(this.boundsComposite, 0);
                this.configGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                RowLayout configGroupLayout = new RowLayout(256);
                this.configGroup.setLayout((Layout)configGroupLayout);
                this.configGroup.setLayoutData((Object)configGroupLData);
                this.configGroup.setText(Messages.getString((String)"GDE_MSGT1534"));
                this.configGroup.addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent evt) {
                        log.log(Level.FINEST, "configGroup.paintControl, event=" + String.valueOf(evt));
                        if (VC800Dialog.this.configData.size() >= 3) {
                            VC800Dialog.this.inputTypeUnit.setText(VC800Dialog.this.configData.get("input_type") + "  " + VC800Dialog.this.configData.get("input_symbol") + "   [" + VC800Dialog.this.configData.get("input_unit") + "]");
                        }
                        VC800Dialog.this.batteryCondition.setText(VC800Dialog.this.isBatteryOK ? Messages.getString((String)"GDE_MSGT1535") : Messages.getString((String)"GDE_MSGT1536"));
                    }
                });
                RowData composite1LData = new RowData();
                composite1LData.width = 150;
                composite1LData.height = 95;
                this.labelComposite = new Composite((Composite)this.configGroup, 0);
                FillLayout composite1Layout = new FillLayout(512);
                this.labelComposite.setLayout((Layout)composite1Layout);
                this.labelComposite.setLayoutData((Object)composite1LData);
                this.inputTypeLabel = new CLabel(this.labelComposite, 0);
                this.inputTypeLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.inputTypeLabel.setText(Messages.getString((String)"GDE_MSGT1530"));
                this.batteryLabel = new CLabel(this.labelComposite, 0);
                this.batteryLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.batteryLabel.setText(Messages.getString((String)"GDE_MSGT1531"));
                this.dataComposite = new Composite((Composite)this.configGroup, 0);
                FillLayout composite3Layout = new FillLayout(512);
                RowData composite3LData = new RowData();
                composite3LData.width = 150;
                composite3LData.height = 95;
                this.dataComposite.setLayoutData((Object)composite3LData);
                this.dataComposite.setLayout((Layout)composite3Layout);
                this.inputTypeUnit = new CLabel(this.dataComposite, 0);
                this.inputTypeUnit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.inputTypeUnit.setText(Messages.getString((String)"GDE_MSGT1532"));
                this.batteryCondition = new CLabel(this.dataComposite, 0);
                this.batteryCondition.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.batteryCondition.setText(this.isBatteryOK ? Messages.getString((String)"GDE_MSGT1535") : Messages.getString((String)"GDE_MSGT1536"));
                this.configGroup.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                FormData closeButtonLData = new FormData();
                closeButtonLData.height = 30;
                closeButtonLData.bottom = new FormAttachment(1000, 1000, -12);
                closeButtonLData.left = new FormAttachment(0, 1000, 12);
                closeButtonLData.right = new FormAttachment(1000, 1000, -12);
                this.closeButton = new Button(this.boundsComposite, 0x1000008);
                this.closeButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.closeButton.setLayoutData((Object)closeButtonLData);
                this.closeButton.setText(Messages.getString((String)"GDE_MSGT0188"));
                this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "okButton.widgetSelected, event=" + String.valueOf(evt));
                        VC800Dialog.this.close();
                    }
                });
                this.closeButton.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                this.boundsComposite.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                    public void mouseEnter(MouseEvent evt) {
                        log.log(Level.FINE, "boundsComposite.mouseEnter, event=" + String.valueOf(evt));
                        VC800Dialog.this.fadeOutAplhaBlending(evt, VC800Dialog.this.boundsComposite.getSize(), 10, 10, 10, 15);
                    }

                    public void mouseHover(MouseEvent evt) {
                        log.log(Level.FINEST, "boundsComposite.mouseHover, event=" + String.valueOf(evt));
                    }

                    public void mouseExit(MouseEvent evt) {
                        log.log(Level.FINE, "boundsComposite.mouseExit, event=" + String.valueOf(evt));
                        VC800Dialog.this.fadeInAlpaBlending(evt, VC800Dialog.this.boundsComposite.getSize(), 10, 10, -10, 15);
                    }
                });
                this.dialogShell.setLocation(this.getParent().toDisplay(this.getParent().getSize().x / 2 - 175, 100));
                this.dialogShell.open();
            } else {
                this.dialogShell.setVisible(true);
                this.dialogShell.setActive();
            }
            Display display = this.dialogShell.getDisplay();
            while (!this.dialogShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void resetButtons() {
        if (!this.isDisposed()) {
            this.startCollectDataButton.setEnabled(true);
            this.stopCollectDataButton.setEnabled(false);
        }
    }

    public HashMap<String, String> getConfigData() {
        return this.configData;
    }

    void updateConfig() throws ApplicationConfigurationException, SerialPortException, InterruptedException, TimeOutException, IOException, Exception {
        if (this.configData.size() < 3 || !this.configData.get("input_type").equals(Messages.getString((String)"GDE_MSGT1500").split(" ")[0])) {
            if (!this.serialPort.isConnected()) {
                this.serialPort.open();
                this.isPortOpenedByMe = true;
            } else {
                this.isPortOpenedByMe = false;
            }
            do {
                byte[] dataBuffer = this.serialPort.getData();
                this.device.getMeasurementInfo(dataBuffer, this.configData);
                this.isBatteryOK = this.device.isBatteryLevelLow(dataBuffer);
            } while (this.configData.get("input_type") == null || this.configData.get("input_type").equals(Messages.getString((String)"GDE_MSGT1500").split(" ")[0]));
            if (this.dialogShell != null && !this.dialogShell.isDisposed()) {
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        VC800Dialog.this.configGroup.redraw();
                    }
                });
            }
        }
    }
}

