/*
 * Decompiled with CFR 0.152.
 */
package gde.device.unitrend;

import gde.GDE;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.unitrend.UniTrend;
import gde.device.unitrend.UniTrendDialog;
import gde.device.unitrend.UniTrendSerialPort;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.SerialPortException;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import java.util.HashMap;
import java.util.logging.Logger;

public class GathererThread
extends Thread {
    static final String $CLASS_NAME = GathererThread.class.getName();
    static final Logger log = Logger.getLogger(GathererThread.class.getName());
    DataExplorer application;
    final UniTrendSerialPort serialPort;
    final UniTrend device;
    final UniTrendDialog dialog;
    final Channels channels;
    final Channel channel;
    final int channelNumber;
    String recordSetKey = Messages.getString((String)"GDE_MSGT0272");
    boolean isPortOpenedByLiveGatherer = false;
    boolean isSwitchedRecordSet = false;
    boolean isGatheredRecordSetVisible = true;
    static final int WAIT_TIME_RETRYS = 600;
    int retryCounter = 600;
    final long cycleTime_ms;
    boolean isCollectDataStopped = false;

    public GathererThread(DataExplorer currentApplication, UniTrend useDevice, UniTrendSerialPort useSerialPort, int channelConfigNumber, UniTrendDialog useDialog) throws ApplicationConfigurationException, SerialPortException {
        super("liveDataGatherer");
        this.application = currentApplication;
        this.device = useDevice;
        this.dialog = useDialog;
        this.serialPort = useSerialPort;
        this.channels = Channels.getInstance();
        this.channelNumber = channelConfigNumber;
        this.channel = (Channel)this.channels.get((Object)this.channelNumber);
        this.recordSetKey = this.device.getRecordSetStemNameReplacement();
        if (!this.serialPort.isConnected()) {
            this.serialPort.open();
            this.isPortOpenedByLiveGatherer = true;
        }
        this.setPriority(10);
        this.cycleTime_ms = (long)this.device.getTimeStep_ms();
    }

    @Override
    public void run() {
        String $METHOD_NAME = "run";
        RecordSet recordSet = null;
        int[] points = new int[this.device.getNumberOfMeasurements(this.channelNumber)];
        HashMap<String, String> configData = this.dialog.getConfigData();
        long startCycleTime = 0L;
        long tmpCycleTime = 0L;
        long measurementCount = 0L;
        byte[] dataBuffer = null;
        String m_unit = "";
        String old_unit = "";
        this.isCollectDataStopped = false;
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, $CLASS_NAME, "run", "====> entry initial time step ms = " + this.device.getTimeStep_ms());
        }
        this.application.setStatusMessage("");
        try {
            this.serialPort.read(new byte[14], 1000);
            this.serialPort.read(new byte[14], 1000);
            this.serialPort.getData();
        }
        catch (Exception exception) {
            // empty catch block
        }
        long lastTimeStamp = 0L;
        while (!this.isCollectDataStopped) {
            try {
                if (this.application != null) {
                    this.application.setPortConnected(true);
                }
                dataBuffer = this.serialPort.getData();
                this.device.getMeasurementInfo(dataBuffer, configData);
                m_unit = configData.get("input_unit");
                String processName = this.device.getMode(dataBuffer);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "unit = " + m_unit + " mode = " + processName);
                }
                if (m_unit.length() <= 0) continue;
                if (this.channel.size() == 0 || recordSet == null || !this.recordSetKey.endsWith(" " + processName) || !m_unit.equals(old_unit)) {
                    this.application.setStatusMessage("");
                    this.setRetryCounter(600);
                    this.recordSetKey = this.channel.getNextRecordSetNumber() + ") " + processName;
                    this.channel.put((Object)this.recordSetKey, (Object)RecordSet.createRecordSet((String)this.recordSetKey, (IDevice)this.application.getActiveDevice(), (int)this.channel.getNumber(), (boolean)true, (boolean)false, (boolean)true));
                    this.channel.applyTemplateBasics(this.recordSetKey);
                    if (log.isLoggable(Level.FINE)) {
                        log.logp(Level.FINE, $CLASS_NAME, "run", this.recordSetKey + " created for channel " + this.channel.getName());
                    }
                    if (this.channel.getActiveRecordSet() == null) {
                        this.channel.setActiveRecordSet(this.recordSetKey);
                    }
                    recordSet = (RecordSet)this.channel.get((Object)this.recordSetKey);
                    recordSet.setAllDisplayable();
                    Record record = recordSet.get((Object)recordSet.getFirstRecordName());
                    record.setUnit(m_unit);
                    record.setSymbol(configData.get("input_symbol"));
                    record.setName(configData.get("input_type"));
                    this.channel.applyTemplate(this.recordSetKey, false);
                    if (this.channel.getName().equals(this.channels.getActiveChannel().getName())) {
                        this.channels.getActiveChannel().switchRecordSet(this.recordSetKey);
                    }
                    recordSet.updateVisibleAndDisplayableRecordsForTable();
                    measurementCount = 0L;
                    old_unit = m_unit;
                }
                tmpCycleTime = System.nanoTime() / 1000000L;
                if (measurementCount == 0L) {
                    ++measurementCount;
                    startCycleTime = tmpCycleTime;
                }
                if (this.cycleTime_ms > 1500L || lastTimeStamp == 0L) {
                    if (tmpCycleTime - lastTimeStamp > this.cycleTime_ms - 150L) {
                        long delayTime;
                        recordSet.addPoints(this.device.convertDataBytes(points, dataBuffer), (double)(tmpCycleTime - startCycleTime));
                        long l = delayTime = lastTimeStamp == 0L ? 0L : tmpCycleTime - startCycleTime - measurementCount++ * this.cycleTime_ms;
                        if (log.isLoggable(Level.TIME)) {
                            log.logp(Level.TIME, $CLASS_NAME, "run", "deltaTime = " + (lastTimeStamp == 0L ? 0L : (tmpCycleTime - startCycleTime) / (measurementCount - 1L)) + ", delayTime = " + delayTime);
                        }
                        lastTimeStamp = tmpCycleTime - delayTime;
                    }
                } else {
                    recordSet.addPoints(this.device.convertDataBytes(points, dataBuffer), (double)(tmpCycleTime - startCycleTime));
                }
                if (!recordSet.isChildOfActiveChannel() || !recordSet.equals((Object)this.channels.getActiveChannel().getActiveRecordSet())) continue;
                this.application.updateAllTabs(false);
            }
            catch (DataInconsitsentException e) {
                log.log(Level.SEVERE, Messages.getString((String)"GDE_MSGE0036", (Object[])new Object[]{this.getClass().getSimpleName(), "run"}));
                this.postCleanup();
            }
            catch (Throwable e) {
                log.logp(Level.WARNING, $CLASS_NAME, "run", e.getMessage(), e);
                if (e instanceof TimeOutException) {
                    this.application.setStatusMessage(Messages.getString((String)"GDE_MSGI1500"));
                    log.logp(Level.WARNING, $CLASS_NAME, "run", "wait for device activation ... " + this.getRetryCounter());
                    if (0 != this.setRetryCounter(this.getRetryCounter() - 1)) continue;
                    log.log(Level.WARNING, "device activation timeout", e);
                    this.application.setStatusMessage(Messages.getString((String)"GDE_MSGI1501"), 3);
                    this.stopDataGatheringThread(false);
                    continue;
                }
                this.stopDataGatheringThread(true);
            }
        }
        configData.clear();
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, $CLASS_NAME, "run", "======> exit");
        }
    }

    void stopDataGatheringThread(boolean enableEndMessage) {
        RecordSet recordSet;
        this.isCollectDataStopped = true;
        if (this.serialPort != null && this.serialPort.getXferErrors() > 0) {
            log.log(Level.WARNING, "During complete data transfer " + this.serialPort.getXferErrors() + " number of errors occured!");
            this.application.setStatusMessage(Messages.getString((String)"GDE_MSGE0026"), 3);
        }
        if (this.serialPort != null && this.serialPort.isConnected() && this.isPortOpenedByLiveGatherer && this.serialPort.isConnected()) {
            this.serialPort.close();
        }
        if ((recordSet = (RecordSet)this.channel.get((Object)this.recordSetKey)) != null && recordSet.getRecordDataSize(true) > 5) {
            this.finalizeRecordSet(false);
            if (enableEndMessage) {
                this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGI1501"));
            }
        } else {
            this.postCleanup();
        }
    }

    void finalizeRecordSet(boolean doClosePort) {
        RecordSet tmpRecordSet;
        if (doClosePort && this.isPortOpenedByLiveGatherer && this.serialPort.isConnected()) {
            this.serialPort.close();
        }
        if ((tmpRecordSet = (RecordSet)this.channel.get((Object)this.recordSetKey)) != null) {
            this.device.updateVisibilityStatus(tmpRecordSet, false);
            this.device.makeInActiveDisplayable(tmpRecordSet);
            this.application.updateStatisticsData();
            this.application.updateDataTable(this.recordSetKey, false);
        }
    }

    void postCleanup() {
        if (this.channel.get((Object)this.recordSetKey) != null) {
            ((RecordSet)this.channel.get((Object)this.recordSetKey)).clear();
            this.channel.remove(this.recordSetKey);
            if (Thread.currentThread().threadId() == this.application.getThreadId()) {
                this.application.getMenuToolBar().updateRecordSetSelectCombo();
                this.application.updateStatisticsData();
                this.application.updateDataTable(this.recordSetKey, true);
                this.device.getDialog().resetButtons();
            } else {
                final String useRecordSetKey = this.recordSetKey;
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GathererThread.this.application.getMenuToolBar().updateRecordSetSelectCombo();
                        GathererThread.this.application.updateStatisticsData();
                        GathererThread.this.application.updateDataTable(useRecordSetKey, true);
                        GathererThread.this.device.getDialog().resetButtons();
                    }
                });
            }
        }
    }

    void setCollectDataStopped(boolean enabled) {
        this.isCollectDataStopped = enabled;
    }

    boolean isCollectDataStopped() {
        return this.isCollectDataStopped;
    }

    int getRetryCounter() {
        return this.retryCounter;
    }

    int setRetryCounter(int newRetryCounter) {
        this.retryCounter = newRetryCounter;
        return this.retryCounter;
    }
}

