/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DesktopPropertyType;
import gde.device.DesktopPropertyTypes;
import gde.device.DeviceConfiguration;
import gde.device.DeviceDialog;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.graupner.PolaronGathererThread;
import gde.device.graupner.PolaronSerialPort;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.SerialPortException;
import gde.io.DataParser;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;

public abstract class Polaron
extends DeviceConfiguration
implements IDevice {
    static final Logger log = Logger.getLogger(Polaron.class.getName());
    protected String[] PROCESSING_MODE;
    protected String[] CHARGE_TYPE;
    protected String[] DISCHARGE_TYPE;
    protected String[] ERROR_TYPE;
    protected static final int OPERATIONS_MODE_LINK_DISCHARGE = 4;
    protected static final int OPERATIONS_MODE_LINK_CHARGE = 6;
    protected static final int OPERATIONS_MODE_ERROR = 6;
    protected static final int OPERATIONS_MODE_NONE = 0;
    protected String firmware = "-";
    protected PolaronGathererThread dataGatherThread;
    protected final Settings settings = Settings.getInstance();
    protected final DataExplorer application;
    protected final PolaronSerialPort serialPort;
    protected final Channels channels;

    public Polaron(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        Messages.setDeviceResourceBundle((String)"gde.device.graupner.polaron.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.PROCESSING_MODE = new String[]{Messages.getString((String)"GDE_MSGT3100"), Messages.getString((String)"GDE_MSGT3101"), Messages.getString((String)"GDE_MSGT3102"), Messages.getString((String)"GDE_MSGT3103"), Messages.getString((String)"GDE_MSGT3100"), Messages.getString((String)"GDE_MSGT3105"), Messages.getString((String)"GDE_MSGT3106"), Messages.getString((String)"GDE_MSGT3107"), Messages.getString((String)"GDE_MSGT3122"), Messages.getString((String)"GDE_MSGT3109"), Messages.getString((String)"GDE_MSGT3100"), Messages.getString((String)"GDE_MSGT3100"), Messages.getString((String)"GDE_MSGT3100"), Messages.getString((String)"GDE_MSGT3100"), Messages.getString((String)"GDE_MSGT3100"), Messages.getString((String)"GDE_MSGT3100"), Messages.getString((String)"GDE_MSGT3100"), Messages.getString((String)"GDE_MSGT3100"), Messages.getString((String)"GDE_MSGT3100"), Messages.getString((String)"GDE_MSGT3100")};
        this.CHARGE_TYPE = new String[]{Messages.getString((String)"GDE_MSGT3110"), Messages.getString((String)"GDE_MSGT3111"), Messages.getString((String)"GDE_MSGT3112"), Messages.getString((String)"GDE_MSGT3113"), Messages.getString((String)"GDE_MSGT3118"), Messages.getString((String)"GDE_MSGT3120"), Messages.getString((String)"GDE_MSGT3119"), Messages.getString((String)"GDE_MSGT3116"), Messages.getString((String)"GDE_MSGT3121"), Messages.getString((String)"GDE_MSGT3117"), Messages.getString((String)"GDE_MSGT3118"), Messages.getString((String)"GDE_MSGT3119"), Messages.getString((String)"GDE_MSGT3120"), Messages.getString((String)"GDE_MSGT3122")};
        this.DISCHARGE_TYPE = new String[]{Messages.getString((String)"GDE_MSGT3110"), Messages.getString((String)"GDE_MSGT3111"), Messages.getString((String)"GDE_MSGT3112"), Messages.getString((String)"GDE_MSGT3113"), Messages.getString((String)"GDE_MSGT3124"), Messages.getString((String)"GDE_MSGT3118"), Messages.getString((String)"GDE_MSGT3124"), Messages.getString((String)"GDE_MSGT3120"), Messages.getString((String)"GDE_MSGT3122")};
        this.application = DataExplorer.getInstance();
        this.serialPort = new PolaronSerialPort(this, this.application);
        this.channels = Channels.getInstance();
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(1, "", "");
        }
    }

    public Polaron(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.graupner.polaron.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.PROCESSING_MODE = new String[]{Messages.getString((String)"GDE_MSGT3100"), Messages.getString((String)"GDE_MSGT3101"), Messages.getString((String)"GDE_MSGT3102"), Messages.getString((String)"GDE_MSGT3103"), Messages.getString((String)"GDE_MSGT3100"), Messages.getString((String)"GDE_MSGT3105"), Messages.getString((String)"GDE_MSGT3106"), Messages.getString((String)"GDE_MSGT3107"), Messages.getString((String)"GDE_MSGT3122"), Messages.getString((String)"GDE_MSGT3109"), Messages.getString((String)"GDE_MSGT3100"), Messages.getString((String)"GDE_MSGT3100"), Messages.getString((String)"GDE_MSGT3100"), Messages.getString((String)"GDE_MSGT3100"), Messages.getString((String)"GDE_MSGT3100"), Messages.getString((String)"GDE_MSGT3100"), Messages.getString((String)"GDE_MSGT3100"), Messages.getString((String)"GDE_MSGT3100"), Messages.getString((String)"GDE_MSGT3100"), Messages.getString((String)"GDE_MSGT3100")};
        this.CHARGE_TYPE = new String[]{Messages.getString((String)"GDE_MSGT3110"), Messages.getString((String)"GDE_MSGT3111"), Messages.getString((String)"GDE_MSGT3112"), Messages.getString((String)"GDE_MSGT3113"), Messages.getString((String)"GDE_MSGT3118"), Messages.getString((String)"GDE_MSGT3120"), Messages.getString((String)"GDE_MSGT3119"), Messages.getString((String)"GDE_MSGT3116"), Messages.getString((String)"GDE_MSGT3121"), Messages.getString((String)"GDE_MSGT3117"), Messages.getString((String)"GDE_MSGT3118"), Messages.getString((String)"GDE_MSGT3119"), Messages.getString((String)"GDE_MSGT3120"), Messages.getString((String)"GDE_MSGT3122")};
        this.DISCHARGE_TYPE = new String[]{Messages.getString((String)"GDE_MSGT3110"), Messages.getString((String)"GDE_MSGT3111"), Messages.getString((String)"GDE_MSGT3112"), Messages.getString((String)"GDE_MSGT3113"), Messages.getString((String)"GDE_MSGT3124"), Messages.getString((String)"GDE_MSGT3118"), Messages.getString((String)"GDE_MSGT3124"), Messages.getString((String)"GDE_MSGT3120"), Messages.getString((String)"GDE_MSGT3122")};
        this.application = DataExplorer.getInstance();
        this.serialPort = new PolaronSerialPort(this, this.application);
        this.channels = Channels.getInstance();
        this.configureSerialPortMenu(1, "", "");
    }

    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        return lov2osdMap;
    }

    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        return "";
    }

    public int getLovDataByteSize() {
        return 132;
    }

    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int deviceDataBufferSize = Math.abs(this.getDataBlockSize(InputTypes.SERIAL_IO));
        int deviceDataBufferSize2 = deviceDataBufferSize / 2;
        int channel2Offset = deviceDataBufferSize2 - 4;
        int[] points = new int[this.getNumberOfMeasurements(recordSet.getChannelConfigNumber())];
        int offset = 0;
        int progressCycle = 0;
        int lovDataSize = this.getLovDataByteSize();
        int outputChannel = recordSet.getChannelConfigNumber();
        if (dataBuffer[offset] == 12) {
            byte[] convertBuffer = new byte[deviceDataBufferSize];
            if (doUpdateProgressBar) {
                this.application.setProgress(progressCycle, sThreadId);
            }
            for (int i = 0; i < recordDataSize; ++i) {
                if (outputChannel == 1) {
                    System.arraycopy(dataBuffer, offset + i * lovDataSize, convertBuffer, 0, deviceDataBufferSize2);
                } else if (outputChannel == 2) {
                    System.arraycopy(dataBuffer, channel2Offset + offset + i * lovDataSize, convertBuffer, 0, deviceDataBufferSize2);
                }
                recordSet.addPoints(this.convertDataBytes(points, convertBuffer));
                if (!doUpdateProgressBar || i % 50 != 0) continue;
                this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
            }
            recordSet.setTimeStep_ms(this.getAverageTimeStep_ms() != null ? this.getAverageTimeStep_ms() : 1000.0);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        this.updateVisibilityStatus(recordSet, true);
        recordSet.syncScaleOfSyncableRecords();
    }

    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        int maxVotage = Integer.MIN_VALUE;
        int minVotage = Integer.MAX_VALUE;
        int deviceDataBufferSize = Math.abs(this.getDataBlockSize(InputTypes.SERIAL_IO));
        if (deviceDataBufferSize == dataBuffer.length && this.isLinkedMode(dataBuffer)) {
            try {
                int offset2 = 114;
                points[0] = DataParser.parse2Short((byte[])dataBuffer, (int)11);
                points[2] = DataParser.parse2Short((byte[])dataBuffer, (int)31);
                points[3] = DataParser.parse2Short((byte[])dataBuffer, (int)145);
                points[1] = points[2] + points[3];
                points[5] = DataParser.parse2Short((byte[])dataBuffer, (int)33);
                points[6] = DataParser.parse2Short((byte[])dataBuffer, (int)147);
                points[4] = points[5] + points[6];
                points[8] = DataParser.parse2Short((byte[])dataBuffer, (int)35);
                points[9] = DataParser.parse2Short((byte[])dataBuffer, (int)149);
                points[7] = points[8] + points[9];
                points[11] = Double.valueOf((double)(points[2] * points[5]) / 1000.0).intValue();
                points[12] = Double.valueOf((double)(points[3] * points[6]) / 1000.0).intValue();
                points[10] = points[11] + points[12];
                points[14] = Double.valueOf((double)(points[2] * points[8]) / 1000.0).intValue();
                points[15] = Double.valueOf((double)(points[3] * points[9]) / 1000.0).intValue();
                points[13] = points[14] + points[15];
                points[16] = DataParser.parse2Short((byte[])dataBuffer, (int)37);
                if (DataParser.parse2Short((byte[])dataBuffer, (int)39) == 0) {
                    points[16] = -1 * points[16];
                }
                points[17] = DataParser.parse2Short((byte[])dataBuffer, (int)151);
                if (DataParser.parse2Short((byte[])dataBuffer, (int)39) == 0) {
                    points[17] = -1 * points[17];
                }
                points[18] = 0;
                int i = 0;
                int j = 0;
                while (i < 7) {
                    points[i + 19] = DataParser.parse2Short((byte[])dataBuffer, (int)(j + 45));
                    if (points[i + 19] > 0) {
                        maxVotage = points[i + 19] > maxVotage ? points[i + 19] : maxVotage;
                        minVotage = points[i + 19] < minVotage ? points[i + 19] : minVotage;
                    }
                    ++i;
                    j += 2;
                }
                i = 0;
                j = 0;
                while (i < 7) {
                    points[i + 26] = DataParser.parse2Short((byte[])dataBuffer, (int)(j + 45 + 114));
                    if (points[i + 26] > 0) {
                        maxVotage = points[i + 26] > maxVotage ? points[i + 26] : maxVotage;
                        minVotage = points[i + 26] < minVotage ? points[i + 26] : minVotage;
                    }
                    ++i;
                    j += 2;
                }
                points[18] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
                points[33] = DataParser.parse2Short((byte[])dataBuffer, (int)91) + DataParser.parse2Short((byte[])dataBuffer, (int)205);
                i = 0;
                j = 0;
                while (i < 7) {
                    points[i + 34] = DataParser.parse2Short((byte[])dataBuffer, (int)(j + 59));
                    ++i;
                    j += 2;
                }
                i = 0;
                j = 0;
                while (i < 7) {
                    points[i + 41] = DataParser.parse2Short((byte[])dataBuffer, (int)(j + 59 + 114));
                    ++i;
                    j += 2;
                }
            }
            catch (NumberFormatException e) {
                log.log(java.util.logging.Level.WARNING, e.getMessage(), e);
            }
        } else {
            try {
                points[0] = DataParser.parse2Short((byte[])dataBuffer, (int)11);
                points[1] = DataParser.parse2Short((byte[])dataBuffer, (int)31);
                points[2] = DataParser.parse2Short((byte[])dataBuffer, (int)33);
                points[3] = DataParser.parse2Short((byte[])dataBuffer, (int)35);
                points[4] = Double.valueOf((double)(points[1] * points[2]) / 1000.0).intValue();
                points[5] = Double.valueOf((double)(points[1] * points[3]) / 1000.0).intValue();
                points[6] = DataParser.parse2Short((byte[])dataBuffer, (int)37);
                if (DataParser.parse2Short((byte[])dataBuffer, (int)39) == 0) {
                    points[6] = -1 * points[6];
                }
                points[7] = 0;
                int i = 0;
                int j = 0;
                while (i < 7) {
                    points[i + 8] = DataParser.parse2Short((byte[])dataBuffer, (int)(j + 45));
                    if (points[i + 8] > 0) {
                        maxVotage = points[i + 8] > maxVotage ? points[i + 8] : maxVotage;
                        minVotage = points[i + 8] < minVotage ? points[i + 8] : minVotage;
                    }
                    ++i;
                    j += 2;
                }
                points[7] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
                points[15] = DataParser.parse2Short((byte[])dataBuffer, (int)91);
                i = 0;
                j = 0;
                while (i < 7) {
                    points[i + 16] = DataParser.parse2Short((byte[])dataBuffer, (int)(j + 59));
                    ++i;
                    j += 2;
                }
            }
            catch (Exception e) {
                log.log(java.util.logging.Level.WARNING, e.getMessage(), e);
            }
        }
        return points;
    }

    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int progressCycle = 0;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        if (recordSet.getChannelConfigNumber() == 3) {
            for (int i = 0; i < recordDataSize; ++i) {
                int maxVotage = Integer.MIN_VALUE;
                int minVotage = Integer.MAX_VALUE;
                log.log(java.util.logging.Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize);
                System.arraycopy(dataBuffer, i * dataBufferSize, convertBuffer, 0, dataBufferSize);
                points[0] = ((convertBuffer[0] & 0xFF) << 24) + ((convertBuffer[1] & 0xFF) << 16) + ((convertBuffer[2] & 0xFF) << 8) + ((convertBuffer[3] & 0xFF) << 0);
                points[2] = ((convertBuffer[4] & 0xFF) << 24) + ((convertBuffer[5] & 0xFF) << 16) + ((convertBuffer[6] & 0xFF) << 8) + ((convertBuffer[7] & 0xFF) << 0);
                points[3] = ((convertBuffer[8] & 0xFF) << 24) + ((convertBuffer[9] & 0xFF) << 16) + ((convertBuffer[10] & 0xFF) << 8) + ((convertBuffer[11] & 0xFF) << 0);
                points[1] = points[2] + points[3];
                points[5] = ((convertBuffer[12] & 0xFF) << 24) + ((convertBuffer[13] & 0xFF) << 16) + ((convertBuffer[14] & 0xFF) << 8) + ((convertBuffer[15] & 0xFF) << 0);
                points[6] = ((convertBuffer[16] & 0xFF) << 24) + ((convertBuffer[17] & 0xFF) << 16) + ((convertBuffer[18] & 0xFF) << 8) + ((convertBuffer[19] & 0xFF) << 0);
                points[4] = points[5] + points[6];
                points[8] = ((convertBuffer[20] & 0xFF) << 24) + ((convertBuffer[21] & 0xFF) << 16) + ((convertBuffer[22] & 0xFF) << 8) + ((convertBuffer[23] & 0xFF) << 0);
                points[9] = ((convertBuffer[24] & 0xFF) << 24) + ((convertBuffer[25] & 0xFF) << 16) + ((convertBuffer[26] & 0xFF) << 8) + ((convertBuffer[27] & 0xFF) << 0);
                points[7] = points[8] + points[9];
                points[10] = Double.valueOf((double)points[1] / 1000.0 * (double)points[4]).intValue();
                points[11] = Double.valueOf((double)points[2] / 1000.0 * (double)points[5]).intValue();
                points[12] = Double.valueOf((double)points[3] / 1000.0 * (double)points[6]).intValue();
                points[13] = Double.valueOf((double)points[1] / 1000.0 * (double)points[7]).intValue();
                points[14] = Double.valueOf((double)points[1] / 1000.0 * (double)points[8]).intValue();
                points[15] = Double.valueOf((double)points[1] / 1000.0 * (double)points[9]).intValue();
                points[16] = ((convertBuffer[28] & 0xFF) << 24) + ((convertBuffer[29] & 0xFF) << 16) + ((convertBuffer[30] & 0xFF) << 8) + ((convertBuffer[31] & 0xFF) << 0);
                points[17] = ((convertBuffer[32] & 0xFF) << 24) + ((convertBuffer[33] & 0xFF) << 16) + ((convertBuffer[34] & 0xFF) << 8) + ((convertBuffer[35] & 0xFF) << 0);
                points[18] = 0;
                int j = 0;
                int k = 0;
                while (j < 14) {
                    points[j + 19] = ((convertBuffer[k + 36] & 0xFF) << 24) + ((convertBuffer[k + 37] & 0xFF) << 16) + ((convertBuffer[k + 38] & 0xFF) << 8) + ((convertBuffer[k + 39] & 0xFF) << 0);
                    if (points[j + 19] > 0) {
                        maxVotage = points[j + 19] > maxVotage ? points[j + 19] : maxVotage;
                        minVotage = points[j + 19] < minVotage ? points[j + 19] : minVotage;
                    }
                    ++j;
                    k += 4;
                }
                points[18] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
                points[33] = ((convertBuffer[92] & 0xFF) << 24) + ((convertBuffer[93] & 0xFF) << 16) + ((convertBuffer[94] & 0xFF) << 8) + ((convertBuffer[95] & 0xFF) << 0);
                j = 0;
                k = 0;
                while (j < 14) {
                    points[j + 34] = ((convertBuffer[k + 96] & 0xFF) << 24) + ((convertBuffer[k + 97] & 0xFF) << 16) + ((convertBuffer[k + 98] & 0xFF) << 8) + ((convertBuffer[k + 99] & 0xFF) << 0);
                    ++j;
                    k += 4;
                }
                recordSet.addPoints(points);
                if (!doUpdateProgressBar || i % 50 != 0) continue;
                this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
            }
        } else {
            for (int i = 0; i < recordDataSize; ++i) {
                int maxVotage = Integer.MIN_VALUE;
                int minVotage = Integer.MAX_VALUE;
                log.log(java.util.logging.Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize);
                System.arraycopy(dataBuffer, i * dataBufferSize, convertBuffer, 0, dataBufferSize);
                points[0] = ((convertBuffer[0] & 0xFF) << 24) + ((convertBuffer[1] & 0xFF) << 16) + ((convertBuffer[2] & 0xFF) << 8) + ((convertBuffer[3] & 0xFF) << 0);
                points[1] = ((convertBuffer[4] & 0xFF) << 24) + ((convertBuffer[5] & 0xFF) << 16) + ((convertBuffer[6] & 0xFF) << 8) + ((convertBuffer[7] & 0xFF) << 0);
                points[2] = ((convertBuffer[8] & 0xFF) << 24) + ((convertBuffer[9] & 0xFF) << 16) + ((convertBuffer[10] & 0xFF) << 8) + ((convertBuffer[11] & 0xFF) << 0);
                points[3] = ((convertBuffer[12] & 0xFF) << 24) + ((convertBuffer[13] & 0xFF) << 16) + ((convertBuffer[14] & 0xFF) << 8) + ((convertBuffer[15] & 0xFF) << 0);
                points[4] = Double.valueOf((double)points[1] / 1000.0 * (double)points[2]).intValue();
                points[5] = Double.valueOf((double)points[1] / 1000.0 * (double)points[3]).intValue();
                points[6] = ((convertBuffer[16] & 0xFF) << 24) + ((convertBuffer[17] & 0xFF) << 16) + ((convertBuffer[18] & 0xFF) << 8) + ((convertBuffer[19] & 0xFF) << 0);
                points[7] = 0;
                int j = 0;
                int k = 0;
                while (j < 7) {
                    points[j + 8] = ((convertBuffer[k + 20] & 0xFF) << 24) + ((convertBuffer[k + 21] & 0xFF) << 16) + ((convertBuffer[k + 22] & 0xFF) << 8) + ((convertBuffer[k + 23] & 0xFF) << 0);
                    if (points[j + 8] > 0) {
                        maxVotage = points[j + 8] > maxVotage ? points[j + 8] : maxVotage;
                        minVotage = points[j + 8] < minVotage ? points[j + 8] : minVotage;
                    }
                    ++j;
                    k += 4;
                }
                points[7] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
                j = 0;
                k = 0;
                while (j < 8) {
                    points[j + 15] = ((convertBuffer[k + 48] & 0xFF) << 24) + ((convertBuffer[k + 49] & 0xFF) << 16) + ((convertBuffer[k + 50] & 0xFF) << 8) + ((convertBuffer[k + 51] & 0xFF) << 0);
                    ++j;
                    k += 4;
                }
                recordSet.addPoints(points);
                if (!doUpdateProgressBar || i % 50 != 0) continue;
                this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
            }
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                double factor = record.getFactor();
                dataTableRow[index + 1] = record.getDecimalFormat().format((double)record.realGet(rowIndex).intValue() / 1000.0 * factor);
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    public double translateValue(Record record, double value) {
        double offset = record.getOffset();
        double factor = record.getFactor();
        double newValue = value * factor + offset;
        log.log(java.util.logging.Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    public double reverseTranslateValue(Record record, double value) {
        double offset = record.getOffset();
        double factor = record.getFactor();
        double newValue = value / factor - offset;
        log.log(java.util.logging.Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        Record record;
        int i;
        int displayableCounter = 0;
        recordSet.setAllDisplayable();
        for (i = 0; i < recordSet.size(); ++i) {
            record.setDisplayable((record = recordSet.get(i)).getOrdinal() <= 5 || record.hasReasonableData());
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, record.getName() + " setDisplayable=" + (record.getOrdinal() <= 5 || record.hasReasonableData()));
            }
            if (!record.isActive() || !record.isDisplayable()) continue;
            ++displayableCounter;
        }
        if (log.isLoggable(Level.FINE)) {
            for (i = 0; i < recordSet.size(); ++i) {
                record = recordSet.get(i);
                log.log(Level.FINE, record.getName() + " isActive=" + record.isActive() + " isVisible=" + record.isVisible() + " isDisplayable=" + record.isDisplayable());
            }
        }
        recordSet.setConfiguredDisplayable(displayableCounter);
    }

    public void makeInActiveDisplayable(RecordSet recordSet) {
        if (recordSet.isRaw()) {
            try {
                int displayableCounter = 0;
                for (String measurementKey : recordSet.keySet()) {
                    Record record = recordSet.get((Object)measurementKey);
                    if (!record.isActive() || record.getOrdinal() > 5 && !record.hasReasonableData()) continue;
                    ++displayableCounter;
                }
                log.log(java.util.logging.Level.FINE, "displayableCounter = " + displayableCounter);
                recordSet.setConfiguredDisplayable(displayableCounter);
                if (recordSet.getName().equals(this.channels.getActiveChannel().getActiveRecordSet().getName())) {
                    this.application.updateGraphicsWindow();
                }
            }
            catch (RuntimeException e) {
                log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public PolaronSerialPort getCommunicationPort() {
        return this.serialPort;
    }

    public DeviceDialog getDialog() {
        return null;
    }

    public String[] getUsedPropertyKeys() {
        return new String[]{IDevice.OFFSET, IDevice.FACTOR};
    }

    public void open_closeCommPort() {
        block14: {
            if (this.serialPort != null) {
                if (!this.serialPort.isConnected()) {
                    try {
                        this.serialPort.open();
                        Channel activChannel = Channels.getInstance().getActiveChannel();
                        if (activChannel == null) break block14;
                        this.dataGatherThread = new PolaronGathererThread();
                        try {
                            if (this.serialPort.isConnected()) {
                                this.dataGatherThread.start();
                            }
                        }
                        catch (RuntimeException e) {
                            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        }
                        catch (Throwable e) {
                            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    catch (SerialPortException e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        this.serialPort.close();
                        this.application.openMessageDialog(Messages.getString((String)"GDE_MSGE0015", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage()}));
                        this.application.getDeviceSelectionDialog().open();
                    }
                    catch (ApplicationConfigurationException e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        this.serialPort.close();
                        this.application.openMessageDialog(Messages.getString((String)"GDE_MSGE0010"));
                        this.application.getDeviceSelectionDialog().open();
                    }
                    catch (Throwable e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        this.serialPort.close();
                    }
                } else {
                    if (this.dataGatherThread != null) {
                        try {
                            this.dataGatherThread.stopDataGatheringThread(false, null);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.serialPort.close();
                }
            }
        }
    }

    public int[] getCellVoltageOrdinals() {
        return new int[]{1, this.channels.getActiveChannelNumber() == 3 ? 7 : 3};
    }

    public boolean isProcessing(int outletNum, byte[] dataBuffer) {
        if (outletNum == 1) {
            int processingModeOut1 = this.getProcessingMode(dataBuffer);
            int n = processingModeOut1 = processingModeOut1 > 9 ? 0 : processingModeOut1;
            if (log.isLoggable(java.util.logging.Level.FINE)) {
                log.log(java.util.logging.Level.FINE, "processingModeOut1 = " + this.PROCESSING_MODE[processingModeOut1]);
            }
            return processingModeOut1 != 0 && processingModeOut1 != 6;
        }
        if (outletNum == 2) {
            short processingModeOut2 = DataParser.parse2Short((byte[])dataBuffer, (int)127);
            short s = processingModeOut2 = processingModeOut2 > 9 ? (short)0 : processingModeOut2;
            if (log.isLoggable(java.util.logging.Level.FINE)) {
                log.log(java.util.logging.Level.FINE, "processingModeOut2 = " + this.PROCESSING_MODE[processingModeOut2]);
            }
            return processingModeOut2 != 0 && processingModeOut2 != 6;
        }
        return false;
    }

    public int getProcessingMode(byte[] dataBuffer) {
        return DataParser.parse2Short((byte[])dataBuffer, (int)13);
    }

    public String getProcessingType(byte[] dataBuffer) {
        int processingMode = this.getProcessingMode(dataBuffer);
        short processingType = DataParser.parse2Short((byte[])dataBuffer, (int)15);
        String type = "";
        switch (processingMode) {
            case 1: {
                type = this.CHARGE_TYPE[processingType];
                break;
            }
            case 2: {
                type = this.DISCHARGE_TYPE[processingType];
                break;
            }
            case 6: {
                GDE.getUiNotification().setStatusMessage(Messages.getString((String)"GDE_MSGE3118") + String.format("%02d", processingType), 3);
            }
        }
        if (log.isLoggable(java.util.logging.Level.FINE)) {
            log.log(java.util.logging.Level.FINE, "processingMode=" + this.PROCESSING_MODE[processingMode] + " processingType=" + type);
        }
        return type;
    }

    public int getCycleNumber(int outletNum, byte[] dataBuffer) {
        return DataParser.parse2Short((byte[])dataBuffer, (int)17);
    }

    public boolean isLinkedMode(byte[] dataBuffer) {
        short processingMode1 = DataParser.parse2Short((byte[])dataBuffer, (int)13);
        short processingType1 = DataParser.parse2Short((byte[])dataBuffer, (int)15);
        short processingMode2 = DataParser.parse2Short((byte[])dataBuffer, (int)127);
        short processingType2 = DataParser.parse2Short((byte[])dataBuffer, (int)129);
        short numCells = DataParser.parse2Short((byte[])dataBuffer, (int)43);
        return processingMode1 == 7 && processingMode2 == 0 && numCells > 7 || processingMode1 == processingMode2 && processingType1 == processingType2 && (processingMode1 == 1 && (processingType1 == 6 || processingType1 == 11) || processingMode1 == 2 && (processingType1 == 4 || processingType1 == 6));
    }

    public void setTemperatureUnit(int channelNumber, RecordSet recordSet, byte[] dataBuffer) {
        short unit = DataParser.parse2Short((byte[])dataBuffer, (int)41);
        if (unit == 0) {
            this.setMeasurementUnit(recordSet.getChannelConfigNumber(), 6, "\u00b0C");
            this.setMeasurementUnit(recordSet.getChannelConfigNumber(), 6, "\u00b0C");
        } else if (unit == 1) {
            this.setMeasurementUnit(recordSet.getChannelConfigNumber(), 6, "\u00b0F");
            this.setMeasurementUnit(recordSet.getChannelConfigNumber(), 6, "\u00b0F");
        }
    }

    public int getDesktopTargetReferenceOrdinal(DesktopPropertyTypes desktopPropertyType) {
        DesktopPropertyType property = this.getDesktopProperty(desktopPropertyType);
        if (this.channels.getActiveChannelNumber() == 3) {
            return property != null ? property.getTargetReferenceOrdinal() + 11 : -1;
        }
        return property != null ? property.getTargetReferenceOrdinal() : -1;
    }

    public abstract GraupnerDeviceType getDeviceTypeIdentifier();

    public String getFirmwareVersion(byte[] dataBuffer) {
        return String.format(Locale.ENGLISH, "%.3f", (double)DataParser.parse2Short((byte[])dataBuffer, (int)7) / 1000.0);
    }

    public int getProductCode(byte[] dataBuffer) {
        return DataParser.parse2Short((byte[])dataBuffer, (int)5);
    }

    public int getBatteryMemoryNumber(int outletNum, byte[] dataBuffer) {
        return -1;
    }

    public int getCurrentSmoothIndex() {
        return 2;
    }

    public static enum GraupnerDeviceType {
        unknown,
        PolaronEx,
        PolaronACDC_EQ,
        PolaronACDC,
        PolaronPro,
        PolaronSports,
        Gemini2030iEvo,
        Absolute1807,
        PolaronEx1400,
        UltraDuoPlus80;

    }
}

